/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.shape.TerrainDistanceField;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class OctahedronRasterization {
    private static final Quaternionf EMPTY_QUATERNION = new Quaternionf();
    private static final int[] CARDINAL_OFFSETS = new int[]{0, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, 0};

    public static void octahedron(ChunkedBlockRegion region, class_2680 block, class_2338 center, float widthX, float widthY, float widthZ, boolean hollow, boolean centerEvenDiameters, float cutoffY, @Nullable Quaternionf quaternionf) {
        if (widthX <= 0.0f || widthY <= 0.0f || widthZ <= 0.0f) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        float radiusX = (widthX - 1.0f) / 2.0f;
        float radiusY = (widthY - 1.0f) / 2.0f;
        float radiusZ = (widthZ - 1.0f) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRadiusY * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float offsetX = centerEvenDiameters ? -(radiusX % 1.0f) : 0.0f;
        float offsetY = centerEvenDiameters ? -(radiusY % 1.0f) : 0.0f;
        float offsetZ = centerEvenDiameters ? -(radiusZ % 1.0f) : 0.0f;
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block5: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    if (ry < cutoffY || !(Math.abs(rx) * radiusY * radiusZ + Math.abs(ry) * radiusX * radiusZ + Math.abs(rz) * radiusX * radiusY <= radiusX * radiusY * radiusZ)) continue;
                    if (!hollow) {
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue;
                    }
                    for (int i = 0; i < 18; i += 3) {
                        int nx = x + CARDINAL_OFFSETS[i];
                        int ny = y + CARDINAL_OFFSETS[i + 1];
                        int nz = z + CARDINAL_OFFSETS[i + 2];
                        vector3f.set((float)nx, (float)ny, (float)nz);
                        quaternionf.transform(vector3f);
                        rx = vector3f.x + offsetX;
                        ry = vector3f.y + offsetY;
                        rz = vector3f.z + offsetZ;
                        if (!(Math.abs(rx) * radiusY * radiusZ + Math.abs(ry) * radiusX * radiusZ + Math.abs(rz) * radiusX * radiusY > radiusX * radiusY * radiusZ)) continue;
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue block5;
                    }
                }
            }
        }
    }

    public static void octahedronMetaball(ChunkedBlockRegion region, int metaballRange, class_2680 block, class_2338 center, float widthX, float widthY, float widthZ, boolean hollow, boolean centerEvenDiameters, @Nullable Quaternionf quaternionf) {
        class_638 level = class_310.method_1551().field_1687;
        if (metaballRange <= 1 || level == null) {
            OctahedronRasterization.octahedron(region, block, center, widthX, widthY, widthZ, hollow, centerEvenDiameters, Float.NEGATIVE_INFINITY, quaternionf);
            return;
        }
        int extra = (int)Math.ceil(Math.sqrt((float)(metaballRange * metaballRange - metaballRange) / 2.0f)) + 1;
        if (widthX <= 0.0f || widthY <= 0.0f || widthZ <= 0.0f) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        float radiusX = (widthX - 1.0f) / 2.0f;
        float radiusY = (widthY - 1.0f) / 2.0f;
        float radiusZ = (widthZ - 1.0f) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX + (float)extra);
        int ceilRadiusY = (int)Math.ceil(radiusY + (float)extra);
        int ceilRadiusZ = (int)Math.ceil(radiusZ + (float)extra);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRadiusY * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        float invRadiusX = 1.0f / radiusX;
        float invRadiusY = 1.0f / radiusY;
        float invRadiusZ = 1.0f / radiusZ;
        float expandedRadiusX = radiusX + (float)extra;
        float expandedRadiusY = radiusY + (float)extra;
        float expandedRadiusZ = radiusZ + (float)extra;
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float offsetX = centerEvenDiameters ? -(radiusX % 1.0f) : 0.0f;
        float offsetY = centerEvenDiameters ? -(radiusY % 1.0f) : 0.0f;
        float offsetZ = centerEvenDiameters ? -(radiusZ % 1.0f) : 0.0f;
        float[] distances = TerrainDistanceField.calculateChamferEuclidean((class_1937)level, centerX - maxRadiusX, centerY - maxRadiusY, centerZ - maxRadiusZ, centerX + maxRadiusX, centerY + maxRadiusY, centerZ + maxRadiusZ);
        int xIndexOffset = (maxRadiusY * 2 + 3) * (maxRadiusZ * 2 + 3);
        int yIndexOffset = maxRadiusZ * 2 + 3;
        float normalLength = (float)Math.sqrt(invRadiusX * invRadiusX + invRadiusY * invRadiusY + invRadiusZ * invRadiusZ);
        float normalX = invRadiusX / normalLength;
        float normalY = invRadiusY / normalLength;
        float normalZ = invRadiusZ / normalLength;
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block5: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    int index;
                    float distance;
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    if (Math.abs(rx) * radiusY * radiusZ + Math.abs(ry) * radiusX * radiusZ + Math.abs(rz) * radiusX * radiusY <= radiusX * radiusY * radiusZ) {
                        if (!hollow) {
                            region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                            continue;
                        }
                        for (int i = 0; i < 18; i += 3) {
                            int nx = x + CARDINAL_OFFSETS[i];
                            int ny = y + CARDINAL_OFFSETS[i + 1];
                            int nz = z + CARDINAL_OFFSETS[i + 2];
                            vector3f.set((float)nx, (float)ny, (float)nz);
                            quaternionf.transform(vector3f);
                            rx = vector3f.x + offsetX;
                            ry = vector3f.y + offsetY;
                            rz = vector3f.z + offsetZ;
                            if (!(Math.abs(rx) * radiusY * radiusZ + Math.abs(ry) * radiusX * radiusZ + Math.abs(rz) * radiusX * radiusY > radiusX * radiusY * radiusZ)) continue;
                            region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                            continue block5;
                        }
                        continue;
                    }
                    if (!(Math.abs(rx) * expandedRadiusY * expandedRadiusZ + Math.abs(ry) * expandedRadiusX * expandedRadiusZ + Math.abs(rz) * expandedRadiusX * expandedRadiusY <= expandedRadiusX * expandedRadiusY * expandedRadiusZ) || !Float.isFinite(distance = distances[index = (x + maxRadiusX + 1) * xIndexOffset + (y + maxRadiusY + 1) * yIndexOffset + (z + maxRadiusZ + 1)]) || distance == 0.0f) continue;
                    float terrainAmount = (float)metaballRange / ((float)metaballRange + distance * distance) - 1.0f / (float)(1 + metaballRange);
                    float top = invRadiusX * Math.abs(rx) + invRadiusY * Math.abs(ry) + invRadiusZ * Math.abs(rz) - 1.0f;
                    float planeDistance = top / normalLength;
                    float planeX = Math.abs(rx) - normalX * planeDistance;
                    float planeY = Math.abs(ry) - normalY * planeDistance;
                    float planeZ = Math.abs(rz) - normalZ * planeDistance;
                    if (planeX < 0.0f) {
                        if ((planeY += planeX * 0.5f * radiusY / radiusX) < 0.0f) {
                            planeZ = radiusZ;
                            planeY = 0.0f;
                        } else if ((planeZ += planeX * 0.5f * radiusZ / radiusX) < 0.0f) {
                            planeY = radiusY;
                            planeZ = 0.0f;
                        }
                        planeX = 0.0f;
                    } else if (planeY < 0.0f) {
                        if ((planeX += planeY * 0.5f * radiusX / radiusY) < 0.0f) {
                            planeZ = radiusZ;
                            planeX = 0.0f;
                        } else if ((planeZ += planeY * 0.5f * radiusZ / radiusY) < 0.0f) {
                            planeX = radiusX;
                            planeZ = 0.0f;
                        }
                        planeY = 0.0f;
                    } else if (planeZ < 0.0f) {
                        if ((planeX += planeZ * 0.5f * radiusX / radiusZ) < 0.0f) {
                            planeY = radiusY;
                            planeX = 0.0f;
                        } else if ((planeY += planeZ * 0.5f * radiusY / radiusZ) < 0.0f) {
                            planeX = radiusX;
                            planeY = 0.0f;
                        }
                        planeZ = 0.0f;
                    }
                    float dx = planeX - Math.abs(rx);
                    float dy = planeY - Math.abs(ry);
                    float dz = planeZ - Math.abs(rz);
                    float surfaceDistanceSq = dx * dx + dy * dy + dz * dz;
                    float amount = (float)metaballRange / ((float)metaballRange + surfaceDistanceSq) - 1.0f / (float)(1 + metaballRange);
                    if (!(terrainAmount + amount >= 1.0f)) continue;
                    region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                }
            }
        }
    }
}

