/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.moulberry.axiom.core_rendering.AxiomRenderPipeline;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.render.Effects;
import com.moulberry.axiom.render.ShaderManager;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.RenderHelper;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;

public class EffectRenderer {
    public static void render(EffectCallback effectCallback, long time, int effects) {
        if (!Effects.any(effects)) {
            return;
        }
        if ((effects & 8) != 0) {
            float factor = (float)Math.sin((float)time / 5.0E8f) * 0.5f + 0.5f;
            float f = factor = (double)factor < 0.5 ? 2.0f * (float)Math.pow(factor, 2.0) : 1.0f - (float)Math.pow(-2.0f * factor + 2.0f, 2.0) / 2.0f;
            if (factor > 0.0f) {
                AxiomRenderer.setShaderColour(1.0f, 0.5f, 0.5f, 0.2f + factor * 0.2f);
                effectCallback.render(AxiomRenderPipelines.EFFECT_RENDERER_NORMAL_PIPELINE, null);
            }
        } else if (Effects.blueOrRed(effects)) {
            float factor;
            if ((effects & 3) == 1) {
                factor = 1.0f;
            } else if ((effects & 3) == 2) {
                factor = 0.0f;
            } else {
                factor = (float)Math.sin((float)time / 5.0E8f) * 0.5f + 0.5f;
                float f = factor = (double)factor < 0.5 ? 2.0f * (float)Math.pow(factor, 2.0) : 1.0f - (float)Math.pow(-2.0f * factor + 2.0f, 2.0) / 2.0f;
            }
            if (factor < 1.0f) {
                AxiomRenderer.setShaderColour(1.0f, 0.5f, 0.5f, 0.3f - factor * 0.3f);
                effectCallback.render(AxiomRenderPipelines.EFFECT_RENDERER_RED_INVERSE_DEPTH, null);
            }
            if (factor > 0.0f) {
                AxiomRenderer.setShaderColour(1.0f - factor * 0.3f, 1.0f - factor * 0.3f, 1.0f, factor * 0.5f);
                effectCallback.render(AxiomRenderPipelines.EFFECT_RENDERER_BLUE_BACK, null);
                effectCallback.render(AxiomRenderPipelines.EFFECT_RENDERER_NORMAL_PIPELINE, null);
            }
        }
        if ((effects & 4) != 0) {
            AxiomRenderer.setShaderColour(1.0f, 0.9f, 0.12f, 1.0f);
            effectCallback.render(AxiomRenderPipelines.EFFECT_RENDERER_OUTLINE, ShaderManager.getSelectionOutlineTarget(false));
        }
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderBoundingBox(class_4184 camera, long time, class_4587 matrices, class_243 one, class_243 two, int effects) {
        double minX = Math.min(one.method_10216(), two.method_10216()) - 1.0E-4;
        double minY = Math.min(one.method_10214(), two.method_10214()) - 1.0E-4;
        double minZ = Math.min(one.method_10215(), two.method_10215()) - 1.0E-4;
        float sizeX = (float)Math.abs(one.method_10216() - two.method_10216()) + 2.0E-4f;
        float sizeY = (float)Math.abs(one.method_10214() - two.method_10214()) + 2.0E-4f;
        float sizeZ = (float)Math.abs(one.method_10215() - two.method_10215()) + 2.0E-4f;
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        matrices.method_22903();
        matrices.method_22904(minX - camera.method_19326().field_1352, minY - camera.method_19326().field_1351, minZ - camera.method_19326().field_1350);
        RenderHelper.tryApplyModelViewMatrix();
        class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
        Shapes.lineBox(matrices, (class_4588)bufferBuilder, 0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, 1.0f, 1.0f, 1.0f, 0.5f, 1.0f, 1.0f, 1.0f);
        AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH.render(provider.build());
        bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
        Shapes.lineBox(matrices, (class_4588)bufferBuilder, 0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, 1.0f, 1.0f, 1.0f, 0.15f, 1.0f, 1.0f, 1.0f);
        AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(provider.build());
        EffectRenderer.render((pipeline, target) -> {
            Shapes.shadedBox(provider, matrices.method_23760().method_23761(), sizeX, sizeY, sizeZ, -1);
            pipeline.render(target, provider.build());
        }, time, effects & 0xFFFFFFFB);
        matrices.method_22909();
    }

    @FunctionalInterface
    public static interface EffectCallback {
        public void render(AxiomRenderPipeline var1, @Nullable class_276 var2);
    }
}

