/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.GlobalCleaner;
import com.moulberry.axiom.editor.EditorUI;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import org.jetbrains.annotations.Nullable;

public class DynamicTextureSupplier
implements AutoCloseable {
    private class_1011 nativeImage;
    private CleanState cleanState;
    private class_1043 dynamicTexture = null;
    private boolean closed = false;

    public DynamicTextureSupplier(class_1011 nativeImage) {
        this.nativeImage = nativeImage;
        this.cleanState = new CleanState();
        this.cleanState.nativeImage = nativeImage;
        GlobalCleaner.INSTANCE.register(this, this.cleanState);
    }

    @Nullable
    public class_1043 get() {
        if (this.closed) {
            return null;
        }
        if (this.dynamicTexture == null && RenderSystem.isOnRenderThread()) {
            this.cleanState.dynamicTexture = this.dynamicTexture = new class_1043(this.nativeImage);
        }
        return this.dynamicTexture;
    }

    public class_1011 getPixels() {
        return this.nativeImage;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.dynamicTexture != null) {
            this.dynamicTexture.close();
            this.dynamicTexture = null;
        }
        if (this.nativeImage != null) {
            this.nativeImage.close();
            this.nativeImage = null;
        }
        if (this.cleanState != null) {
            this.cleanState.nativeImage = null;
            this.cleanState.dynamicTexture = null;
            this.cleanState = null;
        }
    }

    private static class CleanState
    implements Runnable {
        private class_1011 nativeImage = null;
        private class_1043 dynamicTexture = null;

        private CleanState() {
        }

        @Override
        public void run() {
            if (this.nativeImage != null) {
                this.nativeImage.close();
                this.nativeImage = null;
            }
            if (this.dynamicTexture != null) {
                EditorUI.deferredClose((AutoCloseable)this.dynamicTexture);
                this.dynamicTexture = null;
            }
        }
    }
}

