/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate;

import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.AbstractConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.ConfigurationVisitor;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.RepresentationHint;
import org.spongepowered.configurate.serialize.Scalars;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.Types;

public interface ConfigurationNode {
    public static final int NUMBER_DEF = 0;

    public @Nullable Object key();

    public NodePath path();

    public @Nullable ConfigurationNode parent();

    public ConfigurationNode node(Object ... var1);

    public ConfigurationNode node(Iterable<?> var1);

    public boolean hasChild(Object ... var1);

    public boolean hasChild(Iterable<?> var1);

    public boolean virtual();

    public ConfigurationOptions options();

    public boolean isNull();

    public boolean isList();

    public boolean isMap();

    public boolean empty();

    public List<? extends ConfigurationNode> childrenList();

    public Map<Object, ? extends ConfigurationNode> childrenMap();

    default public <V> Collector<Map.Entry<?, V>, ? extends ConfigurationNode, ? extends ConfigurationNode> toMapCollector(TypeToken<V> valueType) {
        return Collector.of(() -> this, (node, entry) -> {
            try {
                node.node(entry.getKey()).set(valueType, entry.getValue());
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, ConfigurationNode::mergeFrom, new Collector.Characteristics[0]);
    }

    default public <V> Collector<Map.Entry<?, V>, ? extends ConfigurationNode, ? extends ConfigurationNode> toMapCollector(Class<V> valueType) {
        return Collector.of(() -> this, (node, entry) -> {
            try {
                node.node(entry.getKey()).set(valueType, entry.getValue());
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, ConfigurationNode::mergeFrom, new Collector.Characteristics[0]);
    }

    default public <V> Collector<V, ? extends ConfigurationNode, ? extends ConfigurationNode> toListCollector(TypeToken<V> valueType) {
        return Collector.of(() -> this, (node, value) -> {
            try {
                node.appendListNode().set(valueType, value);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, ConfigurationNode::mergeFrom, new Collector.Characteristics[0]);
    }

    default public <V> Collector<V, ? extends ConfigurationNode, ? extends ConfigurationNode> toListCollector(Class<V> valueType) {
        return Collector.of(() -> this, (node, value) -> {
            try {
                node.appendListNode().set(valueType, value);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, ConfigurationNode::mergeFrom, new Collector.Characteristics[0]);
    }

    default public <V> V require(TypeToken<V> type2) throws SerializationException {
        @Nullable V ret = this.get(type2);
        if (ret == null) {
            throw new NoSuchElementException("Node value was null when a non-null node was require()d");
        }
        return ret;
    }

    default public <V> V require(Class<V> type2) throws SerializationException {
        @Nullable V ret = this.get(type2);
        if (ret == null) {
            throw new NoSuchElementException("Node value was null when a non-null node was require()d");
        }
        return ret;
    }

    default public @Nullable Object require(Type type2) throws SerializationException {
        @Nullable Object ret = this.get(type2);
        if (ret == null) {
            throw new NoSuchElementException("Node value was null when a non-null node was require()d");
        }
        return ret;
    }

    default public <V> @Nullable V get(TypeToken<V> type2) throws SerializationException {
        return (V)this.get(type2.getType());
    }

    default public <V> V get(TypeToken<V> type2, V def) throws SerializationException {
        return (V)this.get(type2.getType(), def);
    }

    default public <V> V get(TypeToken<V> type2, Supplier<V> defSupplier) throws SerializationException {
        return (V)this.get(type2.getType(), defSupplier);
    }

    default public <V> @Nullable V get(Class<V> type2) throws SerializationException {
        return (V)this.get((Type)type2);
    }

    default public <V> V get(Class<V> type2, V def) throws SerializationException {
        return (V)this.get((Type)type2, (Object)def);
    }

    default public <V> V get(Class<V> type2, Supplier<V> defSupplier) throws SerializationException {
        return (V)this.get((Type)type2, (Supplier<?>)defSupplier);
    }

    public @Nullable Object get(Type var1) throws SerializationException;

    default public Object get(Type type2, Object def) throws SerializationException {
        @Nullable Object value = this.get(type2);
        return value == null ? AbstractConfigurationNode.storeDefault(this, type2, def) : value;
    }

    default public Object get(Type type2, Supplier<?> defSupplier) throws SerializationException {
        @Nullable Object value = this.get(type2);
        return value == null ? AbstractConfigurationNode.storeDefault(this, type2, defSupplier.get()) : value;
    }

    default public <V> @Nullable List<V> getList(TypeToken<V> type2) throws SerializationException {
        return this.get(Types.makeListType(type2));
    }

    default public <V> List<V> getList(TypeToken<V> elementType, List<V> def) throws SerializationException {
        TypeToken<List<V>> type2 = Types.makeListType(elementType);
        @Nullable List<V> ret = this.get(type2, def);
        return ret == null || ret.isEmpty() ? AbstractConfigurationNode.storeDefault(this, type2.getType(), def) : ret;
    }

    default public <V> List<V> getList(TypeToken<V> elementType, Supplier<List<V>> defSupplier) throws SerializationException {
        TypeToken<List<V>> type2 = Types.makeListType(elementType);
        List<V> ret = this.get(type2, defSupplier);
        return ret.isEmpty() ? AbstractConfigurationNode.storeDefault(this, type2.getType(), defSupplier.get()) : ret;
    }

    default public <V> @Nullable List<V> getList(Class<V> type2) throws SerializationException {
        return (List)this.get(TypeFactory.parameterizedClass(List.class, type2));
    }

    default public <V> List<V> getList(Class<V> elementType, List<V> def) throws SerializationException {
        Type type2 = TypeFactory.parameterizedClass(List.class, elementType);
        @Nullable List<V> ret = (List<V>)this.get(type2, def);
        return ret == null || ret.isEmpty() ? AbstractConfigurationNode.storeDefault(this, type2, def) : ret;
    }

    default public <V> List<V> getList(Class<V> elementType, Supplier<List<V>> defSupplier) throws SerializationException {
        Type type2 = TypeFactory.parameterizedClass(List.class, elementType);
        List<V> ret = (List<V>)this.get(type2, defSupplier);
        return ret.isEmpty() ? AbstractConfigurationNode.storeDefault(this, type2, defSupplier.get()) : ret;
    }

    default public @Nullable String getString() {
        return Scalars.STRING.tryDeserialize(this.rawScalar());
    }

    default public String getString(String def) {
        Objects.requireNonNull(def, "def");
        @Nullable String value = this.getString();
        if (value != null) {
            return value;
        }
        if (this.options().shouldCopyDefaults()) {
            Scalars.STRING.serialize(Float.TYPE, def, this);
        }
        return def;
    }

    default public float getFloat() {
        return this.getFloat(0.0f);
    }

    default public float getFloat(float def) {
        @Nullable Float val = Scalars.FLOAT.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val.floatValue();
        }
        if (this.options().shouldCopyDefaults() && def != 0.0f) {
            Scalars.FLOAT.serialize(Float.TYPE, Float.valueOf(def), this);
        }
        return def;
    }

    default public double getDouble() {
        return this.getDouble(0.0);
    }

    default public double getDouble(double def) {
        @Nullable Double val = Scalars.DOUBLE.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val;
        }
        if (this.options().shouldCopyDefaults() && def != 0.0) {
            Scalars.DOUBLE.serialize(Double.TYPE, def, this);
        }
        return def;
    }

    default public int getInt() {
        return this.getInt(0);
    }

    default public int getInt(int def) {
        @Nullable Integer val = Scalars.INTEGER.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val;
        }
        if (this.options().shouldCopyDefaults() && def != 0) {
            Scalars.INTEGER.serialize(Integer.TYPE, def, this);
        }
        return def;
    }

    default public long getLong() {
        return this.getLong(0L);
    }

    default public long getLong(long def) {
        @Nullable Long val = Scalars.LONG.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val;
        }
        if (this.options().shouldCopyDefaults() && def != 0L) {
            Scalars.LONG.serialize(Long.TYPE, def, this);
        }
        return def;
    }

    default public boolean getBoolean() {
        return this.getBoolean(false);
    }

    default public boolean getBoolean(boolean def) {
        @Nullable Boolean val = Scalars.BOOLEAN.tryDeserialize(this.rawScalar());
        if (val != null) {
            return val;
        }
        if (this.options().shouldCopyDefaults()) {
            Scalars.BOOLEAN.serialize(Boolean.TYPE, def, this);
        }
        return def;
    }

    public ConfigurationNode set(@Nullable Object var1) throws SerializationException;

    public <V> ConfigurationNode set(TypeToken<V> var1, @Nullable V var2) throws SerializationException;

    public <V> ConfigurationNode set(Class<V> var1, @Nullable V var2) throws SerializationException;

    public ConfigurationNode set(Type var1, @Nullable Object var2) throws SerializationException;

    default public <V> ConfigurationNode setList(Class<V> elementType, @Nullable List<V> items) throws SerializationException {
        return this.set(TypeFactory.parameterizedClass(List.class, elementType), items);
    }

    default public <V> ConfigurationNode setList(TypeToken<V> elementType, @Nullable List<V> items) throws SerializationException {
        return this.set(TypeFactory.parameterizedClass(List.class, elementType.getType()), items);
    }

    public @Nullable Object raw();

    public ConfigurationNode raw(@Nullable Object var1);

    public @Nullable Object rawScalar();

    public ConfigurationNode from(ConfigurationNode var1);

    public ConfigurationNode mergeFrom(ConfigurationNode var1);

    public boolean removeChild(Object var1);

    public ConfigurationNode appendListNode();

    public ConfigurationNode copy();

    default public <S, T, E extends Exception> T visit(ConfigurationVisitor<S, T, E> visitor) throws E {
        return this.visit(visitor, visitor.newState());
    }

    public <S, T, E extends Exception> T visit(ConfigurationVisitor<S, T, E> var1, S var2) throws E;

    default public <S, T> T visit(ConfigurationVisitor.Safe<S, T> visitor) {
        return this.visit(visitor, visitor.newState());
    }

    public <S, T> T visit(ConfigurationVisitor.Safe<S, T> var1, S var2);

    public <V> ConfigurationNode hint(RepresentationHint<V> var1, @Nullable V var2);

    public <V> @Nullable V hint(RepresentationHint<V> var1);

    public <V> @Nullable V ownHint(RepresentationHint<V> var1);

    public Map<RepresentationHint<?>, ?> ownHints();
}

