/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.clipboard;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.MissingTextureImage;
import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.blueprint.ServerBlueprintRegistry;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.collections.FlowCache;
import com.moulberry.axiom.configuration.AxiomConfig;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.TagListWidget;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintDirectory;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintDirectoryLoader;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintOrDirectory;
import com.moulberry.axiom.editor.windows.clipboard.PathWrapper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.packets.blueprint.AxiomServerboundRequestBlueprint;
import com.moulberry.axiom.packets.blueprint.AxiomServerboundUploadBlueprint;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.DynamicTextureSupplier;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axi\u03bfm.utils.Authorization;
import imgui.ImGui;
import imgui.ImGuiListClipper;
import imgui.ImVec2;
import imgui.callback.ImListClipperCallback;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;

public class BlueprintBrowserWindow {
    public static final Thumbnail EMPTY_THUMBNAIL = new Thumbnail(null);
    public static final Set<Path> updatedBlueprintPaths = new HashSet<Path>();
    private static final ImString searchString = ImGuiHelper.createResizableString(64);
    private static final ImString renameFilenameString = ImGuiHelper.createResizableString(64);
    private static String noLongerExistsErrorFileName = null;
    private static boolean reloadDirectoryStructure = false;
    private static BlueprintDirectory rootDirectory = null;
    private static BlueprintDirectory currentDirectory = null;
    private static List<BlueprintOrDirectory.Bp> recursiveSearchInCurrentDirectory = null;
    private static String lastRecursiveSearch = null;
    private static Set<String> lastRecursiveSearchFilteredTags = null;
    private static EditBlueprintData editBlueprintData = null;
    private static final Set<String> filteredTags = new TreeSet<String>();
    private static boolean filteredTagsChanged = false;
    private static Exception displayedException = null;
    private static MoveFileOperation moveFileOperation = null;
    public static BlueprintDirectory pendingSelectDirectory = null;
    private static List<BlueprintDirectory> forwardsQueue = new ArrayList<BlueprintDirectory>();
    private static boolean dirStructureToggled = false;
    public static boolean anyOrderUpdated = false;
    private static int updateOrderingCounter = 0;
    private static boolean renderedAtLeastOnce = false;
    private static int tooManyFileChangesCount = -1;
    private static float draggingDirListDividerStartMouseX = -1.0f;
    private static float draggingDirListDividerStartDirWidth = -1.0f;
    private static WatchService watchService = null;
    private static final Map<Path, BlueprintDirectory> dirStructureMap = new HashMap<Path, BlueprintDirectory>();
    private static ServerBlueprintRegistry serverBlueprintRegistry = null;
    private static BlueprintDirectory rootServerBlueprintDirectory = null;
    public static String pendingServerBlueprintDownload = null;
    public static Blueprint pendingServerBlueprintResult = null;
    private static boolean popupBrowserBecauseJustOpened = false;
    private static boolean makeActiveBecauseJustOpened = false;
    public static boolean selectMultiple = false;
    private static Predicate<Blueprint> callback = BlueprintBrowserWindow::defaultCallback;
    private static final FlowCache<PathWrapper, Thumbnail> loadedBlueprintThumbnails = new FlowCache<PathWrapper, Thumbnail>(0, 100, 4, 1, true, path -> {
        if (path.real() != null) {
            Thumbnail thumbnail;
            if (Files.isDirectory(path.real(), new LinkOption[0])) {
                return EMPTY_THUMBNAIL;
            }
            BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path.real(), new OpenOption[0]));
            try {
                thumbnail = new Thumbnail(BlueprintIo.readThumbnail(inputStream));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return EMPTY_THUMBNAIL;
                }
            }
            ((InputStream)inputStream).close();
            return thumbnail;
        }
        RawBlueprint rawBlueprint = serverBlueprintRegistry.blueprints().get(path.fakePath());
        if (rawBlueprint == null) {
            return EMPTY_THUMBNAIL;
        }
        try {
            class_1011 nativeImage;
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                ByteBuffer byteBuffer = memoryStack.malloc(rawBlueprint.thumbnail().length);
                byteBuffer.put(rawBlueprint.thumbnail());
                byteBuffer.rewind();
                nativeImage = class_1011.method_4324((ByteBuffer)byteBuffer);
            }
            return new Thumbnail(new DynamicTextureSupplier(nativeImage));
        }
        catch (Exception ignored) {
            return EMPTY_THUMBNAIL;
        }
    });
    private static final int ICON_SIZE = 100;

    public static void open(@Nullable Predicate<Blueprint> callback, boolean selectMultiple) {
        EditorWindowType.BLUEPRINT_BROWSER.setOpen(true);
        BlueprintBrowserWindow.callback = callback == null ? BlueprintBrowserWindow::defaultCallback : callback;
        BlueprintBrowserWindow.selectMultiple = selectMultiple;
        makeActiveBecauseJustOpened = true;
        if (!EditorWindowType.BLUEPRINT_BROWSER.isDocked()) {
            popupBrowserBecauseJustOpened = true;
        }
    }

    public static void resetCallback() {
        callback = BlueprintBrowserWindow::defaultCallback;
        selectMultiple = false;
    }

    public static void setServerBlueprintRegistry(boolean replace, ServerBlueprintRegistry registry) {
        pendingServerBlueprintDownload = null;
        if (registry == null) {
            serverBlueprintRegistry = null;
        } else if (replace || serverBlueprintRegistry == null) {
            serverBlueprintRegistry = registry;
        } else {
            for (Map.Entry<String, RawBlueprint> entry : registry.blueprints().entrySet()) {
                serverBlueprintRegistry.blueprints().put(entry.getKey(), entry.getValue());
            }
        }
        if (rootServerBlueprintDirectory != null) {
            BlueprintDirectory currentRoot = currentDirectory;
            while (currentRoot.parent() != null) {
                currentRoot = currentRoot.parent();
            }
            if (rootServerBlueprintDirectory.equals(currentRoot)) {
                currentDirectory = rootDirectory;
                BlueprintBrowserWindow.unsetRecursiveSearch();
            }
            rootServerBlueprintDirectory = null;
        }
    }

    private static void unsetRecursiveSearch() {
        recursiveSearchInCurrentDirectory = null;
        lastRecursiveSearch = null;
        lastRecursiveSearchFilteredTags = null;
    }

    private static BlueprintDirectory createHierarchical(Map<String, Object> hierarchical, String name, String path) {
        BlueprintDirectory directory = new BlueprintDirectory(new PathWrapper(null, path), name);
        for (Map.Entry<String, Object> child : hierarchical.entrySet()) {
            Object object = child.getValue();
            if (object instanceof RawBlueprint) {
                RawBlueprint rawBlueprint = (RawBlueprint)object;
                directory.addLast(new BlueprintOrDirectory.Bp(new PathWrapper(null, path + child.getKey()), rawBlueprint.header()));
                continue;
            }
            Map map = (Map)child.getValue();
            BlueprintDirectory childDirectory = BlueprintBrowserWindow.createHierarchical(map, child.getKey(), path + child.getKey() + "/");
            directory.addLast(new BlueprintOrDirectory.Dir(childDirectory));
        }
        directory.sort(BlueprintDirectory.SortMode.NAME);
        return directory;
    }

    private static boolean defaultCallback(Blueprint blueprint) {
        Clipboard.INSTANCE.setClipboard(blueprint);
        return true;
    }

    private static void updateOrdering(BlueprintDirectory blueprintDirectory) {
        blueprintDirectory.saveOrdering();
        for (BlueprintDirectory child : blueprintDirectory.children()) {
            BlueprintBrowserWindow.updateOrdering(child);
        }
    }

    public static void tick() {
        if (!renderedAtLeastOnce) {
            return;
        }
        if (Authorization.hasCommercialLicense() && serverBlueprintRegistry != null && rootServerBlueprintDirectory == null) {
            HashMap<String, Object> hierarchical = new HashMap<String, Object>();
            for (Map.Entry<String, RawBlueprint> entry : serverBlueprintRegistry.blueprints().entrySet()) {
                String path = entry.getKey();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                String[] paths = path.split("/");
                Map<String, Object> map = hierarchical;
                for (int i = 0; i < paths.length; ++i) {
                    String name = paths[i];
                    if (i < paths.length - 1) {
                        map = (Map)map.computeIfAbsent(name, k -> new HashMap());
                        continue;
                    }
                    map.put(name, entry.getValue());
                }
            }
            rootServerBlueprintDirectory = BlueprintBrowserWindow.createHierarchical(hierarchical, "Server Blueprints", "/");
        }
        boolean automaticRefreshing = Axiom.configuration.blueprint.automaticRefreshing;
        loadedBlueprintThumbnails.tick();
        if (pendingSelectDirectory != null) {
            BlueprintBrowserWindow.setCurrentDirectory(pendingSelectDirectory);
            pendingSelectDirectory = null;
            if (currentDirectory == null) {
                forwardsQueue.clear();
            } else if (!forwardsQueue.isEmpty()) {
                BlueprintDirectory head = forwardsQueue.get(0);
                if (!currentDirectory.children().contains(head)) {
                    forwardsQueue.clear();
                }
            }
        }
        if (moveFileOperation != null) {
            BlueprintBrowserWindow.handleMoveFileOperation();
        }
        if (watchService != null) {
            if (!automaticRefreshing) {
                try {
                    watchService.close();
                    watchService = null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else {
                BlueprintBrowserWindow.pollAndUpdateWatchService();
            }
        }
        for (Path updatedPath : updatedBlueprintPaths) {
            BlueprintDirectory blueprintDirectory;
            Path parent = updatedPath.getParent();
            if (parent == null || updatedBlueprintPaths.contains(parent) || (blueprintDirectory = dirStructureMap.get(parent)) == null) continue;
            if (!Files.exists(updatedPath, new LinkOption[0])) {
                blueprintDirectory.remove(new PathWrapper(updatedPath, null));
                continue;
            }
            Thumbnail texture = loadedBlueprintThumbnails.remove(new PathWrapper(updatedPath, null));
            BlueprintOrDirectory blueprintOrDirectory = BlueprintDirectoryLoader.loadBlueprintOrDirectory(updatedPath, watchService, dirStructureMap);
            if (blueprintOrDirectory == null) continue;
            blueprintDirectory.addLast(blueprintOrDirectory);
        }
        updatedBlueprintPaths.clear();
        if (rootDirectory == null || reloadDirectoryStructure || automaticRefreshing && watchService == null) {
            if (rootDirectory != null && anyOrderUpdated) {
                BlueprintBrowserWindow.updateOrdering(rootDirectory);
                anyOrderUpdated = false;
            }
            searchString.clear();
            filteredTags.clear();
            try {
                if (watchService != null) {
                    watchService.close();
                }
                watchService = automaticRefreshing ? FileSystems.getDefault().newWatchService() : null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            dirStructureMap.clear();
            Path rootPath = Axiom.getInstance().getBlueprintDirectory();
            rootDirectory = currentDirectory = BlueprintDirectoryLoader.loadDirectory("Blueprints", rootPath, watchService, dirStructureMap);
            BlueprintBrowserWindow.unsetRecursiveSearch();
            loadedBlueprintThumbnails.clear();
            reloadDirectoryStructure = false;
            anyOrderUpdated = false;
            updateOrderingCounter = 0;
        }
        if (filteredTagsChanged) {
            BlueprintBrowserWindow.updateSearch();
            filteredTagsChanged = false;
        }
        if (anyOrderUpdated) {
            if (updateOrderingCounter < 200) {
                ++updateOrderingCounter;
            } else {
                BlueprintBrowserWindow.updateOrdering(rootDirectory);
                updateOrderingCounter = 0;
                anyOrderUpdated = false;
            }
        }
    }

    private static void updateSearch() {
        boolean allowRecursiveSearch;
        String search = ImGuiHelper.getString(searchString);
        search = search.toLowerCase(Locale.ROOT);
        boolean bl = allowRecursiveSearch = Axiom.configuration.blueprint.recursiveSearch && (!search.isEmpty() || !filteredTags.isEmpty());
        if (allowRecursiveSearch) {
            if (recursiveSearchInCurrentDirectory == null) {
                recursiveSearchInCurrentDirectory = new ArrayList<BlueprintOrDirectory.Bp>();
            } else if (lastRecursiveSearch != null && search.startsWith(lastRecursiveSearch) && lastRecursiveSearchFilteredTags != null && filteredTags.containsAll(lastRecursiveSearchFilteredTags)) {
                if (search.equals(lastRecursiveSearch) && filteredTags.equals(lastRecursiveSearchFilteredTags)) {
                    return;
                }
                String searchF = search;
                lastRecursiveSearch = search;
                lastRecursiveSearchFilteredTags = Set.copyOf(filteredTags);
                recursiveSearchInCurrentDirectory.removeIf(bp -> !bp.nameContainsLower(searchF) || !bp.containsAllTags(filteredTags));
            }
            lastRecursiveSearch = search;
            lastRecursiveSearchFilteredTags = Set.copyOf(filteredTags);
            recursiveSearchInCurrentDirectory.clear();
            currentDirectory.addRecursiveSearch(search, recursiveSearchInCurrentDirectory, filteredTags);
        } else {
            BlueprintBrowserWindow.unsetRecursiveSearch();
            if (currentDirectory != null) {
                currentDirectory.search(search, filteredTags);
            }
        }
    }

    private static void handleMoveFileOperation() {
        if (BlueprintBrowserWindow.moveFileOperation.to.equals(BlueprintBrowserWindow.moveFileOperation.from)) {
            if (BlueprintBrowserWindow.moveFileOperation.repositionReference != null) {
                BlueprintBrowserWindow.moveFileOperation.to.reposition(BlueprintBrowserWindow.moveFileOperation.file, BlueprintBrowserWindow.moveFileOperation.repositionReference, BlueprintBrowserWindow.moveFileOperation.repositionBefore);
            }
            moveFileOperation = null;
        } else if (!BlueprintBrowserWindow.moveFileOperation.pendingOverwriteConfirmation || BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation) {
            try {
                Path path = BlueprintBrowserWindow.getNewPath(BlueprintBrowserWindow.moveFileOperation.to, BlueprintBrowserWindow.moveFileOperation.file);
                BlueprintBrowserWindow.moveBlueprint(BlueprintBrowserWindow.moveFileOperation.file, path, BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation);
                if (BlueprintBrowserWindow.moveFileOperation.from.remove(BlueprintBrowserWindow.moveFileOperation.file.path())) {
                    BlueprintBrowserWindow.moveFileOperation.file.path(path);
                    if (BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation) {
                        BlueprintBrowserWindow.moveFileOperation.to.remove(BlueprintBrowserWindow.moveFileOperation.file.path());
                    }
                    BlueprintBrowserWindow.moveFileOperation.to.addLast(BlueprintBrowserWindow.moveFileOperation.file);
                } else {
                    reloadDirectoryStructure = true;
                }
                moveFileOperation = null;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                noLongerExistsErrorFileName = BlueprintBrowserWindow.moveFileOperation.file.path().getFileName();
                moveFileOperation = null;
            }
            catch (FileAlreadyExistsException e) {
                if (BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation) {
                    displayedException = e;
                    moveFileOperation = null;
                    e.printStackTrace();
                } else {
                    BlueprintBrowserWindow.moveFileOperation.pendingOverwriteConfirmation = true;
                }
            }
            catch (Exception e) {
                displayedException = e;
                moveFileOperation = null;
                e.printStackTrace();
            }
        }
    }

    private static void pollAndUpdateWatchService() {
        WatchKey key;
        while ((key = watchService.poll()) != null) {
            Path keyPath = (Path)key.watchable();
            for (WatchEvent<?> event : key.pollEvents()) {
                Path filename;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    if (tooManyFileChangesCount < 0) {
                        tooManyFileChangesCount = 0;
                    }
                    tooManyFileChangesCount += Math.max(0, event.count());
                    continue;
                }
                Object obj = event.context();
                if (!(obj instanceof Path) || (filename = (Path)obj).getFileName().toString().startsWith(".")) continue;
                Path absolute = keyPath.resolve(filename);
                updatedBlueprintPaths.add(absolute);
            }
            if (key.reset()) continue;
            BlueprintDirectory blueprintDirectory = dirStructureMap.remove(keyPath);
            if (blueprintDirectory != null && blueprintDirectory.parent() != null) {
                blueprintDirectory.parent().remove(new PathWrapper(keyPath, null));
            }
            if (pendingSelectDirectory != null && pendingSelectDirectory.equals(blueprintDirectory)) {
                pendingSelectDirectory = null;
            }
            if (currentDirectory == null || !currentDirectory.equals(blueprintDirectory)) continue;
            currentDirectory = rootDirectory;
            BlueprintBrowserWindow.unsetRecursiveSearch();
        }
    }

    private static void setCurrentDirectory(BlueprintDirectory structure) {
        if (currentDirectory != null && currentDirectory.equals(structure)) {
            return;
        }
        if (currentDirectory != null) {
            currentDirectory.search("", Set.of());
            searchString.set("");
        }
        currentDirectory = structure;
        BlueprintBrowserWindow.unsetRecursiveSearch();
        structure.search("", filteredTags);
    }

    private static void renderDirectoryOverview(BlueprintDirectory blueprintDirectory, String id) {
        int flags = 4096;
        if (blueprintDirectory.children().isEmpty()) {
            flags |= 0x200;
        } else if (currentDirectory != blueprintDirectory) {
            flags |= 0x80;
        }
        if (blueprintDirectory.equals(rootDirectory)) {
            flags |= 0x20;
        }
        id = (String)id + blueprintDirectory.dirName();
        if (currentDirectory != null && currentDirectory.equals(blueprintDirectory)) {
            flags |= 1;
        }
        String formattedCount = NumberFormat.getInstance().format(blueprintDirectory.blueprints().size());
        boolean treeNodeOpen = ImGui.treeNodeEx(blueprintDirectory.dirName() + " (" + formattedCount + ")###DirOverview" + (String)id, flags);
        if (ImGui.isItemHovered() && ImGui.isMouseReleased(0) && (!(dirStructureToggled |= ImGui.isItemToggledOpen()) || blueprintDirectory.children().isEmpty())) {
            pendingSelectDirectory = blueprintDirectory;
        }
        if (ImGui.beginDragDropTarget()) {
            BlueprintOrDirectory blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
            if (blueprintOrDirectory != null) {
                ImVec2 min2 = ImGui.getItemRectMin();
                ImVec2 max2 = ImGui.getItemRectMax();
                ImGui.getForegroundDrawList().addRect(min2.x - 3.5f, min2.y - 3.5f, max2.x + 3.5f, max2.y + 3.5f, ImGui.getColorU32(50), 0.0f, 0, 2.0f);
                if (ImGui.isMouseReleased(0)) {
                    moveFileOperation = new MoveFileOperation(currentDirectory, blueprintDirectory, blueprintOrDirectory);
                }
            }
            ImGui.endDragDropTarget();
        }
        if (treeNodeOpen) {
            for (BlueprintDirectory child : blueprintDirectory.children()) {
                BlueprintBrowserWindow.renderDirectoryOverview(child, (String)id);
            }
            ImGui.treePop();
        }
    }

    public static void render() {
        if (pendingServerBlueprintDownload != null) {
            if (pendingServerBlueprintResult == null) {
                if (!ImGui.isPopupOpen("###DownloadingModal")) {
                    ImGui.openPopup("###DownloadingModal");
                }
                if (ImGuiHelper.beginPopupModal("###DownloadingModal", 325)) {
                    ImGui.text("Downloading blueprint...");
                    if (ImGui.button("Cancel")) {
                        pendingServerBlueprintDownload = null;
                    }
                    ImGui.endPopup();
                }
                return;
            }
            boolean success = callback.test(pendingServerBlueprintResult);
            if (!success) {
                callback = BlueprintBrowserWindow::defaultCallback;
                selectMultiple = false;
                callback.test(pendingServerBlueprintResult);
            }
            if (!(selectMultiple && EditorUI.getIO().getKeyShift() || EditorWindowType.BLUEPRINT_BROWSER.isDocked())) {
                EditorWindowType.BLUEPRINT_BROWSER.setOpen(false);
            }
            pendingServerBlueprintDownload = null;
            pendingServerBlueprintResult = null;
        }
        if (pendingServerBlueprintResult != null) {
            pendingServerBlueprintResult.close();
            pendingServerBlueprintResult = null;
        }
        if (!EditorWindowType.BLUEPRINT_BROWSER.isOpen()) {
            selectMultiple = false;
            callback = BlueprintBrowserWindow::defaultCallback;
            popupBrowserBecauseJustOpened = true;
            return;
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        if (popupBrowserBecauseJustOpened) {
            ImGui.setNextWindowSize(720.0f, 500.0f, 2);
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            popupBrowserBecauseJustOpened = false;
        }
        if (makeActiveBecauseJustOpened) {
            ImGui.setNextWindowFocus();
            makeActiveBecauseJustOpened = false;
        }
        ImGui.setNextWindowSizeConstraints(510.0f, 350.0f, 5000.0f, 3000.0f);
        if (EditorUI.canProcessKeybinds) {
            if (ImGui.isMouseClicked(3)) {
                BlueprintBrowserWindow.goBack();
            } else if (ImGui.isMouseClicked(4)) {
                BlueprintBrowserWindow.goForwards();
            }
        }
        if (EditorWindowType.BLUEPRINT_BROWSER.begin("###OpenBlueprint", true)) {
            BlueprintBrowserWindow.renderInner(center);
        }
        EditorWindowType.BLUEPRINT_BROWSER.end();
        if (!ImGui.isMouseDown(0)) {
            dirStructureToggled = false;
        }
    }

    private static void goBack() {
        if (currentDirectory == null) {
            return;
        }
        pendingSelectDirectory = currentDirectory.parent();
        forwardsQueue.add(0, currentDirectory);
    }

    private static void goForwards() {
        if (forwardsQueue.isEmpty()) {
            return;
        }
        BlueprintDirectory head = forwardsQueue.remove(0);
        if (currentDirectory == null || currentDirectory.children().contains(head)) {
            pendingSelectDirectory = head;
        } else {
            forwardsQueue.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void renderInner(ImVec2 center) {
        boolean backDisabled;
        renderedAtLeastOnce = true;
        AxiomConfig.SubcategoryBlueprint blueprintConfig = Axiom.configuration.blueprint;
        if (tooManyFileChangesCount >= 0) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            if (ImGuiHelper.beginPopupModal(AxiomI18n.get("axiom.editorui.window.blueprint_browser.overflow_files") + "###TooManyFileChangesPopup", 64)) {
                ImGui.pushTextWrapPos(600.0f);
                Object message = AxiomI18n.get("axiom.editorui.window.blueprint_browser.overflow_files_message");
                if (tooManyFileChangesCount > 0) {
                    message = (String)message + " (" + NumberFormat.getInstance().format(tooManyFileChangesCount) + "+)";
                }
                ImGui.text((String)message);
                ImGui.popTextWrapPos();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.reload"))) {
                    reloadDirectoryStructure = true;
                    tooManyFileChangesCount = -1;
                    ImGui.closeCurrentPopup();
                }
                ImGui.sameLine();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.disable_auto_refresh"))) {
                    tooManyFileChangesCount = -1;
                }
                EditorUI.consumeNavClose();
                ImGui.endPopup();
            } else {
                ImGui.openPopup("###TooManyFileChangesPopup");
            }
            moveFileOperation = null;
        } else if (noLongerExistsErrorFileName != null) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            if (ImGuiHelper.beginPopupModal(AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_missing") + "###NoLongerExistsErrorPopup", 64)) {
                String osFileBrowser = switch (class_156.method_668()) {
                    case class_156.class_158.field_1137 -> AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_browser_osx");
                    case class_156.class_158.field_1133 -> AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_browser_win");
                    default -> AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_browser_other");
                };
                ImGui.pushTextWrapPos(600.0f);
                ImGui.text(AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_missing_message1", noLongerExistsErrorFileName));
                ImGui.text(AxiomI18n.get("axiom.editorui.window.blueprint_browser.file_missing_message2", osFileBrowser));
                ImGui.popTextWrapPos();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.reload"))) {
                    reloadDirectoryStructure = true;
                    noLongerExistsErrorFileName = null;
                    ImGui.closeCurrentPopup();
                }
                EditorUI.consumeNavClose();
                ImGui.endPopup();
            } else {
                ImGui.openPopup("###NoLongerExistsErrorPopup");
            }
            moveFileOperation = null;
        } else if (editBlueprintData != null) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            String editBlueprint = AxiomI18n.get("axiom.editorui.window.blueprint_browser.edit_blueprint");
            if (!ImGui.isPopupOpen(editBlueprint + "###EditBlueprintPopup")) {
                ImGui.openPopup("###EditBlueprintPopup");
            }
            if (ImGuiHelper.beginPopupModalCloseable(editBlueprint + "###EditBlueprintPopup", 64)) {
                BlueprintBrowserWindow.editBlueprintPopup();
                ImGuiHelper.endPopupModalCloseable();
            }
            if (!ImGui.isPopupOpen(editBlueprint + "###EditBlueprintPopup") && editBlueprintData != null) {
                editBlueprintData.close();
                editBlueprintData = null;
            }
        } else if (displayedException != null) {
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            if (!ImGui.isPopupOpen("###BrowserErrorPopup")) {
                ImGui.openPopup("###BrowserErrorPopup");
            }
            if (ImGuiHelper.beginPopupModalCloseable(displayedException.getClass().getSimpleName() + "###BrowserErrorPopup", 64)) {
                ImGui.pushTextWrapPos(600.0f);
                ImGui.text(displayedException.getMessage());
                ImGui.popTextWrapPos();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.close"))) {
                    displayedException = null;
                    ImGui.closeCurrentPopup();
                }
                ImGuiHelper.endPopupModalCloseable();
            }
            if (!ImGui.isPopupOpen("###BrowserErrorPopup")) {
                displayedException = null;
            }
        } else if (moveFileOperation != null && BlueprintBrowserWindow.moveFileOperation.pendingOverwriteConfirmation) {
            if (!ImGui.isPopupOpen("###BrowserOverwritePopup")) {
                ImGui.openPopup("###BrowserOverwritePopup");
            }
            ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
            if (ImGuiHelper.beginPopupModalCloseable(AxiomI18n.get("axiom.editorui.window.blueprint_browser.move_file") + "###BrowserOverwritePopup", 64)) {
                ImGui.pushTextWrapPos(600.0f);
                ImGui.text(AxiomI18n.get("axiom.editorui.window.blueprint_browser.move_file_already_exists", BlueprintBrowserWindow.moveFileOperation.file.path().getFileName()));
                ImGui.popTextWrapPos();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.move_file_overwrite"))) {
                    BlueprintBrowserWindow.moveFileOperation.overwriteConfirmation = true;
                }
                ImGui.sameLine();
                if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.close"))) {
                    moveFileOperation = null;
                    ImGui.closeCurrentPopup();
                }
                ImGuiHelper.endPopupModalCloseable();
            }
            if (!ImGui.isPopupOpen("###BrowserOverwritePopup") && moveFileOperation != null) {
                moveFileOperation = null;
            }
        }
        ImGui.beginGroup();
        float uiScale = EditorUI.getUiScale();
        float contentRegionAvailX = ImGui.getContentRegionAvailX();
        float minDirectorySize = (int)Math.ceil(contentRegionAvailX / 10.0f);
        float maxDirectorySize = (int)Math.ceil(contentRegionAvailX / 2.0f);
        if (draggingDirListDividerStartMouseX >= 0.0f) {
            if (!ImGui.isAnyMouseDown()) {
                draggingDirListDividerStartMouseX = -1.0f;
            } else {
                ImGui.setMouseCursor(4);
                float mouseX = EditorUI.getIO().getMousePosX();
                float deltaX = mouseX - draggingDirListDividerStartMouseX;
                float newDirWidth = draggingDirListDividerStartDirWidth * uiScale + deltaX;
                newDirWidth = Math.max(minDirectorySize, Math.min(maxDirectorySize, newDirWidth));
                Axiom.configuration.internal.blueprintBrowserDirSize = (int)Math.ceil(newDirWidth / uiScale);
            }
        }
        float directorySize = Math.max(minDirectorySize, Math.min(maxDirectorySize, uiScale * (float)Axiom.configuration.internal.blueprintBrowserDirSize));
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.reload"), (int)Math.ceil(directorySize), 0.0f)) {
            reloadDirectoryStructure = true;
        }
        float halfButtonSize = (directorySize - ImGui.getStyle().getItemSpacingX()) / 2.0f;
        boolean bl = backDisabled = currentDirectory == null || currentDirectory.parent() == null;
        if (backDisabled) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.go_back"), (int)Math.floor(halfButtonSize), 0.0f)) {
            BlueprintBrowserWindow.goBack();
        }
        if (backDisabled) {
            ImGui.endDisabled();
        }
        ImGui.sameLine();
        boolean forwardsDisabled = forwardsQueue.isEmpty();
        if (forwardsDisabled) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.go_forwards"), (int)Math.ceil(halfButtonSize), 0.0f)) {
            BlueprintBrowserWindow.goForwards();
        }
        if (forwardsDisabled) {
            ImGui.endDisabled();
        }
        float bottomBarHeight = ImGui.getFrameHeightWithSpacing() + ImGui.getStyle().getItemSpacingY();
        if (ImGui.beginChild("DirList", directorySize, ImGui.getContentRegionAvailY() - bottomBarHeight, false, 2048)) {
            if (rootDirectory != null) {
                BlueprintBrowserWindow.renderDirectoryOverview(rootDirectory, "");
            }
            if (rootServerBlueprintDirectory != null) {
                BlueprintBrowserWindow.renderDirectoryOverview(rootServerBlueprintDirectory, "");
            } else if (!Authorization.hasCommercialLicense() && !class_310.method_1551().method_1496()) {
                int flags = 4608;
                if (ImGui.treeNodeEx("Server Blueprints", flags)) {
                    ImGui.treePop();
                }
                ImGuiHelper.tooltip("Server Blueprints are a Commercial License feature. Click for more information");
                ImGuiHelper.openCommercialLicenseOnClick();
            }
        }
        ImGui.endChild();
        ImGui.endGroup();
        ImGui.sameLine();
        if (draggingDirListDividerStartMouseX < 0.0f) {
            ImVec2 cursorPos = ImGui.getCursorScreenPos();
            float spacingX = ImGui.getStyle().getItemSpacingX();
            float mouseX = EditorUI.getIO().getMousePosX();
            ImGui.setCursorScreenPos(cursorPos.x - spacingX, cursorPos.y);
            ImGui.invisibleButton("##DirListDrag", spacingX, ImGui.getContentRegionAvailY() - bottomBarHeight);
            if (ImGui.isItemClicked()) {
                ImGui.setMouseCursor(4);
                draggingDirListDividerStartMouseX = mouseX;
                draggingDirListDividerStartDirWidth = directorySize / uiScale;
            } else if (ImGui.isItemHovered()) {
                ImGui.setMouseCursor(4);
            }
            ImGui.setCursorScreenPos(cursorPos.x, cursorPos.y);
        }
        ImGui.beginGroup();
        float tagFilterDropdownSize = ImGui.getContentRegionAvailX() * 0.75f;
        ImGui.setNextItemWidth(ImGui.getContentRegionAvailX() * 0.25f);
        if (ImGui.inputText("##Search", searchString)) {
            BlueprintBrowserWindow.updateSearch();
        }
        if (currentDirectory != null) {
            Map<String, Integer> tagsWithCount = currentDirectory.tagsWithCount();
            boolean broke = false;
            for (String string : filteredTags) {
                if (tagsWithCount.containsKey(string)) continue;
                ImGui.sameLine();
                if (!BlueprintBrowserWindow.renderTagFilterButton(string, 0)) continue;
                broke = true;
                break;
            }
            if (!broke) {
                ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(tagsWithCount.entrySet());
                list.sort(Comparator.comparingInt(entry -> -((Integer)entry.getValue()).intValue()));
                for (Map.Entry entry2 : list) {
                    ImGui.sameLine();
                    if (!BlueprintBrowserWindow.renderTagFilterButton((String)entry2.getKey(), (Integer)entry2.getValue())) continue;
                    broke = true;
                    break;
                }
            }
            ImVec2 buttonPos = ImGui.getCursorScreenPos();
            if (broke && ImGui.arrowButton("##TagFilterDropdownButton", 3)) {
                ImGui.openPopup("##TagFilterDropdown");
            }
            float f = ImGui.getFrameHeight();
            ImGui.setNextWindowPos(buttonPos.x + f, buttonPos.y + f, 1, 1.0f, 0.0f);
            if (ImGuiHelper.beginPopup("##TagFilterDropdown")) {
                BlueprintBrowserWindow.renderTagFilterDropdown(tagFilterDropdownSize, tagsWithCount);
                ImGui.endPopup();
            }
        }
        if (ImGui.beginChild("Browser", 0.0f, ImGui.getContentRegionAvailY() - bottomBarHeight)) {
            final int countPerRow = Math.max(1, (int)Math.floor((ImGui.getContentRegionAvailX() + ImGui.getStyle().getItemSpacingX() + 2.0f) / (100.0f + ImGui.getStyle().getItemSpacingX())));
            if (ImGui.isWindowHovered() && recursiveSearchInCurrentDirectory == null && ImGui.isMouseClicked(1)) {
                ImGui.openPopup("##BrowserCtxMenu");
            }
            if (currentDirectory != null && currentDirectory.path().real() != null && recursiveSearchInCurrentDirectory == null && ImGuiHelper.beginPopup("##BrowserCtxMenu")) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.add_folder"))) {
                    Path currentDir = currentDirectory.path().real();
                    int i = 0;
                    while (true) {
                        void var15_35;
                        if (i == 0) {
                            String string = AxiomI18n.get("axiom.editorui.window.blueprint_browser.new_folder");
                        } else {
                            String string = AxiomI18n.get("axiom.editorui.window.blueprint_browser.new_folder_i", Integer.toString(i));
                        }
                        Path path = currentDir.resolve((String)var15_35);
                        try {
                            Files.createDirectory(path, new FileAttribute[0]);
                            updatedBlueprintPaths.add(path);
                            break;
                        }
                        catch (FileAlreadyExistsException ignored) {
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            break;
                        }
                        ++i;
                    }
                }
                if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by"))) {
                    if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by.name"))) {
                        currentDirectory.sort(BlueprintDirectory.SortMode.NAME);
                    }
                    if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by.block_count"))) {
                        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by.ascending"))) {
                            currentDirectory.sort(BlueprintDirectory.SortMode.BLOCK_COUNT_ASC);
                        }
                        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.sort_by.descending"))) {
                            currentDirectory.sort(BlueprintDirectory.SortMode.BLOCK_COUNT_DESC);
                        }
                        ImGui.endMenu();
                    }
                    ImGui.endMenu();
                }
                ImGui.endPopup();
            }
            if (recursiveSearchInCurrentDirectory != null) {
                int vcount = (int)Math.ceil((float)recursiveSearchInCurrentDirectory.size() / (float)countPerRow);
                float itemHeightWithSpacing = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f + ImGui.getStyle().getItemSpacingY();
                ImGuiListClipper.forEach(vcount, (int)itemHeightWithSpacing, new ImListClipperCallback(){

                    @Override
                    public void accept(int index) {
                        int from = index * countPerRow;
                        int to = Math.min(from + countPerRow, recursiveSearchInCurrentDirectory.size());
                        for (int i = from; i < to; ++i) {
                            BlueprintOrDirectory blueprintOrDirectory = recursiveSearchInCurrentDirectory.get(i);
                            if (blueprintOrDirectory instanceof BlueprintOrDirectory.Dir) {
                                BlueprintOrDirectory.Dir dir = (BlueprintOrDirectory.Dir)blueprintOrDirectory;
                                ImGui.pushID(i);
                                BlueprintBrowserWindow.renderBlueprintDirectory(dir, i, i == to - 1);
                                ImGui.popID();
                            } else if (blueprintOrDirectory instanceof BlueprintOrDirectory.Bp) {
                                BlueprintOrDirectory.Bp bp = (BlueprintOrDirectory.Bp)blueprintOrDirectory;
                                ImGui.pushID(i);
                                BlueprintBrowserWindow.renderBlueprintLoaded(bp, i, i == to - 1);
                                ImGui.popID();
                            }
                            if (i >= to - 1) continue;
                            ImGui.sameLine();
                        }
                    }
                });
            } else if (currentDirectory != null && !currentDirectory.searchedBlueprints().isEmpty()) {
                int vcount = (int)Math.ceil((float)currentDirectory.searchedBlueprints().size() / (float)countPerRow);
                float itemHeightWithSpacing = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f + ImGui.getStyle().getItemSpacingY();
                ImGuiListClipper.forEach(vcount, (int)itemHeightWithSpacing, new ImListClipperCallback(){
                    private BlueprintOrDirectory currentBlueprintOrDirectory = null;
                    private boolean ended = false;

                    @Override
                    public void accept(int index) {
                        if (this.ended) {
                            return;
                        }
                        int from = index * countPerRow;
                        int to = Math.min(from + countPerRow, currentDirectory.searchedBlueprints().size());
                        if (this.currentBlueprintOrDirectory == null) {
                            this.currentBlueprintOrDirectory = currentDirectory.setSearchVisibleStart(from);
                            if (this.currentBlueprintOrDirectory == null) {
                                this.ended = true;
                                return;
                            }
                        }
                        for (int i = from; i < to; ++i) {
                            BlueprintOrDirectory blueprintOrDirectory = this.currentBlueprintOrDirectory;
                            if (blueprintOrDirectory instanceof BlueprintOrDirectory.Dir) {
                                BlueprintOrDirectory.Dir dir = (BlueprintOrDirectory.Dir)blueprintOrDirectory;
                                ImGui.pushID(i);
                                BlueprintBrowserWindow.renderBlueprintDirectory(dir, i, i == to - 1);
                                ImGui.popID();
                            } else if (blueprintOrDirectory instanceof BlueprintOrDirectory.Bp) {
                                BlueprintOrDirectory.Bp bp = (BlueprintOrDirectory.Bp)blueprintOrDirectory;
                                ImGui.pushID(i);
                                BlueprintBrowserWindow.renderBlueprintLoaded(bp, i, i == to - 1);
                                ImGui.popID();
                            }
                            this.currentBlueprintOrDirectory = blueprintOrDirectory.nextSearchNode;
                            if (this.currentBlueprintOrDirectory == null) {
                                this.ended = true;
                                return;
                            }
                            if (i >= to - 1) continue;
                            ImGui.sameLine();
                        }
                    }
                });
            }
        }
        ImGui.endChild();
        ImGui.endGroup();
        ImGui.separator();
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.open_folder"))) {
            Path rootPath = Axiom.getInstance().getBlueprintDirectory();
            class_156.method_668().method_673(rootPath.toUri());
        }
        ImGui.sameLine();
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.blueprint_browser.automatically_refresh"), blueprintConfig.automaticRefreshing)) {
            blueprintConfig.automaticRefreshing = !blueprintConfig.automaticRefreshing;
        }
        ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.window.blueprint_browser.automatically_refresh.description"));
        ImGui.sameLine();
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.blueprint_browser.search_inside_folders"), blueprintConfig.recursiveSearch)) {
            blueprintConfig.recursiveSearch = !blueprintConfig.recursiveSearch;
            BlueprintBrowserWindow.updateSearch();
        }
        ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.window.blueprint_browser.search_inside_folders.description"));
        ImGui.sameLine();
    }

    private static void renderTagFilterDropdown(float width, Map<String, Integer> tagsWithCount) {
        record Tag(String tag, String tagWithCount) {
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String string : filteredTags) {
            if (tagsWithCount.containsKey(string)) continue;
            tags.add(new Tag(string, string + " (0)"));
        }
        for (Map.Entry entry : tagsWithCount.entrySet()) {
            tags.add(new Tag((String)entry.getKey(), (String)entry.getKey() + " (" + String.valueOf(entry.getValue()) + ")"));
        }
        int minLines = 1;
        int n = 8;
        float itemSpacingX = ImGui.getStyle().getItemSpacingX();
        float framePaddingX = ImGui.getStyle().getFramePaddingX();
        float availableSpace = width;
        int lines = 0;
        boolean scrollbar = false;
        if (minLines == n) {
            lines = minLines;
            scrollbar = true;
        } else {
            float consumedWidth = 0.0f;
            for (Tag tag : tags) {
                float elementWidth = framePaddingX * 2.0f + ImGuiHelper.calcTextWidth(tag.tagWithCount);
                if (consumedWidth + elementWidth < availableSpace && consumedWidth > 0.0f) {
                    consumedWidth += elementWidth + itemSpacingX;
                    continue;
                }
                consumedWidth = elementWidth + itemSpacingX;
                if (++lines <= n) continue;
                lines = n;
                scrollbar = true;
                break;
            }
            if (lines < minLines) {
                lines = minLines;
            }
        }
        float lineHeight = (float)ImGui.getFontSize() + ImGui.getStyle().getFramePaddingY() * 2.0f + ImGui.getStyle().getItemSpacingY();
        if (ImGui.beginChild("##TagFilterDropdownScroller", width, lineHeight * (float)lines - ImGui.getStyle().getItemSpacingY())) {
            if (scrollbar) {
                availableSpace -= ImGui.getStyle().getScrollbarSize();
            }
            boolean disabledAlpha = false;
            float consumedWidth = 0.0f;
            for (Tag tag : tags) {
                float elementWidth = framePaddingX * 2.0f + ImGuiHelper.calcTextWidth(tag.tagWithCount);
                if (consumedWidth + elementWidth < availableSpace && consumedWidth > 0.0f) {
                    ImGui.sameLine();
                    consumedWidth += elementWidth + itemSpacingX;
                } else {
                    consumedWidth = elementWidth + itemSpacingX;
                }
                boolean contains = filteredTags.contains(tag.tag);
                if (contains != disabledAlpha) {
                    disabledAlpha = contains;
                    if (disabledAlpha) {
                        ImGuiHelper.pushStyleVar(0, ImGui.getStyle().getAlpha() * ImGui.getStyle().getDisabledAlpha());
                    } else {
                        ImGuiHelper.popStyleVar();
                    }
                }
                if (!ImGui.button(tag.tagWithCount + "##" + tag.tag)) continue;
                if (contains) {
                    filteredTags.remove(tag.tag);
                } else {
                    filteredTags.add(tag.tag);
                }
                filteredTagsChanged = true;
            }
            if (disabledAlpha) {
                ImGuiHelper.popStyleVar();
            }
        }
        ImGui.endChild();
    }

    private static boolean renderTagFilterButton(String tag, int count) {
        float needed;
        String display = tag + " (" + count + ")";
        float available = ImGui.getContentRegionAvailX();
        if (available < (needed = ImGui.getStyle().getFramePaddingX() * 2.0f + ImGuiHelper.calcTextWidth(display) + ImGui.getStyle().getItemSpacingX() + ImGui.getFrameHeight())) {
            return true;
        }
        boolean contains = filteredTags.contains(tag);
        if (contains) {
            ImGuiHelper.pushStyleVar(0, ImGui.getStyle().getAlpha() * ImGui.getStyle().getDisabledAlpha());
        }
        if (ImGui.button(display + "##" + tag)) {
            if (contains) {
                filteredTags.remove(tag);
            } else {
                filteredTags.add(tag);
            }
            filteredTagsChanged = true;
        }
        if (contains) {
            ImGuiHelper.popStyleVar();
        }
        return false;
    }

    private static void editBlueprintPopup() {
        if (!BlueprintBrowserWindow.editBlueprintData.previewLocked && BlueprintBrowserWindow.editBlueprintData.blockRegion.count() < 0x1000000) {
            ImGui.image(BlueprintBrowserWindow.editBlueprintData.blueprintPreview.render(512, true, true), 256.0f, 256.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            if (BlueprintBrowserWindow.editBlueprintData.isRotating) {
                if (!ImGui.isMouseDown(0)) {
                    BlueprintBrowserWindow.editBlueprintData.isRotating = false;
                    BlueprintBrowserWindow.editBlueprintData.blueprintPreview.mouseReleased();
                } else {
                    float mouseX = ImGui.getMousePosX();
                    float mouseY = ImGui.getMousePosY();
                    BlueprintBrowserWindow.editBlueprintData.blueprintPreview.mouseMoved(mouseX - BlueprintBrowserWindow.editBlueprintData.lastMouseX, mouseY - BlueprintBrowserWindow.editBlueprintData.lastMouseY, EditorUI.isCtrlOrCmdDown());
                    BlueprintBrowserWindow.editBlueprintData.lastMouseX = mouseX;
                    BlueprintBrowserWindow.editBlueprintData.lastMouseY = mouseY;
                }
            } else if (ImGui.isItemClicked(0)) {
                BlueprintBrowserWindow.editBlueprintData.isRotating = true;
                BlueprintBrowserWindow.editBlueprintData.lastMouseX = ImGui.getMousePosX();
                BlueprintBrowserWindow.editBlueprintData.lastMouseY = ImGui.getMousePosY();
            }
        }
        ImGui.inputText(AxiomI18n.get("axiom.editorui.window.create_blueprint.name"), BlueprintBrowserWindow.editBlueprintData.blueprintName);
        ImGui.inputText(AxiomI18n.get("axiom.editorui.window.create_blueprint.author"), BlueprintBrowserWindow.editBlueprintData.authorName);
        BlueprintBrowserWindow.editBlueprintData.tagListWidget.render(256);
        if (!BlueprintBrowserWindow.editBlueprintData.previewLocked) {
            float[] angleArray = new float[]{BlueprintBrowserWindow.editBlueprintData.blueprintPreview.getYaw(), BlueprintBrowserWindow.editBlueprintData.blueprintPreview.getPitch()};
            if (ImGui.inputFloat2(AxiomI18n.get("axiom.editorui.window.create_blueprint.angle"), angleArray, "%.2f")) {
                BlueprintBrowserWindow.editBlueprintData.blueprintPreview.setYaw(angleArray[0], false);
                BlueprintBrowserWindow.editBlueprintData.blueprintPreview.setPitch(angleArray[1], false);
            }
        }
        if (ImGui.button(AxiomI18n.get("axiom.editorui.window.create_blueprint.save"))) {
            if (BlueprintBrowserWindow.editBlueprintData.previewImageFuture != null) {
                BlueprintBrowserWindow.editBlueprintData.previewImageFuture.thenAccept(class_1011::close);
            }
            if (BlueprintBrowserWindow.editBlueprintData.blockRegion.count() < 0x1000000) {
                BlueprintBrowserWindow.editBlueprintData.blueprintPreview.render(960, false, false);
                BlueprintBrowserWindow.editBlueprintData.previewImageFuture = BlueprintBrowserWindow.editBlueprintData.blueprintPreview.toNativeImage(96, true);
            } else {
                BlueprintBrowserWindow.editBlueprintData.previewImageFuture = CompletableFuture.completedFuture(new class_1011(96, 96, true));
            }
        }
        if (BlueprintBrowserWindow.editBlueprintData.previewImageFuture != null && BlueprintBrowserWindow.editBlueprintData.previewImageFuture.isDone()) {
            BlueprintHeader header = new BlueprintHeader(ImGuiHelper.getString(BlueprintBrowserWindow.editBlueprintData.blueprintName).trim(), ImGuiHelper.getString(BlueprintBrowserWindow.editBlueprintData.authorName).trim(), BlueprintBrowserWindow.editBlueprintData.tagListWidget.tags(), BlueprintBrowserWindow.editBlueprintData.blueprintPreview.getYaw(), BlueprintBrowserWindow.editBlueprintData.blueprintPreview.getPitch(), false, BlueprintBrowserWindow.editBlueprintData.blockRegion.count(), BlueprintBrowserWindow.editBlueprintData.containsAir);
            updatedBlueprintPaths.add(BlueprintBrowserWindow.editBlueprintData.path);
            class_1011 nativeImage = BlueprintBrowserWindow.editBlueprintData.previewImageFuture.join();
            BlueprintBrowserWindow.editBlueprintData.previewImageFuture = null;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(BlueprintBrowserWindow.editBlueprintData.path, new OpenOption[0]));){
                BlueprintIo.write(outputStream, header, nativeImage, BlueprintBrowserWindow.editBlueprintData.blockRegion, BlueprintBrowserWindow.editBlueprintData.blockEntities, BlueprintBrowserWindow.editBlueprintData.entities);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            nativeImage.close();
            ImGui.closeCurrentPopup();
            editBlueprintData.close();
            editBlueprintData = null;
        }
        ImGui.sameLine();
        if (ImGui.button(AxiomI18n.get("axiom.widget.cancel"))) {
            ImGui.closeCurrentPopup();
            editBlueprintData.close();
            editBlueprintData = null;
        }
    }

    private static void renderBlueprintDirectory(BlueprintOrDirectory.Dir directory, int index, boolean last) {
        float lineX;
        BlueprintOrDirectory blueprintOrDirectory;
        ImVec2 textSize = new ImVec2();
        ImGui.calcTextSize(textSize, directory.blueprintDirectory.dirName(), 100.0f);
        float childHeight = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f;
        boolean openCtxMenu = false;
        ImVec2 startCursorPos = ImGui.getCursorScreenPos();
        float itemSpacingX = ImGui.getStyle().getItemSpacingX();
        ImGui.setCursorScreenPos(startCursorPos.x - itemSpacingX, startCursorPos.y);
        ImGui.dummy(itemSpacingX + 20.0f, childHeight);
        if (ImGui.beginDragDropTarget()) {
            blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
            if (blueprintOrDirectory != null && directory.prevNode != blueprintOrDirectory && directory != blueprintOrDirectory) {
                lineX = startCursorPos.x - ImGui.getStyle().getItemSpacingX() / 2.0f;
                ImGui.getForegroundDrawList().addRectFilled(lineX - 1.0f, startCursorPos.y, lineX + 1.0f, startCursorPos.y + 100.0f + 3.0f, ImGui.getColorU32(50));
                if (ImGui.isMouseReleased(0)) {
                    moveFileOperation = new MoveFileOperation(currentDirectory, currentDirectory, blueprintOrDirectory);
                    BlueprintBrowserWindow.moveFileOperation.repositionBefore = true;
                    BlueprintBrowserWindow.moveFileOperation.repositionReference = directory;
                }
            }
            ImGui.endDragDropTarget();
        }
        ImGui.setCursorScreenPos(startCursorPos.x + 80.0f, startCursorPos.y);
        ImGui.dummy(last ? ImGui.getContentRegionAvailX() : 20.0f, childHeight);
        if (ImGui.beginDragDropTarget()) {
            blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
            if (blueprintOrDirectory != null && directory.nextNode != blueprintOrDirectory && directory != blueprintOrDirectory) {
                lineX = startCursorPos.x + 100.0f + ImGui.getStyle().getItemSpacingX() / 2.0f;
                ImGui.getForegroundDrawList().addRectFilled(lineX - 1.0f, startCursorPos.y, lineX + 1.0f, startCursorPos.y + 100.0f + 3.0f, ImGui.getColorU32(50));
                if (ImGui.isMouseReleased(0)) {
                    moveFileOperation = new MoveFileOperation(currentDirectory, currentDirectory, blueprintOrDirectory);
                    BlueprintBrowserWindow.moveFileOperation.repositionBefore = false;
                    BlueprintBrowserWindow.moveFileOperation.repositionReference = directory;
                }
            }
            ImGui.endDragDropTarget();
        }
        ImGui.setCursorScreenPos(startCursorPos.x, startCursorPos.y);
        if (ImGui.beginChild("", 100.0f, childHeight, false, 59)) {
            BlueprintOrDirectory.Bp head;
            Thumbnail thumbnail;
            Object min2;
            ImVec2 pos = ImGui.getCursorScreenPos();
            ImGuiHelper.pushStyleVar(11, 0.0f, 0.0f);
            ImVec2 buttonStartPos = ImGui.getCursorScreenPos();
            ImGui.setCursorScreenPos(buttonStartPos.x + 20.0f, buttonStartPos.y);
            ImGui.dummy(60.0f, 100.0f);
            if (ImGui.beginDragDropTarget()) {
                BlueprintOrDirectory blueprintOrDirectory2 = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
                if (blueprintOrDirectory2 != null && directory != blueprintOrDirectory2) {
                    min2 = ImGui.getItemRectMin();
                    ImVec2 max2 = ImGui.getItemRectMax();
                    ImGui.getForegroundDrawList().addRect(((ImVec2)min2).x - 3.5f - 20.0f, ((ImVec2)min2).y - 3.5f, max2.x + 3.5f + 20.0f, max2.y + 3.5f, ImGui.getColorU32(50), 0.0f, 0, 2.0f);
                    if (ImGui.isMouseReleased(0)) {
                        moveFileOperation = new MoveFileOperation(currentDirectory, directory.blueprintDirectory, blueprintOrDirectory2);
                    }
                }
                ImGui.endDragDropTarget();
            }
            ImGui.setCursorScreenPos(buttonStartPos.x, buttonStartPos.y);
            ImGui.pushFont(EditorUI.icons);
            if (ImGui.button("\ue908", 100.0f, 100.0f)) {
                pendingSelectDirectory = directory.blueprintDirectory;
            }
            if ((min2 = directory.blueprintDirectory.head()) instanceof BlueprintOrDirectory.Bp && (thumbnail = loadedBlueprintThumbnails.get((head = (BlueprintOrDirectory.Bp)min2).path())) != null) {
                class_1043 texture = thumbnail.getTextureOrMissing();
                if (texture != null) {
                    ImGui.getWindowDrawList().addImage(new AxiomGpuTexture(texture.method_4624()).glId(), buttonStartPos.x, buttonStartPos.y + 100.0f, buttonStartPos.x + 100.0f, buttonStartPos.y);
                }
                ImGui.getWindowDrawList().addRectFilled(buttonStartPos.x + 17.0f, buttonStartPos.y + 33.0f, buttonStartPos.x + 83.0f, buttonStartPos.y + 81.0f, -1, 5.0f);
            }
            openCtxMenu = ImGui.isItemClicked(1);
            if (ImGui.beginDragDropSource()) {
                ImGui.setDragDropPayload("BlueprintOrDirectory", directory);
                ImGui.text("\ue908");
                ImGui.endDragDropSource();
            }
            ImGui.popFont();
            String countText = NumberFormat.getInstance().format(directory.blueprintDirectory.blueprints().size());
            ImVec2 countTextSize = new ImVec2();
            ImGui.calcTextSize(countTextSize, countText);
            ImGui.getWindowDrawList().addText(pos.x + 50.0f - countTextSize.x / 2.0f, pos.y + 5.0f + 50.0f - countTextSize.y / 2.0f, -9155541, countText);
            ImVec2 cursorPos = ImGui.getCursorPos();
            ImGui.setCursorPos(cursorPos.x + (100.0f - textSize.x) / 2.0f, cursorPos.y);
            ImGui.pushTextWrapPos(100.0f);
            ImGui.text(directory.blueprintDirectory.dirName());
            ImGui.popTextWrapPos();
            ImGuiHelper.popStyleVar();
        }
        ImGui.endChild();
        if (directory.path().real() != null) {
            Path path = directory.path().real();
            boolean openRename = false;
            if (openCtxMenu) {
                ImGui.openPopup("###BlueprintCtxMenu" + index);
            }
            if (ImGuiHelper.beginPopup("###BlueprintCtxMenu" + index)) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.rename_file"))) {
                    openRename = true;
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.delete"))) {
                    try {
                        Files.delete(path);
                        BlueprintDirectory parent = dirStructureMap.get(path.getParent());
                        if (parent != null) {
                            parent.remove(directory.path());
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = directory.path().getFileName();
                    }
                    catch (Exception e) {
                        displayedException = e;
                        e.printStackTrace();
                    }
                }
                ImGui.endPopup();
            }
            BlueprintBrowserWindow.renameContextMenu(directory, index, openRename);
        }
    }

    private static void renderBlueprintLoaded(BlueprintOrDirectory.Bp blueprint, int index, boolean last) {
        boolean fileBasedBlueprint = blueprint.path().real() != null;
        String textToRender = blueprint.blueprint.name().trim();
        if (textToRender.isBlank()) {
            textToRender = AxiomI18n.get("axiom.editorui.window.blueprint_browser.unnamed_blueprint");
        }
        ImVec2 textSize = new ImVec2();
        ImGui.calcTextSize(textSize, textToRender, 100.0f);
        float childHeight = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f;
        boolean openCtxMenu = false;
        if (fileBasedBlueprint) {
            float lineX;
            BlueprintOrDirectory blueprintOrDirectory;
            ImVec2 startCursorPos = ImGui.getCursorScreenPos();
            float itemSpacingX = ImGui.getStyle().getItemSpacingX();
            ImGui.setCursorScreenPos(startCursorPos.x - itemSpacingX, startCursorPos.y);
            ImGui.dummy(itemSpacingX + 50.0f, childHeight);
            if (ImGui.beginDragDropTarget()) {
                blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
                if (blueprintOrDirectory != null && blueprint.prevNode != blueprintOrDirectory && blueprint != blueprintOrDirectory) {
                    lineX = startCursorPos.x - ImGui.getStyle().getItemSpacingX() / 2.0f;
                    ImGui.getForegroundDrawList().addRectFilled(lineX - 1.0f, startCursorPos.y, lineX + 1.0f, startCursorPos.y + 100.0f + 3.0f, ImGui.getColorU32(50));
                    if (ImGui.isMouseReleased(0)) {
                        moveFileOperation = new MoveFileOperation(currentDirectory, currentDirectory, blueprintOrDirectory);
                        BlueprintBrowserWindow.moveFileOperation.repositionBefore = true;
                        BlueprintBrowserWindow.moveFileOperation.repositionReference = blueprint;
                    }
                }
                ImGui.endDragDropTarget();
            }
            ImGui.setCursorScreenPos(startCursorPos.x + 50.0f, startCursorPos.y);
            ImGui.dummy(last ? ImGui.getContentRegionAvailX() : 50.0f, childHeight);
            if (ImGui.beginDragDropTarget()) {
                blueprintOrDirectory = (BlueprintOrDirectory)ImGui.acceptDragDropPayload("BlueprintOrDirectory", 3072);
                if (blueprintOrDirectory != null && blueprint.nextNode != blueprintOrDirectory && blueprint != blueprintOrDirectory) {
                    lineX = startCursorPos.x + 100.0f + ImGui.getStyle().getItemSpacingX() / 2.0f;
                    ImGui.getForegroundDrawList().addRectFilled(lineX - 1.0f, startCursorPos.y, lineX + 1.0f, startCursorPos.y + 100.0f + 3.0f, ImGui.getColorU32(50));
                    if (ImGui.isMouseReleased(0)) {
                        moveFileOperation = new MoveFileOperation(currentDirectory, currentDirectory, blueprintOrDirectory);
                        BlueprintBrowserWindow.moveFileOperation.repositionBefore = false;
                        BlueprintBrowserWindow.moveFileOperation.repositionReference = blueprint;
                    }
                }
                ImGui.endDragDropTarget();
            }
            ImGui.setCursorScreenPos(startCursorPos.x, startCursorPos.y);
        }
        if (ImGui.beginChild("", 100.0f, childHeight, false, 59)) {
            ImGuiHelper.pushStyleVar(11, 0.0f, 0.0f);
            Thumbnail thumbnail = loadedBlueprintThumbnails.get(blueprint.path());
            class_1043 texture = thumbnail == null ? null : thumbnail.getTextureOrMissing();
            boolean openBlueprint = texture != null ? ImGui.imageButton(new AxiomGpuTexture(texture.method_4624()).glId(), 96.0f, 96.0f, 0.0f, 1.0f, 1.0f, 0.0f, 2) : ImGui.button("##OpenBlueprintFallback", 100.0f, 100.0f);
            openCtxMenu = ImGui.isItemClicked(1);
            if (fileBasedBlueprint && ImGui.beginDragDropSource()) {
                ImGui.setDragDropPayload("BlueprintOrDirectory", blueprint);
                if (texture != null) {
                    ImGui.image(new AxiomGpuTexture(texture.method_4624()).glId(), 100.0f, 100.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                }
                ImGui.endDragDropSource();
            }
            if (openBlueprint) {
                if (fileBasedBlueprint) {
                    try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(blueprint.path().real(), new OpenOption[0]));){
                        Blueprint fullBlueprint = BlueprintIo.readBlueprint(inputStream);
                        if (fullBlueprint.blockRegion().isEmpty()) {
                            ChatUtils.error("Failed to load blueprint: empty");
                            fullBlueprint.close();
                        } else {
                            boolean success = callback.test(fullBlueprint);
                            if (!success) {
                                callback = BlueprintBrowserWindow::defaultCallback;
                                selectMultiple = false;
                                callback.test(fullBlueprint);
                            }
                        }
                        if (!(selectMultiple && EditorUI.getIO().getKeyShift() || EditorWindowType.BLUEPRINT_BROWSER.isDocked())) {
                            EditorWindowType.BLUEPRINT_BROWSER.setOpen(false);
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = blueprint.path().getFileName();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (Axiom.getInstance().serverConfig == null || Axiom.getInstance().serverConfig.blueprintVersion() != 2) {
                    ChatUtils.error("Unable to request blueprint since server is running a version with a different blueprint format. Please ensure both the client & server are running the most up-to-date versions of Axiom");
                } else if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.BLUEPRINT_REQUEST)) {
                    ChatUtils.error("Server has not given you permission to download blueprints");
                } else {
                    pendingServerBlueprintDownload = blueprint.path().fakePath();
                    if (pendingServerBlueprintResult != null) {
                        pendingServerBlueprintResult.close();
                        pendingServerBlueprintResult = null;
                    }
                    new AxiomServerboundRequestBlueprint(blueprint.path().fakePath()).send();
                }
            }
            ImVec2 cursorPos = ImGui.getCursorPos();
            ImGui.setCursorPos(cursorPos.x + (100.0f - textSize.x) / 2.0f, cursorPos.y);
            ImGui.pushTextWrapPos(100.0f);
            ImGui.text(textToRender);
            ImGui.popTextWrapPos();
            if (textSize.y > ImGui.getTextLineHeight() + ImGui.getTextLineHeightWithSpacing() && ImGui.isItemHovered()) {
                ImGui.beginTooltip();
                ImGui.pushTextWrapPos((float)ImGui.getFontSize() * 20.0f);
                ImGui.textUnformatted(textToRender);
                ImGui.popTextWrapPos();
                ImGui.endTooltip();
            }
            ImGuiHelper.popStyleVar();
        }
        ImGui.endChild();
        if (fileBasedBlueprint) {
            Path path = blueprint.path().real();
            boolean openRename = false;
            if (openCtxMenu) {
                ImGui.openPopup("###BlueprintCtxMenu" + index);
            }
            if (ImGuiHelper.beginPopup("###BlueprintCtxMenu" + index)) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.rename_file"))) {
                    openRename = true;
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.edit_blueprint"))) {
                    try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                        Blueprint fullBlueprint = BlueprintIo.readBlueprint(inputStream);
                        if (editBlueprintData != null) {
                            editBlueprintData.close();
                        }
                        editBlueprintData = new EditBlueprintData(path, fullBlueprint.thumbnail(), fullBlueprint.blockRegion(), fullBlueprint.blockEntities(), fullBlueprint.entities(), fullBlueprint.header().containsAir());
                        BlueprintBrowserWindow.editBlueprintData.blueprintName.set(fullBlueprint.header().name());
                        BlueprintBrowserWindow.editBlueprintData.authorName.set(fullBlueprint.header().author());
                        BlueprintBrowserWindow.editBlueprintData.tagListWidget.tags().addAll(fullBlueprint.header().tags());
                        BlueprintBrowserWindow.editBlueprintData.blueprintPreview.setYaw(fullBlueprint.header().thumbnailYaw(), false);
                        BlueprintBrowserWindow.editBlueprintData.blueprintPreview.setPitch(fullBlueprint.header().thumbnailPitch(), false);
                        BlueprintBrowserWindow.editBlueprintData.previewLocked = fullBlueprint.header().lockedThumbnail();
                        ImGui.closeCurrentPopup();
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = path.getFileName().toString();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.delete"))) {
                    try {
                        Files.delete(path);
                        BlueprintDirectory parent = dirStructureMap.get(path.getParent());
                        if (parent != null) {
                            parent.remove(blueprint.path());
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = path.getFileName().toString();
                    }
                    catch (Exception e) {
                        displayedException = e;
                        e.printStackTrace();
                    }
                }
                if (rootServerBlueprintDirectory != null) {
                    if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.BLUEPRINT_UPLOAD)) {
                        ImGuiHelper.disabledMenuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.upload_to_server"), "Server hasn't given you permission to upload blueprints");
                    } else if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.window.blueprint_browser.upload_to_server"))) {
                        if (Axiom.getInstance().serverConfig == null || Axiom.getInstance().serverConfig.blueprintVersion() != 2) {
                            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Unable to upload blueprint since server is running a version with a different blueprint format. Please ensure both the client & server are running the most up-to-date versions of Axiom"));
                        } else {
                            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                                RawBlueprint rawBlueprint = BlueprintIo.readRawBlueprint(inputStream);
                                Path rootPath = Axiom.getInstance().getBlueprintDirectory();
                                Path relative = rootPath.relativize(path);
                                Object relativeStr = relative.toString();
                                relativeStr = ((String)relativeStr).replace("\\", "/");
                                if (!((String)relativeStr).startsWith("/")) {
                                    relativeStr = "/" + (String)relativeStr;
                                }
                                new AxiomServerboundUploadBlueprint((String)relativeStr, rawBlueprint).send();
                                ImGui.closeCurrentPopup();
                            }
                            catch (FileNotFoundException | NoSuchFileException e) {
                                noLongerExistsErrorFileName = path.getFileName().toString();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                ImGui.endPopup();
            }
            BlueprintBrowserWindow.renameContextMenu(blueprint, index, openRename);
        }
    }

    private static void renameContextMenu(BlueprintOrDirectory blueprint, int index, boolean openRename) {
        Path path = blueprint.path().real();
        if (openRename) {
            ImGui.openPopup("###BlueprintCtxMenu" + index + "Rename");
            renameFilenameString.set(path.getFileName().toString());
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
        if (ImGuiHelper.beginPopupModalCloseable(AxiomI18n.get("axiom.editorui.window.blueprint_browser.rename_file") + "###BlueprintCtxMenu" + index + "Rename", 64)) {
            boolean confirm = ImGui.inputText("##Filename", renameFilenameString, 32);
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.blueprint_browser.confirm")) || confirm) {
                String filename = path.getFileName().toString();
                String newFilename = ImGuiHelper.getString(renameFilenameString);
                if (!newFilename.equals(filename)) {
                    try {
                        Path newPath = path.getParent().resolve(newFilename);
                        BlueprintDirectory from = dirStructureMap.get(path.getParent());
                        BlueprintDirectory to = dirStructureMap.get(newPath.getParent());
                        Files.move(path, newPath, new CopyOption[0]);
                        if (from == to) {
                            from.changeChildPath(path, newPath);
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        noLongerExistsErrorFileName = path.getFileName().toString();
                    }
                    catch (Exception e) {
                        displayedException = e;
                        e.printStackTrace();
                    }
                }
                ImGui.closeCurrentPopup();
            }
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.widget.cancel"))) {
                ImGui.closeCurrentPopup();
            }
            ImGuiHelper.endPopupModalCloseable();
        }
    }

    private static Path getNewPath(BlueprintDirectory newDir, BlueprintOrDirectory blueprintOrDirectory) {
        return newDir.path().real().resolve(blueprintOrDirectory.path().getFileName());
    }

    private static void moveBlueprint(BlueprintOrDirectory blueprintOrDirectory, Path path, boolean overwrite) throws IOException {
        CopyOption[] copyOptionArray;
        if (blueprintOrDirectory.path().real().equals(path)) {
            return;
        }
        Path path2 = blueprintOrDirectory.path().real();
        if (overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        Files.move(path2, path, copyOptionArray);
    }

    private static class MoveFileOperation {
        boolean pendingOverwriteConfirmation = false;
        boolean overwriteConfirmation = false;
        BlueprintDirectory from;
        BlueprintDirectory to;
        BlueprintOrDirectory file;
        BlueprintOrDirectory repositionReference;
        boolean repositionBefore;

        public MoveFileOperation(BlueprintDirectory from, BlueprintDirectory to, BlueprintOrDirectory file) {
            this.from = from;
            this.to = to;
            this.file = file;
        }
    }

    public record Thumbnail(DynamicTextureSupplier textureSupplier) {
        public class_1043 getTextureOrMissing() {
            return this.textureSupplier != null ? this.textureSupplier.get() : MissingTextureImage.getDynamicTexture();
        }
    }

    public static class EditBlueprintData {
        Path path;
        ChunkedBlockRegion blockRegion;
        Long2ObjectMap<CompressedBlockEntity> blockEntities;
        List<class_2487> entities;
        boolean isRotating = false;
        float lastMouseX = 0.0f;
        float lastMouseY = 0.0f;
        boolean previewLocked = false;
        DynamicTextureSupplier fallbackPreview;
        BlueprintPreview blueprintPreview = new BlueprintPreview();
        ImString blueprintName = new ImString();
        ImString authorName = new ImString();
        TagListWidget tagListWidget = new TagListWidget();
        CompletableFuture<class_1011> previewImageFuture = null;
        boolean containsAir;

        public EditBlueprintData(Path path, DynamicTextureSupplier fallbackPreview, ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, List<class_2487> entities, boolean containsAir) {
            this.path = path;
            this.blockRegion = blockRegion;
            this.blockEntities = blockEntities;
            this.entities = entities;
            this.fallbackPreview = fallbackPreview;
            this.blueprintPreview.setBlockRegion(blockRegion);
            this.containsAir = containsAir;
        }

        public void close() {
            this.fallbackPreview.close();
            if (this.previewImageFuture != null) {
                this.previewImageFuture.thenAccept(class_1011::close);
                this.previewImageFuture = null;
            }
        }
    }
}

