/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.shape.TerrainDistanceField;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CylinderRasterization {
    private static final Quaternionf EMPTY_QUATERNION = new Quaternionf();
    private static final int[] CARDINAL_OFFSETS = new int[]{0, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, 0};

    public static void cylinder(ChunkedBlockRegion region, class_2680 block, class_2338 center, float diameterX, float height, float diameterZ, boolean hollow, boolean centerEvenDiameters, @Nullable Quaternionf quaternionf) {
        if (diameterX <= 0.0f || height <= 0.0f || diameterZ <= 0.0f) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        float radiusX = (diameterX - 1.0f) / 2.0f;
        float radiusY = (height - 1.0f) / 2.0f;
        float radiusZ = (diameterZ - 1.0f) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRadiusY * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        float invRadiusSqX = 1.0f / ((radiusX + 0.5f) * (radiusX + 0.5f));
        float invRadiusSqZ = 1.0f / ((radiusZ + 0.5f) * (radiusZ + 0.5f));
        if (!Float.isFinite(invRadiusSqX)) {
            invRadiusSqX = Float.MAX_VALUE;
        }
        if (!Float.isFinite(invRadiusSqZ)) {
            invRadiusSqZ = Float.MAX_VALUE;
        }
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float offsetX = centerEvenDiameters ? -(radiusX % 1.0f) : 0.0f;
        float offsetY = centerEvenDiameters ? -(radiusY % 1.0f) : 0.0f;
        float offsetZ = centerEvenDiameters ? -(radiusZ % 1.0f) : 0.0f;
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block5: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    if (!(rx * rx * invRadiusSqX + rz * rz * invRadiusSqZ <= 1.0f) || !(Math.abs(ry) <= radiusY + 0.5f)) continue;
                    if (!hollow) {
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue;
                    }
                    for (int i = 0; i < 18; i += 3) {
                        int nx = x + CARDINAL_OFFSETS[i];
                        int ny = y + CARDINAL_OFFSETS[i + 1];
                        int nz = z + CARDINAL_OFFSETS[i + 2];
                        vector3f.set((float)nx, (float)ny, (float)nz);
                        quaternionf.transform(vector3f);
                        rx = vector3f.x + offsetX;
                        ry = vector3f.y + offsetY;
                        rz = vector3f.z + offsetZ;
                        if (!(rx * rx * invRadiusSqX + rz * rz * invRadiusSqZ > 1.0f) && !(Math.abs(ry) > radiusY + 0.5f)) continue;
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue block5;
                    }
                }
            }
        }
    }

    public static void cylinderMetaball(ChunkedBlockRegion region, int metaballRange, class_2680 block, class_2338 center, float diameterX, float height, float diameterZ, boolean hollow, boolean centerEvenDiameters, @Nullable Quaternionf quaternionf) {
        class_638 level = class_310.method_1551().field_1687;
        if (metaballRange <= 1 || level == null) {
            CylinderRasterization.cylinder(region, block, center, diameterX, height, diameterZ, hollow, centerEvenDiameters, quaternionf);
            return;
        }
        int extra = (int)Math.ceil(Math.sqrt((float)(metaballRange * metaballRange - metaballRange) / 2.0f)) + 1;
        if (diameterX <= 0.0f || height <= 0.0f || diameterZ <= 0.0f) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        float radiusX = (diameterX - 1.0f) / 2.0f;
        float radiusY = (height - 1.0f) / 2.0f;
        float radiusZ = (diameterZ - 1.0f) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX + (float)extra);
        int ceilRadiusY = (int)Math.ceil(radiusY + (float)extra);
        int ceilRadiusZ = (int)Math.ceil(radiusZ + (float)extra);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRadiusY * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        float invRadiusSqX = 1.0f / ((radiusX + 0.5f) * (radiusX + 0.5f));
        float invRadiusSqZ = 1.0f / ((radiusZ + 0.5f) * (radiusZ + 0.5f));
        if (!Float.isFinite(invRadiusSqX)) {
            invRadiusSqX = Float.MAX_VALUE;
        }
        if (!Float.isFinite(invRadiusSqZ)) {
            invRadiusSqZ = Float.MAX_VALUE;
        }
        float invExpandedRadiusSqX = 1.0f / ((radiusX + (float)extra + 0.5f) * (radiusX + (float)extra + 0.5f));
        float invExpandedRadiusSqZ = 1.0f / ((radiusZ + (float)extra + 0.5f) * (radiusZ + (float)extra + 0.5f));
        if (!Float.isFinite(invExpandedRadiusSqX)) {
            invExpandedRadiusSqX = Float.MAX_VALUE;
        }
        if (!Float.isFinite(invExpandedRadiusSqZ)) {
            invExpandedRadiusSqZ = Float.MAX_VALUE;
        }
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float offsetX = centerEvenDiameters ? -(radiusX % 1.0f) : 0.0f;
        float offsetY = centerEvenDiameters ? -(radiusY % 1.0f) : 0.0f;
        float offsetZ = centerEvenDiameters ? -(radiusZ % 1.0f) : 0.0f;
        float[] distances = TerrainDistanceField.calculateChamferEuclidean((class_1937)level, centerX - maxRadiusX, centerY - maxRadiusY, centerZ - maxRadiusZ, centerX + maxRadiusX, centerY + maxRadiusY, centerZ + maxRadiusZ);
        int xIndexOffset = (maxRadiusY * 2 + 3) * (maxRadiusZ * 2 + 3);
        int yIndexOffset = maxRadiusZ * 2 + 3;
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block5: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    float amount;
                    float verticalDelta;
                    float terrainAmount;
                    int index;
                    float distance;
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    float surface = rx * rx * invRadiusSqX + rz * rz * invRadiusSqZ;
                    if (surface <= 1.0f && Math.abs(ry) <= radiusY + 0.5f) {
                        if (!hollow) {
                            region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                            continue;
                        }
                        for (int i = 0; i < 18; i += 3) {
                            int nx = x + CARDINAL_OFFSETS[i];
                            int ny = y + CARDINAL_OFFSETS[i + 1];
                            int nz = z + CARDINAL_OFFSETS[i + 2];
                            vector3f.set((float)nx, (float)ny, (float)nz);
                            quaternionf.transform(vector3f);
                            rx = vector3f.x + offsetX;
                            ry = vector3f.y + offsetY;
                            rz = vector3f.z + offsetZ;
                            if (!(rx * rx * invRadiusSqX + rz * rz * invRadiusSqZ > 1.0f) && !(Math.abs(ry) > radiusY + 0.5f)) continue;
                            region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                            continue block5;
                        }
                        continue;
                    }
                    if (!(rx * rx * invExpandedRadiusSqX + rz * rz * invExpandedRadiusSqZ <= 1.0f) || !(Math.abs(ry) <= radiusY + 0.5f + (float)extra) || !Float.isFinite(distance = distances[index = (x + maxRadiusX + 1) * xIndexOffset + (y + maxRadiusY + 1) * yIndexOffset + (z + maxRadiusZ + 1)]) || distance == 0.0f || (terrainAmount = (float)metaballRange / ((float)metaballRange + distance * distance)) < 2.0f / (float)(1 + metaballRange)) continue;
                    float surfaceDistanceSq = 0.0f;
                    if (surface > 1.0f) {
                        float xzDistance = RasterizationHelper.distancePointEllipse(radiusX + 0.5f, radiusZ + 0.5f, rx, rz, null);
                        surfaceDistanceSq += xzDistance * xzDistance;
                    }
                    if ((verticalDelta = Math.abs(ry) - (radiusY + 0.5f)) > 0.0f) {
                        surfaceDistanceSq += verticalDelta * verticalDelta;
                    }
                    if (!(terrainAmount + (amount = (float)metaballRange / ((float)metaballRange + surfaceDistanceSq)) >= 1.0f + 2.0f / (float)(1 + metaballRange))) continue;
                    region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                }
            }
        }
    }
}

