/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.custom_blocks;

import com.mojang.brigadier.StringReader;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockImplementation;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.CustomBlockStateImplementation;
import com.moulberry.axiom.custom_blocks.update.AxisCustomBlockPlacementLogic;
import com.moulberry.axiom.custom_blocks.update.CustomBlockPlacementLogic;
import com.moulberry.axiom.custom_blocks.update.FacingClickedCustomBlockPlacementLogic;
import com.moulberry.axiom.custom_blocks.update.FacingClickedOppositeCustomBlockPlacementLogic;
import com.moulberry.axiom.custom_blocks.update.FacingCustomBlockPlacementLogic;
import com.moulberry.axiom.custom_blocks.update.FacingOppositeCustomBlockPlacementLogic;
import com.moulberry.axiom.custom_blocks.update.HalfCustomBlockPlacementLogic;
import com.moulberry.axiom.custom_blocks.update.WaterloggedCustomBlockPlacementLogic;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.utils.BlockHelper;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ServerCustomBlocks {
    public static final Map<class_2960, CustomBlock> customBlockMap = new HashMap<class_2960, CustomBlock>();
    private static final Map<class_2680, CustomBlockState> vanillaStateToCustomBlockState = new HashMap<class_2680, CustomBlockState>();
    private static final Map<class_2960, CustomBlockPlacementLogic> placementLogicMap = new HashMap<class_2960, CustomBlockPlacementLogic>();
    private static final List<class_2350> HORIZONTAL_DIRECTIONS = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039);

    public static void clearRegisteredCustomBlocks() {
        if (!customBlockMap.isEmpty() || !vanillaStateToCustomBlockState.isEmpty()) {
            customBlockMap.clear();
            vanillaStateToCustomBlockState.clear();
            BlockHelper.customRotateY.clear();
        }
    }

    public static void registerCustomBlock(class_2960 resourceLocation, String translationKey, List<class_2769<?>> properties, List<class_2680> vanillaStates, @Nullable class_1799 pickBlockItemStack, boolean sendServerPickBlockIfPossible, boolean preventRightClickInteraction, boolean preventShapeUpdates, List<class_2960> placementLogicNames, boolean automaticRotationAndMirroring, Map<class_2680, class_2680> rotateYMappings, Map<class_2680, class_2680> flipXMappings, Map<class_2680, class_2680> flipYMappings, Map<class_2680, class_2680> flipZMappings) {
        class_2680 vanillaState;
        ArrayList<CustomBlockPlacementLogic> placementLogics = new ArrayList<CustomBlockPlacementLogic>(placementLogicNames.size());
        for (class_2960 updater : placementLogicNames) {
            CustomBlockPlacementLogic placementLogic = placementLogicMap.get(updater);
            if (placementLogic == null) {
                throw new RuntimeException(String.valueOf(resourceLocation) + " - unknown custom block updater: " + String.valueOf(updater));
            }
            placementLogics.add(placementLogic);
        }
        if (customBlockMap.containsKey(resourceLocation)) {
            throw new RuntimeException(String.valueOf(resourceLocation) + " - duplicate custom block registered: " + String.valueOf(resourceLocation));
        }
        if (pickBlockItemStack != null && !pickBlockItemStack.method_7960()) {
            ItemStackDataHelper.setCustomBlockPlacer(pickBlockItemStack, resourceLocation.toString());
        }
        CustomBlockImplementation customBlock = new CustomBlockImplementation(resourceLocation, translationKey, properties, vanillaStates, pickBlockItemStack, sendServerPickBlockIfPossible, preventRightClickInteraction, preventShapeUpdates, placementLogics);
        HashSet<class_2680> vanillaStatesSet = new HashSet<class_2680>(vanillaStates);
        ServerCustomBlocks.checkMappingContainedInSet(rotateYMappings, vanillaStatesSet, "customRotateY");
        ServerCustomBlocks.checkMappingContainedInSet(flipXMappings, vanillaStatesSet, "customFlipX");
        ServerCustomBlocks.checkMappingContainedInSet(flipYMappings, vanillaStatesSet, "customFlipY");
        ServerCustomBlocks.checkMappingContainedInSet(flipZMappings, vanillaStatesSet, "customFlipZ");
        for (CustomBlockState possibleCustomState : customBlock.axiom$getPossibleCustomStates()) {
            vanillaState = possibleCustomState.getVanillaState();
            if (!vanillaStateToCustomBlockState.containsKey(vanillaState)) continue;
            throw new RuntimeException(String.valueOf(resourceLocation) + " - duplicate vanilla state registered: " + vanillaState.toString());
        }
        for (CustomBlockState possibleCustomState : customBlock.axiom$getPossibleCustomStates()) {
            vanillaState = possibleCustomState.getVanillaState();
            vanillaStateToCustomBlockState.put(vanillaState, possibleCustomState);
            BlockHelper.customRotateY.put(vanillaState, vanillaState);
            BlockHelper.customFlipX.put(vanillaState, vanillaState);
            BlockHelper.customFlipY.put(vanillaState, vanillaState);
            BlockHelper.customFlipZ.put(vanillaState, vanillaState);
        }
        if (automaticRotationAndMirroring) {
            ServerCustomBlocks.applyAutomaticRotationAndMirroring(properties, customBlock);
        }
        BlockHelper.customRotateY.putAll(rotateYMappings);
        BlockHelper.customFlipX.putAll(flipXMappings);
        BlockHelper.customFlipY.putAll(flipYMappings);
        BlockHelper.customFlipZ.putAll(flipZMappings);
        customBlockMap.put(resourceLocation, customBlock);
        ServerCustomBlocks.update();
    }

    private static void checkMappingContainedInSet(Map<class_2680, class_2680> mappings, Set<class_2680> vanillaStatesSet, String name) {
        for (Map.Entry<class_2680, class_2680> entry : mappings.entrySet()) {
            if (vanillaStatesSet.contains(entry.getKey()) || vanillaStatesSet.contains(entry.getValue())) continue;
            throw new RuntimeException(name + " mapping either key or value must be part of custom block");
        }
    }

    private static void applyAutomaticRotationAndMirroring(List<class_2769<?>> properties, CustomBlock customBlock) {
        class_2350[] directions = class_2350.values();
        class_2754<class_2350> facingProperty = CustomBlockPlacementLogic.findFacingProperty(properties);
        class_2754<class_2350.class_2351> axisProperty = CustomBlockPlacementLogic.findAxisProperty(properties);
        EnumMap<class_2350, class_2769<?>> directionalProperties = ServerCustomBlocks.findSharedDirectionalProperties(properties, directions);
        Set facingValues = facingProperty == null ? Set.of() : Set.copyOf(facingProperty.method_11898());
        Set axisValues = axisProperty == null ? Set.of() : Set.copyOf(axisProperty.method_11898());
        boolean doClockwiseFacingRotate = facingProperty != null && facingValues.containsAll(HORIZONTAL_DIRECTIONS);
        boolean doClockwiseDirectionalRotate = directionalProperties != null && directionalProperties.keySet().containsAll(HORIZONTAL_DIRECTIONS);
        boolean doDirectionalFlipX = directionalProperties != null && directionalProperties.containsKey(class_2350.field_11034) && directionalProperties.containsKey(class_2350.field_11039);
        boolean doDirectionalFlipY = directionalProperties != null && directionalProperties.containsKey(class_2350.field_11036) && directionalProperties.containsKey(class_2350.field_11033);
        boolean doDirectionalFlipZ = directionalProperties != null && directionalProperties.containsKey(class_2350.field_11043) && directionalProperties.containsKey(class_2350.field_11035);
        for (CustomBlockState possibleCustomState : customBlock.axiom$getPossibleCustomStates()) {
            class_2680 vanillaState = possibleCustomState.getVanillaState();
            CustomBlockState rotated = possibleCustomState;
            CustomBlockState flippedX = possibleCustomState;
            CustomBlockState flippedY = possibleCustomState;
            CustomBlockState flippedZ = possibleCustomState;
            if (facingProperty != null) {
                class_2350 direction = possibleCustomState.getProperty(facingProperty);
                if (doClockwiseFacingRotate && direction.method_10166() != class_2350.class_2351.field_11052) {
                    rotated = rotated.setPropertyUnsafe(facingProperty, (Comparable<?>)direction.method_10170());
                }
                if (facingValues.contains(direction.method_10153())) {
                    switch (direction.method_10166()) {
                        case field_11048: {
                            flippedX = flippedX.setPropertyUnsafe(facingProperty, (Comparable<?>)direction.method_10153());
                            break;
                        }
                        case field_11052: {
                            flippedY = flippedY.setPropertyUnsafe(facingProperty, (Comparable<?>)direction.method_10153());
                            break;
                        }
                        case field_11051: {
                            flippedZ = flippedZ.setPropertyUnsafe(facingProperty, (Comparable<?>)direction.method_10153());
                        }
                    }
                }
            }
            if (axisProperty != null) {
                class_2350.class_2351 axis = possibleCustomState.getProperty(axisProperty);
                if (axis == class_2350.class_2351.field_11048) {
                    if (axisValues.contains(class_2350.class_2351.field_11051)) {
                        rotated = rotated.setPropertyUnsafe(axisProperty, (Comparable<?>)class_2350.class_2351.field_11051);
                    }
                } else if (axis == class_2350.class_2351.field_11051 && axisValues.contains(class_2350.class_2351.field_11048)) {
                    rotated = rotated.setPropertyUnsafe(axisProperty, (Comparable<?>)class_2350.class_2351.field_11048);
                }
            }
            if (doClockwiseDirectionalRotate) {
                for (class_2350 direction : HORIZONTAL_DIRECTIONS) {
                    Object propertyValue = possibleCustomState.getProperty(directionalProperties.get(direction));
                    rotated = rotated.setPropertyUnsafe(directionalProperties.get(direction.method_10170()), (Comparable<?>)propertyValue);
                }
            }
            if (doDirectionalFlipX) {
                flippedX = flippedX.setPropertyUnsafe(directionalProperties.get(class_2350.field_11034), (Comparable<?>)possibleCustomState.getProperty(directionalProperties.get(class_2350.field_11039)));
                flippedX = flippedX.setPropertyUnsafe(directionalProperties.get(class_2350.field_11039), (Comparable<?>)possibleCustomState.getProperty(directionalProperties.get(class_2350.field_11034)));
            }
            if (doDirectionalFlipY) {
                flippedY = flippedY.setPropertyUnsafe(directionalProperties.get(class_2350.field_11036), (Comparable<?>)possibleCustomState.getProperty(directionalProperties.get(class_2350.field_11033)));
                flippedY = flippedY.setPropertyUnsafe(directionalProperties.get(class_2350.field_11033), (Comparable<?>)possibleCustomState.getProperty(directionalProperties.get(class_2350.field_11036)));
            }
            if (doDirectionalFlipZ) {
                flippedZ = flippedZ.setPropertyUnsafe(directionalProperties.get(class_2350.field_11043), (Comparable<?>)possibleCustomState.getProperty(directionalProperties.get(class_2350.field_11035)));
                flippedZ = flippedZ.setPropertyUnsafe(directionalProperties.get(class_2350.field_11035), (Comparable<?>)possibleCustomState.getProperty(directionalProperties.get(class_2350.field_11043)));
            }
            BlockHelper.customRotateY.put(vanillaState, rotated.getVanillaState());
            BlockHelper.customFlipX.put(vanillaState, flippedX.getVanillaState());
            BlockHelper.customFlipY.put(vanillaState, flippedY.getVanillaState());
            BlockHelper.customFlipZ.put(vanillaState, flippedZ.getVanillaState());
        }
    }

    @Nullable
    private static EnumMap<class_2350, class_2769<?>> findSharedDirectionalProperties(List<class_2769<?>> properties, class_2350[] directions) {
        EnumMap directionalProperties = new EnumMap(class_2350.class);
        Class valueClass = null;
        List<?> possibleValues = null;
        block0: for (class_2769<?> property : properties) {
            for (class_2350 value : directions) {
                if (!property.method_11899().equals(value.method_15434())) continue;
                directionalProperties.put(value, property);
                if (valueClass == null) {
                    valueClass = property.method_11902();
                    possibleValues = VersionUtils.helperGetPossibleValues(property);
                    continue block0;
                }
                if (valueClass == property.method_11902() && possibleValues.equals(VersionUtils.helperGetPossibleValues(property))) continue block0;
                directionalProperties = null;
                break block0;
            }
        }
        if (directionalProperties != null && directionalProperties.size() < 2) {
            directionalProperties = null;
        }
        return directionalProperties;
    }

    public static void update() {
        EditorUI.getBlockList().markNeedsReload();
        if (Axiom.configuration.internal.rootEditorPalette != null) {
            Axiom.configuration.internal.rootEditorPalette.markNeedsReload();
        }
        BlockColourMap.invalidateCache();
    }

    @Nullable
    public static CustomBlock getCustomBlock(class_2960 resourceLocation) {
        return customBlockMap.get(resourceLocation);
    }

    @Nullable
    public static CustomBlockState getCustomStateFor(class_2680 blockState) {
        return vanillaStateToCustomBlockState.get(blockState);
    }

    public static CustomBlockState getCustomOrVanillaStateFor(class_2680 blockState) {
        CustomBlockState customBlockState = vanillaStateToCustomBlockState.get(blockState);
        if (customBlockState == null) {
            return (CustomBlockState)blockState;
        }
        return customBlockState;
    }

    public static CustomBlock getFromItemStack(class_1799 itemStack) {
        CustomBlock customBlock;
        String customBlockPlacer = ItemStackDataHelper.getCustomBlockPlacer(itemStack);
        if (customBlockPlacer != null && (customBlock = ServerCustomBlocks.getCustomBlock(class_2960.method_60654((String)customBlockPlacer))) != null) {
            return customBlock;
        }
        return (CustomBlock)class_2248.method_9503((class_1792)itemStack.method_7909());
    }

    public static void registerUpdater(class_2960 resourceLocation, CustomBlockPlacementLogic customBlockUpdater) {
        placementLogicMap.put(resourceLocation, customBlockUpdater);
    }

    public static String serialize(CustomBlockState customBlockState) {
        if (customBlockState instanceof class_2680) {
            class_2680 blockState = (class_2680)customBlockState;
            return class_2259.method_9685((class_2680)blockState);
        }
        if (customBlockState instanceof CustomBlockStateImplementation) {
            CustomBlockStateImplementation state = (CustomBlockStateImplementation)customBlockState;
            StringBuilder stringBuilder = new StringBuilder(state.getCustomBlock().axiom$getResourceLocation().toString());
            if (!state.method_28501().isEmpty()) {
                stringBuilder.append('[');
                boolean addComma = false;
                for (Map.Entry entry : state.method_11656().entrySet()) {
                    if (addComma) {
                        stringBuilder.append(',');
                    }
                    ServerCustomBlocks.appendProperty(stringBuilder, (class_2769)entry.getKey(), (Comparable)entry.getValue());
                    addComma = true;
                }
                stringBuilder.append(']');
            }
            return stringBuilder.toString();
        }
        throw new FaultyImplementationError();
    }

    private static <T extends Comparable<T>> void appendProperty(StringBuilder stringBuilder, class_2769<T> property, Comparable<?> comparable) {
        stringBuilder.append(property.method_11899());
        stringBuilder.append('=');
        stringBuilder.append(property.method_11901(comparable));
    }

    public static CustomBlockState deserialize(String input) {
        return ServerCustomBlocks.deserialize(input, null);
    }

    public static CustomBlockState deserialize(String input, Set<String> nonDefaultProperties) {
        try {
            class_2259.class_7211 result = class_2259.method_41957(VersionUtils.createLookup(class_7923.field_41175), (String)input, (boolean)false);
            if (nonDefaultProperties != null) {
                for (class_2769 property : result.comp_623().keySet()) {
                    nonDefaultProperties.add(property.method_11899());
                }
            }
            return (CustomBlockState)result.comp_622();
        }
        catch (Exception result) {
            try {
                StringReader reader = new StringReader(input);
                class_2960 resourceLocation = class_2960.method_12835((StringReader)reader);
                CustomBlock customBlock = ServerCustomBlocks.getCustomBlock(resourceLocation);
                if (customBlock == null) {
                    return null;
                }
                CustomBlockImplementation customBlockImplementation = (CustomBlockImplementation)customBlock;
                class_2689<CustomBlock, CustomBlockStateImplementation> definition = customBlockImplementation.getStateDefinition();
                CustomBlockState customBlockState = customBlockImplementation.axiom$defaultCustomState();
                if (reader.canRead()) {
                    if (reader.peek() == '[') {
                        reader.skip();
                        reader.skipWhitespace();
                        while (reader.canRead() && reader.peek() != ']') {
                            reader.skipWhitespace();
                            String string = reader.readString();
                            class_2769 property = definition.method_11663(string);
                            if (property == null) {
                                return null;
                            }
                            reader.skipWhitespace();
                            if (!reader.canRead() || reader.peek() != '=') {
                                return null;
                            }
                            reader.skip();
                            reader.skipWhitespace();
                            if (nonDefaultProperties != null) {
                                nonDefaultProperties.add(property.method_11899());
                            }
                            if ((customBlockState = ServerCustomBlocks.setValue(customBlockState, property, reader.readString())) == null) {
                                return null;
                            }
                            reader.skipWhitespace();
                            if (!reader.canRead()) continue;
                            if (reader.peek() == ',') {
                                reader.skip();
                                continue;
                            }
                            if (reader.peek() != ']') {
                                return null;
                            }
                            break;
                        }
                    } else {
                        return null;
                    }
                }
                return customBlockState;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static <T extends Comparable<T>> CustomBlockState setValue(CustomBlockState customBlockState, class_2769<T> property, String string) {
        Optional optional = property.method_11900(string);
        if (optional.isEmpty()) {
            return null;
        }
        return customBlockState.setPropertyUnsafe(property, (Comparable)optional.get());
    }

    private static void registerDefaultUpdaters() {
        ServerCustomBlocks.registerUpdater(class_2960.method_60654((String)"axiom:axis"), new AxisCustomBlockPlacementLogic());
        ServerCustomBlocks.registerUpdater(class_2960.method_60654((String)"axiom:facing"), new FacingCustomBlockPlacementLogic());
        ServerCustomBlocks.registerUpdater(class_2960.method_60654((String)"axiom:facing_opposite"), new FacingOppositeCustomBlockPlacementLogic());
        ServerCustomBlocks.registerUpdater(class_2960.method_60654((String)"axiom:facing_clicked"), new FacingClickedCustomBlockPlacementLogic());
        ServerCustomBlocks.registerUpdater(class_2960.method_60654((String)"axiom:facing_clicked_opposite"), new FacingClickedOppositeCustomBlockPlacementLogic());
        ServerCustomBlocks.registerUpdater(class_2960.method_60654((String)"axiom:waterlogged"), new WaterloggedCustomBlockPlacementLogic());
        ServerCustomBlocks.registerUpdater(class_2960.method_60654((String)"axiom:half"), new HalfCustomBlockPlacementLogic());
    }

    static {
        ServerCustomBlocks.registerDefaultUpdaters();
    }
}

