/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.displayentity;

import com.mojang.brigadier.StringReader;
import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.displayentity.DisplayEntityHelper;
import com.moulberry.axiom.displayentity.GizmoMode;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.hooks.ScreenRenderHook;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.screen.EditDisplayEntityScreen;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2179;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7733;
import net.minecraft.class_7837;
import net.minecraft.class_7924;
import net.minecraft.class_8113;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;

public class DisplayEntityManipulator {
    private static Map<class_8113, Gizmo> gizmos = new HashMap<class_8113, Gizmo>();
    private static final Map<UUID, PendingUpdate> pendingUpdates = new HashMap<UUID, PendingUpdate>();
    private static class_8113 activeEntity = null;
    private static boolean hoveredGizmoPart = false;
    private static Matrix4f overrideMatrix = null;
    private static int overrideMatrixTicks = 0;
    public static GizmoMode gizmoMode = GizmoMode.GLOBAL;
    private static final List<UndoState> undoStates = new ArrayList<UndoState>();
    private static final List<UndoState> redoStates = new ArrayList<UndoState>();
    private static boolean movementDirty = false;
    private static Matrix4f previewMultiplyTransformMatrix = null;

    public static void tick() {
        if (overrideMatrixTicks > 0) {
            --overrideMatrixTicks;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (player == null || level == null || EditorUI.isActive() || !AxiomClient.isAxiomActive() || !ClientEvents.serverSupportsProtocol(SupportedProtocol.MANIPULATE_ENTITY) || !Axiom.configuration.entityManipulation.showDisplayEntities) {
            if (activeEntity != null) {
                if (activeEntity.method_31481()) {
                    gizmos.remove(activeEntity);
                } else {
                    Gizmo gizmo = gizmos.get(activeEntity);
                    if (gizmo != null) {
                        gizmo.enableAxes = false;
                    }
                }
                activeEntity = null;
                movementDirty = false;
                undoStates.clear();
                redoStates.clear();
            }
            pendingUpdates.clear();
            gizmos.clear();
            return;
        }
        if (!pendingUpdates.isEmpty()) {
            ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry> entries = new ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry>();
            for (Map.Entry<UUID, PendingUpdate> entry : pendingUpdates.entrySet()) {
                entries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(entry.getKey(), entry.getValue().position, entry.getValue().mergeNbt));
            }
            new AxiomServerboundManipulateEntity(entries).send();
        }
        pendingUpdates.clear();
        class_238 aabb = player.method_5829().method_1014((double)Math.max(1, Axiom.configuration.entityManipulation.displayEntityRange));
        HashMap<class_8113, Gizmo> newGizmos = new HashMap<class_8113, Gizmo>();
        for (class_8113 display : level.method_18467(class_8113.class, aabb)) {
            if (display.method_5765()) continue;
            if (AxiomClient.ignoredDisplayEntities.contains(display.method_5667())) {
                if (display == activeEntity) {
                    activeEntity = null;
                }
                gizmos.remove(display);
                continue;
            }
            Gizmo oldGizmo = gizmos.get(display);
            if (oldGizmo != null) {
                if (!oldGizmo.isGrabbed() && overrideMatrixTicks == 0) {
                    oldGizmo.moveToVec(display.method_19538());
                }
                newGizmos.put(display, oldGizmo);
                continue;
            }
            Gizmo gizmo = new Gizmo(display.method_19538());
            gizmo.enableAxes = false;
            gizmo.enableRotation = true;
            gizmo.enableScale = true;
            gizmo.rotationSnapRadians = (float)Math.toRadians(1.0);
            gizmo.minVisualScale = 2.0f;
            gizmo.translationSnapping = 16;
            newGizmos.put(display, gizmo);
        }
        if (activeEntity != null) {
            if (activeEntity.method_31481() || activeEntity.method_5765()) {
                newGizmos.remove(activeEntity);
                activeEntity = null;
                movementDirty = false;
                undoStates.clear();
                redoStates.clear();
            } else if (!newGizmos.containsKey(activeEntity)) {
                Gizmo gizmo = gizmos.get(activeEntity);
                if (gizmo != null) {
                    newGizmos.put(activeEntity, gizmo);
                } else {
                    activeEntity = null;
                    movementDirty = false;
                    undoStates.clear();
                    redoStates.clear();
                }
            }
        }
        gizmos = newGizmos;
    }

    public static void render(class_4184 camera, long time, class_4587 poseStack, Matrix4f projection) {
        previewMultiplyTransformMatrix = null;
        hoveredGizmoPart = false;
        if (!Axiom.configuration.entityManipulation.showDisplayEntities) {
            return;
        }
        if (EditorUI.isActive()) {
            return;
        }
        class_243 lookDirection = Tool.getLookDirection();
        boolean isLeftDown = Axiom.configuration.entityManipulation.swapLeftRightClick ? Tool.isMouseDown(1) : Tool.isMouseDown(0);
        long window = class_310.method_1551().method_22683().method_4490();
        boolean isCtrlDown = GLFW.glfwGetKey((long)window, (int)(class_310.field_1703 ? 343 : 341)) != 0 || GLFW.glfwGetKey((long)window, (int)(class_310.field_1703 ? 347 : 345)) != 0;
        for (Map.Entry<class_8113, Gizmo> entry : gizmos.entrySet()) {
            class_243 position;
            Gizmo.GizmoScale gizmoScale;
            Gizmo.GizmoRotation gizmoRotation;
            class_8113 entity = entry.getKey();
            Gizmo gizmo = entry.getValue();
            class_243 before = gizmo.getTargetVec();
            if (gizmo.enableAxes) {
                if (gizmoMode == GizmoMode.LOCAL) {
                    Matrix4f matrix4f = DisplayEntityManipulator.getTransformationMatrix(entity);
                    Quaternionf orientation = DisplayEntityManipulator.calculateOrientation(entity.method_49777(), entity, new Quaternionf());
                    matrix4f.rotateLocal((Quaternionfc)orientation);
                    float f = 1.0f / matrix4f.m33();
                    Triple triple = class_7837.method_46412((Matrix3f)new Matrix3f((Matrix4fc)matrix4f).scale(f));
                    gizmo.localRotation = ((Quaternionf)triple.getLeft()).mul((Quaternionfc)triple.getRight());
                    gizmo.setAxisDirections(true, true, true);
                } else {
                    gizmo.localRotation = null;
                    gizmo.setAxisDirections(camera.method_19326().field_1352 > gizmo.getTargetVec().field_1352, camera.method_19326().field_1351 > gizmo.getTargetVec().field_1351, camera.method_19326().field_1350 > gizmo.getTargetVec().field_1350);
                }
            }
            gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, true);
            if (!class_310.method_1551().field_1690.field_1842) {
                gizmo.render(poseStack, camera, isCtrlDown);
            }
            if (gizmo.isHovered()) {
                hoveredGizmoPart = true;
            }
            if (entity != activeEntity) continue;
            if (gizmo.isGrabbed()) {
                movementDirty = true;
            }
            if ((gizmoRotation = gizmo.peekGizmoRotation()) != null) {
                Matrix4f matrix4f = DisplayEntityManipulator.getTransformationMatrix(entity);
                Quaternionf orientation = DisplayEntityManipulator.calculateOrientation(entity.method_49777(), entity, new Quaternionf());
                matrix4f.rotateLocal((Quaternionfc)orientation);
                DisplayEntityManipulator.applyGizmoRotation(matrix4f, gizmoRotation);
                matrix4f.rotateLocal((Quaternionfc)orientation.invert());
                float f = 1.0f / matrix4f.m33();
                Triple triple = class_7837.method_46412((Matrix3f)new Matrix3f((Matrix4fc)matrix4f).scale(f));
                Quaternionf quaternionf = ((Quaternionf)triple.getLeft()).mul((Quaternionfc)triple.getRight());
                Vector3f eulerAngles = new Vector3f();
                float asinFactor = quaternionf.y * quaternionf.z - quaternionf.w * quaternionf.x;
                if (asinFactor >= 0.49999997f) {
                    eulerAngles.x = -90.0f;
                } else if (asinFactor <= -0.49999997f) {
                    eulerAngles.x = 90.0f;
                } else {
                    eulerAngles.x = (float)Math.asin(-2.0f * asinFactor);
                    eulerAngles.x = (float)Math.toDegrees(eulerAngles.x);
                }
                eulerAngles.y = (float)Math.atan2(quaternionf.x * quaternionf.z + quaternionf.y * quaternionf.w, 0.5f - quaternionf.y * quaternionf.y - quaternionf.x * quaternionf.x);
                eulerAngles.z = (float)Math.atan2(quaternionf.y * quaternionf.x + quaternionf.w * quaternionf.z, 0.5f - quaternionf.x * quaternionf.x - quaternionf.z * quaternionf.z);
                eulerAngles.y = (float)Math.toDegrees(eulerAngles.y);
                eulerAngles.z = (float)Math.toDegrees(eulerAngles.z);
                if (eulerAngles.x <= 0.0f && (double)eulerAngles.x > -0.01) {
                    eulerAngles.x = 0.0f;
                }
                if (eulerAngles.y <= 0.0f && (double)eulerAngles.y > -0.01) {
                    eulerAngles.y = 0.0f;
                }
                if (eulerAngles.z <= 0.0f && (double)eulerAngles.z > -0.01) {
                    eulerAngles.z = 0.0f;
                }
                String paddedRotationX = String.format("%.2f", Float.valueOf(eulerAngles.x));
                String paddedRotationY = String.format("%.2f", Float.valueOf(eulerAngles.y));
                String paddedRotationZ = String.format("%.2f", Float.valueOf(eulerAngles.z));
                ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Rotation: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(paddedRotationX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(paddedRotationY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)paddedRotationZ).method_27692(class_124.field_1075)));
            }
            if ((gizmoRotation = gizmo.popRotation()) != null) {
                HashMap<UUID, Matrix4fc> transforms = new HashMap<UUID, Matrix4fc>();
                DisplayEntityManipulator.applyGizmoRotationToEntityRecursive(entity, gizmoRotation, transforms);
                movementDirty = false;
                undoStates.add(new UndoState(gizmo.getTargetVec(), transforms));
                if (undoStates.size() > 256) {
                    undoStates.remove(0);
                }
                redoStates.clear();
            }
            if ((gizmoScale = gizmo.peekScale()) != null) {
                Matrix4f matrix4f = DisplayEntityManipulator.getTransformationMatrix(entity);
                Quaternionf orientation = DisplayEntityManipulator.calculateOrientation(entity.method_49777(), entity, new Quaternionf());
                matrix4f.rotateLocal((Quaternionfc)orientation);
                DisplayEntityManipulator.applyGizmoScale(matrix4f, gizmoScale);
                matrix4f.rotateLocal((Quaternionfc)orientation.invert());
                float f = 1.0f / matrix4f.m33();
                Triple triple = class_7837.method_46412((Matrix3f)new Matrix3f((Matrix4fc)matrix4f).scale(f));
                Vector3f scale = (Vector3f)triple.getMiddle();
                if (scale.x <= 0.0f && (double)scale.x > -1.0E-4) {
                    scale.x = 0.0f;
                }
                if (scale.y <= 0.0f && (double)scale.y > -1.0E-4) {
                    scale.y = 0.0f;
                }
                if (scale.z <= 0.0f && (double)scale.z > -1.0E-4) {
                    scale.z = 0.0f;
                }
                String paddedScaleX = String.format("%.3f", Float.valueOf(scale.x));
                String paddedScaleY = String.format("%.3f", Float.valueOf(scale.y));
                String paddedScaleZ = String.format("%.3f", Float.valueOf(scale.z));
                ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Scale: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(paddedScaleX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(paddedScaleY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)paddedScaleZ).method_27692(class_124.field_1075)));
            }
            if ((gizmoScale = gizmo.popScale()) != null) {
                HashMap<UUID, Matrix4fc> transforms = new HashMap<UUID, Matrix4fc>();
                DisplayEntityManipulator.applyGizmoScaleToEntityRecursive(entity, gizmoScale, transforms);
                movementDirty = false;
                undoStates.add(new UndoState(gizmo.getTargetVec(), transforms));
                if (undoStates.size() > 256) {
                    undoStates.remove(0);
                }
                redoStates.clear();
            }
            if (!(position = gizmo.getTargetVec()).equals((Object)before)) {
                DisplayEntityManipulator.applyTeleport(entity, position);
                String paddedPositionX = String.format("%.4f", position.field_1352);
                String paddedPositionY = String.format("%.4f", position.field_1351);
                String paddedPositionZ = String.format("%.4f", position.field_1350);
                ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Position: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)paddedPositionZ).method_27692(class_124.field_1075)));
            }
            if (!movementDirty || gizmo.isGrabbed()) continue;
            movementDirty = false;
            DisplayEntityManipulator.addTranslationUndoState(position);
        }
    }

    private static void addTranslationUndoState(class_243 position) {
        UndoState first = undoStates.get(undoStates.size() - 1);
        if (first.position.equals((Object)position)) {
            return;
        }
        if (undoStates.size() >= 2) {
            UndoState second = undoStates.get(undoStates.size() - 2);
            boolean merge = false;
            if (first.position.field_1352 == position.field_1352 && first.position.field_1351 == position.field_1351 && second.position.field_1352 == position.field_1352 && second.position.field_1351 == position.field_1351) {
                merge = Math.abs(first.position.field_1350 - position.field_1350) < 1.0 && Math.abs(second.position.field_1350 - position.field_1350) < 1.0;
            } else if (first.position.field_1352 == position.field_1352 && first.position.field_1350 == position.field_1350 && second.position.field_1352 == position.field_1352 && second.position.field_1350 == position.field_1350) {
                merge = Math.abs(first.position.field_1351 - position.field_1351) < 1.0 && Math.abs(second.position.field_1351 - position.field_1351) < 1.0;
            } else if (first.position.field_1351 == position.field_1351 && first.position.field_1350 == position.field_1350 && second.position.field_1351 == position.field_1351 && second.position.field_1350 == position.field_1350) {
                boolean bl = merge = Math.abs(first.position.field_1352 - position.field_1352) < 1.0 && Math.abs(second.position.field_1352 - position.field_1352) < 1.0;
            }
            if (merge) {
                undoStates.set(undoStates.size() - 1, new UndoState(position, DisplayEntityManipulator.undoStates.get((int)(DisplayEntityManipulator.undoStates.size() - 1)).transformations));
                redoStates.clear();
                return;
            }
        }
        undoStates.add(new UndoState(position, DisplayEntityManipulator.undoStates.get((int)(DisplayEntityManipulator.undoStates.size() - 1)).transformations));
        if (undoStates.size() > 256) {
            undoStates.remove(0);
        }
        redoStates.clear();
    }

    public static void disableActive() {
        if (activeEntity != null) {
            Gizmo gizmo = gizmos.get(activeEntity);
            if (gizmo != null) {
                gizmo.enableAxes = false;
            }
            activeEntity = null;
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
        }
    }

    public static void deleteActive() {
        if (activeEntity != null) {
            DisplayEntityHelper.killRecursive(activeEntity);
        }
        DisplayEntityManipulator.disableActive();
    }

    public static void onEntityRemoved(class_1297 entity) {
        if (activeEntity == entity) {
            DisplayEntityManipulator.disableActive();
        }
    }

    @Nullable
    public static class_8113 getActiveDisplayEntity() {
        return activeEntity;
    }

    public static boolean hasActiveGizmo() {
        return activeEntity != null;
    }

    public static boolean hasGrabbedNotCenterGizmo() {
        if (activeEntity == null) {
            return false;
        }
        Gizmo gizmo = gizmos.get(activeEntity);
        if (gizmo == null) {
            return false;
        }
        return gizmo.isGrabbed() && !gizmo.isCenterGrabbed();
    }

    public static boolean hoveredGizmoPart() {
        return hoveredGizmoPart;
    }

    public static boolean canUndo() {
        return undoStates.size() >= 2;
    }

    public static boolean canRedo() {
        return redoStates.size() >= 1;
    }

    private static Matrix4f getPreviewMultiplyTransformMatrix() {
        Gizmo.GizmoScale peekedScale;
        if (previewMultiplyTransformMatrix != null) {
            return previewMultiplyTransformMatrix;
        }
        if (activeEntity == null) {
            return null;
        }
        class_8113.class_8229 oldRenderState = activeEntity.method_49777();
        Gizmo gizmo = gizmos.get(activeEntity);
        if (gizmo == null || !gizmo.isGrabbed()) {
            if (overrideMatrixTicks > 0) {
                Matrix4f oldMatrix = new Matrix4f((Matrix4fc)((class_4590)oldRenderState.comp_1328().method_48888(1.0f)).method_22936());
                Matrix4f newMatrix = overrideMatrix == null ? new Matrix4f((Matrix4fc)((class_4590)oldRenderState.comp_1328().method_48888(1.0f)).method_22936()) : new Matrix4f((Matrix4fc)overrideMatrix);
                previewMultiplyTransformMatrix = newMatrix.mul((Matrix4fc)oldMatrix.invert());
                return previewMultiplyTransformMatrix;
            }
            return null;
        }
        Matrix4f oldMatrix = new Matrix4f((Matrix4fc)((class_4590)oldRenderState.comp_1328().method_48888(1.0f)).method_22936());
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)oldMatrix);
        Quaternionf orientation = DisplayEntityManipulator.calculateOrientation(oldRenderState, activeEntity, new Quaternionf());
        Quaternionf invertedOrientation = new Quaternionf((Quaternionfc)orientation).invert();
        Gizmo.GizmoRotation peekedRotation = gizmo.peekGizmoRotation();
        if (peekedRotation != null) {
            matrix4f.rotateLocal((Quaternionfc)orientation);
            DisplayEntityManipulator.applyGizmoRotation(matrix4f, peekedRotation);
            matrix4f.rotateLocal((Quaternionfc)invertedOrientation);
        }
        if ((peekedScale = gizmo.peekScale()) != null) {
            matrix4f.rotateLocal((Quaternionfc)orientation);
            DisplayEntityManipulator.applyGizmoScale(matrix4f, peekedScale);
            matrix4f.rotateLocal((Quaternionfc)invertedOrientation);
        }
        overrideMatrixTicks = 10;
        overrideMatrix = new Matrix4f((Matrix4fc)matrix4f);
        previewMultiplyTransformMatrix = matrix4f.mul((Matrix4fc)oldMatrix.invert());
        return previewMultiplyTransformMatrix;
    }

    public static class_8113.class_8229 getModifiedRenderState(class_8113 display) {
        if (activeEntity == null || activeEntity.method_49777() == null) {
            return display.method_49777();
        }
        class_1297 root = display.method_5668();
        if (root != activeEntity) {
            return display.method_49777();
        }
        class_8113.class_8229 oldRenderState = display.method_49777();
        if (oldRenderState == null) {
            return null;
        }
        Matrix4f transformBy = DisplayEntityManipulator.getPreviewMultiplyTransformMatrix();
        if (transformBy == null) {
            return oldRenderState;
        }
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)((class_4590)oldRenderState.comp_1328().method_48888(1.0f)).method_22936());
        Quaternionf parentOrientation = DisplayEntityManipulator.calculateOrientation(activeEntity.method_49777(), activeEntity, new Quaternionf());
        Quaternionf parentInvertedOrientation = new Quaternionf((Quaternionfc)parentOrientation).invert();
        Quaternionf orientation = DisplayEntityManipulator.calculateOrientation(oldRenderState, display, new Quaternionf());
        Quaternionf invertedOrientation = new Quaternionf((Quaternionfc)orientation).invert();
        matrix4f.rotateLocal((Quaternionfc)orientation);
        matrix4f.rotateLocal((Quaternionfc)parentInvertedOrientation);
        matrix4f.mulLocal((Matrix4fc)transformBy);
        matrix4f.rotateLocal((Quaternionfc)parentOrientation);
        matrix4f.rotateLocal((Quaternionfc)invertedOrientation);
        Gizmo gizmo = gizmos.get(activeEntity);
        if (gizmo != null) {
            float partial = VersionUtilsClient.getPartialTick(class_310.method_1551());
            double x = class_3532.method_16436((double)partial, (double)display.field_6038, (double)display.method_23317());
            double y = class_3532.method_16436((double)partial, (double)display.field_5971, (double)display.method_23318());
            double z = class_3532.method_16436((double)partial, (double)display.field_5989, (double)display.method_23321());
            class_243 interpPosition = gizmo.getInterpPosition();
            matrix4f.rotateLocal((Quaternionfc)orientation);
            matrix4f.translateLocal((float)(interpPosition.field_1352 - x), (float)(interpPosition.field_1351 - y), (float)(interpPosition.field_1350 - z));
            matrix4f.rotateLocal((Quaternionfc)invertedOrientation);
        }
        class_8113.class_8118 transformation = class_8113.class_8118.constant((Object)VersionUtils.helperTransformationNew((Matrix4fc)matrix4f));
        return new class_8113.class_8229(transformation, oldRenderState.comp_1329(), oldRenderState.comp_1330(), oldRenderState.comp_1331(), oldRenderState.comp_1332(), oldRenderState.comp_1333());
    }

    private static Quaternionf calculateOrientation(class_8113.class_8229 renderState, class_8113 display, Quaternionf quaternionf) {
        if (renderState == null) {
            return quaternionf;
        }
        return DisplayEntityManipulator.calculateOrientation(renderState.comp_1329(), display, quaternionf);
    }

    private static Quaternionf calculateOrientation(class_8113.class_8114 billboardConstraints, class_8113 display, Quaternionf quaternionf) {
        if (billboardConstraints == null) {
            return quaternionf;
        }
        class_4184 camera = class_310.method_1551().method_1561().field_4686;
        return switch (billboardConstraints) {
            default -> throw new IncompatibleClassChangeError();
            case class_8113.class_8114.field_42406 -> quaternionf.rotationYXZ((float)(-Math.PI) / 180 * display.method_36454(), (float)Math.PI / 180 * display.method_36455(), 0.0f);
            case class_8113.class_8114.field_42408 -> quaternionf.rotationYXZ((float)(-Math.PI) / 180 * display.method_36454(), (float)Math.PI / 180 * -camera.method_19329(), 0.0f);
            case class_8113.class_8114.field_42407 -> quaternionf.rotationYXZ((float)(-Math.PI) / 180 * (camera.method_19330() - 180.0f), (float)Math.PI / 180 * display.method_36455(), 0.0f);
            case class_8113.class_8114.field_42409 -> quaternionf.rotationYXZ((float)(-Math.PI) / 180 * (camera.method_19330() - 180.0f), (float)Math.PI / 180 * -camera.method_19329(), 0.0f);
        };
    }

    private static void applyGizmoRotationToEntityRecursive(class_8113 display, Gizmo.GizmoRotation gizmoRotation, Map<UUID, Matrix4fc> transforms) {
        if (!display.method_31481()) {
            Matrix4f originalMatrix = DisplayEntityManipulator.getTransformationMatrix(display);
            Matrix4f newMatrix = new Matrix4f((Matrix4fc)originalMatrix);
            byte billboardId = (Byte)display.method_5841().method_12789(class_8113.field_42368);
            class_8113.class_8114 billboardConstraints = (class_8113.class_8114)class_8113.class_8114.field_42411.apply(billboardId);
            Quaternionf orientation = DisplayEntityManipulator.calculateOrientation(billboardConstraints, display, new Quaternionf());
            Quaternionf invertedOrientation = new Quaternionf((Quaternionfc)orientation).invert();
            newMatrix.rotateLocal((Quaternionfc)orientation);
            DisplayEntityManipulator.applyGizmoRotation(newMatrix, gizmoRotation);
            newMatrix.rotateLocal((Quaternionfc)invertedOrientation);
            transforms.put(display.method_5667(), (Matrix4fc)new Matrix4f((Matrix4fc)newMatrix));
            class_4590 transformation = VersionUtils.helperTransformationNew((Matrix4fc)newMatrix);
            transformation.method_22937();
            class_4590.field_42532.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(DisplayEntityManipulator.createTagConsumer(display.method_5667()));
            Matrix4f childTransform = newMatrix.mul((Matrix4fc)originalMatrix.invert());
            for (class_1297 passenger : display.method_5685()) {
                if (!(passenger instanceof class_8113)) continue;
                class_8113 display1 = (class_8113)passenger;
                DisplayEntityManipulator.transformSelfAndChildren(display1, childTransform, orientation, invertedOrientation, transforms);
            }
        }
    }

    private static Consumer<class_2520> createTagConsumer(UUID uuid) {
        return tag -> {
            class_2487 root = new class_2487();
            root.method_10566("transformation", tag);
            PendingUpdate pendingUpdate = pendingUpdates.computeIfAbsent(uuid, k -> new PendingUpdate());
            pendingUpdate.mergeNbt = pendingUpdate.mergeNbt.method_10543(root);
        };
    }

    private static void applyGizmoScaleToEntityRecursive(class_8113 display, Gizmo.GizmoScale gizmoScale, Map<UUID, Matrix4fc> transforms) {
        if (!display.method_31481()) {
            Matrix4f originalMatrix = DisplayEntityManipulator.getTransformationMatrix(display);
            Matrix4f newMatrix = new Matrix4f((Matrix4fc)originalMatrix);
            byte billboardId = (Byte)display.method_5841().method_12789(class_8113.field_42368);
            class_8113.class_8114 billboardConstraints = (class_8113.class_8114)class_8113.class_8114.field_42411.apply(billboardId);
            Quaternionf orientation = DisplayEntityManipulator.calculateOrientation(billboardConstraints, display, new Quaternionf());
            Quaternionf invertedOrientation = new Quaternionf((Quaternionfc)orientation).invert();
            newMatrix.rotateLocal((Quaternionfc)orientation);
            DisplayEntityManipulator.applyGizmoScale(newMatrix, gizmoScale);
            newMatrix.rotateLocal((Quaternionfc)invertedOrientation);
            transforms.put(display.method_5667(), (Matrix4fc)new Matrix4f((Matrix4fc)newMatrix));
            class_4590 transformation = VersionUtils.helperTransformationNew((Matrix4fc)newMatrix);
            transformation.method_22937();
            class_4590.field_42532.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(DisplayEntityManipulator.createTagConsumer(display.method_5667()));
            Matrix4f childTransform = newMatrix.mul((Matrix4fc)originalMatrix.invert());
            for (class_1297 passenger : display.method_5685()) {
                if (!(passenger instanceof class_8113)) continue;
                class_8113 display1 = (class_8113)passenger;
                DisplayEntityManipulator.transformSelfAndChildren(display1, childTransform, orientation, invertedOrientation, transforms);
            }
        }
    }

    private static void transformSelfAndChildren(class_8113 display, Matrix4f transform, Quaternionf parentOrientation, Quaternionf parentInvertedOrientation, Map<UUID, Matrix4fc> transforms) {
        for (class_1297 passenger : display.method_5685()) {
            if (!(passenger instanceof class_8113)) continue;
            class_8113 display1 = (class_8113)passenger;
            DisplayEntityManipulator.transformSelfAndChildren(display1, transform, parentOrientation, parentInvertedOrientation, transforms);
        }
        if (!display.method_31481()) {
            Matrix4f matrix4f = DisplayEntityManipulator.getTransformationMatrix(display);
            byte billboardId = (Byte)display.method_5841().method_12789(class_8113.field_42368);
            class_8113.class_8114 billboardConstraints = (class_8113.class_8114)class_8113.class_8114.field_42411.apply(billboardId);
            Quaternionf orientation = DisplayEntityManipulator.calculateOrientation(billboardConstraints, display, new Quaternionf());
            Quaternionf invertedOrientation = new Quaternionf((Quaternionfc)orientation).invert();
            matrix4f.rotateLocal((Quaternionfc)orientation);
            matrix4f.rotateLocal((Quaternionfc)parentInvertedOrientation);
            matrix4f.mulLocal((Matrix4fc)transform);
            matrix4f.rotateLocal((Quaternionfc)parentOrientation);
            matrix4f.rotateLocal((Quaternionfc)invertedOrientation);
            transforms.put(display.method_5667(), (Matrix4fc)new Matrix4f((Matrix4fc)matrix4f));
            class_4590 transformation = VersionUtils.helperTransformationNew((Matrix4fc)matrix4f);
            transformation.method_22937();
            class_4590.field_42532.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(DisplayEntityManipulator.createTagConsumer(display.method_5667()));
        }
    }

    private static void transformSelfAndChildren(class_8113 display, Map<UUID, Matrix4fc> transforms) {
        for (class_1297 passenger : display.method_5685()) {
            if (!(passenger instanceof class_8113)) continue;
            class_8113 display1 = (class_8113)passenger;
            DisplayEntityManipulator.transformSelfAndChildren(display1, transforms);
        }
        if (!display.method_31481()) {
            Matrix4fc matrix4f = transforms.get(display.method_5667());
            if (matrix4f == null) {
                return;
            }
            class_4590 transformation = VersionUtils.helperTransformationNew(matrix4f);
            transformation.method_22937();
            class_4590.field_42532.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(DisplayEntityManipulator.createTagConsumer(display.method_5667()));
        }
    }

    public static Matrix4f getTransformationMatrix(class_8113 display) {
        Vector3f translation = (Vector3f)display.method_5841().method_12789(class_8113.field_42401);
        Quaternionf left = (Quaternionf)display.method_5841().method_12789(class_8113.field_42403);
        Vector3f scale = (Vector3f)display.method_5841().method_12789(class_8113.field_42402);
        Quaternionf right = (Quaternionf)display.method_5841().method_12789(class_8113.field_42367);
        Matrix4f matrix = new Matrix4f();
        matrix.translate((Vector3fc)translation);
        matrix.rotate((Quaternionfc)left);
        matrix.scale((Vector3fc)scale);
        matrix.rotate((Quaternionfc)right);
        return matrix;
    }

    private static void applyGizmoRotation(Matrix4f matrix4f, Gizmo.GizmoRotation gizmoRotation) {
        float f = 1.0f / matrix4f.m33();
        Triple triple = class_7837.method_46412((Matrix3f)new Matrix3f((Matrix4fc)matrix4f).scale(f));
        Vector3f translation = matrix4f.getTranslation(new Vector3f()).mul(f);
        Quaternionf leftRotation = (Quaternionf)triple.getLeft();
        Vector3f scale = (Vector3f)triple.getMiddle();
        Quaternionf rightRotation = (Quaternionf)triple.getRight();
        Quaternionf totalRotation = new Quaternionf();
        totalRotation.mul((Quaternionfc)leftRotation);
        totalRotation.mul((Quaternionfc)rightRotation);
        Quaternionf oldRotation = new Quaternionf((Quaternionfc)totalRotation);
        if (gizmoMode == GizmoMode.LOCAL) {
            switch (gizmoRotation.axis()) {
                case field_11048: {
                    totalRotation.rotateX(gizmoRotation.radians());
                    break;
                }
                case field_11052: {
                    totalRotation.rotateY(gizmoRotation.radians());
                    break;
                }
                case field_11051: {
                    totalRotation.rotateZ(gizmoRotation.radians());
                }
            }
        } else {
            switch (gizmoRotation.axis()) {
                case field_11048: {
                    totalRotation.rotateLocalX(gizmoRotation.radians());
                    break;
                }
                case field_11052: {
                    totalRotation.rotateLocalY(gizmoRotation.radians());
                    break;
                }
                case field_11051: {
                    totalRotation.rotateLocalZ(gizmoRotation.radians());
                }
            }
        }
        if (!DisplayEntityManipulator.isShiftDown()) {
            float sinX = -2.0f * (totalRotation.y * totalRotation.z - totalRotation.w * totalRotation.x);
            boolean useAlternative = (double)sinX <= -0.999 || (double)sinX >= 0.999;
            Vector3f eulerAngles = new Vector3f();
            if (useAlternative) {
                totalRotation.getEulerAnglesXYZ(eulerAngles);
            } else {
                totalRotation.getEulerAnglesYXZ(eulerAngles);
            }
            eulerAngles.x = (float)Math.toRadians((float)Math.round(Math.toDegrees(eulerAngles.x) * 10.0) / 10.0f);
            eulerAngles.y = (float)Math.toRadians((float)Math.round(Math.toDegrees(eulerAngles.y) * 10.0) / 10.0f);
            eulerAngles.z = (float)Math.toRadians((float)Math.round(Math.toDegrees(eulerAngles.z) * 10.0) / 10.0f);
            totalRotation.identity();
            if (useAlternative) {
                totalRotation.rotateXYZ(eulerAngles.x, eulerAngles.y, eulerAngles.z);
            } else {
                totalRotation.rotateYXZ(eulerAngles.y, eulerAngles.x, eulerAngles.z);
            }
        }
        oldRotation.transformInverse(translation);
        totalRotation.transform(translation);
        Quaternionf newLeftRotation = totalRotation.div((Quaternionfc)rightRotation);
        Matrix4f newMatrix = new Matrix4f();
        newMatrix.translate((Vector3fc)translation);
        newMatrix.rotate((Quaternionfc)newLeftRotation);
        newMatrix.scale((Vector3fc)scale);
        newMatrix.rotate((Quaternionfc)rightRotation);
        matrix4f.set((Matrix4fc)newMatrix);
    }

    private static void applyTeleport(class_8113 display, class_243 position) {
        Gizmo gizmo = gizmos.get(display);
        if (gizmo != null) {
            gizmo.moveToVec(position);
        }
        PendingUpdate pendingUpdate = pendingUpdates.computeIfAbsent(display.method_5667(), k -> new PendingUpdate());
        pendingUpdate.position = position;
    }

    private static boolean isShiftDown() {
        long window = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetKey((long)window, (int)340) != 0 || GLFW.glfwGetKey((long)window, (int)344) != 0;
    }

    private static void applyGizmoScale(Matrix4f matrix4f, Gizmo.GizmoScale gizmoScale) {
        boolean doHinting;
        boolean bl = doHinting = !DisplayEntityManipulator.isShiftDown();
        if (gizmoScale.scaleAll()) {
            if (gizmoMode == GizmoMode.LOCAL) {
                float oldScale = switch (gizmoScale.axis()) {
                    case class_2350.class_2351.field_11048 -> (float)Math.sqrt(matrix4f.m00() * matrix4f.m00() + matrix4f.m01() * matrix4f.m01() + matrix4f.m02() * matrix4f.m02());
                    case class_2350.class_2351.field_11052 -> (float)Math.sqrt(matrix4f.m10() * matrix4f.m10() + matrix4f.m11() * matrix4f.m11() + matrix4f.m12() * matrix4f.m12());
                    case class_2350.class_2351.field_11051 -> (float)Math.sqrt(matrix4f.m20() * matrix4f.m20() + matrix4f.m21() * matrix4f.m21() + matrix4f.m22() * matrix4f.m22());
                    default -> throw new FaultyImplementationError();
                };
                if (oldScale == 0.0f) {
                    oldScale = 1.0f;
                }
                float scale = oldScale < 1.0f && gizmoScale.scale() > 1.0f ? (gizmoScale.scale() - 1.0f) / oldScale + 1.0f : gizmoScale.scale();
                if (doHinting) {
                    scale = (float)Math.round(oldScale * scale * 16.0f) / 16.0f / oldScale;
                }
                if ((double)scale < 1.0E-4 / (double)oldScale) {
                    scale = 1.0E-4f / oldScale;
                }
                matrix4f.scale(scale, scale, scale);
            } else {
                float oldScale = switch (gizmoScale.axis()) {
                    case class_2350.class_2351.field_11048 -> (float)Math.sqrt(matrix4f.m00() * matrix4f.m00() + matrix4f.m10() * matrix4f.m10() + matrix4f.m20() * matrix4f.m20());
                    case class_2350.class_2351.field_11052 -> (float)Math.sqrt(matrix4f.m01() * matrix4f.m01() + matrix4f.m11() * matrix4f.m11() + matrix4f.m21() * matrix4f.m21());
                    case class_2350.class_2351.field_11051 -> (float)Math.sqrt(matrix4f.m02() * matrix4f.m02() + matrix4f.m12() * matrix4f.m12() + matrix4f.m22() * matrix4f.m22());
                    default -> throw new FaultyImplementationError();
                };
                if (oldScale == 0.0f) {
                    oldScale = 1.0f;
                }
                float scale = oldScale < 1.0f && gizmoScale.scale() > 1.0f ? (gizmoScale.scale() - 1.0f) / oldScale + 1.0f : gizmoScale.scale();
                if (doHinting) {
                    scale = (float)Math.round(oldScale * scale * 16.0f) / 16.0f / oldScale;
                }
                if ((double)scale < 1.0E-4 / (double)oldScale) {
                    scale = 1.0E-4f / oldScale;
                }
                matrix4f.scaleLocal(scale, scale, scale);
            }
        } else {
            class_2350.class_2351 axis = gizmoScale.axis();
            if (gizmoMode == GizmoMode.LOCAL) {
                float c;
                float b;
                float a = matrix4f.get(axis.ordinal(), 0);
                float oldScale = (float)Math.sqrt(a * a + (b = matrix4f.get(axis.ordinal(), 1)) * b + (c = matrix4f.get(axis.ordinal(), 2)) * c);
                if (oldScale == 0.0f) {
                    oldScale = 1.0f;
                }
                float scale = oldScale < 1.0f && gizmoScale.scale() > 1.0f ? (gizmoScale.scale() - 1.0f) / oldScale + 1.0f : gizmoScale.scale();
                if (doHinting) {
                    scale = (float)Math.round(oldScale * scale * 16.0f) / 16.0f / oldScale;
                }
                if ((double)scale < 1.0E-4 / (double)oldScale) {
                    scale = 1.0E-4f / oldScale;
                }
                matrix4f.scale((float)axis.method_10172((double)scale, 1.0, 1.0), (float)axis.method_10172(1.0, (double)scale, 1.0), (float)axis.method_10172(1.0, 1.0, (double)scale));
            } else {
                float c;
                float b;
                float a = matrix4f.get(0, axis.ordinal());
                float oldScale = (float)Math.sqrt(a * a + (b = matrix4f.get(1, axis.ordinal())) * b + (c = matrix4f.get(2, axis.ordinal())) * c);
                if (oldScale == 0.0f) {
                    oldScale = 1.0f;
                }
                float scale = oldScale < 1.0f && gizmoScale.scale() > 1.0f ? (gizmoScale.scale() - 1.0f) / oldScale + 1.0f : gizmoScale.scale();
                if (doHinting) {
                    scale = (float)Math.round(oldScale * scale * 16.0f) / 16.0f / oldScale;
                }
                if ((double)scale < 1.0E-4 / (double)oldScale) {
                    scale = 1.0E-4f / oldScale;
                }
                matrix4f.scaleLocal((float)axis.method_10172((double)scale, 1.0, 1.0), (float)axis.method_10172(1.0, (double)scale, 1.0), (float)axis.method_10172(1.0, 1.0, (double)scale));
            }
        }
    }

    public static List<String> getKeyHints() {
        ArrayList<String> keyHints = new ArrayList<String>();
        keyHints.add("RMB - Edit/Move");
        keyHints.add("Scroll - Nudge");
        Gizmo gizmo = gizmos.get(activeEntity);
        if (gizmo != null && gizmo.isGrabbed()) {
            if (gizmo.isScaleGrabbed()) {
                keyHints.add("Hold Ctrl - Scale All");
            } else {
                keyHints.add("Hold Ctrl - Inc Snapping");
            }
            keyHints.add("Hold Shift - No Snapping");
        }
        keyHints.add(Keybinds.COPY_INGAME.shortKeyIdentifier() + " - Copy");
        keyHints.add("Delete - Remove");
        boolean canUndo = DisplayEntityManipulator.canUndo();
        boolean canRedo = DisplayEntityManipulator.canRedo();
        if (canUndo && canRedo) {
            keyHints.add("Ctrl+Z/Y - Undo/Redo");
        } else if (canUndo) {
            keyHints.add("Ctrl+Z - Undo");
        } else if (canRedo) {
            keyHints.add("Ctrl+Y - Redo");
        }
        return keyHints;
    }

    public static UserAction.ActionResult callAction(UserAction userAction, Object object) {
        if (EditorUI.isActive() || !AxiomClient.isAxiomActive()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        if (userAction == UserAction.PASTE) {
            String clipboard = class_310.method_1551().field_1774.method_1460();
            if (clipboard != null && clipboard.startsWith("/summon")) {
                StringReader stringReader = new StringReader(clipboard.substring("/summon".length()).trim());
                class_634 connection = class_310.method_1551().method_1562();
                class_746 player = class_310.method_1551().field_1724;
                if (connection == null || player == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                class_7157 buildContext = class_7157.method_46722((class_7225.class_7874)connection.method_29091(), (class_7699)connection.method_45735());
                try {
                    class_243 position;
                    stringReader.skipWhitespace();
                    class_7733 resourceArgument = class_7733.method_45603((class_7157)buildContext, (class_5321)class_7924.field_41266);
                    class_6880.class_6883 entity = resourceArgument.method_45600(stringReader);
                    stringReader.skipWhitespace();
                    if (stringReader.canRead()) {
                        class_2267 coordinates = class_2277.method_9737().method_9738(stringReader);
                        class_2168 commandSourceStack = new class_2168(null, player.method_19538(), player.method_5802(), null, 2, null, class_5244.field_39003, null, (class_1297)player);
                        position = coordinates.method_9708(commandSourceStack);
                    } else {
                        position = player.method_19538();
                    }
                    stringReader.skipWhitespace();
                    class_2487 compoundTag = stringReader.canRead() ? class_2179.method_9284().method_9286(stringReader) : new class_2487();
                    compoundTag.method_10582("id", entity.method_40237().method_29177().toString());
                    new AxiomServerboundSpawnEntity(List.of(new AxiomServerboundSpawnEntity.SpawnEntry(UUID.randomUUID(), position, 0.0f, 0.0f, null, compoundTag))).send();
                    player.method_7353((class_2561)class_2561.method_43470((String)"Pasted entity").method_27692(class_124.field_1054), false);
                    DisplayEntityManipulator.disableActive();
                    return UserAction.ActionResult.USED_STOP;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return UserAction.ActionResult.NOT_HANDLED;
                }
            }
            return UserAction.ActionResult.NOT_HANDLED;
        }
        if (!Axiom.configuration.entityManipulation.showDisplayEntities) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (userAction) {
            case COPY: {
                if (DisplayEntityManipulator.tryCopyToClipboard()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case UNDO: {
                if (activeEntity != null) {
                    Gizmo gizmo = gizmos.get(activeEntity);
                    if (gizmo != null && gizmo.isGrabbed()) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    if (undoStates.size() >= 2) {
                        UndoState current = undoStates.remove(undoStates.size() - 1);
                        redoStates.add(current);
                        UndoState head = undoStates.get(undoStates.size() - 1);
                        DisplayEntityManipulator.applyTeleport(activeEntity, head.position);
                        DisplayEntityManipulator.transformSelfAndChildren(activeEntity, head.transformations);
                        overrideMatrixTicks = 10;
                        overrideMatrix = null;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case REDO: {
                if (activeEntity != null) {
                    Gizmo gizmo = gizmos.get(activeEntity);
                    if (gizmo != null && gizmo.isGrabbed()) {
                        return UserAction.ActionResult.USED_STOP;
                    }
                    if (redoStates.size() >= 1) {
                        UndoState head = redoStates.remove(redoStates.size() - 1);
                        undoStates.add(head);
                        DisplayEntityManipulator.applyTeleport(activeEntity, head.position);
                        DisplayEntityManipulator.transformSelfAndChildren(activeEntity, head.transformations);
                        overrideMatrixTicks = 10;
                        overrideMatrix = null;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case SCROLL: {
                if (activeEntity != null) {
                    UserAction.ScrollAmount amount = (UserAction.ScrollAmount)object;
                    Gizmo gizmo = gizmos.get(activeEntity);
                    class_243 look = Tool.getLookDirection();
                    if (gizmo != null && look != null) {
                        long window = class_310.method_1551().method_22683().method_4490();
                        boolean isCtrlDown = GLFW.glfwGetKey((long)window, (int)(class_310.field_1703 ? 343 : 341)) != 0 || GLFW.glfwGetKey((long)window, (int)(class_310.field_1703 ? 347 : 345)) != 0;
                        gizmo.handleScroll(amount.scrollX(), amount.scrollY(), isCtrlDown, look);
                        DisplayEntityManipulator.applyTeleport(activeEntity, gizmo.getTargetVec());
                        movementDirty = true;
                        String paddedPositionX = String.format("%.4f", gizmo.getTargetVec().field_1352);
                        String paddedPositionY = String.format("%.4f", gizmo.getTargetVec().field_1351);
                        String paddedPositionZ = String.format("%.4f", gizmo.getTargetVec().field_1350);
                        ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Position: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(paddedPositionY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)paddedPositionZ).method_27692(class_124.field_1075)));
                        overrideMatrixTicks = 10;
                        overrideMatrix = null;
                    }
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case LEFT_MOUSE: {
                if (Axiom.configuration.entityManipulation.swapLeftRightClick) {
                    return DisplayEntityManipulator.handleRightClick();
                }
                return DisplayEntityManipulator.handleLeftClick();
            }
            case RIGHT_MOUSE: {
                if (Axiom.configuration.entityManipulation.swapLeftRightClick) {
                    return DisplayEntityManipulator.handleLeftClick();
                }
                return DisplayEntityManipulator.handleRightClick();
            }
            case MIDDLE_MOUSE: {
                return DisplayEntityManipulator.handleMiddleClick();
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public static boolean tryCopyToClipboard() {
        if (activeEntity != null) {
            String command = DisplayEntityHelper.getSummonCommandForDisplay(activeEntity);
            class_310.method_1551().field_1774.method_1455(command);
            class_746 player = class_310.method_1551().field_1724;
            player.method_7353((class_2561)class_2561.method_43470((String)("Copied summon command to clipboard (" + command.length() + " characters)")).method_27692(class_124.field_1054), false);
            player.method_7353((class_2561)class_2561.method_43470((String)"You can use Ctrl+V to paste the entity").method_27692(class_124.field_1054), false);
            return true;
        }
        return false;
    }

    public static void tryCopyInterpolateToClipboard() {
        if (activeEntity != null) {
            String command = DisplayEntityHelper.getInterpolateCommandForDisplay(activeEntity);
            class_310.method_1551().field_1774.method_1455(command);
            class_746 player = class_310.method_1551().field_1724;
            player.method_7353((class_2561)class_2561.method_43470((String)("Copied interpolate command to clipboard (" + command.length() + " characters)")).method_27692(class_124.field_1054), false);
        }
    }

    @NotNull
    private static UserAction.ActionResult handleRightClick() {
        if (hoveredGizmoPart) {
            Object gizmo;
            if (activeEntity != null && (gizmo = gizmos.get(activeEntity)) != null && ((Gizmo)gizmo).isHovered()) {
                class_310.method_1551().method_1507((class_437)new EditDisplayEntityScreen(activeEntity.method_5667()));
                return UserAction.ActionResult.USED_STOP;
            }
            for (Map.Entry entry : gizmos.entrySet()) {
                if (!((Gizmo)entry.getValue()).isHovered()) continue;
                if (activeEntity != null) {
                    Gizmo gizmo2 = gizmos.get(activeEntity);
                    if (gizmo2 != null) {
                        gizmo2.enableAxes = false;
                    }
                    activeEntity = null;
                    movementDirty = false;
                    undoStates.clear();
                    redoStates.clear();
                }
                ((Gizmo)entry.getValue()).enableAxes = true;
                activeEntity = (class_8113)entry.getKey();
                HashMap<UUID, Matrix4fc> transforms = new HashMap<UUID, Matrix4fc>();
                DisplayEntityManipulator.putTransformRecursive(activeEntity, transforms);
                movementDirty = false;
                undoStates.clear();
                redoStates.clear();
                undoStates.add(new UndoState(activeEntity.method_19538(), transforms));
                class_310.method_1551().method_1507((class_437)new EditDisplayEntityScreen(activeEntity.method_5667()));
                return UserAction.ActionResult.USED_STOP;
            }
        }
        if (activeEntity != null) {
            class_239 hitResult = class_310.method_1551().field_1765;
            if (hitResult instanceof class_3965) {
                class_3965 class_39652 = (class_3965)hitResult;
                if (hitResult.method_17783() == class_239.class_240.field_1332) {
                    class_2338 position = class_39652.method_17777().method_10093(class_39652.method_17780());
                    DisplayEntityManipulator.applyTeleport(activeEntity, class_243.method_24953((class_2382)position));
                }
            }
            return UserAction.ActionResult.USED_STOP;
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private static UserAction.ActionResult handleMiddleClick() {
        Gizmo gizmo;
        if (activeEntity != null && (gizmo = gizmos.get(activeEntity)) != null && gizmo.isCenterHovered()) {
            DisplayEntityManipulator.handleMiddleClick(activeEntity);
            DisplayEntityManipulator.disableActive();
            return UserAction.ActionResult.USED_STOP;
        }
        for (Map.Entry<class_8113, Gizmo> entry : gizmos.entrySet()) {
            if (!entry.getValue().isCenterHovered()) continue;
            DisplayEntityManipulator.handleMiddleClick(entry.getKey());
            return UserAction.ActionResult.USED_STOP;
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private static void handleMiddleClick(class_8113 display) {
        class_1799 placerItemStack;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_2487 displayNbt = DisplayEntityHelper.getDisplayEntityTagWithId(display);
        if (display instanceof class_8113.class_8122) {
            class_8113.class_8122 itemDisplay = (class_8113.class_8122)display;
            placerItemStack = ((class_1799)itemDisplay.method_5841().method_12789(class_8113.class_8122.field_42423)).method_7972();
        } else {
            class_8113.class_8115 blockDisplay;
            class_2680 blockState;
            CustomBlockState customBlockState;
            placerItemStack = display instanceof class_8113.class_8115 ? ((customBlockState = ServerCustomBlocks.getCustomStateFor(blockState = (class_2680)(blockDisplay = (class_8113.class_8115)display).method_5841().method_12789(class_8113.class_8115.field_42416))) != null ? customBlockState.getCustomBlock().axiom$asItemStack() : new class_1799((class_1935)blockState.method_26204().method_8389())) : (display instanceof class_8113.class_8123 ? new class_1799((class_1935)class_1802.field_8788) : new class_1799((class_1935)class_1802.field_8694));
        }
        if (placerItemStack.method_7960()) {
            placerItemStack = new class_1799((class_1935)class_1802.field_8694);
        }
        ItemStackDataHelper.setEntityPlacer(placerItemStack, displayNbt);
        ItemStackDataHelper.setName(placerItemStack, (class_2561)display.method_5477().method_27661().method_27692(class_124.field_1054));
        ItemStackDataHelper.setLore(placerItemStack, List.of(class_2561.method_43470((String)"Right Click to place with rotation (90\u00b0 snapping)").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1080)), class_2561.method_43470((String)"Sneak+Right Click to place with rotation (1\u00b0 snapping)").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1080))));
        class_1661 inventory = player.method_31548();
        inventory.method_65126(placerItemStack);
        class_310.method_1551().field_1761.method_2909(player.method_5998(class_1268.field_5808), 36 + inventory.field_7545);
    }

    @NotNull
    private static UserAction.ActionResult handleLeftClick() {
        boolean ret = false;
        if (activeEntity != null) {
            Gizmo gizmo = gizmos.get(activeEntity);
            if (gizmo != null) {
                if (gizmo.leftClick()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                gizmo.enableAxes = false;
                ret = true;
            }
            activeEntity = null;
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
        }
        for (Map.Entry<class_8113, Gizmo> entry : gizmos.entrySet()) {
            if (!entry.getValue().leftClick()) continue;
            activeEntity = entry.getKey();
            HashMap<UUID, Matrix4fc> transforms = new HashMap<UUID, Matrix4fc>();
            DisplayEntityManipulator.putTransformRecursive(activeEntity, transforms);
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
            undoStates.add(new UndoState(activeEntity.method_19538(), transforms));
            return UserAction.ActionResult.USED_STOP;
        }
        if (ret) {
            return UserAction.ActionResult.USED_STOP;
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public static void trySelectDisplayEntity(class_8113 display) {
        DisplayEntityManipulator.disableActive();
        Gizmo gizmo = gizmos.get(display);
        if (gizmo != null) {
            gizmo.enableAxes = true;
            activeEntity = display;
            HashMap<UUID, Matrix4fc> transforms = new HashMap<UUID, Matrix4fc>();
            DisplayEntityManipulator.putTransformRecursive(activeEntity, transforms);
            movementDirty = false;
            undoStates.clear();
            redoStates.clear();
            undoStates.add(new UndoState(activeEntity.method_19538(), transforms));
        }
    }

    private static void putTransformRecursive(class_8113 display, Map<UUID, Matrix4fc> transforms) {
        Vector3f vector3f = (Vector3f)display.method_5841().method_12789(class_8113.field_42401);
        Quaternionf quaternionf = (Quaternionf)display.method_5841().method_12789(class_8113.field_42403);
        Vector3f vector3f2 = (Vector3f)display.method_5841().method_12789(class_8113.field_42402);
        Quaternionf quaternionf2 = (Quaternionf)display.method_5841().method_12789(class_8113.field_42367);
        Matrix4f transform = new class_4590(vector3f, quaternionf, vector3f2, quaternionf2).method_22936();
        transforms.put(display.method_5667(), (Matrix4fc)transform);
        for (class_1297 passenger : display.method_5685()) {
            if (!(passenger instanceof class_8113)) continue;
            class_8113 displayPassenger = (class_8113)passenger;
            DisplayEntityManipulator.putTransformRecursive(displayPassenger, transforms);
        }
    }

    private static class PendingUpdate {
        private class_243 position;
        private class_2487 mergeNbt = new class_2487();

        private PendingUpdate() {
        }
    }

    private record UndoState(class_243 position, Map<UUID, Matrix4fc> transformations) {
    }
}

