/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.clipboard.ModifySelection;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.clipboard.SelectionSerialization;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.downgrade.BlockVersionCompatibility;
import com.moulberry.axiom.downgrade.DowngradeVersionList;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.ImageReferenceWindows;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.schematic.SchematicLoader;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.editor.views.ViewManager;
import com.moulberry.axiom.editor.windows.OpenSourceLicensesWindow;
import com.moulberry.axiom.editor.windows.operations.FillBlocksWindow;
import com.moulberry.axiom.editor.windows.save_world.ExportSchematicWindow;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.operations.DrainOperation;
import com.moulberry.axiom.operations.FillNearestOperation;
import com.moulberry.axiom.operations.GenerateColourFieldOperation;
import com.moulberry.axiom.operations.HollowOperation;
import com.moulberry.axiom.operations.SimulateGravityOperation;
import com.moulberry.axiom.operations.UpdateBlocksOperation;
import com.moulberry.axiom.operations.WaterlogOperation;
import com.moulberry.axiom.operations.smooth.SmoothSnow;
import com.moulberry.axiom.rasterization.HullRasterization;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.vanilla_structure_file.VanillaStructureHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import imgui.ImGui;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class MainMenuBar {
    /*
     * Unable to fully structure code
     */
    public static void render() {
        block96: {
            block97: {
                if (!ImGui.beginMainMenuBar()) break block96;
                config = Axiom.getInstance().serverConfig;
                selectionActive = Selection.getSelectionBuffer().isEmpty() == false;
                clipboardEmpty = Clipboard.INSTANCE.getClipboard() == null;
                v0 = clipboardNonEmpty = clipboardEmpty == false;
                if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.file"))) {
                    if (!AxiomClient.hasPermission(AxiomPermission.CAN_IMPORT_BLOCKS)) {
                        ImGuiHelper.disabledMenuItem(AxiomI18n.get("axiom.editorui.mainmenu.file.import_schematic"), "Server has disallowed importing");
                    } else if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.file.import_schematic"))) {
                        schematicDir = SchematicLoader.getDefaultSchematicDir();
                        schematicDirStr = schematicDir.toString();
                        if (!schematicDirStr.endsWith(separator = schematicDir.getFileSystem().getSeparator())) {
                            schematicDirStr = (String)schematicDirStr + separator;
                        }
                        future = AsyncFileDialogs.openFileDialog((String)schematicDirStr, "Schematic Files", new String[]{"schem", "schematic", "litematic"});
                        future.thenAccept((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$render$5(java.lang.String ), (Ljava/lang/String;)V)());
                    }
                    if (!AxiomClient.hasPermission(AxiomPermission.CAN_EXPORT_BLOCKS)) {
                        ImGuiHelper.disabledMenuItem(AxiomI18n.get("axiom.editorui.mainmenu.export_schematic"), "Server has disallowed exporting");
                    } else if (clipboardEmpty) {
                        ImGuiHelper.disabledMenuItem(AxiomI18n.get("axiom.editorui.mainmenu.export_schematic"), AxiomI18n.get("axiom.tool.painter.clipboard_empty_warning"));
                    } else if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.export_schematic"))) {
                        clipboardObject = Clipboard.INSTANCE.getClipboard();
                        if (clipboardObject instanceof ClipboardObject.Anonymous) {
                            anonymous = (ClipboardObject.Anonymous)clipboardObject;
                            ExportSchematicWindow.open(clipboardObject.blockRegion(), clipboardObject.blockEntities(), anonymous.additionalSchematicData());
                        } else {
                            ExportSchematicWindow.open(clipboardObject.blockRegion(), clipboardObject.blockEntities(), null);
                        }
                    }
                    if (!AxiomClient.hasPermission(AxiomPermission.CAN_EXPORT_BLOCKS)) {
                        ImGuiHelper.disabledMenuItem("Export Minecraft Structure NBT", "Server has disallowed exporting");
                    } else if (clipboardEmpty) {
                        ImGuiHelper.disabledMenuItem("Export Minecraft Structure NBT", "Clipboard is empty");
                    } else if (ImGui.menuItem("Export Minecraft Structure NBT")) {
                        structureNbt = VanillaStructureHelper.toStructureNbt(Clipboard.INSTANCE.getClipboard());
                        future = AsyncFileDialogs.saveFileDialog(FabricLoader.getInstance().getGameDir().toString(), "structure.nbt", "NBT", new String[]{"nbt"});
                        future.thenAccept((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$render$7(net.minecraft.class_2487 java.lang.String ), (Ljava/lang/String;)V)((class_2487)structureNbt));
                    }
                    if (!AxiomClient.hasPermission(AxiomPermission.CAN_EXPORT_BLOCKS)) {
                        ImGuiHelper.disabledMenuItem("Export as CSV", "Server has disallowed exporting");
                    } else if (Selection.getSelectionBuffer().isEmpty()) {
                        ImGuiHelper.disabledMenuItem("Export as CSV", "Selection is empty");
                    } else if (ImGui.menuItem("Export as CSV")) {
                        level = class_310.method_1551().field_1687;
                        mutableBlockPos = new class_2338.class_2339();
                        stringBuilder = new StringBuilder();
                        Selection.getSelectionBuffer().forEach((TriIntConsumer)LambdaMetafactory.metafactory(null, null, null, (III)V, lambda$render$8(net.minecraft.class_638 net.minecraft.class_2338$class_2339 java.lang.StringBuilder int int int ), (III)V)((class_638)level, (class_2338.class_2339)mutableBlockPos, (StringBuilder)stringBuilder));
                        future = AsyncFileDialogs.saveFileDialog(FabricLoader.getInstance().getGameDir().toString(), "blocks.csv", "Comma Separated Values", new String[]{"csv"});
                        future.thenAccept((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$render$10(java.lang.StringBuilder java.lang.String ), (Ljava/lang/String;)V)((StringBuilder)stringBuilder));
                    }
                    if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.open_reference_image"))) {
                        path = FabricLoader.getInstance().getGameDir();
                        dirStr = path.toString();
                        if (!dirStr.endsWith(separator = path.getFileSystem().getSeparator())) {
                            dirStr = (String)dirStr + separator;
                        }
                        future = AsyncFileDialogs.openFileDialog((String)dirStr, "Image Files", new String[]{"png", "jpeg", "jpg"});
                        future.thenAccept((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$render$12(java.lang.String ), (Ljava/lang/String;)V)());
                    }
                    ImGui.endMenu();
                }
                if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.edit"))) {
                    historyPosition = Dispatcher.getHistoryPosition();
                    if (historyPosition < 0) {
                        ImGui.beginDisabled();
                        ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.undo"), Keybinds.UNDO.longKeyIdentifier());
                        ImGui.endDisabled();
                    } else {
                        data = Dispatcher.getHistoryData(historyPosition);
                        undoMessage = AxiomI18n.get("axiom.editorui.mainmenu.edit.undo_named", new Object[]{data.entry().description()});
                        if (ImGui.menuItem(undoMessage, Keybinds.UNDO.longKeyIdentifier())) {
                            Dispatcher.callAction(UserAction.UNDO, null);
                        }
                    }
                    if (historyPosition + 1 >= Dispatcher.getHistoryDataCount()) {
                        ImGui.beginDisabled();
                        ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.redo"), Keybinds.REDO.longKeyIdentifier());
                        ImGui.endDisabled();
                    } else {
                        data = Dispatcher.getHistoryData(historyPosition + 1);
                        redoMessage = AxiomI18n.get("axiom.editorui.mainmenu.edit.redo_named", new Object[]{data.entry().description()});
                        if (ImGui.menuItem(redoMessage, Keybinds.REDO.longKeyIdentifier())) {
                            Dispatcher.callAction(UserAction.REDO, null);
                        }
                    }
                    ImGui.separator();
                    if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.cut"), Keybinds.CUT.longKeyIdentifier(), false, selectionActive)) {
                        UserAction.CUT.call(null);
                    }
                    if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.copy"), Keybinds.COPY.longKeyIdentifier(), false, selectionActive)) {
                        UserAction.COPY.call(null);
                    }
                    ImGui.separator();
                    if (!AxiomClient.hasPermission(AxiomPermission.CAN_EXPORT_BLOCKS)) {
                        ImGuiHelper.disabledMenuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.save_blueprint"), "Server has disallowed saving blueprints");
                    } else if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.edit.save_blueprint"), Keybinds.SAVE_BLUEPRINT.longKeyIdentifier(), false, clipboardNonEmpty)) {
                        UserAction.SAVE.call(null);
                    }
                    ImGui.endMenu();
                }
                if (!ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.select"))) break block97;
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.clear"), AxiomI18n.get("key.keyboard.enter"), false, selectionActive)) {
                    Selection.clearSelection();
                }
                if (!selectionActive) {
                    ImGui.beginDisabled();
                }
                if (ImGui.menuItem("Move Selection")) {
                    ModifySelection.start();
                }
                if (!selectionActive) {
                    ImGui.endDisabled();
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.filter"))) {
                    EditorWindowType.FILTER_SELECTION.setOpen(true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.expand"))) {
                    EditorWindowType.EXPAND_SELECTION.setOpen(true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.shrink"))) {
                    EditorWindowType.SHRINK_SELECTION.setOpen(true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.distort"))) {
                    EditorWindowType.DISTORT_SELECTION.setOpen(true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.smooth"))) {
                    EditorWindowType.SMOOTH_SELECTION.setOpen(true);
                }
                if (!((data = Selection.getSelectionBuffer()) instanceof SelectionBuffer.Set)) ** GOTO lbl-1000
                set = (SelectionBuffer.Set)data;
                if (set.selectionRegion.count() > 0) {
                    if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.bounding_box"))) {
                        Selection.addAABB(set.min(), set.max());
                    }
                    if (ImGui.menuItem("Convex Hull")) {
                        doubleArrayList = new DoubleArrayList(set.selectionRegion.count() * 3);
                        set.selectionRegion.forEach((TriIntConsumer)LambdaMetafactory.metafactory(null, null, null, (III)V, lambda$render$13(it.unimi.dsi.fastutil.doubles.DoubleArrayList int int int ), (III)V)((DoubleArrayList)doubleArrayList));
                        newSet = new PositionSet();
                        positions = doubleArrayList.elements();
                        if (positions.length != doubleArrayList.size()) {
                            positions = doubleArrayList.toDoubleArray();
                        }
                        HullRasterization.quickHullPositionSet(newSet, positions);
                        Selection.addSet(newSet);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    ImGui.beginDisabled();
                    ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.select.bounding_box"));
                    ImGui.endDisabled();
                    ImGui.beginDisabled();
                    ImGui.menuItem("Convex Hull");
                    ImGui.endDisabled();
                }
                if (Selection.getSelectionBuffer().isEmpty()) {
                    ImGuiHelper.disabledMenuItem("Save...", "Selection is empty");
                } else {
                    if (ImGui.menuItem("Save...")) {
                        future = AsyncFileDialogs.saveFileDialog(FabricLoader.getInstance().getGameDir().toString(), "selection.csv", "Comma Separated Values", new String[]{"csv"});
                        future.thenAccept((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$render$15(java.lang.String ), (Ljava/lang/String;)V)());
                    }
                    ImGuiHelper.tooltip("Save selection region to a file. Can be used in external programs, or loaded through the Load... button below");
                }
                if (ImGui.menuItem("Load...")) {
                    future = AsyncFileDialogs.openFileDialog(FabricLoader.getInstance().getGameDir().toString(), "Comma Separated Values", new String[]{"csv"});
                    future.thenAccept((Consumer)(Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$render$17(java.lang.String ), (Ljava/lang/String;)V)());
                }
                ImGuiHelper.tooltip("Load a selection region from a file");
                ImGui.endMenu();
            }
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.view"))) {
                v1 = canAddView = ViewManager.getViews().size() < 16 && AxiomClient.hasPermission(AxiomPermission.EDITOR_VIEWS) != false;
                if (!canAddView) {
                    ImGui.beginDisabled();
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.view.create_new"))) {
                    ViewManager.addNewView();
                }
                if (!canAddView) {
                    ImGui.endDisabled();
                }
                ImGui.separator();
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.view.show_selection"), Keybinds.SHOW_SELECTION.longKeyIdentifier(), Selection.shouldRenderSelection())) {
                    Selection.setShouldRenderSelection(Selection.shouldRenderSelection() == false);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.view.show_biomes"), Keybinds.SHOW_BIOMES.longKeyIdentifier(), Axiom.configuration.visuals.showBiomes)) {
                    v2 = Axiom.configuration.visuals.showBiomes = Axiom.configuration.visuals.showBiomes == false;
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.view.show_annotations"), Keybinds.SHOW_ANNOTATIONS.longKeyIdentifier(), Axiom.configuration.visuals.showAnnotations)) {
                    v3 = Axiom.configuration.visuals.showAnnotations = Axiom.configuration.visuals.showAnnotations == false;
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.view.show_ruler"), "", Axiom.configuration.visuals.showRuler)) {
                    v4 = Axiom.configuration.visuals.showRuler = Axiom.configuration.visuals.showRuler == false;
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.view.show_key_presses"), "", Axiom.configuration.visuals.keypressOverlay)) {
                    Axiom.configuration.visuals.keypressOverlay = Axiom.configuration.visuals.keypressOverlay == false;
                }
                uiScale = new float[]{Axiom.configuration.internal.globalScale};
                ImGui.setNextItemWidth(100.0f * EditorUI.getUiScale());
                if (ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.mainmenu.view.ui_scale"), uiScale, 0.5f, 2.0f)) {
                    Axiom.configuration.internal.globalScale = uiScale[0];
                }
                minBrightness = new float[]{(float)Axiom.configuration.visuals.minBrightness / 100.0f};
                ImGui.setNextItemWidth(100.0f * EditorUI.getUiScale());
                if (ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.mainmenu.view.min_brightness"), minBrightness, 0.0f, 1.0f)) {
                    Axiom.configuration.visuals.minBrightness = (int)(minBrightness[0] * 100.0f);
                }
                liquidOpacity = new float[]{(float)Axiom.configuration.visuals.liquidOpacity / 100.0f};
                ImGui.setNextItemWidth(100.0f * EditorUI.getUiScale());
                if (ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.mainmenu.view.liquid_opacity"), liquidOpacity, 0.0f, 1.0f)) {
                    Axiom.configuration.visuals.liquidOpacity = (int)(liquidOpacity[0] * 100.0f);
                }
                if ((compatibilityLevel = BlockVersionCompatibility.getCompatibilityLevel()) != null && (versionStrings = DowngradeVersionList.getVersionStrings()) != null) {
                    currentIndex = DowngradeVersionList.getVersions().indexOf((Object)compatibilityLevel);
                    indexArray = new int[]{currentIndex};
                    ImGui.setNextItemWidth(100.0f * EditorUI.getUiScale());
                    if (ImGuiHelper.combo("Block Version", indexArray, versionStrings) && indexArray[0] != currentIndex) {
                        BlockVersionCompatibility.setCompatibilityLevel(DowngradeVersionList.getVersions().get(indexArray[0]));
                    }
                    ImGuiHelper.tooltip("Set the compatibility version for Blocks. Incompatible newer blocks will be highlighted with a red background");
                }
                ImGui.endMenu();
            }
            MainMenuBar.renderOperationsImgui(true);
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.toolmasks"))) {
                canClear = MaskManager.hasConfiguredMask();
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.toolmasks.clear"), null, false, canClear)) {
                    MaskManager.setConfiguredMask(null, true, true);
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.toolmasks.edit"))) {
                    EditorWindowType.TOOL_MASKS.setOpen(true);
                }
                ImGui.endMenu();
            }
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.window"))) {
                if (ImGui.menuItem("Store Current Layout as Default")) {
                    Axiom.configuration.internal.defaultLayout = MainMenuBar.storeLayout();
                }
                if (ImGui.menuItem("Restore Default Layout")) {
                    MainMenuBar.restoreLayout(Axiom.configuration.internal.defaultLayout);
                }
                ImGui.separator();
                if (ImGui.menuItem("Copy Current Layout to Clipboard")) {
                    class_310.method_1551().field_1774.method_1455(MainMenuBar.storeLayout());
                }
                if (!(allowLoadingLayout = (clipboard = class_310.method_1551().field_1774.method_1460()).contains("[Docking][Data]"))) {
                    ImGui.beginDisabled();
                }
                if (ImGui.menuItem("Load Layout from Clipboard")) {
                    MainMenuBar.restoreLayout(clipboard);
                }
                if (!allowLoadingLayout) {
                    ImGui.endDisabled();
                }
                ImGui.separator();
                internal = Axiom.configuration.internal;
                if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.mainmenu.window.show_close_window_button"), internal.showCloseWindowButton)) {
                    internal.showCloseWindowButton = internal.showCloseWindowButton == false;
                }
                ImGui.separator();
                if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.window.windows"))) {
                    for (EditorWindowType windowType : EditorWindowType.values()) {
                        if (!windowType.isImportant()) continue;
                        open = new ImBoolean(windowType.isOpen());
                        ImGui.checkbox(windowType.getName(), open);
                        windowType.setOpen(open.get());
                    }
                    ImGui.endMenu();
                }
                ImGui.endMenu();
            }
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.help.keybinds"))) {
                EditorWindowType.KEYBINDS.setOpen(true);
            }
            if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.help"))) {
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.help.discord_server"))) {
                    discord = "https://discord.gg/axiomtool/";
                    class_310.method_1551().method_1507((class_437)new class_407((BooleanConsumer)LambdaMetafactory.metafactory(null, null, null, (Z)V, lambda$render$18(java.lang.String boolean ), (Z)V)((String)discord), discord, false));
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.help.documentation"))) {
                    docs = "https://axiomdocs.moulberry.com/";
                    class_310.method_1551().method_1507((class_437)new class_407((BooleanConsumer)LambdaMetafactory.metafactory(null, null, null, (Z)V, lambda$render$19(java.lang.String boolean ), (Z)V)((String)docs), docs, false));
                }
                if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.help.style_editor"))) {
                    EditorWindowType.STYLE_EDITOR.setOpen(true);
                }
                if (ImGui.menuItem("Skip Tutorial")) {
                    TutorialManager.skip();
                }
                if (FabricLoader.getInstance().isDevelopmentEnvironment() && ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.help.reset_tutorial"))) {
                    if (ImGui.menuItem("Introduction")) {
                        TutorialManager.reset(Tutorial.INTRODUCTION);
                    }
                    if (ImGui.menuItem("Selection")) {
                        TutorialManager.reset(Tutorial.SELECTION);
                    }
                    if (ImGui.beginMenu("Tools")) {
                        if (ImGui.menuItem("Magic Select")) {
                            TutorialManager.reset(Tutorial.MAGIC_SELECT_TOOL);
                        }
                        if (ImGui.menuItem("Box Select")) {
                            TutorialManager.reset(Tutorial.BOX_SELECT_TOOL);
                        }
                        if (ImGui.menuItem("Slope")) {
                            TutorialManager.reset(Tutorial.SLOPE_TOOL);
                        }
                        if (ImGui.menuItem("Sculpt Draw")) {
                            TutorialManager.reset(Tutorial.SCULPT_DRAW_TOOL);
                        }
                        ImGui.endMenu();
                    }
                    ImGui.endMenu();
                }
                if (ImGui.menuItem("Open Source Licenses")) {
                    OpenSourceLicensesWindow.open = true;
                }
                ImGui.endMenu();
            }
            ImGui.endMainMenuBar();
        }
    }

    @NotNull
    private static String storeLayout() {
        String iniSettingsStr = ImGui.saveIniSettingsToMemory();
        boolean addNewline = !iniSettingsStr.endsWith("\n");
        StringBuilder iniSettings = new StringBuilder(iniSettingsStr);
        if (addNewline) {
            iniSettings.append("\n");
        }
        iniSettings.append("[AxiomWindows]\n");
        for (String openWindow : EditorWindowType.getOpenByName()) {
            iniSettings.append(openWindow).append("\n");
        }
        return iniSettings.toString();
    }

    private static void restoreLayout(String layout) {
        if (!layout.contains("[Docking][Data]")) {
            return;
        }
        String[] split = layout.split("\\[AxiomWindows\\]");
        String imgui = split[0].trim();
        ImGui.loadIniSettingsFromMemory(imgui);
        if (split.length >= 2) {
            String axiom = split[1].trim();
            String[] windows = axiom.split("\n");
            ArrayList<String> openByName = new ArrayList<String>();
            for (String window : windows) {
                openByName.add(window.trim());
            }
            EditorWindowType.setOpenByName(openByName);
        } else {
            EditorWindowType.setOpenToDefault();
        }
    }

    public static void renderOperationsImgui(boolean menu) {
        if (menu) {
            if (!ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.operations"))) {
                return;
            }
        } else {
            if (ImGui.button(AxiomI18n.get("axiom.editorui.mainmenu.operations") + "...")) {
                ImGui.openPopup("OperationsPopup");
            }
            if (!ImGuiHelper.beginPopup("OperationsPopup")) {
                return;
            }
        }
        if (ImGui.beginMenu(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_category"))) {
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill"), Keybinds.QUICK_FILL.longKeyIdentifier())) {
                FillBlocksWindow.setFillType(0);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_description"));
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_outline"))) {
                FillBlocksWindow.setFillType(2);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_outline_description"));
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_walls"))) {
                FillBlocksWindow.setFillType(3);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_walls_description"));
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_top"))) {
                FillBlocksWindow.setFillType(4);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_top_description"));
            if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_bottom"))) {
                FillBlocksWindow.setFillType(5);
                EditorWindowType.FILL.setOpen(true);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_bottom_description"));
            ImGui.endMenu();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_nearest"))) {
            FillNearestOperation.fillNearest();
        }
        ImGuiHelper.tooltip(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_nearest_description"));
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.replace"), Keybinds.QUICK_REPLACE.longKeyIdentifier())) {
            EditorWindowType.REPLACE.setOpen(true);
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.type_replace"))) {
            EditorWindowType.TYPE_REPLACE.setOpen(true);
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.set_biome"))) {
            EditorWindowType.SET_BIOME.setOpen(true);
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.autoshade"))) {
            EditorWindowType.AUTOSHADE.setOpen(true);
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.drain"))) {
            DrainOperation.drain();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.waterlog"))) {
            WaterlogOperation.waterlog();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.smoothsnow"))) {
            SmoothSnow.smoothSnow();
        }
        ImGui.separator();
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.simulate_gravity"))) {
            SimulateGravityOperation.gravity();
        }
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.trigger_updates"))) {
            UpdateBlocksOperation.updateBlocks();
        }
        ImGui.separator();
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.hollow"))) {
            HollowOperation.hollow();
        }
        ImGuiHelper.tooltip("Hollow replaces all unreachable blocks inside your build with air");
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_gaps"))) {
            HollowOperation.fillGaps(Tool.getActiveBlock());
        }
        ImGuiHelper.tooltip("Fill gaps replaces all unreachable air blocks inside your build with your active block");
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.fill_unreachable"))) {
            HollowOperation.fillUnreachable(Tool.getActiveBlock());
        }
        ImGuiHelper.tooltip("Fill unreachable replaces all unreachable non-air blocks inside your build with your active block");
        ImGui.separator();
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.generate_colour_field"))) {
            GenerateColourFieldOperation.generateColourField();
        }
        ImGui.separator();
        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.mainmenu.operations.analyze"))) {
            EditorWindowType.ANALYZE.setOpen(true);
        }
        if (ImGui.menuItem("Animated Rebuild...")) {
            EditorWindowType.ANIMATED_REBUILD.setOpen(true);
        }
        ImGuiHelper.tooltip("Gradually rebuilds a selection block-by-block. This feature is intended for content creators making video showcases of a build");
        if (menu) {
            ImGui.endMenu();
        } else {
            ImGui.endPopup();
        }
    }

    private static /* synthetic */ void lambda$render$19(String docs, boolean open) {
        if (open) {
            try {
                class_156.method_668().method_673(new URI(docs));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        class_310.method_1551().method_1507(null);
    }

    private static /* synthetic */ void lambda$render$18(String discord, boolean open) {
        if (open) {
            try {
                class_156.method_668().method_673(new URI(discord));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        class_310.method_1551().method_1507(null);
    }

    private static /* synthetic */ void lambda$render$17(String filePath) {
        if (filePath == null) {
            Axiom.LOGGER.info("Skipping load selection since file dialog was cancelled");
            ChatUtils.warning("Cancelled open file, aborting");
            return;
        }
        Axiom.LOGGER.info("Loading selection from file: {}", (Object)filePath);
        class_310.method_1551().method_20493(() -> {
            Path file = Path.of(filePath, new String[0]);
            try (BufferedReader reader = Files.newBufferedReader(file);){
                BooleanWrapper malformed = new BooleanWrapper(false);
                SelectionBuffer buffer = SelectionSerialization.loadSelection(reader, malformed);
                if (malformed.value) {
                    ChatUtils.warning("Selection file contained unexpected data. Selection may be malformed");
                }
                Selection.setBufferWithHistory(buffer);
            }
            catch (Throwable e) {
                e.printStackTrace();
                ChatUtils.error(e.getMessage());
            }
        });
    }

    private static /* synthetic */ void lambda$render$15(String filePath) {
        if (filePath == null) {
            Axiom.LOGGER.info("Skipping save selection since file dialog was cancelled");
            ChatUtils.warning("Cancelled file save, aborting");
            return;
        }
        Axiom.LOGGER.info("Saving selection to file: {}", (Object)filePath);
        class_310.method_1551().method_20493(() -> {
            try {
                Path file = Path.of(filePath, new String[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                    SelectionSerialization.writeSelection(writer, Selection.getSelectionBuffer());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                ChatUtils.error(e.getMessage());
            }
        });
    }

    private static /* synthetic */ void lambda$render$13(DoubleArrayList doubleArrayList, int x, int y, int z) {
        doubleArrayList.add((double)x);
        doubleArrayList.add((double)y);
        doubleArrayList.add((double)z);
    }

    private static /* synthetic */ void lambda$render$12(String imagePath) {
        if (imagePath == null) {
            Axiom.LOGGER.info("Skipping open reference image since file dialog was cancelled");
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Cancelled open file, aborting").method_27692(class_124.field_1054), false);
            return;
        }
        Axiom.LOGGER.info("Opening reference image from file: {}", (Object)imagePath);
        class_310.method_1551().method_20493(() -> {
            Path file = Path.of(imagePath, new String[0]);
            try {
                BufferedImage image = ImageIO.read(Files.newInputStream(file, new OpenOption[0]));
                int width = image.getWidth();
                int height = image.getHeight();
                class_1011 nativeImage = new class_1011(width, height, true);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int argb = image.getRGB(x, y);
                        int alpha = argb >> 24 & 0xFF;
                        int red = argb >> 16 & 0xFF;
                        int green = argb >> 8 & 0xFF;
                        int blue = argb & 0xFF;
                        nativeImage.method_61941(x, y, alpha << 24 | red << 16 | green << 8 | blue);
                    }
                }
                ImageReferenceWindows.add(nativeImage);
            }
            catch (Throwable e) {
                e.printStackTrace();
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061), false);
            }
        });
    }

    private static /* synthetic */ void lambda$render$10(StringBuilder stringBuilder, String filePath) {
        if (filePath == null) {
            Axiom.LOGGER.info("Skipping export as csv since file dialog was cancelled");
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Cancelled file save, aborting").method_27692(class_124.field_1054), false);
            return;
        }
        Axiom.LOGGER.info("Saving blocks as csv to file: {}", (Object)filePath);
        class_310.method_1551().method_20493(() -> {
            try {
                Path file = Path.of(filePath, new String[0]);
                Files.writeString(file, (CharSequence)stringBuilder, new OpenOption[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061), false);
            }
        });
    }

    private static /* synthetic */ void lambda$render$8(class_638 level, class_2338.class_2339 mutableBlockPos, StringBuilder stringBuilder, int x, int y, int z) {
        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
        if (!blockState.method_26215()) {
            stringBuilder.append(class_2259.method_9685((class_2680)blockState).replace(",", ";"));
            stringBuilder.append(',');
            stringBuilder.append(x);
            stringBuilder.append(',');
            stringBuilder.append(y);
            stringBuilder.append(',');
            stringBuilder.append(z);
            stringBuilder.append('\n');
        }
    }

    private static /* synthetic */ void lambda$render$7(class_2487 structureNbt, String filePath) {
        if (filePath == null) {
            Axiom.LOGGER.info("Skipping export structure nbt since file dialog was cancelled");
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Cancelled file save, aborting").method_27692(class_124.field_1054), false);
            return;
        }
        Axiom.LOGGER.info("Saving structure nbt to file: {}", (Object)filePath);
        class_310.method_1551().method_20493(() -> {
            try {
                Path file = Path.of(filePath, new String[0]);
                class_2507.method_30614((class_2487)structureNbt, (Path)file);
            }
            catch (Throwable e) {
                e.printStackTrace();
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061), false);
            }
        });
    }

    private static /* synthetic */ void lambda$render$5(String path) {
        if (path == null) {
            Axiom.LOGGER.info("Skipping schematic load since file dialog was cancelled");
            return;
        }
        Axiom.LOGGER.info("Loading schematic from file: {}", (Object)path);
        try {
            ClipboardObject clipboardObject;
            Path file = Path.of(path, new String[0]);
            class_2487 tag = class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
            while (tag.method_10541().size() == 1) {
                String key = (String)tag.method_10541().iterator().next();
                class_2487 inner = tag.method_10562(key);
                if (inner.method_33133()) continue;
                tag = inner;
            }
            if (tag.method_10545("Regions")) {
                class_310.method_1551().method_20493(() -> class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Loading Litematic schematic").method_27692(class_124.field_1060), false));
                clipboardObject = SchematicLoader.loadLitematic(tag);
            } else if (tag.method_10545("Version")) {
                int version = VersionUtilsNbt.helperCompoundTagGetInt(tag, "Version").get();
                class_310.method_1551().method_20493(() -> class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Loading SpongeV" + version + " schematic")).method_27692(class_124.field_1060), false));
                clipboardObject = SchematicLoader.loadSponge(tag);
            } else if (tag.method_10545("Materials")) {
                class_310.method_1551().method_20493(() -> class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Loading Legacy1.12 schematic").method_27692(class_124.field_1060), false));
                clipboardObject = SchematicLoader.loadLegacy(tag);
            } else {
                throw new SchematicLoader.SchematicLoadException("Unknown format");
            }
            class_310.method_1551().method_20493(() -> {
                if (!clipboardObject.blockRegion().isEmpty()) {
                    Clipboard.INSTANCE.setClipboard(clipboardObject);
                } else {
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Schematic appears to be empty :(").method_27692(class_124.field_1061), false);
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
            String message = e.getMessage();
            class_310.method_1551().method_20493(() -> class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061), false));
        }
    }
}

