/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedArrayTypeImpl;
import io.leangen.geantyref.AnnotatedCaptureType;
import io.leangen.geantyref.AnnotatedCaptureTypeImpl;
import io.leangen.geantyref.AnnotatedTypeVariableImpl;
import io.leangen.geantyref.AnnotatedWildcardTypeImpl;
import io.leangen.geantyref.CaptureType;
import io.leangen.geantyref.GenericArrayTypeImpl;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.WildcardTypeImpl;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class TypeVisitor {
    private final Map<TypeVariable, AnnotatedTypeVariable> varCache = new IdentityHashMap<TypeVariable, AnnotatedTypeVariable>();
    private final Map<AnnotatedCaptureCacheKey, AnnotatedType> captureCache = new HashMap<AnnotatedCaptureCacheKey, AnnotatedType>();

    protected AnnotatedType visitParameterizedType(AnnotatedParameterizedType type2) {
        AnnotatedType[] params = (AnnotatedType[])Arrays.stream(type2.getAnnotatedActualTypeArguments()).map(param -> GenericTypeReflector.transform(param, this)).toArray(AnnotatedType[]::new);
        return GenericTypeReflector.replaceParameters(type2, params);
    }

    protected AnnotatedType visitWildcardType(AnnotatedWildcardType type2) {
        Type[] typeArray;
        AnnotatedType[] lowerBounds = (AnnotatedType[])Arrays.stream(type2.getAnnotatedLowerBounds()).map(bound -> GenericTypeReflector.transform(bound, this)).toArray(AnnotatedType[]::new);
        AnnotatedType[] upperBounds = (AnnotatedType[])Arrays.stream(type2.getAnnotatedUpperBounds()).map(bound -> GenericTypeReflector.transform(bound, this)).toArray(AnnotatedType[]::new);
        if (upperBounds.length > 0) {
            typeArray = (Type[])Arrays.stream(upperBounds).map(AnnotatedType::getType).toArray(Type[]::new);
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        }
        WildcardTypeImpl inner = new WildcardTypeImpl(typeArray, (Type[])Arrays.stream(lowerBounds).map(AnnotatedType::getType).toArray(Type[]::new));
        return new AnnotatedWildcardTypeImpl(inner, type2.getAnnotations(), lowerBounds, upperBounds);
    }

    protected AnnotatedType visitVariable(AnnotatedTypeVariable type2) {
        TypeVariable var = (TypeVariable)type2.getType();
        if (this.varCache.containsKey(var)) {
            return this.varCache.get(var);
        }
        AnnotatedTypeVariableImpl variable = new AnnotatedTypeVariableImpl(var, type2.getAnnotations());
        this.varCache.put(var, variable);
        AnnotatedType[] bounds = (AnnotatedType[])Arrays.stream(type2.getAnnotatedBounds()).map(bound -> GenericTypeReflector.transform(bound, this)).toArray(AnnotatedType[]::new);
        variable.init(bounds);
        return variable;
    }

    protected AnnotatedType visitArray(AnnotatedArrayType type2) {
        AnnotatedType componentType = GenericTypeReflector.transform(type2.getAnnotatedGenericComponentType(), this);
        return new AnnotatedArrayTypeImpl(GenericArrayTypeImpl.createArrayType(componentType.getType()), type2.getAnnotations(), componentType);
    }

    protected AnnotatedType visitCaptureType(AnnotatedCaptureType type2) {
        AnnotatedCaptureCacheKey key = new AnnotatedCaptureCacheKey(type2);
        if (this.captureCache.containsKey(key)) {
            return this.captureCache.get(key);
        }
        AnnotatedCaptureTypeImpl annotatedCapture = new AnnotatedCaptureTypeImpl((CaptureType)type2.getType(), (AnnotatedWildcardType)GenericTypeReflector.transform(type2.getAnnotatedWildcardType(), this), (AnnotatedTypeVariable)GenericTypeReflector.transform(type2.getAnnotatedTypeVariable(), this), null, type2.getAnnotations());
        this.captureCache.put(key, annotatedCapture);
        AnnotatedType[] upperBounds = (AnnotatedType[])Arrays.stream(type2.getAnnotatedUpperBounds()).map(bound -> GenericTypeReflector.transform(bound, this)).toArray(AnnotatedType[]::new);
        annotatedCapture.setAnnotatedUpperBounds(upperBounds);
        return annotatedCapture;
    }

    protected AnnotatedType visitClass(AnnotatedType type2) {
        return type2;
    }

    protected AnnotatedType visitUnmatched(AnnotatedType type2) {
        return type2;
    }

    private static class AnnotatedCaptureCacheKey {
        AnnotatedCaptureType capture;
        CaptureType raw;

        AnnotatedCaptureCacheKey(AnnotatedCaptureType capture) {
            this.capture = capture;
            this.raw = (CaptureType)capture.getType();
        }

        public int hashCode() {
            return 127 * this.raw.getWildcardType().hashCode() ^ this.raw.getTypeVariable().hashCode() ^ GenericTypeReflector.hashCode(Arrays.stream(this.capture.getAnnotations()));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AnnotatedCaptureCacheKey)) {
                return false;
            }
            AnnotatedCaptureCacheKey that = (AnnotatedCaptureCacheKey)obj;
            return this.capture == that.capture || new GenericTypeReflector.CaptureCacheKey(this.raw).equals(new GenericTypeReflector.CaptureCacheKey(that.raw)) && Arrays.equals(this.capture.getAnnotations(), that.capture.getAnnotations());
        }
    }
}

