/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.core_rendering;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import java.nio.ByteBuffer;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;

public class AxiomDrawBuffer
implements AutoCloseable {
    AxiomBufferUsage bufferUsage;
    GpuBuffer vertexBuffer;
    @Nullable
    GpuBuffer indexBuffer;
    @Nullable
    VertexFormat.class_5595 indexType;
    int indexCount;
    VertexFormat vertexFormat;
    VertexFormat.class_5596 vertexFormatMode;

    public AxiomDrawBuffer(AxiomBufferUsage bufferUsage) {
        this.bufferUsage = bufferUsage;
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
    }

    public void upload(class_9801 meshData) {
        try (class_9801 class_98012 = meshData;){
            class_9801.class_4574 drawState = meshData.method_60822();
            this.uploadVertexBuffer(meshData.method_60818());
            this.uploadIndexBuffer(meshData.method_60821());
            this.vertexFormat = drawState.comp_749();
            this.vertexFormatMode = drawState.comp_752();
            this.indexCount = drawState.comp_751();
            this.indexType = drawState.comp_753();
        }
    }

    public void setIndexBuffer(class_9799.class_9800 result) {
        try (class_9799.class_9800 class_98002 = result;){
            this.uploadIndexBuffer(result.method_60817());
        }
    }

    private void uploadVertexBuffer(ByteBuffer byteBuffer) {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = RenderSystem.getDevice().createBuffer(null, this.bufferUsage.usageFlags() | 0x20, byteBuffer);
    }

    private void uploadIndexBuffer(@Nullable ByteBuffer byteBuffer) {
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
        if (byteBuffer != null) {
            this.indexBuffer = RenderSystem.getDevice().createBuffer(null, this.bufferUsage.usageFlags() | 0x40, byteBuffer);
        }
    }

    public void draw() {
        throw new IllegalStateException("AxiomDrawBuffer#draw isn't supported on 1.21.5+");
    }
}

