/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.schematic;

import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.block_maps.LegacyBlocks;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2843;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SchematicLoader {
    public static Path getDefaultSchematicDir() {
        Path worldeditSchematicsDir = FabricLoader.getInstance().getConfigDir().resolve("worldedit").resolve("schematics");
        if (Files.exists(worldeditSchematicsDir, new LinkOption[0])) {
            return worldeditSchematicsDir;
        }
        return FabricLoader.getInstance().getGameDir();
    }

    public static ClipboardObject loadSponge(class_2487 compoundTag) throws SchematicLoadException {
        int currentDataVersion = DFUHelper.DATA_VERSION;
        SpongeSchematic schem = SpongeSchematic.parse(compoundTag);
        class_2487 palette = schem.palette;
        Int2ObjectOpenHashMap paletteMap = new Int2ObjectOpenHashMap();
        for (String key : palette.method_10541()) {
            try {
                class_2680 blockState;
                if (currentDataVersion <= schem.dataVersion) {
                    class_2259.class_7211 result = class_2259.method_41957(VersionUtils.createLookup(class_7923.field_41175), (String)key, (boolean)false);
                    blockState = result.comp_622();
                } else {
                    class_2487 blockTag = DFUHelper.createBlockTag(key);
                    blockState = DFUHelper.updateBlockState(blockTag, schem.dataVersion).result().orElse(class_2246.field_10124.method_9564());
                }
                paletteMap.put(palette.method_68083(key, -1), (Object)blockState);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SchematicLoadException("Unable to parse BlockState: " + key);
            }
        }
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])schem.blockData));
        for (int y = 0; y < schem.height; ++y) {
            for (int z = 0; z < schem.length; ++z) {
                for (int x = 0; x < schem.width; ++x) {
                    int blockId = buf.method_10816();
                    class_2680 blockState = (class_2680)paletteMap.get(blockId);
                    if (blockState == null) {
                        blockState = class_2246.field_10124.method_9564();
                    }
                    blockRegion.addBlockWithoutDirty(x - schem.width / 2, y - schem.height / 2, z - schem.length / 2, blockState);
                }
            }
        }
        blockRegion.dirtyAll();
        Long2ObjectOpenHashMap blockEntityMap = new Long2ObjectOpenHashMap();
        if (schem.blockEntities != null && !schem.blockEntities.isEmpty()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (class_2520 blockEntityTag : schem.blockEntities) {
                String key;
                Optional idOptional;
                class_2487 blockEntity = (class_2487)blockEntityTag;
                Optional posOptional = blockEntity.method_10561("Pos");
                if (posOptional.isEmpty() || (idOptional = blockEntity.method_10558("Id")).isEmpty()) continue;
                int[] pos = (int[])posOptional.get();
                String id = (String)idOptional.get();
                int x = pos[0] - schem.width / 2;
                int y = pos[1] - schem.height / 2;
                int z = pos[2] - schem.length / 2;
                class_2591 type2 = class_7923.field_41181.method_17966(class_2960.method_60654((String)id)).orElse(null);
                if (type2 == null || !type2.method_20526(blockRegion.getBlockStateOrAir(x, y, z))) continue;
                blockEntity.method_10551("Pos");
                blockEntity.method_10551("Id");
                if (blockEntity.method_10541().size() == 1 && (key = (String)blockEntity.method_10541().iterator().next()).equals("Data")) {
                    blockEntity = blockEntity.method_68568("Data");
                }
                CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(blockEntity, baos);
                blockEntityMap.put(class_2338.method_10064((int)x, (int)y, (int)z), (Object)compressedBlockEntity);
            }
        }
        return new ClipboardObject.Anonymous(blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntityMap, List.of(), schem.name, 45.0f, true, compoundTag);
    }

    public static ClipboardObject loadLitematic(class_2487 compoundTag) throws SchematicLoadException {
        int litematicDataVersion = compoundTag.method_68083("MinecraftDataVersion", 0);
        String name = "";
        Optional metadataOptional = compoundTag.method_10562("Metadata");
        if (metadataOptional.isPresent()) {
            class_2487 metadata = (class_2487)metadataOptional.get();
            name = metadata.method_10558("Name").orElse("");
        }
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        Long2ObjectOpenHashMap blockEntityMap = new Long2ObjectOpenHashMap();
        class_2487 regions = compoundTag.method_68568("Regions");
        for (String regionName : regions.method_10541()) {
            class_2487 region = regions.method_68568(regionName);
            SchematicLoader.loadLitematicRegion(region, blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntityMap, litematicDataVersion);
        }
        blockRegion.dirtyAll();
        return new ClipboardObject.Anonymous(blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntityMap, List.of(), name, 45.0f, true, null);
    }

    private static void loadLitematicRegion(class_2487 region, ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntityMap, int schemDataVersion) {
        int currentDataVersion = DFUHelper.DATA_VERSION;
        Int2ObjectOpenHashMap paletteMap = new Int2ObjectOpenHashMap();
        class_2499 palette = NbtHelper.getList(region, "BlockStatePalette", 10);
        for (int i = 0; i < palette.size(); ++i) {
            class_2487 entryTag = palette.method_68582(i);
            class_2680 blockState = currentDataVersion <= schemDataVersion ? class_2680.field_24734.parse((DynamicOps)class_2509.field_11560, (Object)entryTag).result().orElse(class_2246.field_10124.method_9564()) : DFUHelper.updateBlockState(entryTag, schemDataVersion).result().orElse(class_2246.field_10124.method_9564());
            paletteMap.put(i, (Object)blockState);
        }
        class_2487 size = region.method_68568("Size");
        int width = size.method_68083("x", 0);
        int height = size.method_68083("y", 0);
        int length = size.method_68083("z", 0);
        class_2487 position = region.method_68568("Position");
        int offsetX = position.method_68083("x", 0);
        int offsetY = position.method_68083("y", 0);
        int offsetZ = position.method_68083("z", 0);
        if (width < 0) {
            offsetX += width + 1;
            width = -width;
        }
        if (height < 0) {
            offsetY += height + 1;
            height = -height;
        }
        if (length < 0) {
            offsetZ += length + 1;
            length = -length;
        }
        int bitsPerEntry = Math.max(2, 32 - Integer.numberOfLeadingZeros(palette.size() - 1));
        int entryMask = (1 << bitsPerEntry) - 1;
        long[] blockStateData = region.method_10565("BlockStates").orElse(new long[0]);
        int currentLongIndex = 0;
        int currentLongBitPosition = 0;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width; ++x) {
                    long value = blockStateData[currentLongIndex] >>> currentLongBitPosition & (long)entryMask;
                    int overflowBits = currentLongBitPosition + bitsPerEntry - 64;
                    if (overflowBits > 0) {
                        value |= (blockStateData[currentLongIndex + 1] & (1L << overflowBits) - 1L) << bitsPerEntry - overflowBits;
                    }
                    if ((currentLongBitPosition += bitsPerEntry) >= 64) {
                        ++currentLongIndex;
                        currentLongBitPosition -= 64;
                    }
                    class_2680 blockState = (class_2680)paletteMap.get((int)value);
                    blockRegion.addBlockWithoutDirty(x + offsetX, y + offsetY, z + offsetZ, blockState);
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        block4: for (class_2520 blockEntityTag : NbtHelper.getList(region, "TileEntities", 10)) {
            class_2487 blockEntity = (class_2487)blockEntityTag;
            int x = blockEntity.method_68083("x", 0);
            int y = blockEntity.method_68083("y", 0);
            int z = blockEntity.method_68083("z", 0);
            blockEntity.method_10551("x");
            blockEntity.method_10551("y");
            blockEntity.method_10551("z");
            if (blockEntity.method_33133()) continue;
            class_2680 blockState = blockRegion.getBlockStateOrAir(x + offsetX, y + offsetY, z + offsetZ);
            for (class_2591 blockEntityType : class_7923.field_41181) {
                if (!blockEntityType.method_20526(blockState)) continue;
                CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(blockEntity, baos);
                blockEntityMap.put(class_2338.method_10064((int)(x + offsetX), (int)(y + offsetY), (int)(z + offsetZ)), (Object)compressedBlockEntity);
                continue block4;
            }
        }
    }

    public static ClipboardObject loadLegacy(class_2487 compoundTag) throws SchematicLoadException {
        Optional blocksOptional = compoundTag.method_10547("Blocks");
        if (blocksOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Blocks' byte array tag");
        }
        Optional dataOptional = compoundTag.method_10547("Data");
        if (dataOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Data' byte array tag");
        }
        Optional widthOptional = compoundTag.method_10568("Width");
        if (widthOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Width' short tag");
        }
        Optional heightOptional = compoundTag.method_10568("Height");
        if (heightOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Height' short tag");
        }
        Optional lengthOptional = compoundTag.method_10568("Length");
        if (lengthOptional.isEmpty()) {
            throw new SchematicLoadException("Missing 'Length' short tag");
        }
        short width = (Short)widthOptional.get();
        short height = (Short)heightOptional.get();
        short length = (Short)lengthOptional.get();
        int maxIndex = width * height * length;
        int minX = -Math.floorDiv(width, 2);
        int minY = -Math.floorDiv(height, 2);
        int minZ = -Math.floorDiv(length, 2);
        byte[] legacyBlockIds = (byte[])blocksOptional.get();
        byte[] legacyBlockData = (byte[])dataOptional.get();
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        class_2680[] legacyBlocks = LegacyBlocks.getLegacyBlocks();
        for (int index = 0; index < maxIndex; ++index) {
            int blockId = legacyBlockIds[index] & 0xFF;
            int blockData = legacyBlockData[index] & 0xFF;
            class_2680 blockState = legacyBlocks[blockId * 16 + blockData];
            if (blockState == null && (blockState = legacyBlocks[blockId * 16]) == null) continue;
            int x2 = index % width + minX;
            int z2 = index % (width * length) / width + minZ;
            int y2 = index / (width * length) + minY;
            chunkedBlockRegion.addBlockWithoutDirty(x2, y2, z2, blockState);
        }
        class_2350[] directions = class_2350.values();
        class_2338.class_2339 mutableBlockPos1 = new class_2338.class_2339();
        class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();
        ChunkedBlockRegion updatedRegion = new ChunkedBlockRegion();
        chunkedBlockRegion.forEachEntry((x, y, z, block) -> {
            if (block.method_26204() instanceof class_2320) {
                class_2680 below;
                class_2756 half = (class_2756)block.method_11654((class_2769)class_2741.field_12533);
                if (half == class_2756.field_12609 && (below = chunkedBlockRegion.getBlockStateOrAir(x, y - 1, z)).method_26204() instanceof class_2320) {
                    block = (class_2680)below.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                }
            } else if (block.method_26204() instanceof class_2323) {
                class_2756 half = (class_2756)block.method_11654((class_2769)class_2741.field_12533);
                if (half == class_2756.field_12609) {
                    class_2680 below = chunkedBlockRegion.getBlockStateOrAir(x, y - 1, z);
                    if (below.method_26204() instanceof class_2323) {
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)below.method_11654((class_2769)class_2741.field_12481)));
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12537, (Comparable)((Boolean)below.method_11654((class_2769)class_2741.field_12537)));
                    }
                } else {
                    class_2680 above = chunkedBlockRegion.getBlockStateOrAir(x, y + 1, z);
                    if (above.method_26204() instanceof class_2323) {
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12520, (Comparable)((class_2750)above.method_11654((class_2769)class_2741.field_12520)));
                        block = (class_2680)block.method_11657((class_2769)class_2741.field_12484, (Comparable)((Boolean)above.method_11654((class_2769)class_2741.field_12484)));
                    }
                }
            }
            updatedRegion.addBlock(x, y, z, (class_2680)block);
        });
        updatedRegion.forEachEntry((x, y, z, block) -> {
            try {
                for (class_2350 direction : directions) {
                    mutableBlockPos1.method_10103(x, y, z);
                    mutableBlockPos2.method_25505((class_2382)mutableBlockPos1, direction);
                    block = class_2843.method_12351((class_2680)block, (class_2350)direction, (class_1936)updatedRegion, (class_2338)mutableBlockPos1, (class_2338)mutableBlockPos2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            chunkedBlockRegion.addBlockWithoutDirty(x, y, z, (class_2680)block);
        });
        chunkedBlockRegion.dirtyAll();
        return new ClipboardObject.Anonymous(chunkedBlockRegion, (Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), List.of(), "", 45.0f, true, compoundTag);
    }

    record SpongeSchematic(int dataVersion, int width, int height, int length, String name, class_2487 palette, byte[] blockData, class_2499 blockEntities, class_2487 remainingTag) {
        public static SpongeSchematic parse(class_2487 compoundTag) {
            Optional versionOptional = compoundTag.method_10550("Version");
            if (versionOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Version' int tag");
            }
            int version = (Integer)versionOptional.get();
            if (version == 2) {
                return SpongeSchematic.parseV2(compoundTag);
            }
            if (version == 3) {
                return SpongeSchematic.parseV3(compoundTag);
            }
            throw new SchematicLoadException("Unsupported version, expected 2 or 3, but got " + version);
        }

        public static SpongeSchematic parseV2(class_2487 compoundTag) {
            Optional dataVersionOptional = compoundTag.method_10550("DataVersion");
            if (dataVersionOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'DataVersion' int tag");
            }
            Optional widthOptional = compoundTag.method_10568("Width");
            if (widthOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Width' short tag");
            }
            Optional heightOptional = compoundTag.method_10568("Height");
            if (heightOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Height' short tag");
            }
            Optional lengthOptional = compoundTag.method_10568("Length");
            if (lengthOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Length' short tag");
            }
            Optional paletteOptional = compoundTag.method_10562("Palette");
            if (paletteOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Palette' compound tag");
            }
            Optional blockDataOptional = compoundTag.method_10547("BlockData");
            if (blockDataOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'BlockData' byte array tag");
            }
            int schematicDataVersion = (Integer)dataVersionOptional.get();
            class_2487 palette = (class_2487)paletteOptional.get();
            byte[] blockData = (byte[])blockDataOptional.get();
            String name = "";
            Optional metadataOptional = compoundTag.method_10562("Metadata");
            if (metadataOptional.isPresent()) {
                class_2487 metadata = (class_2487)metadataOptional.get();
                name = metadata.method_10558("Name").orElse("");
            }
            int width = (Short)widthOptional.get() & 0xFFFF;
            int height = (Short)heightOptional.get() & 0xFFFF;
            int length = (Short)lengthOptional.get() & 0xFFFF;
            class_2499 blockEntities = NbtHelper.getList(compoundTag, "BlockEntities", 10);
            class_2487 remaining = compoundTag.method_10553();
            compoundTag.method_10551("Version");
            compoundTag.method_10551("DataVersion");
            compoundTag.method_10551("Palette");
            compoundTag.method_10551("PaletteMax");
            compoundTag.method_10551("BlockData");
            compoundTag.method_10551("Width");
            compoundTag.method_10551("Height");
            compoundTag.method_10551("Length");
            compoundTag.method_10551("BlockEntities");
            return new SpongeSchematic(schematicDataVersion, width, height, length, name, palette, blockData, blockEntities, remaining);
        }

        public static SpongeSchematic parseV3(class_2487 compoundTag) {
            Optional dataVersionOptional = compoundTag.method_10550("DataVersion");
            if (dataVersionOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'DataVersion' int tag");
            }
            Optional widthOptional = compoundTag.method_10568("Width");
            if (widthOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Width' short tag");
            }
            Optional heightOptional = compoundTag.method_10568("Height");
            if (heightOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Height' short tag");
            }
            Optional lengthOptional = compoundTag.method_10568("Length");
            if (lengthOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Length' short tag");
            }
            Optional blocksOptional = compoundTag.method_10562("Blocks");
            if (blocksOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Blocks' compound tag");
            }
            class_2487 blocks = (class_2487)blocksOptional.get();
            Optional paletteOptional = blocks.method_10562("Palette");
            if (paletteOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Palette' compound tag inside 'Blocks'");
            }
            Optional dataOptional = blocks.method_10547("Data");
            if (dataOptional.isEmpty()) {
                throw new SchematicLoadException("Missing 'Data' byte array tag inside 'Blocks'");
            }
            int schematicDataVersion = (Integer)dataVersionOptional.get();
            class_2487 palette = (class_2487)paletteOptional.get();
            byte[] blockData = (byte[])dataOptional.get();
            String name = "";
            Optional metadataOptional = compoundTag.method_10562("Metadata");
            if (metadataOptional.isPresent()) {
                class_2487 metadata = (class_2487)metadataOptional.get();
                name = metadata.method_10558("Name").orElse("");
            }
            int width = (Short)widthOptional.get() & 0xFFFF;
            int height = (Short)heightOptional.get() & 0xFFFF;
            int length = (Short)lengthOptional.get() & 0xFFFF;
            class_2499 blockEntities = NbtHelper.getList(compoundTag, "BlockEntities", 10);
            class_2487 remaining = compoundTag.method_10553();
            compoundTag.method_10551("Version");
            compoundTag.method_10551("DataVersion");
            compoundTag.method_10551("BlockData");
            compoundTag.method_10551("Width");
            compoundTag.method_10551("Height");
            compoundTag.method_10551("Length");
            compoundTag.method_10551("Blocks");
            return new SpongeSchematic(schematicDataVersion, width, height, length, name, palette, blockData, blockEntities, remaining);
        }
    }

    public static class SchematicLoadException
    extends RuntimeException {
        public SchematicLoadException(String message) {
            super(message);
        }
    }
}

