/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.clipboard;

import com.moulberry.axiom.editor.windows.clipboard.BlueprintBrowserWindow;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintOrDirectory;
import com.moulberry.axiom.editor.windows.clipboard.NaturalOrderComparator;
import com.moulberry.axiom.editor.windows.clipboard.PathWrapper;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public final class BlueprintDirectory {
    private PathWrapper path;
    private final String dirName;
    private BlueprintDirectory parent;
    private final List<BlueprintDirectory> children;
    private Map<PathWrapper, BlueprintOrDirectory> blueprints;
    private boolean orderingChanged = false;
    private String lastSearch = "";
    private Set<String> lastFilterTags = new HashSet<String>();
    private Map<PathWrapper, BlueprintOrDirectory> searchedBlueprints;
    private BlueprintOrDirectory head = null;
    private BlueprintOrDirectory tail = null;
    private BlueprintOrDirectory searchHead = null;
    private BlueprintOrDirectory searchVisibleStart = null;
    private int searchVisibleStartIndex = 0;
    private BlueprintOrDirectory searchTail = null;
    private final Map<String, Integer> tagCounts = new TreeMap<String, Integer>();

    public BlueprintDirectory(PathWrapper path, String dirName) {
        this.path = path;
        this.dirName = dirName;
        this.children = new ArrayList<BlueprintDirectory>();
        this.blueprints = new HashMap<PathWrapper, BlueprintOrDirectory>();
        this.searchedBlueprints = this.blueprints;
    }

    public PathWrapper path() {
        return this.path;
    }

    public String dirName() {
        return this.dirName;
    }

    public BlueprintDirectory parent() {
        return this.parent;
    }

    public Map<String, Integer> tagsWithCount() {
        return this.tagCounts;
    }

    public Set<String> tags() {
        return this.tagCounts.keySet();
    }

    @Nullable
    public BlueprintOrDirectory head() {
        return this.head;
    }

    public List<BlueprintDirectory> children() {
        return this.children;
    }

    public Map<PathWrapper, BlueprintOrDirectory> blueprints() {
        return this.blueprints;
    }

    public Map<PathWrapper, BlueprintOrDirectory> searchedBlueprints() {
        return this.searchedBlueprints;
    }

    public BlueprintOrDirectory setSearchVisibleStart(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index >= this.searchedBlueprints.size()) {
            return null;
        }
        if (this.searchVisibleStart == null || index != this.searchVisibleStartIndex) {
            int distanceToSearchVisibleStart = Math.abs(index - this.searchVisibleStartIndex);
            int distanceToHead = Math.abs(index);
            int distanceToTail = Math.abs(index - (this.searchedBlueprints.size() - 1));
            if (this.searchVisibleStart != null && distanceToSearchVisibleStart < distanceToHead && distanceToSearchVisibleStart < distanceToTail) {
                if (index < this.searchVisibleStartIndex) {
                    BlueprintOrDirectory prev;
                    for (int i = 0; i < distanceToSearchVisibleStart && (prev = this.searchVisibleStart.prevSearchNode) != null; ++i) {
                        this.searchVisibleStart = prev;
                    }
                } else {
                    BlueprintOrDirectory next2;
                    for (int i = 0; i < distanceToSearchVisibleStart && (next2 = this.searchVisibleStart.nextSearchNode) != null; ++i) {
                        this.searchVisibleStart = next2;
                    }
                }
            } else if (distanceToHead < distanceToTail) {
                this.searchVisibleStart = this.searchHead;
                for (int i = 0; i < distanceToHead; ++i) {
                    this.searchVisibleStart = this.searchVisibleStart.nextSearchNode;
                }
            } else {
                this.searchVisibleStart = this.searchTail;
                for (int i = 0; i < distanceToTail; ++i) {
                    this.searchVisibleStart = this.searchVisibleStart.prevSearchNode;
                }
            }
            this.searchVisibleStartIndex = index;
        }
        return this.searchVisibleStart;
    }

    public void setPath(PathWrapper newPath) {
        if (this.path.real() == null || newPath.real() == null) {
            throw new UnsupportedOperationException("Unsupported on server blueprints");
        }
        Path oldPath = this.path.real();
        this.path = newPath;
        HashMap<PathWrapper, BlueprintOrDirectory> blueprints = new HashMap<PathWrapper, BlueprintOrDirectory>();
        for (Map.Entry<PathWrapper, BlueprintOrDirectory> entry : this.blueprints.entrySet()) {
            BlueprintOrDirectory blueprintOrDirectory = entry.getValue();
            Path relative = oldPath.relativize(entry.getKey().real());
            Path newAbsolute = newPath.real().resolve(relative);
            blueprintOrDirectory.path(newAbsolute);
            blueprints.put(new PathWrapper(newAbsolute, null), blueprintOrDirectory);
            blueprintOrDirectory.prevSearchNode = blueprintOrDirectory.prevNode;
            blueprintOrDirectory.nextSearchNode = blueprintOrDirectory.nextNode;
        }
        this.lastSearch = "";
        this.searchHead = this.head;
        this.searchTail = this.tail;
        this.blueprints = blueprints;
        this.searchedBlueprints = this.blueprints;
    }

    public void sort(SortMode sortMode) {
        if (this.head == null) {
            return;
        }
        ArrayList<BlueprintOrDirectory> allBlueprintsList = new ArrayList<BlueprintOrDirectory>();
        BlueprintOrDirectory blueprintOrDirectory = this.head;
        while (blueprintOrDirectory != null) {
            allBlueprintsList.add(blueprintOrDirectory);
            blueprintOrDirectory = blueprintOrDirectory.nextNode;
        }
        allBlueprintsList.sort(sortMode.comparator);
        this.head = this.searchHead = (BlueprintOrDirectory)allBlueprintsList.get(0);
        this.tail = this.searchTail = (BlueprintOrDirectory)allBlueprintsList.get(allBlueprintsList.size() - 1);
        BlueprintOrDirectory last = null;
        for (BlueprintOrDirectory current : allBlueprintsList) {
            current.prevNode = current.prevSearchNode = last;
            if (last != null) {
                last.nextNode = last.nextSearchNode = current;
            }
            last = current;
        }
        last.nextNode = null;
        last.nextSearchNode = null;
        this.searchVisibleStart = null;
        this.searchVisibleStartIndex = -1;
        String lastSearch = this.lastSearch;
        this.lastSearch = "";
        this.search(lastSearch, this.lastFilterTags);
        this.orderingChanged = true;
        BlueprintBrowserWindow.anyOrderUpdated = true;
    }

    public void addRecursiveSearch(String search, List<BlueprintOrDirectory.Bp> results, Set<String> filterTags) {
        ArrayList<BlueprintOrDirectory.Dir> children = new ArrayList<BlueprintOrDirectory.Dir>();
        BlueprintOrDirectory blueprintOrDirectory = this.head;
        while (blueprintOrDirectory != null) {
            if (blueprintOrDirectory.containsAllTags(filterTags)) {
                BlueprintOrDirectory.Bp bp;
                if (blueprintOrDirectory instanceof BlueprintOrDirectory.Dir) {
                    BlueprintOrDirectory.Dir dir = (BlueprintOrDirectory.Dir)blueprintOrDirectory;
                    children.add(dir);
                } else if (blueprintOrDirectory instanceof BlueprintOrDirectory.Bp && (bp = (BlueprintOrDirectory.Bp)blueprintOrDirectory).nameContainsLower(search)) {
                    results.add(bp);
                }
            }
            blueprintOrDirectory = blueprintOrDirectory.nextNode;
        }
        for (BlueprintOrDirectory.Dir dir : children) {
            dir.blueprintDirectory.addRecursiveSearch(search, results, filterTags);
        }
    }

    public void search(String search, Set<String> filterTags) {
        if ((search = search.toLowerCase(Locale.ROOT)).equals(this.lastSearch) && filterTags.equals(this.lastFilterTags)) {
            return;
        }
        if (search.isBlank() && filterTags.isEmpty()) {
            boolean findingSearchVisible = this.searchVisibleStart != null;
            int searchVisibleRemaining = this.searchVisibleStartIndex;
            BlueprintOrDirectory blueprintOrDirectory = this.head;
            while (blueprintOrDirectory != null) {
                blueprintOrDirectory.prevSearchNode = blueprintOrDirectory.prevNode;
                blueprintOrDirectory.nextSearchNode = blueprintOrDirectory.nextNode;
                if (findingSearchVisible) {
                    if (searchVisibleRemaining == 0) {
                        this.searchVisibleStart = blueprintOrDirectory;
                        findingSearchVisible = false;
                    } else {
                        --searchVisibleRemaining;
                    }
                }
                blueprintOrDirectory = blueprintOrDirectory.nextNode;
            }
            this.searchHead = this.head;
            this.searchTail = this.tail;
            this.searchedBlueprints = this.blueprints;
        } else if (this.searchedBlueprints == this.blueprints || !search.startsWith(this.lastSearch) || !filterTags.containsAll(this.lastFilterTags)) {
            HashMap<PathWrapper, BlueprintOrDirectory> searchedBlueprints = new HashMap<PathWrapper, BlueprintOrDirectory>();
            boolean findingSearchVisible = this.searchVisibleStart != null;
            int searchVisibleRemaining = this.searchVisibleStartIndex;
            BlueprintOrDirectory blueprintOrDirectory = this.head;
            BlueprintOrDirectory lastMatching = null;
            while (blueprintOrDirectory != null) {
                blueprintOrDirectory.prevSearchNode = null;
                blueprintOrDirectory.nextSearchNode = null;
                if (blueprintOrDirectory.nameContainsLower(search) && blueprintOrDirectory.containsAllTags(filterTags)) {
                    if (lastMatching == null) {
                        this.searchHead = blueprintOrDirectory;
                    } else {
                        lastMatching.nextSearchNode = blueprintOrDirectory;
                        blueprintOrDirectory.prevSearchNode = lastMatching;
                    }
                    if (findingSearchVisible) {
                        if (searchVisibleRemaining == 0) {
                            this.searchVisibleStart = blueprintOrDirectory;
                            findingSearchVisible = false;
                        } else {
                            --searchVisibleRemaining;
                        }
                    }
                    searchedBlueprints.put(blueprintOrDirectory.path(), blueprintOrDirectory);
                    lastMatching = blueprintOrDirectory;
                }
                blueprintOrDirectory = blueprintOrDirectory.nextNode;
            }
            this.searchedBlueprints = searchedBlueprints;
            this.searchTail = lastMatching;
        } else {
            String searchF = search;
            this.searchedBlueprints.values().removeIf(entry -> {
                if (entry.nameContainsLower(searchF) && entry.containsAllTags(filterTags)) {
                    return false;
                }
                if (entry.prevSearchNode != null) {
                    entry.prevSearchNode.nextSearchNode = entry.nextSearchNode;
                }
                if (entry.nextSearchNode != null) {
                    entry.nextSearchNode.prevSearchNode = entry.prevSearchNode;
                }
                if (entry == this.searchHead) {
                    this.searchHead = entry.nextSearchNode;
                }
                if (entry == this.searchTail) {
                    this.searchTail = entry.prevSearchNode;
                }
                if (entry == this.searchVisibleStart) {
                    this.searchVisibleStart = entry.nextSearchNode;
                }
                entry.nextSearchNode = null;
                entry.prevSearchNode = null;
                return true;
            });
        }
        this.lastSearch = search;
        this.lastFilterTags = new HashSet<String>(filterTags);
    }

    public void saveOrdering() {
        if (!this.orderingChanged) {
            return;
        }
        if (this.path.real() == null) {
            return;
        }
        Path dotfile = this.path.real().resolve(".axiom_blueprint_ordering");
        if (this.blueprints.size() <= 1) {
            try {
                Files.deleteIfExists(dotfile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(dotfile, new OpenOption[0]);){
            BlueprintOrDirectory blueprintOrDirectory = this.head;
            while (blueprintOrDirectory != null) {
                Path path = blueprintOrDirectory.path().real();
                Path relative = this.path.real().relativize(path);
                if (blueprintOrDirectory != this.head) {
                    writer.write(10);
                }
                writer.write(relative.toString().replace(path.getFileSystem().getSeparator(), "/"));
                blueprintOrDirectory = blueprintOrDirectory.nextNode;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.orderingChanged = false;
    }

    public void reposition(BlueprintOrDirectory blueprintOrDirectory, BlueprintOrDirectory reference, boolean before) {
        if (blueprintOrDirectory == reference) {
            return;
        }
        if (this.head == blueprintOrDirectory) {
            this.head = blueprintOrDirectory.nextNode;
        }
        if (this.tail == blueprintOrDirectory) {
            this.tail = blueprintOrDirectory.prevNode;
        }
        if (this.searchHead == blueprintOrDirectory) {
            this.searchHead = blueprintOrDirectory.nextSearchNode;
        }
        if (this.searchTail == blueprintOrDirectory) {
            this.searchTail = blueprintOrDirectory.prevSearchNode;
        }
        if (this.searchVisibleStart == blueprintOrDirectory) {
            this.searchVisibleStart = blueprintOrDirectory.nextSearchNode;
        }
        blueprintOrDirectory.unlink();
        if (before) {
            if (blueprintOrDirectory == reference.prevNode) {
                return;
            }
            if (blueprintOrDirectory.nextNode == reference) {
                return;
            }
            if (this.searchVisibleStart == reference) {
                this.searchVisibleStart = blueprintOrDirectory;
            }
            if (this.head == reference) {
                this.head = blueprintOrDirectory;
            }
            if (reference.prevNode != null) {
                reference.prevNode.nextNode = blueprintOrDirectory;
            }
            blueprintOrDirectory.prevNode = reference.prevNode;
            reference.prevNode = blueprintOrDirectory;
            blueprintOrDirectory.nextNode = reference;
            if (this.searchHead == reference) {
                this.searchHead = blueprintOrDirectory;
            }
            if (reference.prevSearchNode != null) {
                reference.prevSearchNode.nextSearchNode = blueprintOrDirectory;
            }
            blueprintOrDirectory.prevSearchNode = reference.prevSearchNode;
            reference.prevSearchNode = blueprintOrDirectory;
            blueprintOrDirectory.nextSearchNode = reference;
        } else {
            if (blueprintOrDirectory == reference.nextNode) {
                return;
            }
            if (blueprintOrDirectory.prevNode == reference) {
                return;
            }
            if (this.tail == reference) {
                this.tail = blueprintOrDirectory;
            }
            if (reference.nextNode != null) {
                reference.nextNode.prevNode = blueprintOrDirectory;
            }
            blueprintOrDirectory.nextNode = reference.nextNode;
            reference.nextNode = blueprintOrDirectory;
            blueprintOrDirectory.prevNode = reference;
            if (this.searchTail == reference) {
                this.searchTail = blueprintOrDirectory;
            }
            if (reference.nextSearchNode != null) {
                reference.nextSearchNode.prevSearchNode = blueprintOrDirectory;
            }
            blueprintOrDirectory.nextSearchNode = reference.nextSearchNode;
            reference.nextSearchNode = blueprintOrDirectory;
            blueprintOrDirectory.prevSearchNode = reference;
        }
        this.orderingChanged = true;
        BlueprintBrowserWindow.anyOrderUpdated = true;
    }

    public void changeChildPath(Path from, Path to) {
        BlueprintOrDirectory searchedItem;
        if (this.path.real() == null) {
            throw new UnsupportedOperationException("Unsupported on server blueprints");
        }
        if (!from.getParent().equals(this.path.real())) {
            throw new FaultyImplementationError();
        }
        if (!to.getParent().equals(this.path.real())) {
            throw new FaultyImplementationError();
        }
        BlueprintOrDirectory item = this.blueprints.remove(new PathWrapper(from, null));
        if (item == null) {
            return;
        }
        item.path(to);
        this.blueprints.put(new PathWrapper(to, null), item);
        if (this.searchedBlueprints != this.blueprints && item.nameContainsLower(this.lastSearch) && (searchedItem = this.searchedBlueprints.remove(new PathWrapper(from, null))) != null) {
            this.searchedBlueprints.put(new PathWrapper(to, null), searchedItem);
        }
        this.orderingChanged = true;
        BlueprintBrowserWindow.anyOrderUpdated = true;
    }

    public void addTagCounts(Map<String, Integer> counts, boolean subtract) {
        if (subtract) {
            for (Map.Entry<String, Integer> tag : counts.entrySet()) {
                this.tagCounts.computeIfPresent(tag.getKey(), (tag1, count) -> {
                    if ((count = Integer.valueOf(count - (Integer)tag.getValue())) <= 0) {
                        return null;
                    }
                    return count;
                });
            }
        } else {
            for (Map.Entry<String, Integer> tag : counts.entrySet()) {
                this.tagCounts.compute(tag.getKey(), (tag1, count) -> {
                    if (count == null) {
                        return (Integer)tag.getValue();
                    }
                    return count + (Integer)tag.getValue();
                });
            }
        }
        if (this.parent != null) {
            this.parent.addTagCounts(counts, subtract);
        }
    }

    public boolean remove(PathWrapper path) {
        if (this.path.real() == null || path.real() == null) {
            throw new UnsupportedOperationException("Unsupported on server blueprints");
        }
        BlueprintOrDirectory blueprintOrDirectory = this.blueprints.remove(path);
        if (blueprintOrDirectory == null) {
            return false;
        }
        if (this.searchedBlueprints != this.blueprints) {
            this.searchedBlueprints.remove(path);
        }
        if (this.head == blueprintOrDirectory) {
            this.head = blueprintOrDirectory.nextNode;
        }
        if (this.tail == blueprintOrDirectory) {
            this.tail = blueprintOrDirectory.prevNode;
        }
        if (this.searchHead == blueprintOrDirectory) {
            this.searchHead = blueprintOrDirectory.nextSearchNode;
        }
        if (this.searchTail == blueprintOrDirectory) {
            this.searchTail = blueprintOrDirectory.prevSearchNode;
        }
        if (this.searchVisibleStart == blueprintOrDirectory) {
            this.searchVisibleStart = blueprintOrDirectory.nextSearchNode;
        }
        blueprintOrDirectory.unlink();
        if (blueprintOrDirectory instanceof BlueprintOrDirectory.Dir) {
            BlueprintOrDirectory.Dir dir = (BlueprintOrDirectory.Dir)blueprintOrDirectory;
            this.children.remove(dir.blueprintDirectory);
            dir.blueprintDirectory.parent = null;
            if (dir.blueprintDirectory == BlueprintBrowserWindow.pendingSelectDirectory) {
                BlueprintBrowserWindow.pendingSelectDirectory = null;
            }
            this.addTagCounts(dir.blueprintDirectory.tagCounts, true);
        } else if (blueprintOrDirectory instanceof BlueprintOrDirectory.Bp) {
            BlueprintOrDirectory.Bp bp = (BlueprintOrDirectory.Bp)blueprintOrDirectory;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String tag : bp.blueprint.tags()) {
                map.put(tag, 1);
            }
            this.addTagCounts(map, true);
        }
        this.orderingChanged = true;
        BlueprintBrowserWindow.anyOrderUpdated = true;
        return true;
    }

    public void addLast(BlueprintOrDirectory blueprintOrDirectory) {
        HashMap<String, Integer> map;
        BlueprintOrDirectory.Bp bp;
        BlueprintOrDirectory.Dir dir;
        if (blueprintOrDirectory.prevNode != null || blueprintOrDirectory.nextNode != null || blueprintOrDirectory.prevSearchNode != null || blueprintOrDirectory.nextSearchNode != null) {
            throw new FaultyImplementationError("Can't add node which still has links!");
        }
        BlueprintOrDirectory previous = this.blueprints.put(blueprintOrDirectory.path(), blueprintOrDirectory);
        if (this.searchedBlueprints != this.blueprints && blueprintOrDirectory.nameContainsLower(this.lastSearch)) {
            this.searchedBlueprints.put(blueprintOrDirectory.path(), blueprintOrDirectory);
        }
        if (previous != null) {
            if (previous instanceof BlueprintOrDirectory.Dir) {
                dir = (BlueprintOrDirectory.Dir)previous;
                this.children.remove(dir.blueprintDirectory);
                this.addTagCounts(dir.blueprintDirectory.tagCounts, true);
            } else if (previous instanceof BlueprintOrDirectory.Bp) {
                bp = (BlueprintOrDirectory.Bp)previous;
                map = new HashMap<String, Integer>();
                for (String tag : bp.blueprint.tags()) {
                    map.put(tag, 1);
                }
                this.addTagCounts(map, true);
            }
            if (this.head == previous) {
                this.head = blueprintOrDirectory;
            }
            if (this.tail == previous) {
                this.tail = blueprintOrDirectory;
            }
            if (this.searchHead == previous) {
                this.searchHead = blueprintOrDirectory;
            }
            if (this.searchTail == previous) {
                this.searchTail = blueprintOrDirectory;
            }
            if (this.searchVisibleStart == previous) {
                this.searchVisibleStart = blueprintOrDirectory;
            }
            if (previous.prevNode != null) {
                previous.prevNode.nextNode = blueprintOrDirectory;
            }
            if (previous.nextNode != null) {
                previous.nextNode.prevNode = blueprintOrDirectory;
            }
            if (previous.prevSearchNode != null) {
                previous.prevSearchNode.nextSearchNode = blueprintOrDirectory;
            }
            if (previous.nextSearchNode != null) {
                previous.nextSearchNode.prevSearchNode = blueprintOrDirectory;
            }
            blueprintOrDirectory.prevNode = previous.prevNode;
            blueprintOrDirectory.nextNode = previous.nextNode;
            blueprintOrDirectory.prevSearchNode = previous.prevSearchNode;
            blueprintOrDirectory.nextSearchNode = previous.nextSearchNode;
            previous.prevNode = null;
            previous.nextNode = null;
            previous.prevSearchNode = null;
            previous.nextSearchNode = null;
        } else {
            if (this.head == null) {
                this.head = blueprintOrDirectory;
            }
            if (this.tail != null) {
                this.tail.nextNode = blueprintOrDirectory;
            }
            blueprintOrDirectory.prevNode = this.tail;
            this.tail = blueprintOrDirectory;
            if (this.searchHead == null) {
                this.searchHead = blueprintOrDirectory;
            }
            if (this.searchTail != null) {
                this.searchTail.nextSearchNode = blueprintOrDirectory;
            }
            blueprintOrDirectory.prevSearchNode = this.searchTail;
            this.searchTail = blueprintOrDirectory;
        }
        if (blueprintOrDirectory instanceof BlueprintOrDirectory.Dir) {
            dir = (BlueprintOrDirectory.Dir)blueprintOrDirectory;
            this.children.add(dir.blueprintDirectory);
            dir.blueprintDirectory.parent = this;
            this.addTagCounts(dir.blueprintDirectory.tagCounts, false);
        } else if (blueprintOrDirectory instanceof BlueprintOrDirectory.Bp) {
            bp = (BlueprintOrDirectory.Bp)blueprintOrDirectory;
            map = new HashMap();
            for (String tag : bp.blueprint.tags()) {
                map.put(tag, 1);
            }
            this.addTagCounts(map, false);
        }
        this.orderingChanged = true;
        BlueprintBrowserWindow.anyOrderUpdated = true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlueprintDirectory that = (BlueprintDirectory)obj;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public static enum SortMode {
        NAME(Comparator.comparing(k -> {
            if (k instanceof BlueprintOrDirectory.Bp) {
                BlueprintOrDirectory.Bp bp = (BlueprintOrDirectory.Bp)k;
                return bp.blueprint.name().toLowerCase(Locale.ROOT);
            }
            return k.path().getFileName().toLowerCase(Locale.ROOT);
        }, new NaturalOrderComparator())),
        BLOCK_COUNT_ASC(Comparator.comparingInt(k -> {
            if (k instanceof BlueprintOrDirectory.Bp) {
                BlueprintOrDirectory.Bp bp = (BlueprintOrDirectory.Bp)k;
                return bp.blueprint.blockCount();
            }
            return 0;
        })),
        BLOCK_COUNT_DESC(Comparator.comparingInt(k -> {
            if (k instanceof BlueprintOrDirectory.Bp) {
                BlueprintOrDirectory.Bp bp = (BlueprintOrDirectory.Bp)k;
                return Integer.MAX_VALUE - bp.blueprint.blockCount();
            }
            return 0;
        }));

        private final Comparator<BlueprintOrDirectory> comparator;

        private SortMode(Comparator<BlueprintOrDirectory> comparator) {
            this.comparator = comparator;
        }
    }
}

