/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather.async;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.GlobalCleaner;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.pather.ToolPatherPoint;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.tools.Tool;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class AsyncToolPathProvider {
    private class_243 lastLookDirection = null;
    private class_243 lastPosition = null;
    private final DoubleList lastPositionsForSmoothing = new DoubleArrayList();
    private final int smoothingAmount;
    private final ArrayBlockingQueue<long[]> inputPositions;
    private final AsyncToolPather pather;
    private final AtomicBoolean stopTask;
    private final AtomicBoolean stopTaskWhenInputEmpty;
    private final AtomicBoolean stoppedTask;
    private final GlobalCleaner.LeakChecker leakChecker;
    private boolean includeNonSolid = true;
    public boolean includeFluids = Tool.defaultIncludeFluids();
    public static final int SMOOTH_DIVISIONS = 10;
    private static final double SMOOTH_DISTANCE = 0.1;

    public AsyncToolPathProvider(@NotNull AsyncToolPather pather) {
        this.inputPositions = new ArrayBlockingQueue(128);
        this.stopTask = new AtomicBoolean(false);
        this.stopTaskWhenInputEmpty = new AtomicBoolean(false);
        this.stoppedTask = new AtomicBoolean(false);
        this.smoothingAmount = (int)(Axiom.configuration.editor.toolStabilization * 10.0f);
        Tool.sharedPoolThreadExecutor.submit(new AsyncTask(this.inputPositions, this.stopTask, this.stopTaskWhenInputEmpty, this.stoppedTask, pather));
        this.pather = pather;
        this.leakChecker = GlobalCleaner.createLeakChecker(this, "AsyncToolPathProvider");
    }

    public AsyncToolPathProvider includeNonSolid(boolean includeNonSolid) {
        this.includeNonSolid = includeNonSolid;
        return this;
    }

    public void close() {
        this.stopTask.set(true);
        this.leakChecker.disarm();
    }

    public void finish() {
        if (this.stopTask.get()) {
            return;
        }
        class_746 entity = class_310.method_1551().field_1724;
        if (entity == null || entity != class_310.method_1551().method_1560()) {
            return;
        }
        if (!EditorUI.isActive()) {
            return;
        }
        if (EditorUI.isMovingCamera()) {
            return;
        }
        class_243 start = entity.method_33571();
        this.update(false);
        if (this.smoothingAmount > 1) {
            LongArrayList positions = new LongArrayList();
            while (!this.lastPositionsForSmoothing.isEmpty()) {
                double sumX = 0.0;
                double sumY = 0.0;
                double sumZ = 0.0;
                int count = 0;
                for (int j = 0; j < this.lastPositionsForSmoothing.size(); j += 3) {
                    double targetZ;
                    double deltaZ;
                    double targetY;
                    double deltaY;
                    double targetX = this.lastPositionsForSmoothing.getDouble(j);
                    double deltaX = targetX - start.field_1352;
                    class_243 normalizedLook = new class_243(deltaX, deltaY = (targetY = this.lastPositionsForSmoothing.getDouble(j + 1)) - start.field_1351, deltaZ = (targetZ = this.lastPositionsForSmoothing.getDouble(j + 2)) - start.field_1350).method_1029();
                    if (normalizedLook.equals((Object)class_243.field_1353)) continue;
                    sumX += normalizedLook.field_1352;
                    sumY += normalizedLook.field_1351;
                    sumZ += normalizedLook.field_1350;
                    ++count;
                }
                if (count == 0) break;
                Vector3d smoothedLook = new Vector3d(sumX / (double)count, sumY / (double)count, sumZ / (double)count);
                RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_73183(), new Vector3d(start.field_1352, start.field_1351, start.field_1350), smoothedLook, false, this.includeFluids, this.includeNonSolid);
                if (raycastResult != null) {
                    this.updateFromRaycastResult(raycastResult, (class_1297)entity, positions);
                }
                this.lastPositionsForSmoothing.removeElements(0, 3);
            }
            if (!positions.isEmpty()) {
                try {
                    this.inputPositions.put(positions.toLongArray());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.stopTaskWhenInputEmpty.set(true);
        long waitingSince = System.currentTimeMillis();
        while (!this.stoppedTask.get()) {
            LockSupport.parkNanos("waiting for tool async path to finish task", 100000L);
            long now = System.currentTimeMillis();
            if (now >= waitingSince && now <= waitingSince + 5000L) continue;
            break;
        }
        this.leakChecker.disarm();
        this.pather.update();
    }

    public void update() {
        this.update(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(boolean callUpdate) {
        class_746 entity;
        if (this.stopTask.get()) {
            return;
        }
        if (callUpdate) {
            this.pather.update();
        }
        if ((entity = class_310.method_1551().field_1724) == null || entity != class_310.method_1551().method_1560()) {
            return;
        }
        if (!EditorUI.isActive()) {
            return;
        }
        if (EditorUI.isMovingCamera()) {
            return;
        }
        class_243 currentLookDirection = EditorUI.getMouseLookVector();
        if (currentLookDirection == null) {
            return;
        }
        class_243 start = entity.method_33571();
        if (this.lastLookDirection == null || this.lastPosition == null) {
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_73183(), start, currentLookDirection, false, this.includeFluids, this.includeNonSolid);
            if (raycastResult == null) return;
            this.lastLookDirection = currentLookDirection;
            this.lastPosition = raycastResult.getPositionWithinBlock();
            try {
                this.inputPositions.put(new long[]{raycastResult.blockPos().method_10063()});
                if (this.smoothingAmount <= 1) return;
                this.lastPositionsForSmoothing.add(raycastResult.getLocation().field_1352);
                this.lastPositionsForSmoothing.add(raycastResult.getLocation().field_1351);
                this.lastPositionsForSmoothing.add(raycastResult.getLocation().field_1350);
                return;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        List<class_241> mousePositions = EditorUI.imguiGlfw.getCapturedInterframeMousePositions();
        LongArrayList positions = new LongArrayList();
        for (class_241 mousePosition : mousePositions) {
            class_243 lookDirection = EditorUI.getMouseLookVector(mousePosition.field_1343, mousePosition.field_1342);
            if (lookDirection == null) continue;
            double dot = this.lastLookDirection.method_1026(lookDirection);
            double angleChange = Math.toDegrees(Math.acos(dot));
            int steps = 1;
            if (angleChange > 1.0) {
                steps = (int)Math.ceil(angleChange);
            }
            for (int i = 1; i <= steps; ++i) {
                double lastZ;
                double dz;
                double lastY;
                double dy;
                int size;
                double lastX;
                double dx;
                double distance;
                float f = (float)i / (float)steps;
                class_243 look = this.lastLookDirection.method_35590(lookDirection, (double)f);
                RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_73183(), start, look, false, this.includeFluids, this.includeNonSolid);
                if (raycastResult == null) continue;
                if (this.smoothingAmount <= 1) {
                    this.updateFromRaycastResult(raycastResult, (class_1297)entity, positions);
                    continue;
                }
                class_243 target = raycastResult.getLocation();
                for (int c = 0; c < this.smoothingAmount && !((distance = Math.sqrt((dx = target.field_1352 - (lastX = this.lastPositionsForSmoothing.getDouble((size = this.lastPositionsForSmoothing.size()) - 3))) * dx + (dy = target.field_1351 - (lastY = this.lastPositionsForSmoothing.getDouble(size - 2))) * dy + (dz = target.field_1350 - (lastZ = this.lastPositionsForSmoothing.getDouble(size - 1))) * dz)) < 0.1); ++c) {
                    double newX = lastX + dx * 0.1 / distance;
                    double newY = lastY + dy * 0.1 / distance;
                    double newZ = lastZ + dz * 0.1 / distance;
                    this.lastPositionsForSmoothing.add(newX);
                    this.lastPositionsForSmoothing.add(newY);
                    this.lastPositionsForSmoothing.add(newZ);
                    if (this.lastPositionsForSmoothing.size() > this.smoothingAmount * 3) {
                        this.lastPositionsForSmoothing.removeElements(0, 3);
                    }
                    if (this.lastPositionsForSmoothing.size() < this.smoothingAmount * 3) continue;
                    double sumX = 0.0;
                    double sumY = 0.0;
                    double sumZ = 0.0;
                    int count = 0;
                    for (int j = 0; j < this.lastPositionsForSmoothing.size(); j += 3) {
                        double targetZ;
                        double deltaZ;
                        double targetY;
                        double deltaY;
                        double targetX = this.lastPositionsForSmoothing.getDouble(j);
                        double deltaX = targetX - start.field_1352;
                        class_243 normalizedLook = new class_243(deltaX, deltaY = (targetY = this.lastPositionsForSmoothing.getDouble(j + 1)) - start.field_1351, deltaZ = (targetZ = this.lastPositionsForSmoothing.getDouble(j + 2)) - start.field_1350).method_1029();
                        if (normalizedLook.equals((Object)class_243.field_1353)) continue;
                        sumX += normalizedLook.field_1352;
                        sumY += normalizedLook.field_1351;
                        sumZ += normalizedLook.field_1350;
                        ++count;
                    }
                    if (count == 0) continue;
                    Vector3d smoothedLook = new Vector3d(sumX / (double)count, sumY / (double)count, sumZ / (double)count);
                    raycastResult = RayCaster.raycast(entity.method_73183(), new Vector3d(start.field_1352, start.field_1351, start.field_1350), smoothedLook, false, this.includeFluids, this.includeNonSolid);
                    if (raycastResult == null) continue;
                    this.updateFromRaycastResult(raycastResult, (class_1297)entity, positions);
                }
            }
            this.lastLookDirection = lookDirection;
        }
        if (positions.isEmpty()) return;
        try {
            this.inputPositions.put(positions.toLongArray());
            return;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateFromRaycastResult(RayCaster.RaycastResult raycastResult, class_1297 entity, LongArrayList positions) {
        class_243 withinBlock = raycastResult.getPositionWithinBlock();
        ToolPatherPoint.smartDDASkipFrom(entity.method_73183(), this.lastPosition, withinBlock, this.includeNonSolid, (x, y, z) -> positions.add(class_2338.method_10064((int)x, (int)y, (int)z)));
        this.lastPosition = withinBlock;
    }

    public record AsyncTask(ArrayBlockingQueue<long[]> in, AtomicBoolean stopTask, AtomicBoolean stopTaskWhenInputEmpty, AtomicBoolean stoppedTask, AsyncToolPather pather) implements Runnable
    {
        @Override
        public void run() {
            try {
                while (!this.stopTask.get()) {
                    long[] firstPosition = this.in.poll(10L, TimeUnit.MILLISECONDS);
                    if (firstPosition != null) {
                        if (firstPosition.length != 1) {
                            throw new FaultyImplementationError();
                        }
                        this.pather.acceptInitial(firstPosition[0]);
                        break;
                    }
                    if (!this.stopTaskWhenInputEmpty.get()) continue;
                    return;
                }
                while (!this.stopTask.get()) {
                    long[] polled = this.in.poll(10L, TimeUnit.MILLISECONDS);
                    if (polled != null) {
                        this.pather.accept(polled);
                        continue;
                    }
                    if (!this.stopTaskWhenInputEmpty.get()) continue;
                    return;
                }
            }
            catch (Throwable t2) {
                Axiom.LOGGER.error("Error inside AsyncToolPathProvider#AsyncTask", t2);
            }
            finally {
                this.stopTask.set(true);
                this.stoppedTask.set(true);
                this.stopTaskWhenInputEmpty.set(true);
            }
        }
    }
}

