/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.text;

import com.moulberry.axiom.block_maps.HDVoxelMap;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.BlockHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.MissingResourceException;
import java.util.Optional;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTAlignedQuad;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTTPackContext;
import org.lwjgl.stb.STBTTPackedchar;
import org.lwjgl.stb.STBTruetype;

public class TextDrawing {
    @Nullable
    private static ByteBuffer loadFont(Path path) {
        byte[] bytes;
        block13: {
            if (path == null) {
                Optional resource = class_310.method_1551().method_1478().method_14486(new class_2960("axiom", "inter-medium.ttf"));
                if (resource.isEmpty()) {
                    throw new MissingResourceException("Missing font: inter-medium.ttf", "Font", "");
                }
                try (InputStream is = ((class_3298)resource.get()).method_14482();){
                    bytes = is.readAllBytes();
                    break block13;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            try {
                bytes = Files.readAllBytes(path);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        ByteBuffer data = BufferUtils.createByteBuffer((int)bytes.length);
        data.put(bytes);
        data.flip();
        return data;
    }

    public static void drawSimple(ChunkedBlockRegion chunkedBlockRegion, Path path, class_2680 blockState, String text, int direction, float pixelHeight) {
        record CharacterData(STBTTPackedchar.Buffer chardata, ByteBuffer bitmap) {
        }
        ByteBuffer data;
        if (pixelHeight > 256.0f) {
            pixelHeight = 256.0f;
        }
        if (pixelHeight < 8.0f) {
            pixelHeight = 8.0f;
        }
        if ((data = TextDrawing.loadFont(path)) == null) {
            return;
        }
        STBTTFontinfo info = STBTTFontinfo.malloc();
        STBTruetype.stbtt_InitFont((STBTTFontinfo)info, (ByteBuffer)data);
        data.rewind();
        Int2ObjectOpenHashMap characterData = new Int2ObjectOpenHashMap();
        ByteBuffer currentBitmap = BufferUtils.createByteBuffer((int)0x100000);
        STBTTPackContext packContext = STBTTPackContext.malloc();
        STBTruetype.stbtt_PackBegin((STBTTPackContext)packContext, (ByteBuffer)currentBitmap, (int)1024, (int)1024, (int)0, (int)1, (long)0L);
        int[] codepoint = new int[]{0};
        for (int i = 0; i < text.length(); i += TextDrawing.getCodepoint(text, i, codepoint)) {
            if (characterData.containsKey(codepoint[0])) continue;
            STBTTPackedchar.Buffer packedchar = STBTTPackedchar.malloc((int)1);
            if (STBTruetype.stbtt_PackFontRange((STBTTPackContext)packContext, (ByteBuffer)data, (int)0, (float)pixelHeight, (int)codepoint[0], (STBTTPackedchar.Buffer)packedchar)) {
                characterData.put(codepoint[0], (Object)new CharacterData(packedchar, currentBitmap));
                continue;
            }
            currentBitmap = BufferUtils.createByteBuffer((int)0x100000);
            STBTruetype.stbtt_PackEnd((STBTTPackContext)packContext);
            packContext.free();
            packContext = STBTTPackContext.malloc();
            STBTruetype.stbtt_PackBegin((STBTTPackContext)packContext, (ByteBuffer)currentBitmap, (int)1024, (int)1024, (int)0, (int)1, (long)0L);
            if (STBTruetype.stbtt_PackFontRange((STBTTPackContext)packContext, (ByteBuffer)data, (int)0, (float)pixelHeight, (int)codepoint[0], (STBTTPackedchar.Buffer)packedchar)) {
                characterData.put(codepoint[0], (Object)new CharacterData(packedchar, currentBitmap));
                continue;
            }
            throw new Error("Failed to allocate a second time");
        }
        STBTruetype.stbtt_PackEnd((STBTTPackContext)packContext);
        packContext.free();
        STBTTAlignedQuad quad = STBTTAlignedQuad.malloc();
        float scale = STBTruetype.stbtt_ScaleForPixelHeight((STBTTFontinfo)info, (float)pixelHeight);
        float[] locx = new float[]{0.0f};
        float[] locy = new float[]{0.0f};
        int i = 0;
        while (i < text.length()) {
            i += TextDrawing.getCodepoint(text, i, codepoint);
            CharacterData charData = (CharacterData)characterData.get(codepoint[0]);
            if (charData == null) {
                throw new FaultyImplementationError();
            }
            STBTruetype.stbtt_GetPackedQuad((STBTTPackedchar.Buffer)charData.chardata, (int)1024, (int)1024, (int)0, (float[])locx, (float[])locy, (STBTTAlignedQuad)quad, (boolean)true);
            if (i < text.length()) {
                int currentCodepoint = codepoint[0];
                TextDrawing.getCodepoint(text, i, codepoint);
                locx[0] = locx[0] + (float)STBTruetype.stbtt_GetCodepointKernAdvance((STBTTFontinfo)info, (int)currentCodepoint, (int)codepoint[0]) * scale;
            }
            for (int x = (int)quad.x0(); x < (int)quad.x1(); ++x) {
                block8: for (int y = (int)quad.y0(); y < (int)quad.y1(); ++y) {
                    float value = TextDrawing.lookup(charData.bitmap, quad, x, y);
                    if (!((double)value > 0.5)) continue;
                    switch (direction) {
                        default: {
                            chunkedBlockRegion.addBlock(x, -y, 0, blockState);
                            continue block8;
                        }
                        case 1: {
                            chunkedBlockRegion.addBlock(0, -y, x, blockState);
                            continue block8;
                        }
                        case 2: {
                            chunkedBlockRegion.addBlock(-x, -y, 0, blockState);
                            continue block8;
                        }
                        case 3: {
                            chunkedBlockRegion.addBlock(0, -y, -x, blockState);
                        }
                    }
                }
            }
        }
        quad.free();
        info.free();
        for (CharacterData value : characterData.values()) {
            value.chardata.free();
        }
    }

    public static void drawFancy(ChunkedBlockRegion chunkedBlockRegion, Path path, HDVoxelMap.HDVoxelBaseBlocks blocks, String text, int direction, float pixelHeight) {
        record CharacterData(STBTTPackedchar.Buffer chardata, ByteBuffer bitmap) {
        }
        ByteBuffer data;
        if (pixelHeight > 256.0f) {
            pixelHeight = 256.0f;
        }
        if (pixelHeight < 8.0f) {
            pixelHeight = 8.0f;
        }
        if ((data = TextDrawing.loadFont(path)) == null) {
            return;
        }
        STBTTFontinfo info = STBTTFontinfo.malloc();
        STBTruetype.stbtt_InitFont((STBTTFontinfo)info, (ByteBuffer)data);
        data.rewind();
        Int2ObjectOpenHashMap characterData = new Int2ObjectOpenHashMap();
        ByteBuffer currentBitmap = BufferUtils.createByteBuffer((int)0x100000);
        STBTTPackContext packContext = STBTTPackContext.malloc();
        STBTruetype.stbtt_PackBegin((STBTTPackContext)packContext, (ByteBuffer)currentBitmap, (int)1024, (int)1024, (int)0, (int)1, (long)0L);
        int[] codepoint = new int[]{0};
        for (int i = 0; i < text.length(); i += TextDrawing.getCodepoint(text, i, codepoint)) {
            if (characterData.containsKey(codepoint[0])) continue;
            STBTTPackedchar.Buffer packedchar = STBTTPackedchar.malloc((int)1);
            if (STBTruetype.stbtt_PackFontRange((STBTTPackContext)packContext, (ByteBuffer)data, (int)0, (float)pixelHeight, (int)codepoint[0], (STBTTPackedchar.Buffer)packedchar)) {
                characterData.put(codepoint[0], (Object)new CharacterData(packedchar, currentBitmap));
                continue;
            }
            currentBitmap = BufferUtils.createByteBuffer((int)0x100000);
            STBTruetype.stbtt_PackEnd((STBTTPackContext)packContext);
            packContext.free();
            packContext = STBTTPackContext.malloc();
            STBTruetype.stbtt_PackBegin((STBTTPackContext)packContext, (ByteBuffer)currentBitmap, (int)1024, (int)1024, (int)0, (int)1, (long)0L);
            if (STBTruetype.stbtt_PackFontRange((STBTTPackContext)packContext, (ByteBuffer)data, (int)0, (float)pixelHeight, (int)codepoint[0], (STBTTPackedchar.Buffer)packedchar)) {
                characterData.put(codepoint[0], (Object)new CharacterData(packedchar, currentBitmap));
                continue;
            }
            throw new Error("Failed to allocate a second time");
        }
        STBTruetype.stbtt_PackEnd((STBTTPackContext)packContext);
        packContext.free();
        STBTTAlignedQuad quad = STBTTAlignedQuad.malloc();
        float scale = STBTruetype.stbtt_ScaleForPixelHeight((STBTTFontinfo)info, (float)pixelHeight);
        float[] locx = new float[]{0.0f};
        float[] locy = new float[]{0.0f};
        int lastXEnd = 0;
        int i = 0;
        while (i < text.length()) {
            i += TextDrawing.getCodepoint(text, i, codepoint);
            float lastLocX = locx[0];
            CharacterData charData = (CharacterData)characterData.get(codepoint[0]);
            if (charData == null) {
                throw new FaultyImplementationError();
            }
            STBTruetype.stbtt_GetPackedQuad((STBTTPackedchar.Buffer)charData.chardata, (int)1024, (int)1024, (int)0, (float[])locx, (float[])locy, (STBTTAlignedQuad)quad, (boolean)true);
            if (i < text.length()) {
                int currentCodepoint = codepoint[0];
                TextDrawing.getCodepoint(text, i, codepoint);
                locx[0] = locx[0] + (float)STBTruetype.stbtt_GetCodepointKernAdvance((STBTTFontinfo)info, (int)currentCodepoint, (int)codepoint[0]) * scale;
            }
            RenderedGlyph first = TextDrawing.renderFancy(charData.bitmap, blocks, quad, 0);
            RenderedGlyph second = TextDrawing.renderFancy(charData.bitmap, blocks, quad, 1);
            RenderedGlyph renderedGlyph = first;
            if (second.error < first.error) {
                renderedGlyph = second;
            }
            int x0 = (int)quad.x0();
            int y0 = (int)quad.y0();
            int width = (int)Math.ceil((quad.x1() - quad.x0()) / 2.0f);
            int height = (int)Math.ceil(((float)((int)quad.y1()) - quad.y0()) / 2.0f);
            if (lastLocX < locx[0] && x0 / 2 <= lastXEnd + 1) {
                x0 += 2;
                locx[0] = locx[0] + 2.0f;
            }
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    class_2680 block = renderedGlyph.blockStates()[x + y * width];
                    if (block == null) continue;
                    switch (direction) {
                        default: {
                            chunkedBlockRegion.addBlock(x + x0 / 2, -(y + y0 / 2), 0, block);
                            break;
                        }
                        case 1: {
                            chunkedBlockRegion.addBlock(0, -(y + y0 / 2), x + x0 / 2, BlockHelper.rotate(block, class_2470.field_11463));
                            break;
                        }
                        case 2: {
                            chunkedBlockRegion.addBlock(-(x + x0 / 2), -(y + y0 / 2), 0, BlockHelper.rotate(block, class_2470.field_11464));
                            break;
                        }
                        case 3: {
                            chunkedBlockRegion.addBlock(0, -(y + y0 / 2), -(x + x0 / 2), BlockHelper.rotate(block, class_2470.field_11465));
                        }
                    }
                    lastXEnd = x + x0 / 2;
                }
            }
        }
        quad.free();
        info.free();
        for (CharacterData value : characterData.values()) {
            value.chardata.free();
        }
    }

    private static RenderedGlyph renderFancy(ByteBuffer bitmap, HDVoxelMap.HDVoxelBaseBlocks blocks, STBTTAlignedQuad quad, int xOffset) {
        int y;
        int x;
        int x0 = (int)quad.x0() + xOffset;
        int y0 = (int)quad.y0();
        int width = (int)Math.ceil((quad.x1() - quad.x0()) / 2.0f);
        int height = (int)Math.ceil(((float)((int)quad.y1()) - quad.y0()) / 2.0f);
        float[] errors = new float[width * height * 4];
        boolean[] pixels = new boolean[width * height * 4];
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                float botEastStairError;
                float topEastStairError;
                float botWestStairError;
                float topWestStairError;
                float bottomSlabError;
                float topSlabError;
                float one = TextDrawing.lookup(bitmap, quad, x * 2 + x0, y * 2 + y0);
                float two = TextDrawing.lookup(bitmap, quad, x * 2 + x0 + 1, y * 2 + y0);
                float three = TextDrawing.lookup(bitmap, quad, x * 2 + x0, y * 2 + y0 + 1);
                float four = TextDrawing.lookup(bitmap, quad, x * 2 + x0 + 1, y * 2 + y0 + 1);
                if ((double)one > 0.5) {
                    one = 1.0f;
                }
                if ((double)two > 0.5) {
                    two = 1.0f;
                }
                if ((double)three > 0.5) {
                    three = 1.0f;
                }
                if ((double)four > 0.5) {
                    four = 1.0f;
                }
                float lowestError = one * one + two * two + three * three + four * four;
                int lowestErrorPixels = 0;
                float fullBlockError = (1.0f - one) * (1.0f - one) + (1.0f - two) * (1.0f - two) + (1.0f - three) * (1.0f - three) + (1.0f - four) * (1.0f - four);
                if (fullBlockError < lowestError) {
                    lowestError = fullBlockError;
                    lowestErrorPixels = 15;
                }
                if ((topSlabError = (1.0f - one) * (1.0f - one) + (1.0f - two) * (1.0f - two) + three * three + four * four) < lowestError) {
                    lowestError = topSlabError;
                    lowestErrorPixels = 12;
                }
                if ((bottomSlabError = (1.0f - three) * (1.0f - three) + (1.0f - four) * (1.0f - four) + one * one + two * two) < lowestError) {
                    lowestError = bottomSlabError;
                    lowestErrorPixels = 3;
                }
                if ((topWestStairError = (1.0f - one) * (1.0f - one) + (1.0f - two) * (1.0f - two) + (1.0f - three) * (1.0f - three) + four * four) < lowestError) {
                    lowestError = topWestStairError;
                    lowestErrorPixels = 14;
                }
                if ((botWestStairError = (1.0f - one) * (1.0f - one) + (1.0f - three) * (1.0f - three) + (1.0f - four) * (1.0f - four) + two * two) < lowestError) {
                    lowestError = botWestStairError;
                    lowestErrorPixels = 11;
                }
                if ((topEastStairError = (1.0f - one) * (1.0f - one) + (1.0f - two) * (1.0f - two) + (1.0f - four) * (1.0f - four) + three * three) < lowestError) {
                    lowestError = topEastStairError;
                    lowestErrorPixels = 13;
                }
                if ((botEastStairError = (1.0f - two) * (1.0f - two) + (1.0f - three) * (1.0f - three) + (1.0f - four) * (1.0f - four) + one * one) < lowestError) {
                    lowestError = botEastStairError;
                    lowestErrorPixels = 7;
                }
                int oneIdx = x * 2 + y * 2 * width * 2;
                if ((lowestErrorPixels & 8) != 0) {
                    pixels[oneIdx] = true;
                    errors[oneIdx] = 1.0f - one;
                } else {
                    errors[oneIdx] = one;
                }
                int twoIdx = x * 2 + 1 + y * 2 * width * 2;
                if ((lowestErrorPixels & 4) != 0) {
                    pixels[twoIdx] = true;
                    errors[twoIdx] = 1.0f - two;
                } else {
                    errors[twoIdx] = two;
                }
                int threeIdx = x * 2 + (y * 2 + 1) * width * 2;
                if ((lowestErrorPixels & 2) != 0) {
                    pixels[threeIdx] = true;
                    errors[threeIdx] = 1.0f - three;
                } else {
                    errors[threeIdx] = three;
                }
                int fourIdx = x * 2 + 1 + (y * 2 + 1) * width * 2;
                if ((lowestErrorPixels & 1) != 0) {
                    pixels[fourIdx] = true;
                    errors[fourIdx] = 1.0f - four;
                    continue;
                }
                errors[fourIdx] = four;
            }
        }
        for (x = 0; x < width * 2; ++x) {
            for (y = 2; y < height * 2 - 2; y += 2) {
                boolean halfTop;
                boolean bottomEmpty;
                int otherSideOffsetX = 1 - x % 2 * 2;
                boolean top = pixels[x + y * width * 2];
                boolean bottom = pixels[x + (y + 1) * width * 2];
                if (top == bottom || errors[x + y * width * 2] != 1.0f - errors[x + (y + 1) * width * 2] || !pixels[x + otherSideOffsetX + y * width * 2] || !pixels[x + otherSideOffsetX + (y + 1) * width * 2]) continue;
                boolean topEmpty = !pixels[x + otherSideOffsetX + (y - 1) * width * 2] && !pixels[x + (y - 1) * width * 2];
                boolean bl = bottomEmpty = !pixels[x + otherSideOffsetX + (y + 2) * width * 2] && !pixels[x + (y + 2) * width * 2];
                if (!topEmpty && !bottomEmpty || (halfTop = topEmpty && bottomEmpty ? y > height / 2 : !topEmpty) == top) continue;
                pixels[x + y * width * 2] = !top;
                errors[x + y * width * 2] = 1.0f - errors[x + y * width * 2];
                pixels[x + (y + 1) * width * 2] = !bottom;
                errors[x + (y + 1) * width * 2] = 1.0f - errors[x + (y + 1) * width * 2];
            }
        }
        for (x = 0; x < width * 2; ++x) {
            for (y = 0; y < height * 2 - 2; ++y) {
                if ((x <= 0 || !pixels[x - 1 + (y + 1) * width * 2]) && (x >= width * 2 - 1 || !pixels[x + 1 + (y + 1) * width * 2]) || !pixels[x + y * width * 2] || pixels[x + (y + 1) * width * 2] || !pixels[x + (y + 2) * width * 2] || !((double)errors[x + y * width * 2] >= 0.5) && !((double)errors[x + (y + 2) * width * 2] >= 0.5)) continue;
                pixels[x + (y + 1) * width * 2] = true;
                errors[x + (y + 1) * width * 2] = 1.0f - errors[x + (y + 1) * width * 2];
            }
        }
        class_2680[] blockArray = new class_2680[width * height];
        float totalError = 0.0f;
        for (int x2 = 0; x2 < width; ++x2) {
            for (int y2 = 0; y2 < height; ++y2) {
                totalError += errors[x2 * 2 + y2 * 2 * width * 2] * errors[x2 * 2 + y2 * 2 * width * 2];
                totalError += errors[x2 * 2 + 1 + y2 * 2 * width * 2] * errors[x2 * 2 + 1 + y2 * 2 * width * 2];
                totalError += errors[x2 * 2 + (y2 * 2 + 1) * width * 2] * errors[x2 * 2 + (y2 * 2 + 1) * width * 2];
                totalError += errors[x2 * 2 + 1 + (y2 * 2 + 1) * width * 2] * errors[x2 * 2 + 1 + (y2 * 2 + 1) * width * 2];
                int b = 0;
                if (pixels[x2 * 2 + y2 * 2 * width * 2]) {
                    b |= 8;
                }
                if (pixels[x2 * 2 + 1 + y2 * 2 * width * 2]) {
                    b |= 4;
                }
                if (pixels[x2 * 2 + (y2 * 2 + 1) * width * 2]) {
                    b |= 2;
                }
                if (pixels[x2 * 2 + 1 + (y2 * 2 + 1) * width * 2]) {
                    b |= 1;
                }
                blockArray[x2 + y2 * width] = switch (b) {
                    case 0 -> null;
                    case 15 -> blocks.full().method_9564();
                    case 12 -> (class_2680)blocks.slab().method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
                    case 3 -> (class_2680)blocks.slab().method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
                    case 14 -> (class_2680)((class_2680)blocks.stair().method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11039)).method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
                    case 11 -> (class_2680)((class_2680)blocks.stair().method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11039)).method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12617);
                    case 13 -> (class_2680)((class_2680)blocks.stair().method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11034)).method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
                    case 7 -> (class_2680)((class_2680)blocks.stair().method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11034)).method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12617);
                    default -> throw new FaultyImplementationError("Unknown: " + b);
                };
            }
        }
        return new RenderedGlyph(totalError, blockArray);
    }

    private static float lookup(ByteBuffer bitmap, STBTTAlignedQuad quad, int x, int y) {
        if ((float)x >= quad.x1()) {
            return 0.0f;
        }
        if ((float)y >= quad.y1()) {
            return 0.0f;
        }
        if ((float)x < quad.x0()) {
            return 0.0f;
        }
        if ((float)y < quad.y0()) {
            return 0.0f;
        }
        float sf = (quad.x1() - (float)x) / (quad.x1() - quad.x0());
        float s2 = (quad.s0() * sf + quad.s1() * (1.0f - sf)) * 1023.0f;
        float tf = (quad.y1() - (float)y) / (quad.y1() - quad.y0());
        float t2 = (quad.t0() * tf + quad.t1() * (1.0f - tf)) * 1023.0f;
        float sFrac = s2 - (float)Math.floor(s2);
        float tFrac = t2 - (float)Math.floor(t2);
        float total = 0.0f;
        total += (float)(bitmap.get((int)Math.floor(s2) + (int)Math.floor(t2) * 1024) & 0xFF) * (1.0f - sFrac) * (1.0f - tFrac);
        total += (float)(bitmap.get((int)Math.floor(s2) + (int)Math.ceil(t2) * 1024) & 0xFF) * (1.0f - sFrac) * tFrac;
        total += (float)(bitmap.get((int)Math.ceil(s2) + (int)Math.floor(t2) * 1024) & 0xFF) * sFrac * (1.0f - tFrac);
        return (total += (float)(bitmap.get((int)Math.ceil(s2) + (int)Math.ceil(t2) * 1024) & 0xFF) * sFrac * tFrac) / 255.0f;
    }

    private static int getCodepoint(String text, int i, int[] out) {
        char c2;
        char c1 = text.charAt(i);
        if (Character.isHighSurrogate(c1) && i + 1 < text.length() && Character.isLowSurrogate(c2 = text.charAt(i + 1))) {
            out[0] = Character.toCodePoint(c1, c2);
            return 2;
        }
        out[0] = c1;
        return 1;
    }

    private record RenderedGlyph(float error, class_2680[] blockStates) {
    }
}

