/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.packets.AxiomServerboundSetBuffer;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.world_modification.BiomeBuffer;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public interface DispatchTask {
    public int tick(int var1);

    public boolean isDone();

    public static DispatchTask blockOrBiome(class_5321<class_1937> dimension, BlockOrBiomeBuffer blockOrBiomeBuffer) {
        if (blockOrBiomeBuffer instanceof BlockBuffer) {
            BlockBuffer blockBuffer = (BlockBuffer)blockOrBiomeBuffer;
            return new Block(dimension, UUID.randomUUID(), blockBuffer);
        }
        if (blockOrBiomeBuffer instanceof BiomeBuffer) {
            BiomeBuffer biomeBuffer = (BiomeBuffer)blockOrBiomeBuffer;
            return new Biome(dimension, UUID.randomUUID(), biomeBuffer);
        }
        throw new FaultyImplementationError();
    }

    public static class Block
    implements DispatchTask {
        private final class_5321<class_1937> dimension;
        private final UUID uuid;
        private final BlockBuffer blockBuffer;
        private final List<Long2ObjectMap.Entry<class_2841<class_2680>>> entries;
        private class_2540 buf = null;
        private int pendingSend = 0;

        public Block(class_5321<class_1937> dimension, UUID uuid, BlockBuffer blockBuffer) {
            int sortChunkZ;
            int sortChunkX;
            this.dimension = dimension;
            this.uuid = uuid;
            this.blockBuffer = blockBuffer;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                sortChunkX = player.method_31477() >> 4;
                sortChunkZ = player.method_31479() >> 4;
            } else {
                sortChunkX = 0;
                sortChunkZ = 0;
            }
            this.entries = new ArrayList<Long2ObjectMap.Entry<class_2841<class_2680>>>((Collection<Long2ObjectMap.Entry<class_2841<class_2680>>>)blockBuffer.entrySet());
            this.entries.sort(AxiomServerboundSetBuffer.createBlockBufferOrderComparator(sortChunkX, sortChunkZ));
        }

        @Override
        public int tick(int maxSendable) {
            if (maxSendable <= 0 || this.isDone()) {
                return 0;
            }
            int sent = 0;
            int maxSize = Axiom.getInstance().serverConfig.setBufferMaxSize() - 64;
            Iterator<Long2ObjectMap.Entry<class_2841<class_2680>>> iterator = this.entries.iterator();
            while (iterator.hasNext() && this.pendingSend < maxSendable) {
                boolean firstChunk;
                Long2ObjectMap.Entry<class_2841<class_2680>> entry = iterator.next();
                long pos = entry.getLongKey();
                class_2841 container = (class_2841)entry.getValue();
                iterator.remove();
                if (this.buf == null) {
                    this.buf = new class_2540(Unpooled.buffer());
                    this.buf.method_44116(this.dimension);
                    this.buf.method_10797(this.uuid);
                    this.buf.writeByte(0);
                    firstChunk = true;
                } else {
                    firstChunk = false;
                }
                int beforeWriterIndex = this.buf.writerIndex();
                ++this.pendingSend;
                this.buf.writeLong(pos);
                container.method_12325(this.buf);
                Short2ObjectMap<CompressedBlockEntity> blockEntities = this.blockBuffer.getBlockEntityChunkMap(entry.getLongKey());
                if (blockEntities != null && AxiomClient.hasPermission(AxiomPermission.BUILD_NBT)) {
                    this.buf.method_10804(blockEntities.size());
                    for (Short2ObjectMap.Entry blockEntityEntry : blockEntities.short2ObjectEntrySet()) {
                        this.buf.writeShort((int)blockEntityEntry.getShortKey());
                        ((CompressedBlockEntity)blockEntityEntry.getValue()).write(this.buf);
                    }
                } else {
                    this.buf.method_10804(0);
                }
                if (this.buf.writerIndex() < maxSize) continue;
                if (firstChunk) {
                    Axiom.dbg("AxiomServerboundSetBuffer - Warning: More than " + NumberFormat.getInstance().format(maxSize) + " bytes in a single section. Forcing send...");
                    this.buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                    this.buf.method_10804(maxSendable - this.pendingSend);
                    new AxiomServerboundSetBuffer(this.buf).send();
                    this.buf = null;
                    sent += this.pendingSend;
                    maxSendable -= this.pendingSend;
                    this.pendingSend = 0;
                    continue;
                }
                int copiedSize = this.buf.writerIndex() - beforeWriterIndex;
                byte[] copied = new byte[copiedSize];
                this.buf.getBytes(beforeWriterIndex, copied);
                this.buf.writerIndex(beforeWriterIndex);
                this.buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                this.buf.method_10804(maxSendable - (this.pendingSend - 1));
                new AxiomServerboundSetBuffer(this.buf).send();
                this.buf = null;
                sent += this.pendingSend - 1;
                maxSendable -= this.pendingSend - 1;
                this.pendingSend = 1;
                this.buf = new class_2540(Unpooled.buffer());
                this.buf.method_44116(this.dimension);
                this.buf.method_10797(this.uuid);
                this.buf.writeByte(0);
                this.buf.writeBytes(copied);
            }
            if (this.buf != null && this.pendingSend <= maxSendable) {
                this.buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                this.buf.method_10804(maxSendable - this.pendingSend);
                new AxiomServerboundSetBuffer(this.buf).send();
                this.buf = null;
                sent += this.pendingSend;
                this.pendingSend = 0;
            }
            return sent;
        }

        @Override
        public boolean isDone() {
            return this.entries.isEmpty() && this.buf == null;
        }
    }

    public static class Biome
    implements DispatchTask {
        private final class_5321<class_1937> dimension;
        private final UUID uuid;
        private final BiomeBuffer biomeBuffer;
        private final List<Long2ObjectMap.Entry<byte[]>> entries;
        private class_2540 buf = null;
        private int pendingSend = 0;

        public Biome(class_5321<class_1937> dimension, UUID uuid, BiomeBuffer biomeBuffer) {
            int sortChunkZ;
            int sortChunkY;
            int sortChunkX;
            this.dimension = dimension;
            this.uuid = uuid;
            this.biomeBuffer = biomeBuffer;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                sortChunkX = player.method_31477() >> 4;
                sortChunkY = player.method_31478() >> 4;
                sortChunkZ = player.method_31479() >> 4;
            } else {
                sortChunkX = 0;
                sortChunkY = 0;
                sortChunkZ = 0;
            }
            this.entries = new ArrayList<Long2ObjectMap.Entry<byte[]>>((Collection<Long2ObjectMap.Entry<byte[]>>)biomeBuffer.map.map.long2ObjectEntrySet());
            this.entries.sort(Comparator.comparingLong(entry -> {
                long pos = entry.getLongKey();
                int posX = class_2338.method_10061((long)pos);
                int posY = class_2338.method_10071((long)pos);
                int posZ = class_2338.method_10083((long)pos);
                return Math.abs(posX - sortChunkX) + Math.abs(posY - sortChunkY) + Math.abs(posZ - sortChunkZ);
            }));
        }

        @Override
        public int tick(int maxSendable) {
            if (maxSendable <= 0 || this.isDone()) {
                return 0;
            }
            int sent = 0;
            int maxSize = Axiom.getInstance().serverConfig.setBufferMaxSize() - 64;
            Iterator<Long2ObjectMap.Entry<byte[]>> iterator = this.entries.iterator();
            while (iterator.hasNext() && this.pendingSend < maxSendable) {
                Long2ObjectMap.Entry<byte[]> entry = iterator.next();
                iterator.remove();
                if (this.buf != null && (long)(this.buf.writerIndex() + 4096) + 8L + 8L >= (long)maxSize) {
                    this.buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                    this.buf.method_10804(maxSendable - this.pendingSend);
                    new AxiomServerboundSetBuffer(this.buf).send();
                    this.buf = null;
                    sent += this.pendingSend;
                    maxSendable -= this.pendingSend;
                    this.pendingSend = 0;
                }
                if (this.buf == null) {
                    this.buf = new class_2540(Unpooled.buffer());
                    this.buf.method_44116(this.dimension);
                    this.buf.method_10797(this.uuid);
                    this.buf.writeByte(1);
                    this.buf.writeByte(this.biomeBuffer.paletteSize);
                    for (int i = 0; i < this.biomeBuffer.paletteSize; ++i) {
                        this.buf.method_44116(this.biomeBuffer.palette[i]);
                    }
                    this.buf.writeByte((int)this.biomeBuffer.map.getDefaultValue());
                }
                ++this.pendingSend;
                this.buf.writeLong(entry.getLongKey());
                this.buf.writeBytes((byte[])entry.getValue());
            }
            if (this.buf != null && this.pendingSend <= maxSendable) {
                this.buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                this.buf.method_10804(maxSendable - this.pendingSend);
                new AxiomServerboundSetBuffer(this.buf).send();
                this.buf = null;
                sent += this.pendingSend;
                this.pendingSend = 0;
            }
            return sent;
        }

        @Override
        public boolean isDone() {
            return this.entries.isEmpty() && this.buf == null;
        }
    }
}

