/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.utils.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;

public class ConcurrentLevelPredicateSet {
    private final StampedLock lock;
    private final Long2ObjectMap<short[]> map;
    private final class_1937 level;
    private final Predicate<class_2680> predicate;
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private short[] lastChunk = null;

    public ConcurrentLevelPredicateSet(class_1937 level, Predicate<class_2680> predicate) {
        this.lock = new StampedLock();
        this.map = new Long2ObjectOpenHashMap();
        this.level = level;
        this.predicate = predicate;
    }

    public ConcurrentLevelPredicateSet(ConcurrentLevelPredicateSet other) {
        this.lock = other.lock;
        this.map = other.map;
        this.level = other.level;
        this.predicate = other.predicate;
        this.lastChunkPos = other.lastChunkPos;
        this.lastChunk = other.lastChunk;
    }

    private short[] computeForSection(int cx, int cy, int cz) {
        short[] array = new short[256];
        class_2818 chunk = this.level.method_8497(cx, cz);
        int sectionIndex = chunk.method_31603(cy);
        if (sectionIndex < 0 || sectionIndex >= chunk.method_32890()) {
            return array;
        }
        class_2826 section = chunk.method_38259(sectionIndex);
        class_2841 blocks = section.method_12265();
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                short v = 0;
                for (int x = 0; x < 16; ++x) {
                    if (!this.predicate.test((class_2680)blocks.method_12321(x, y, z))) continue;
                    v = (short)(v | 1 << x);
                }
                array[index++] = v;
            }
        }
        return array;
    }

    public boolean contains(int x, int y, int z) {
        int bit;
        int offset;
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        short[] array = this.getOrCreateChunk(xC, yC, zC);
        return (array[offset = (y & 0xF) + (z & 0xF) * 16] & (bit = 1 << (x & 0xF))) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] getOrCreateChunk(int cx, int cy, int cz) {
        long pos = class_2338.method_10064((int)cx, (int)cy, (int)cz);
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            short[] chunk = null;
            long stamp = this.lock.tryOptimisticRead();
            if (stamp != 0L) {
                chunk = (short[])this.map.get(pos);
            }
            if (!this.lock.validate(stamp)) {
                stamp = this.lock.readLock();
                try {
                    chunk = (short[])this.map.get(pos);
                }
                finally {
                    this.lock.unlockRead(stamp);
                }
            }
            if (chunk == null) {
                chunk = this.computeForSection(cx, cy, cz);
                stamp = this.lock.writeLock();
                try {
                    this.map.put(pos, (Object)chunk);
                }
                finally {
                    this.lock.unlockWrite(stamp);
                }
            }
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }
}

