/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.downgrade;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.moulberry.axiom.downgrade.DowngradeVersion;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.utils.DFUHelper;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Downgrader {
    private final List<JsonObject> downgradeMaps = new ArrayList<JsonObject>();

    public Downgrader(DowngradeVersion targetVersion) {
        int currentDataVersion = DFUHelper.DATA_VERSION;
        DowngradeVersion currentVersion = null;
        for (DowngradeVersion value : DowngradeVersion.values()) {
            if (value.getMinDataVersion() > currentDataVersion || currentDataVersion > value.getMaxDataVersion()) continue;
            currentVersion = value;
            break;
        }
        if (currentVersion == null) {
            throw new FaultyImplementationError("Unable to find current version");
        }
        Gson gson = new Gson();
        while (currentVersion != targetVersion) {
            DowngradeVersion to = null;
            for (Map.Entry<DowngradeVersion, String> entry : currentVersion.getDowngradeMap().entrySet()) {
                if (entry.getKey().getMaxDataVersion() < targetVersion.getMaxDataVersion() || to != null && to.getMaxDataVersion() <= entry.getKey().getMaxDataVersion()) continue;
                to = entry.getKey();
            }
            if (to == null) {
                throw new FaultyImplementationError("Unable to downgrade " + currentVersion.getVersionString() + " to " + targetVersion.getVersionString());
            }
            String downgradeFile = currentVersion.getDowngradeMap().get((Object)to);
            try {
                URL url = Downgrader.class.getClassLoader().getResource("downgrade/" + downgradeFile + ".json");
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                try (InputStream is = connection.getInputStream();){
                    byte[] bytes = is.readAllBytes();
                    this.downgradeMaps.add((JsonObject)gson.fromJson(new String(bytes), JsonObject.class));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            currentVersion = to;
        }
    }

    public String downgrade(String state) {
        String block = state.split("\\[")[0];
        boolean bestEffort = false;
        for (JsonObject downgradeMap : this.downgradeMaps) {
            JsonElement downgradeOperation = downgradeMap.get(state);
            if (downgradeOperation == null && !state.equals(block)) {
                downgradeOperation = downgradeMap.get(block);
            }
            if (downgradeOperation == null) {
                return "";
            }
            if (downgradeOperation.isJsonPrimitive()) {
                JsonPrimitive primitive = downgradeOperation.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    if (primitive.getAsBoolean()) continue;
                    return null;
                }
                if (primitive.isString()) {
                    state = primitive.getAsString();
                    if (state.startsWith("?")) {
                        bestEffort = true;
                        state = state.substring(1);
                    }
                    block = state.split("\\[")[0];
                    continue;
                }
            }
            throw new RuntimeException();
        }
        if (bestEffort) {
            return "?" + state;
        }
        return state;
    }
}

