/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mask;

import com.moulberry.axiom.AsyncChunkProvider;
import com.moulberry.axiom.collections.ChunkedPredicateDistanceField;
import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.editor.windows.global_mask.ToolMaskWindow;
import com.moulberry.axiom.funcinterfaces.TriIntFunction;
import com.moulberry.axiom.mask.LuaHelper;
import com.moulberry.axiom.mask.elements.LuaMaskElement;
import com.moulberry.axiom.utils.BlockCondition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_6880;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;

public class MaskContext {
    public static int frame = 0;
    private int lastFrame = 0;
    private final class_2680[] blocks = new class_2680[27];
    private class_6880<class_1959> biome = null;
    private class_243 angleVector = null;
    private final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
    private final Function<class_2338, class_2680> blockGetter;
    private final TriIntFunction<class_6880<class_1959>> biomeGetter;
    private final ChunkedPredicateDistanceField.SectionProvider sectionGetter;
    private final Position2dToIntMap heightmap = new Position2dToIntMap(Integer.MIN_VALUE);
    private final int maximumY;
    private final Map<BlockCondition, ChunkedPredicateDistanceField> distanceFieldMap = new HashMap<BlockCondition, ChunkedPredicateDistanceField>();
    private boolean triedToCompileLuaScript = false;
    private LuaFunction loadedScript = null;
    private Globals luaGlobals = null;

    public MaskContext(class_1937 level) {
        this.blockGetter = arg_0 -> ((class_1937)level).method_8320(arg_0);
        this.biomeGetter = (arg_0, arg_1, arg_2) -> ((class_1937)level).method_16359(arg_0, arg_1, arg_2);
        this.sectionGetter = (cx, cy, cz) -> {
            class_2818 chunk = (class_2818)level.method_8402(cx, cz, class_2806.field_12803, false);
            if (chunk == null) {
                return null;
            }
            int sectionY = chunk.method_31603(cy);
            if (sectionY < 0 || sectionY >= chunk.method_32890()) {
                return null;
            }
            class_2826 section = chunk.method_38259(sectionY);
            return section.method_12265();
        };
        this.maximumY = level.method_31600() - 1;
    }

    public MaskContext(AsyncChunkProvider provider) {
        this.blockGetter = provider::getBlockState;
        this.biomeGetter = provider::getBiome;
        this.sectionGetter = provider::getSection;
        this.maximumY = provider.getMaxY();
    }

    public MaskContext reset() {
        if (this.lastFrame != frame && this.luaGlobals != null) {
            this.lastFrame = frame;
            LuaHelper.updateExtraVariables(this.luaGlobals);
        }
        Arrays.fill(this.blocks, null);
        this.biome = null;
        this.angleVector = null;
        return this;
    }

    public ChunkedPredicateDistanceField getPredicateDistanceField(BlockCondition blockCondition) {
        return this.distanceFieldMap.computeIfAbsent(blockCondition, cond -> new ChunkedPredicateDistanceField(this.sectionGetter, blockCondition));
    }

    public boolean runScript(LuaMaskElement luaMaskElement, int x, int y, int z) {
        if (!this.triedToCompileLuaScript) {
            this.triedToCompileLuaScript = true;
            String script = luaMaskElement.getScript();
            this.luaGlobals = LuaHelper.createSandboxed();
            LuaHelper.initializeMask(this.luaGlobals, this, x, y, z);
            try {
                this.loadedScript = LuaHelper.compile(script, this.luaGlobals);
                ToolMaskWindow.luaExecutionError = null;
            }
            catch (LuaError luaError) {
                String message = luaError.getMessage();
                String[] splitMessage = message.split(":");
                ToolMaskWindow.luaExecutionError = splitMessage[splitMessage.length - 1];
            }
        }
        if (this.loadedScript != null) {
            LuaHelper.setPosition(this.luaGlobals, x, y, z);
            try {
                LuaValue value = this.loadedScript.call();
                if (value.isboolean()) {
                    return value.toboolean();
                }
                ToolMaskWindow.luaExecutionError = "expected boolean output, got " + value.typename() + " instead";
                this.loadedScript = null;
            }
            catch (LuaError luaError) {
                String message = luaError.getMessage();
                String[] splitMessage = message.split(":");
                ToolMaskWindow.luaExecutionError = splitMessage[splitMessage.length - 1];
                this.loadedScript = null;
            }
        }
        return false;
    }

    public int getHighestBlock(int x, int z) {
        int currentValue = this.heightmap.get(x, z);
        if (currentValue == Integer.MIN_VALUE) {
            int y = this.maximumY;
            while (true) {
                class_2680 blockState;
                if ((blockState = this.blockGetter.apply((class_2338)this.mutableBlockPos.method_10103(x, y, z))).method_26204() == class_2246.field_10243 || blockState.method_51366()) {
                    this.heightmap.put(x, z, y);
                    return y;
                }
                --y;
            }
        }
        return currentValue;
    }

    public class_243 getAngleVector(int x, int y, int z) {
        if (this.angleVector != null) {
            return this.angleVector;
        }
        int dirX = 0;
        int dirY = 0;
        int dirZ = 0;
        for (int xo = -2; xo <= 2; ++xo) {
            for (int yo = -2; yo <= 2; ++yo) {
                for (int zo = -2; zo <= 2; ++zo) {
                    class_2680 block = this.blockGetter.apply((class_2338)this.mutableBlockPos.method_10103(x + xo, y + yo, z + zo));
                    if (!block.method_51366()) continue;
                    dirX -= xo;
                    dirY -= yo;
                    dirZ -= zo;
                }
            }
        }
        int dirSq = dirX * dirX + dirY * dirY + dirZ * dirZ;
        if (dirSq == 0) {
            this.angleVector = class_243.field_1353;
            return this.angleVector;
        }
        double scale = 1.0 / Math.sqrt(dirSq);
        this.angleVector = new class_243((double)dirX * scale, (double)dirY * scale, (double)dirZ * scale);
        return this.angleVector;
    }

    public class_6880<class_1959> getBiomeAt(int x, int y, int z) {
        if (this.biome != null) {
            return this.biome;
        }
        this.biome = this.biomeGetter.get(x >> 2, y >> 2, z >> 2);
        return this.biome;
    }

    public class_2680 getBlockStateAt(int x, int y, int z) {
        return this.blockGetter.apply((class_2338)this.mutableBlockPos.method_10103(x, y, z));
    }

    public class_2680 getBlockState(int x, int y, int z) {
        class_2680 blockState = this.blocks[13];
        if (blockState == null) {
            this.blocks[13] = blockState = this.blockGetter.apply((class_2338)this.mutableBlockPos.method_10103(x, y, z));
        }
        return blockState;
    }

    public class_2680 getBlockState(int x, int y, int z, int xo, int yo, int zo) {
        int index = 13 + xo * 9 + yo * 3 + zo;
        class_2680 blockState = this.blocks[index];
        if (blockState == null) {
            this.blocks[index] = blockState = this.blockGetter.apply((class_2338)this.mutableBlockPos.method_10103(x + xo, y + yo, z + zo));
        }
        return blockState;
    }
}

