/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets.blueprint;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomServer;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.blueprint.ServerBlueprintRegistry;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.restrictions.AxiomPermission;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AxiomServerboundUploadBlueprint
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = new class_2960("axiom:upload_blueprint");
    private final String path;
    private final RawBlueprint rawBlueprint;

    public AxiomServerboundUploadBlueprint(String path, RawBlueprint rawBlueprint) {
        this.path = path;
        this.rawBlueprint = rawBlueprint;
    }

    public AxiomServerboundUploadBlueprint(class_2540 friendlyByteBuf) {
        this.path = friendlyByteBuf.method_19772();
        this.rawBlueprint = RawBlueprint.read(friendlyByteBuf);
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_10814(this.path);
        RawBlueprint.write(friendlyByteBuf, this.rawBlueprint);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (!AxiomServer.supportsServerBlueprints()) {
            return;
        }
        if (!AxiomServerboundPacket.canUseAxiom(player, AxiomPermission.BLUEPRINT_UPLOAD)) {
            return;
        }
        ServerBlueprintRegistry registry = ServerBlueprintManager.getRegistry();
        if (registry == null) {
            return;
        }
        String pathStr = this.path;
        if (!(pathStr = pathStr.replace("\\", "/")).endsWith(".bp") || pathStr.contains("..") || !pathStr.startsWith("/")) {
            return;
        }
        Path relative = Path.of(pathStr = pathStr.substring(1), new String[0]).normalize();
        if (relative.isAbsolute()) {
            return;
        }
        Path path = Axiom.getInstance().getBlueprintDirectory().resolve(relative);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            return;
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            BlueprintIo.writeRaw(outputStream, this.rawBlueprint);
        }
        catch (IOException e) {
            return;
        }
        registry.blueprints().put("/" + pathStr.substring(0, pathStr.length() - 3), this.rawBlueprint);
        ServerBlueprintManager.sendManifest(server.method_3760().method_14571());
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundUploadBlueprint::new);
    }
}

