/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.capabilities;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.capabilities.BuildSymmetry;
import com.moulberry.axiom.capabilities.Capability;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.packets.AxiomServerboundSetBlock;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_2885;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_7202;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class SpecialPlace {
    private static boolean usedForcePlace = false;
    private static boolean usedCustomShapeUpdate = false;
    private static boolean usedCustomPlacement = false;
    private static boolean usedSkipInteraction = false;
    private static boolean isCollectingBlockChanges = false;
    private static boolean isDoingUseWithoutItemChanges = false;
    private static boolean hadPredictedBlockChanges = false;
    private static final Map<class_2338, class_2680> collectedBlockChanges = new LinkedHashMap<class_2338, class_2680>();
    private static final Map<class_2338, class_2680> collectedBlockChangesUseWithoutItem = new LinkedHashMap<class_2338, class_2680>();
    private static final Set<class_2338> preventUpdatesAt = new HashSet<class_2338>();

    private static void reset() {
        usedForcePlace = false;
        usedCustomShapeUpdate = false;
        usedCustomPlacement = false;
        usedSkipInteraction = false;
        isCollectingBlockChanges = false;
        isDoingUseWithoutItemChanges = false;
        hadPredictedBlockChanges = false;
        collectedBlockChanges.clear();
        collectedBlockChangesUseWithoutItem.clear();
        preventUpdatesAt.clear();
    }

    public static class_1269 performUseItemOn(class_746 localPlayer, class_1268 interactionHand, class_3965 blockHitResult, NormalUseItemOn normalUseItemOn) {
        int sequence;
        class_1269 normalResult;
        class_1792 inHand;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return class_1269.field_5811;
        }
        if (!AxiomClient.isAxiomActive()) {
            return class_1269.field_5811;
        }
        if (!AxiomClient.hasPermission(AxiomPermission.BUILD_PLACE)) {
            return class_1269.field_5811;
        }
        boolean forceBecauseOfInfiniteReach = false;
        if (Capability.INFINITE_REACH.isEnabled()) {
            double hitDistance = blockHitResult.method_17784().method_1022(localPlayer.method_33571());
            forceBecauseOfInfiniteReach = hitDistance > (double)localPlayer.field_7483 * 0.0 + 5.0;
        }
        boolean noUpdates = Capability.NO_UPDATES.isEnabled();
        boolean forcePlace = Capability.FORCE_PLACE.isEnabled();
        boolean forceBecauseOfSymmetry = BuildSymmetry.isActive();
        class_2680 placingOnBlockState = level.method_8320(blockHitResult.method_17777());
        boolean forceBecauseOfLiquidPlace = false;
        boolean replaceClickedBlockState = placingOnBlockState.method_45474();
        if (Axiom.configuration.blockAttributes.makeFluidHitboxesSolid && placingOnBlockState.method_26204() instanceof class_2404) {
            forceBecauseOfLiquidPlace = true;
            replaceClickedBlockState = false;
        }
        class_2338 clickedPos = null;
        if (replaceClickedBlockState) {
            clickedPos = blockHitResult.method_17777();
        } else if (level.method_8320(blockHitResult.method_17777().method_10093(blockHitResult.method_17780())).method_45474()) {
            clickedPos = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
        }
        if ((noUpdates || forceBecauseOfInfiniteReach || forceBecauseOfLiquidPlace) && ((inHand = localPlayer.method_5998(interactionHand).method_7909()) == class_1802.field_8705 || inHand == class_1802.field_8187)) {
            if (clickedPos == null) {
                return class_1269.field_5814;
            }
            int reasons = 0;
            if (noUpdates) {
                reasons |= 8;
            }
            if (forceBecauseOfInfiniteReach) {
                reasons |= 0x40;
            }
            if (forceBecauseOfLiquidPlace) {
                reasons |= 0x200;
            }
            class_2248 placedBlock = inHand == class_1802.field_8705 ? class_2246.field_10382 : class_2246.field_10164;
            Map<class_2338, class_2680> changes = Map.of(clickedPos, placedBlock.method_9564());
            new AxiomServerboundSetBlock(changes, !noUpdates, reasons, false, blockHitResult, interactionHand, -1).send();
            localPlayer.method_6104(interactionHand);
            return class_1269.field_21466;
        }
        if (!(noUpdates || forceBecauseOfSymmetry || forcePlace || forceBecauseOfLiquidPlace || forceBecauseOfInfiniteReach || Axiom.configuration.blockAttributes.preventInteractions || !ServerCustomBlocks.customBlockMap.isEmpty())) {
            return class_1269.field_5811;
        }
        if (forceBecauseOfLiquidPlace) {
            if (clickedPos == null) {
                return class_1269.field_5814;
            }
            class_2350 dir = blockHitResult.method_17780();
            blockHitResult = new class_3965(class_243.method_24953((class_2382)clickedPos), dir, clickedPos, true);
        }
        if (isCollectingBlockChanges) {
            throw new FaultyImplementationError("Already collecting block changes - was something called async?");
        }
        SpecialPlace.reset();
        class_1799 itemStack = localPlayer.method_5998(interactionHand);
        try (class_7202 blockStatePredictionHandler = level.method_41925().method_41937();){
            isCollectingBlockChanges = true;
            normalResult = SpecialPlace.performUseItemOn(localPlayer, interactionHand, blockHitResult, normalUseItemOn, forcePlace, itemStack, clickedPos, level);
            if (isDoingUseWithoutItemChanges) {
                Axiom.LOGGER.warn("isDoingUseWithoutItemChanges was true after processing. Bug with MixinBlockStateBase#useWithoutItemXYZ?");
                SpecialPlace.finishDoingUseWithoutItem((class_1937)level);
            }
            isCollectingBlockChanges = false;
            sequence = blockStatePredictionHandler.method_41942();
        }
        if (!normalResult.method_23665()) {
            if (normalResult == class_1269.field_5811 && (usedSkipInteraction || usedCustomShapeUpdate || usedCustomPlacement || ItemStackDataHelper.getCustomBlockPlacer(itemStack) != null)) {
                normalResult = class_1269.field_21466;
            }
            if (hadPredictedBlockChanges) {
                level.method_41925().method_41938(sequence, level);
            }
            SpecialPlace.reset();
            return normalResult;
        }
        if (usedForcePlace || usedCustomShapeUpdate || usedCustomPlacement || usedSkipInteraction || noUpdates && !collectedBlockChanges.isEmpty() || forceBecauseOfInfiniteReach || forceBecauseOfSymmetry || forceBecauseOfLiquidPlace) {
            if (!collectedBlockChanges.isEmpty()) {
                int reasons = SpecialPlace.calculateReason(noUpdates, forceBecauseOfInfiniteReach, forceBecauseOfSymmetry, forceBecauseOfLiquidPlace);
                SpecialPlace.sendCollectedBlockChanges(reasons, false, blockHitResult, interactionHand, sequence);
                SpecialPlace.reset();
                return normalResult;
            }
            if (hadPredictedBlockChanges) {
                level.method_41925().method_41938(sequence, level);
            }
            return class_1269.field_21466;
        }
        SpecialPlace.reset();
        class_310.method_1551().method_1562().method_52787((class_2596)new class_2885(interactionHand, blockHitResult, sequence));
        return normalResult;
    }

    private static int calculateReason(boolean noUpdates, boolean forceBecauseOfInfiniteReach, boolean forceBecauseOfSymmetry, boolean forceBecauseOfLiquidPlace) {
        int reasons = 0;
        if (usedForcePlace) {
            reasons |= 4;
        }
        if (usedCustomShapeUpdate) {
            reasons |= 0x10;
        }
        if (usedCustomPlacement) {
            reasons |= 0x20;
        }
        if (noUpdates) {
            reasons |= 8;
        }
        if (forceBecauseOfInfiniteReach) {
            reasons |= 0x40;
        }
        if (forceBecauseOfSymmetry) {
            reasons |= 0x100;
        }
        if (forceBecauseOfLiquidPlace) {
            reasons |= 0x200;
        }
        if (usedSkipInteraction) {
            reasons |= 0x400;
        }
        return reasons;
    }

    private static class_1269 performUseItemOn(class_746 localPlayer, class_1268 interactionHand, class_3965 blockHitResult, NormalUseItemOn normalUseItemOn, boolean forcePlace, class_1799 itemStack, class_2338 clickedPos, class_638 level) {
        String customBlockPlacer;
        class_1792 class_17922;
        if (forcePlace && (class_17922 = itemStack.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            if (ItemStackDataHelper.hasBlockStateTag(itemStack)) {
                if (clickedPos == null) {
                    return class_1269.field_5814;
                }
                usedForcePlace = true;
                class_2680 blockState = blockItem.method_7711().method_9564();
                blockState = ItemStackDataHelper.updateBlockStateFromTag(blockState, itemStack);
                class_2498 soundType = blockState.method_26231();
                level.method_45446(clickedPos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f, false);
                level.method_8652(clickedPos, blockState, 2);
                localPlayer.method_6104(interactionHand);
                return class_1269.field_21466;
            }
        }
        if (!(itemStack.method_7909() instanceof class_1747) && (customBlockPlacer = ItemStackDataHelper.getCustomBlockPlacer(itemStack)) != null) {
            if (clickedPos == null) {
                return class_1269.field_5814;
            }
            usedCustomPlacement = true;
            class_1750 blockPlaceContext = new class_1750(new class_1838((class_1657)localPlayer, interactionHand, blockHitResult));
            class_2680 placed = SpecialPlace.doCustomPlacement(customBlockPlacer, blockPlaceContext);
            if (placed == null) {
                return class_1269.field_5814;
            }
            blockPlaceContext.method_8045().method_8652(clickedPos, placed, 11);
            class_2498 soundType = placed.method_26231();
            level.method_45446(clickedPos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f, false);
            localPlayer.method_6104(interactionHand);
            return class_1269.field_21466;
        }
        return normalUseItemOn.performUseItemOn(localPlayer, interactionHand, blockHitResult);
    }

    @Nullable
    private static class_2680 doCustomPlacement(String customBlockPlacer, class_1750 blockPlaceContext) {
        class_2680 vanillaState;
        CustomBlock customBlock = ServerCustomBlocks.getCustomBlock(new class_2960(customBlockPlacer));
        if (customBlock == null) {
            ChatUtils.error("Unknown custom block: " + customBlockPlacer);
            return null;
        }
        CustomBlockState placedState = customBlock.getCustomStateForPlacement(blockPlaceContext, Capability.FORCE_PLACE.isEnabled());
        class_2680 class_26802 = vanillaState = placedState == null ? null : placedState.getVanillaState();
        if (vanillaState == null) {
            return null;
        }
        if (!Capability.FORCE_PLACE.isEnabled()) {
            class_3726 collisionContext;
            class_3726 class_37262 = collisionContext = blockPlaceContext.method_8036() == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)blockPlaceContext.method_8036());
            if (!blockPlaceContext.method_8045().method_8628(vanillaState, blockPlaceContext.method_8037(), collisionContext)) {
                return null;
            }
        }
        return vanillaState;
    }

    public static boolean destroyBlock(class_638 level, class_2338 blockPos, class_2350 direction, NormalDestroyBlock normalDestroyBlock) {
        int sequence;
        boolean normalResult;
        if (!AxiomClient.isAxiomActive()) {
            return false;
        }
        class_2680 destroyedBlockState = level.method_8320(blockPos);
        if (destroyedBlockState.method_26204() instanceof class_2404) {
            SpecialPlace.reset();
            collectedBlockChanges.put(blockPos, class_2246.field_10124.method_9564());
            class_3965 blockHitResult = (class_3965)class_310.method_1551().field_1765;
            SpecialPlace.sendCollectedBlockChanges(512, true, blockHitResult, class_1268.field_5808, -1);
            level.method_31595(blockPos, destroyedBlockState);
            SpecialPlace.reset();
            return true;
        }
        boolean forceBecauseOfInfiniteReach = false;
        if (Capability.INFINITE_REACH.isEnabled()) {
            class_239 hitResult = class_310.method_1551().field_1765;
            class_746 localPlayer = class_310.method_1551().field_1724;
            double hitDistance = hitResult.method_17784().method_1022(localPlayer.method_33571());
            forceBecauseOfInfiniteReach = hitDistance > (double)localPlayer.field_7483 * 0.0 + 5.0;
        }
        boolean noUpdates = Capability.NO_UPDATES.isEnabled();
        boolean forceBecauseOfSymmetry = BuildSymmetry.isActive();
        if (!noUpdates && !forceBecauseOfSymmetry && !forceBecauseOfInfiniteReach && ServerCustomBlocks.customBlockMap.isEmpty()) {
            return false;
        }
        if (isCollectingBlockChanges) {
            throw new FaultyImplementationError("Already collecting block changes - was something called async?");
        }
        SpecialPlace.reset();
        try (class_7202 blockStatePredictionHandler = level.method_41925().method_41937();){
            isCollectingBlockChanges = true;
            normalResult = normalDestroyBlock.destroyBlock(blockPos);
            isCollectingBlockChanges = false;
            sequence = blockStatePredictionHandler.method_41942();
        }
        if (!normalResult) {
            if (usedSkipInteraction || usedCustomShapeUpdate || usedCustomPlacement) {
                normalResult = true;
            }
            if (hadPredictedBlockChanges) {
                level.method_41925().method_41938(sequence, level);
            }
            SpecialPlace.reset();
            return normalResult;
        }
        collectedBlockChanges.entrySet().removeIf(entry -> {
            if (((class_2338)entry.getKey()).equals((Object)blockPos)) {
                return false;
            }
            return !((class_2680)entry.getValue()).method_26215() && !((class_2680)entry.getValue()).method_51176();
        });
        if (usedCustomShapeUpdate || noUpdates && !collectedBlockChanges.isEmpty() || forceBecauseOfInfiniteReach || forceBecauseOfSymmetry) {
            if (!collectedBlockChanges.isEmpty()) {
                class_3965 blockHitResult = (class_3965)class_310.method_1551().field_1765;
                int reasons = SpecialPlace.calculateReason(noUpdates, forceBecauseOfInfiniteReach, forceBecauseOfSymmetry, false);
                SpecialPlace.sendCollectedBlockChanges(reasons, true, blockHitResult, class_1268.field_5808, sequence);
                SpecialPlace.reset();
                return true;
            }
            if (hadPredictedBlockChanges) {
                level.method_41925().method_41938(sequence, level);
            }
            SpecialPlace.reset();
            return true;
        }
        SpecialPlace.reset();
        class_310.method_1551().method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12968, blockPos, direction, sequence));
        return true;
    }

    private static void sendCollectedBlockChanges(int reasons, boolean breaking, class_3965 blockHitResult, class_1268 hand, int sequence) {
        Map<class_2338, class_2680> changes = BuildSymmetry.applySymmetry(collectedBlockChanges);
        boolean updateNeighbors = !Capability.NO_UPDATES.isEnabled();
        new AxiomServerboundSetBlock(changes, updateNeighbors, preventUpdatesAt, reasons, breaking, blockHitResult, hand, sequence).send();
    }

    public static boolean isSpecialPlacing(class_1922 blockGetter) {
        return AxiomClient.isAxiomActive() && isCollectingBlockChanges && blockGetter instanceof class_638;
    }

    public static boolean isForcePlacing(class_1922 blockGetter) {
        if (SpecialPlace.isSpecialPlacing(blockGetter) && Capability.FORCE_PLACE.isEnabled()) {
            usedForcePlace = true;
            return true;
        }
        return false;
    }

    public static boolean isCancellingUpdates(class_1922 blockGetter) {
        return SpecialPlace.isSpecialPlacing(blockGetter) && Capability.NO_UPDATES.isEnabled();
    }

    public static void markCustomShapeUpdated(class_1922 blockGetter, class_2338 blockPos) {
        if (SpecialPlace.isSpecialPlacing(blockGetter)) {
            usedCustomShapeUpdate = true;
            preventUpdatesAt.add(blockPos);
        }
    }

    public static void markCustomPlacement(class_1922 blockGetter) {
        if (SpecialPlace.isSpecialPlacing(blockGetter)) {
            usedCustomPlacement = true;
        }
    }

    public static void markPreventedDefaultInteraction(class_1922 blockGetter) {
        if (SpecialPlace.isSpecialPlacing(blockGetter)) {
            usedSkipInteraction = true;
        }
        collectedBlockChangesUseWithoutItem.clear();
    }

    public static boolean isUseWithoutItemCancellable(class_1922 blockGetter) {
        return SpecialPlace.isSpecialPlacing(blockGetter) && (Axiom.configuration.blockAttributes.preventInteractions || !ServerCustomBlocks.customBlockMap.isEmpty());
    }

    public static boolean isDoingUseWithoutItemChanges(class_1922 blockGetter) {
        return isDoingUseWithoutItemChanges && SpecialPlace.isSpecialPlacing(blockGetter);
    }

    public static void startDoingUseWithoutItem() {
        if (isDoingUseWithoutItemChanges) {
            Axiom.LOGGER.warn("startDoingUseWithoutItem() called when isDoingUseWithoutItemChanges was already true. Bug with MixinBlockStateBase#useWithoutItemXYZ?");
        }
        isDoingUseWithoutItemChanges = true;
    }

    public static void finishDoingUseWithoutItem(class_1937 level) {
        if (isDoingUseWithoutItemChanges) {
            isDoingUseWithoutItemChanges = false;
            for (Map.Entry<class_2338, class_2680> entry : collectedBlockChangesUseWithoutItem.entrySet()) {
                SpecialPlace.tryCollectBlockChange(level, entry.getKey(), entry.getValue());
            }
            collectedBlockChangesUseWithoutItem.clear();
        }
    }

    public static void tryCollectBlockChange(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (!isCollectingBlockChanges) {
            return;
        }
        if (level.method_31606(blockPos)) {
            return;
        }
        if (level.method_8320(blockPos) == blockState) {
            return;
        }
        hadPredictedBlockChanges = true;
        if (isDoingUseWithoutItemChanges) {
            collectedBlockChangesUseWithoutItem.put(blockPos, blockState);
        } else {
            collectedBlockChanges.put(blockPos, blockState);
        }
    }

    public static interface NormalUseItemOn {
        public class_1269 performUseItemOn(class_746 var1, class_1268 var2, class_3965 var3);
    }

    public static interface NormalDestroyBlock {
        public boolean destroyBlock(class_2338 var1);
    }
}

