/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.displayentity;

import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.displayentity.DisplayEntityObject;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.mixin.DisplayAccessor;
import com.moulberry.axiom.packets.AxiomServerboundDeleteEntity;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.utils.EntityDataUtils;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.utils.SerializationUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2945;
import net.minecraft.class_4590;
import net.minecraft.class_5625;
import net.minecraft.class_746;
import net.minecraft.class_8104;
import net.minecraft.class_811;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DisplayEntityHelper {
    private static final class_2520 DEFAULT_TRANSFORMATION = (class_2520)class_4590.field_42533.encodeStart((DynamicOps)class_2509.field_11560, (Object)class_4590.method_22931()).result().get();
    private static final class_2520 DEFAULT_BILLBOARD = (class_2520)class_8113.class_8114.field_42410.encodeStart((DynamicOps)class_2509.field_11560, (Object)class_8113.class_8114.field_42406).result().get();
    private static final class_2520 DEFAULT_ITEM_DISPLAY = (class_2520)class_811.field_42468.encodeStart((DynamicOps)class_2509.field_11560, (Object)class_811.field_4315).result().get();
    private static final List<String> VALID_PASSENGER_IDS = List.of(class_1299.method_5890((class_1299)class_1299.field_42456).toString(), class_1299.method_5890((class_1299)class_1299.field_42460).toString(), class_1299.method_5890((class_1299)class_1299.field_42457).toString());

    public static void spawnAtPlayer(DisplayEntityObject object, class_746 player) {
        DisplayEntityHelper.spawnAt(object, player.method_19538().method_1031(0.0, 0.5, 0.0));
    }

    public static void spawnAt(DisplayEntityObject object, class_243 position) {
        class_2487 tag = object.getNbt(false);
        tag.method_10582("id", object.entityType());
        if (object instanceof DisplayEntityObject.DisplayEntityBlockObject) {
            class_4590 transformation = new class_4590(new Vector3f(-0.5f, -0.5f, -0.5f), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf());
            class_4590.field_42533.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(t2 -> tag.method_10566("transformation", t2));
        }
        new AxiomServerboundSpawnEntity(List.of(new AxiomServerboundSpawnEntity.SpawnEntry(UUID.randomUUID(), position, 0.0f, 0.0f, null, tag))).send();
    }

    public static void applyTransformation(class_8113 display, Matrix4f matrix4f) {
        class_2487 compoundTag = new class_2487();
        class_4590 transformation = VersionUtils.helperTransformationNew((Matrix4fc)matrix4f);
        transformation.method_22937();
        class_4590.field_42533.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(tag -> compoundTag.method_10566("transformation", tag));
        new AxiomServerboundManipulateEntity(List.of(new AxiomServerboundManipulateEntity.ManipulateEntry(display.method_5667(), null, compoundTag))).send();
    }

    public static void applyBrightness(class_8113 display, @NotNull class_8104 brightness) {
        class_2487 compoundTag = new class_2487();
        class_8104.field_42263.encodeStart((DynamicOps)class_2509.field_11560, (Object)brightness).result().ifPresent(tag -> compoundTag.method_10566("brightness", tag));
        new AxiomServerboundManipulateEntity(List.of(new AxiomServerboundManipulateEntity.ManipulateEntry(display.method_5667(), null, compoundTag))).send();
    }

    public static void spawnAtWithTransformation(DisplayEntityObject object, class_243 position, Matrix4f matrix4f) {
        class_2487 compoundTag = object.getNbt(false);
        compoundTag.method_10582("id", object.entityType());
        class_4590 transformation = VersionUtils.helperTransformationNew((Matrix4fc)matrix4f);
        transformation.method_22937();
        class_4590.field_42533.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(tag -> compoundTag.method_10566("transformation", tag));
        new AxiomServerboundSpawnEntity(List.of(new AxiomServerboundSpawnEntity.SpawnEntry(UUID.randomUUID(), position, 0.0f, 0.0f, null, compoundTag))).send();
    }

    public static void killRecursive(class_8113 display) {
        if (display.method_31481()) {
            return;
        }
        ArrayList<UUID> toKill = new ArrayList<UUID>();
        DisplayEntityHelper.addUuidOfSelfAndChildren(display, toKill);
        new AxiomServerboundDeleteEntity(toKill).send();
    }

    private static void addUuidOfSelfAndChildren(class_8113 display, List<UUID> uuids) {
        if (!display.method_31481()) {
            uuids.add(display.method_5667());
            for (class_1297 passenger : display.method_5685()) {
                if (!(passenger instanceof class_8113)) continue;
                class_8113 displayPassenger = (class_8113)passenger;
                DisplayEntityHelper.addUuidOfSelfAndChildren(displayPassenger, uuids);
            }
        }
    }

    public static void applyDataTo(class_8113 display, DisplayEntityObject object) {
        if (!display.method_31481()) {
            new AxiomServerboundManipulateEntity(List.of(new AxiomServerboundManipulateEntity.ManipulateEntry(display.method_5667(), null, object.getNbt((Integer)display.method_5841().method_12789(class_8113.field_42369) != -1)))).send();
        }
    }

    @Nullable
    public static class_2487 getDisplayEntityTagWithId(class_8113 display) {
        class_2487 tag = EntityDataUtils.saveAsPassenger((class_1297)display);
        if (tag == null) {
            return null;
        }
        DisplayEntityHelper.processDisplayEntityTag(tag);
        return tag;
    }

    public static String getSummonCommandForDisplay(class_8113 display) {
        class_2487 tag = EntityDataUtils.saveWithoutId((class_1297)display);
        DisplayEntityHelper.processDisplayEntityTag(tag);
        String nbt = new class_5625("", 0, new ArrayList()).method_32283((class_2520)tag);
        return "/summon " + String.valueOf(class_1299.method_5890((class_1299)display.method_5864())) + " ~ ~ ~ " + nbt;
    }

    public static String getInterpolateCommandForDisplay(class_8113 display) {
        class_2487 tag = EntityDataUtils.saveWithoutId((class_1297)display);
        class_2487 transformation = tag.method_10562("transformation");
        class_2487 interpolateTag = new class_2487();
        interpolateTag.method_10566("start_interpolation", (class_2520)class_2497.method_23247((int)-1));
        interpolateTag.method_10566("transformation", (class_2520)transformation);
        String nbt = new class_5625("", 0, new ArrayList()).method_32283((class_2520)interpolateTag);
        return "/data merge entity " + display.method_5845() + " " + nbt;
    }

    private static void processDisplayEntityTag(class_2487 tag) {
        tag.method_10551("Pos");
        tag.method_10551("UUID");
        DisplayEntityHelper.removeIfMatches(tag, "Motion", (class_2520)DisplayEntityHelper.newDoubleList(0.0, 0.0, 0.0));
        DisplayEntityHelper.removeIfMatches(tag, "Rotation", (class_2520)DisplayEntityHelper.newFloatList(0.0f, 0.0f));
        DisplayEntityHelper.removeIfMatches(tag, "Invulnerable", (class_2520)class_2481.method_23234((boolean)false));
        tag.method_10551("fall_distance");
        tag.method_10551("Fire");
        tag.method_10551("Air");
        tag.method_10551("OnGround");
        tag.method_10551("PortalCooldown");
        DisplayEntityHelper.removeIfMatches(tag, "transformation", DEFAULT_TRANSFORMATION);
        DisplayEntityHelper.removeIfMatches(tag, "billboard", DEFAULT_BILLBOARD);
        DisplayEntityHelper.removeIfMatches(tag, "interpolation_duration", (class_2520)class_2497.method_23247((int)0));
        DisplayEntityHelper.removeIfMatches(tag, "teleport_duration", (class_2520)class_2497.method_23247((int)0));
        DisplayEntityHelper.removeIfMatches(tag, "view_range", (class_2520)class_2494.method_23244((float)1.0f));
        DisplayEntityHelper.removeIfMatches(tag, "shadow_radius", (class_2520)class_2494.method_23244((float)0.0f));
        DisplayEntityHelper.removeIfMatches(tag, "shadow_strength", (class_2520)class_2494.method_23244((float)1.0f));
        DisplayEntityHelper.removeIfMatches(tag, "width", (class_2520)class_2494.method_23244((float)0.0f));
        DisplayEntityHelper.removeIfMatches(tag, "height", (class_2520)class_2494.method_23244((float)0.0f));
        DisplayEntityHelper.removeIfMatches(tag, "glow_color_override", (class_2520)class_2497.method_23247((int)-1));
        DisplayEntityHelper.removeIfMatches(tag, "item_display", DEFAULT_ITEM_DISPLAY);
        class_2499 passengers = NbtHelper.getList(tag, "Passengers", 10);
        Iterator iterator = passengers.iterator();
        while (iterator.hasNext()) {
            class_2487 passenger = (class_2487)iterator.next();
            String id = VersionUtilsNbt.helperCompoundTagGetStringOr(passenger, "id", "");
            if (id.isEmpty() || !VALID_PASSENGER_IDS.contains(id)) {
                iterator.remove();
                continue;
            }
            DisplayEntityHelper.processDisplayEntityTag(passenger);
        }
    }

    private static void removeIfMatches(class_2487 tag, String key, class_2520 value) {
        class_2520 existing = tag.method_10580(key);
        if (existing == null) {
            return;
        }
        if (existing.equals((Object)value)) {
            tag.method_10551(key);
        }
    }

    private static class_2499 newDoubleList(double ... ds) {
        class_2499 listTag = new class_2499();
        for (double d : ds) {
            listTag.add((Object)class_2489.method_23241((double)d));
        }
        return listTag;
    }

    private static class_2499 newFloatList(float ... fs) {
        class_2499 listTag = new class_2499();
        for (float f : fs) {
            listTag.add((Object)class_2494.method_23244((float)f));
        }
        return listTag;
    }

    public static DisplayEntityObject getObjectFromEntity(class_8113 display) {
        class_2945 data = display.method_5841();
        int brightnessData = (Integer)data.method_12789(class_8113.field_42369);
        class_8104 brightness = brightnessData != -1 ? class_8104.method_48764((int)brightnessData) : null;
        DisplayEntityObject.GenericDisplayEntityData genericDisplayEntityData = new DisplayEntityObject.GenericDisplayEntityData(((Float)data.method_12789(class_8113.field_42373)).floatValue(), ((Float)data.method_12789(class_8113.field_42374)).floatValue(), (Integer)data.method_12789(DisplayAccessor.getDataTransformationInterpolationDurationId()), (Integer)data.method_12789(DisplayAccessor.getDataPosRotInterpolationId()), (Integer)data.method_12789(class_8113.field_42375), (class_8113.class_8114)class_8113.class_8114.field_42411.apply(((Byte)data.method_12789(class_8113.field_42368)).byteValue()), brightness != null, brightness == null ? 0 : brightness.comp_1240(), brightness == null ? 0 : brightness.comp_1241(), ((Float)data.method_12789(class_8113.field_42371)).floatValue(), ((Float)data.method_12789(class_8113.field_42372)).floatValue(), ((Float)data.method_12789(class_8113.field_42370)).floatValue());
        if (display instanceof class_8113.class_8122) {
            return new DisplayEntityObject.DisplayEntityItemObject((class_1799)data.method_12789(class_8113.class_8122.field_42423), (class_811)class_811.field_42469.apply(((Byte)data.method_12789(class_8113.class_8122.field_42424)).byteValue()), genericDisplayEntityData, null, null);
        }
        if (display instanceof class_8113.class_8115) {
            return new DisplayEntityObject.DisplayEntityBlockObject((class_2680)data.method_12789(class_8113.class_8115.field_42416), genericDisplayEntityData);
        }
        if (display instanceof class_8113.class_8123) {
            byte flags = (Byte)data.method_12789(class_8113.class_8123.field_42439);
            boolean shadow = (flags & 1) != 0;
            boolean seeThrough = (flags & 2) != 0;
            boolean useDefaultBackground = (flags & 4) != 0;
            class_8113.class_8123.class_8124 align = class_8113.class_8123.method_48902((byte)flags);
            class_2561 component = (class_2561)data.method_12789(class_8113.class_8123.field_42435);
            String collapsed = VersionUtils.legacyTryCollapseToString(component);
            String json = collapsed != null ? collapsed : SerializationUtils.componentToJson((class_2561)data.method_12789(class_8113.class_8123.field_42435), display.method_37908().method_30349());
            return new DisplayEntityObject.DisplayEntityTextObject(json, useDefaultBackground, (Integer)data.method_12789(class_8113.class_8123.field_42437), (Integer)data.method_12789(class_8113.class_8123.field_42436), align, seeThrough, shadow, ((Byte)data.method_12789(class_8113.class_8123.field_42438)).byteValue(), genericDisplayEntityData);
        }
        throw new FaultyImplementationError();
    }
}

