/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.noise;

import com.moulberry.axiom.noise.NoiseHelper;
import com.moulberry.axiom.noise.NoiseInterface;

public class SimplexNoise
implements NoiseInterface {
    private static final float SQRT3 = 1.7320508f;
    private static final float F2 = 0.3660254f;
    private static final float G2 = 0.21132487f;
    private final int seed;

    public SimplexNoise(long seed) {
        this.seed = Long.hashCode(seed);
    }

    @Override
    public float evaluate(double x, double y) {
        double s2 = (x + y) * 0.3660253882408142;
        double floorX = Math.floor(x += s2);
        double floorY = Math.floor(y += s2);
        int cellX = (int)floorX;
        int cellY = (int)floorY;
        float fracX = (float)(x - floorX);
        float fracY = (float)(y - floorY);
        int cellXPlusOne = (cellX *= 501125321) + 501125321;
        int cellYPlusOne = (cellY *= 1136930381) + 1136930381;
        float t2 = (fracX + fracY) * 0.21132487f;
        float x0 = fracX - t2;
        float y0 = fracY - t2;
        float a0 = 0.6666667f - x0 * x0 - y0 * y0;
        float value = a0 * a0 * (a0 * a0) * NoiseHelper.gradCoord(this.seed, cellX, cellY, x0, y0);
        float a1 = 3.1547005f * t2 + (-0.6666666f + a0);
        float x1 = x0 - 0.57735026f;
        float y1 = y0 - 0.57735026f;
        value += a1 * a1 * (a1 * a1) * NoiseHelper.gradCoord(this.seed, cellXPlusOne, cellYPlusOne, x1, y1);
        float xmyi = fracX - fracY;
        if (t2 > 0.21132487f) {
            if (fracX + xmyi > 1.0f) {
                x2 = x0 + -1.3660254f;
                y2 = y0 + -0.3660254f;
                a2 = 0.6666667f - x2 * x2 - y2 * y2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * NoiseHelper.gradCoord(this.seed, cellX + 1002250642, cellY + 1136930381, x2, y2);
                }
            } else {
                x2 = x0 + 0.21132487f;
                y2 = y0 + -0.7886751f;
                a2 = 0.6666667f - x2 * x2 - y2 * y2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * NoiseHelper.gradCoord(this.seed, cellX, cellY + 1136930381, x2, y2);
                }
            }
            if (fracY - xmyi > 1.0f) {
                x3 = x0 + -0.3660254f;
                y3 = y0 + -1.3660254f;
                a3 = 0.6666667f - x3 * x3 - y3 * y3;
                if (a3 > 0.0f) {
                    value += a3 * a3 * (a3 * a3) * NoiseHelper.gradCoord(this.seed, cellX + 501125321, cellY + -2021106534, x3, y3);
                }
            } else {
                x3 = x0 + -0.7886751f;
                y3 = y0 + 0.21132487f;
                a3 = 0.6666667f - x3 * x3 - y3 * y3;
                if (a3 > 0.0f) {
                    value += a3 * a3 * (a3 * a3) * NoiseHelper.gradCoord(this.seed, cellX + 501125321, cellY, x3, y3);
                }
            }
        } else {
            float a2;
            float y2;
            float x2;
            if (fracX + xmyi < 0.0f) {
                x2 = x0 + 0.7886751f;
                y2 = y0 - 0.21132487f;
                a2 = 0.6666667f - x2 * x2 - y2 * y2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * NoiseHelper.gradCoord(this.seed, cellX - 501125321, cellY, x2, y2);
                }
            } else {
                x2 = x0 + -0.7886751f;
                y2 = y0 + 0.21132487f;
                a2 = 0.6666667f - x2 * x2 - y2 * y2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * NoiseHelper.gradCoord(this.seed, cellX + 501125321, cellY, x2, y2);
                }
            }
            if (fracY < xmyi) {
                x2 = x0 - 0.21132487f;
                y2 = y0 - -0.7886751f;
                a2 = 0.6666667f - x2 * x2 - y2 * y2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * NoiseHelper.gradCoord(this.seed, cellX, cellY - 1136930381, x2, y2);
                }
            } else {
                x2 = x0 + 0.21132487f;
                y2 = y0 + -0.7886751f;
                a2 = 0.6666667f - x2 * x2 - y2 * y2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * NoiseHelper.gradCoord(this.seed, cellX, cellY + 1136930381, x2, y2);
                }
            }
        }
        return value * 9.120981f + 0.5f;
    }

    @Override
    public float evaluate(double x, double y, double z) {
        return SimplexNoise.evaluateStatic(x, y, z, this.seed);
    }

    public static float evaluateStatic(double x, double y, double z, int seed) {
        float aD;
        float a9;
        float a5;
        double xz = x + z;
        double s2 = xz * -0.211324865405187;
        z += s2 - y;
        double floorX = Math.floor(x += s2 - (y *= 0.577350269189626));
        double floorY = Math.floor(y += xz * 0.577350269189626);
        double floorZ = Math.floor(z);
        int cellX = (int)floorX;
        int cellY = (int)floorY;
        int cellZ = (int)floorZ;
        float fracX = (float)(x - floorX);
        float fracY = (float)(y - floorY);
        float fracZ = (float)(z - floorZ);
        cellX *= 501125321;
        cellY *= 1136930381;
        cellZ *= 1720413743;
        int seed2 = seed + 1293373;
        int xNMask = (int)(-0.5f - fracX);
        int yNMask = (int)(-0.5f - fracY);
        int zNMask = (int)(-0.5f - fracZ);
        float x0 = fracX + (float)xNMask;
        float y0 = fracY + (float)yNMask;
        float z0 = fracZ + (float)zNMask;
        float a0 = 0.75f - x0 * x0 - y0 * y0 - z0 * z0;
        float value = a0 * a0 * (a0 * a0) * NoiseHelper.gradCoord(seed, cellX + (xNMask & 0x1DDE90C9), cellY + (yNMask & 0x43C42E4D), cellZ + (zNMask & 0x668B6E2F), x0, y0, z0);
        float x1 = fracX - 0.5f;
        float y1 = fracY - 0.5f;
        float z1 = fracZ - 0.5f;
        float a1 = 0.75f - x1 * x1 - y1 * y1 - z1 * z1;
        value += a1 * a1 * (a1 * a1) * NoiseHelper.gradCoord(seed2, cellX + 501125321, cellY + 1136930381, cellZ + 1720413743, x1, y1, z1);
        float xAFlipMask0 = (float)((xNMask | 1) << 1) * x1;
        float yAFlipMask0 = (float)((yNMask | 1) << 1) * y1;
        float zAFlipMask0 = (float)((zNMask | 1) << 1) * z1;
        float xAFlipMask1 = (float)(-2 - (xNMask << 2)) * x1 - 1.0f;
        float yAFlipMask1 = (float)(-2 - (yNMask << 2)) * y1 - 1.0f;
        float zAFlipMask1 = (float)(-2 - (zNMask << 2)) * z1 - 1.0f;
        boolean skip5 = false;
        float a2 = xAFlipMask0 + a0;
        if (a2 > 0.0f) {
            float x2 = x0 - (float)(xNMask | 1);
            float y2 = y0;
            float z2 = z0;
            value += a2 * a2 * (a2 * a2) * NoiseHelper.gradCoord(seed, cellX + (~xNMask & 0x1DDE90C9), cellY + (yNMask & 0x43C42E4D), cellZ + (zNMask & 0x668B6E2F), x2, y2, z2);
        } else {
            float a4;
            float a3 = yAFlipMask0 + zAFlipMask0 + a0;
            if (a3 > 0.0f) {
                float x3 = x0;
                float y3 = y0 - (float)(yNMask | 1);
                float z3 = z0 - (float)(zNMask | 1);
                value += a3 * a3 * (a3 * a3) * NoiseHelper.gradCoord(seed, cellX + (xNMask & 0x1DDE90C9), cellY + (~yNMask & 0x43C42E4D), cellZ + (~zNMask & 0x668B6E2F), x3, y3, z3);
            }
            if ((a4 = xAFlipMask1 + a1) > 0.0f) {
                float x4 = (float)(xNMask | 1) + x1;
                float y4 = y1;
                float z4 = z1;
                value += a4 * a4 * (a4 * a4) * NoiseHelper.gradCoord(seed2, cellX + (xNMask & 0x3BBD2192), cellY + 1136930381, cellZ + 1720413743, x4, y4, z4);
                skip5 = true;
            }
        }
        boolean skip9 = false;
        float a6 = yAFlipMask0 + a0;
        if (a6 > 0.0f) {
            float x6 = x0;
            float y6 = y0 - (float)(yNMask | 1);
            float z6 = z0;
            value += a6 * a6 * (a6 * a6) * NoiseHelper.gradCoord(seed, cellX + (xNMask & 0x1DDE90C9), cellY + (~yNMask & 0x43C42E4D), cellZ + (zNMask & 0x668B6E2F), x6, y6, z6);
        } else {
            float a8;
            float a7 = xAFlipMask0 + zAFlipMask0 + a0;
            if (a7 > 0.0f) {
                float x7 = x0 - (float)(xNMask | 1);
                float y7 = y0;
                float z7 = z0 - (float)(zNMask | 1);
                value += a7 * a7 * (a7 * a7) * NoiseHelper.gradCoord(seed, cellX + (~xNMask & 0x1DDE90C9), cellY + (yNMask & 0x43C42E4D), cellZ + (~zNMask & 0x668B6E2F), x7, y7, z7);
            }
            if ((a8 = yAFlipMask1 + a1) > 0.0f) {
                float x8 = x1;
                float y8 = (float)(yNMask | 1) + y1;
                float z8 = z1;
                value += a8 * a8 * (a8 * a8) * NoiseHelper.gradCoord(seed2, cellX + 501125321, cellY + (yNMask & 0x87885C9A), cellZ + 1720413743, x8, y8, z8);
                skip9 = true;
            }
        }
        boolean skipD = false;
        float aA = zAFlipMask0 + a0;
        if (aA > 0.0f) {
            float xA = x0;
            float yA = y0;
            float zA = z0 - (float)(zNMask | 1);
            value += aA * aA * (aA * aA) * NoiseHelper.gradCoord(seed, cellX + (xNMask & 0x1DDE90C9), cellY + (yNMask & 0x43C42E4D), cellZ + (~zNMask & 0x668B6E2F), xA, yA, zA);
        } else {
            float aC;
            float aB = xAFlipMask0 + yAFlipMask0 + a0;
            if (aB > 0.0f) {
                float xB = x0 - (float)(xNMask | 1);
                float yB = y0 - (float)(yNMask | 1);
                float zB = z0;
                value += aB * aB * (aB * aB) * NoiseHelper.gradCoord(seed, cellX + (~xNMask & 0x1DDE90C9), cellY + (~yNMask & 0x43C42E4D), cellZ + (zNMask & 0x668B6E2F), xB, yB, zB);
            }
            if ((aC = zAFlipMask1 + a1) > 0.0f) {
                float xC = x1;
                float yC = y1;
                float zC = (float)(zNMask | 1) + z1;
                value += aC * aC * (aC * aC) * NoiseHelper.gradCoord(seed2, cellX + 501125321, cellY + 1136930381, cellZ + (zNMask & 0xCD16DC5E), xC, yC, zC);
                skipD = true;
            }
        }
        if (!skip5 && (a5 = yAFlipMask1 + zAFlipMask1 + a1) > 0.0f) {
            float x5 = x1;
            float y5 = (float)(yNMask | 1) + y1;
            float z5 = (float)(zNMask | 1) + z1;
            value += a5 * a5 * (a5 * a5) * NoiseHelper.gradCoord(seed2, cellX + 501125321, cellY + (yNMask & 0x87885C9A), cellZ + (zNMask & 0xCD16DC5E), x5, y5, z5);
        }
        if (!skip9 && (a9 = xAFlipMask1 + zAFlipMask1 + a1) > 0.0f) {
            float x9 = (float)(xNMask | 1) + x1;
            float y9 = y1;
            float z9 = (float)(zNMask | 1) + z1;
            value += a9 * a9 * (a9 * a9) * NoiseHelper.gradCoord(seed2, cellX + (xNMask & 0x3BBD2192), cellY + 1136930381, cellZ + (zNMask & 0xCD16DC5E), x9, y9, z9);
        }
        if (!skipD && (aD = xAFlipMask1 + yAFlipMask1 + a1) > 0.0f) {
            float xD = (float)(xNMask | 1) + x1;
            float yD = (float)(yNMask | 1) + y1;
            float zD = z1;
            value += aD * aD * (aD * aD) * NoiseHelper.gradCoord(seed2, cellX + (xNMask & 0x3BBD2192), cellY + (yNMask & 0x87885C9A), cellZ + 1720413743, xD, yD, zD);
        }
        return value * 4.523013f + 0.5f;
    }
}

