/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.packets.AxiomClientboundPacket;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.Dispatcher;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AxiomClientboundResponseChunkData
implements AxiomClientboundPacket {
    public static final class_2960 IDENTIFIER = new class_2960("axiom:response_chunk_data");
    private final long id;
    private final boolean finished;
    private final Long2ObjectMap<CompressedBlockEntity> compressedBlockEntities;
    private final Long2ObjectMap<class_2841<class_2680>> chunkSections;
    @Nullable
    private final class_2540 rawByteBuf;

    public AxiomClientboundResponseChunkData(long id, boolean finished, Long2ObjectMap<CompressedBlockEntity> compressedBlockEntities, Long2ObjectMap<class_2841<class_2680>> chunkSections) {
        this.id = id;
        this.finished = finished;
        this.compressedBlockEntities = compressedBlockEntities;
        this.chunkSections = chunkSections;
        this.rawByteBuf = null;
    }

    public AxiomClientboundResponseChunkData(@NotNull class_2540 rawByteBuf) {
        this.id = 0L;
        this.finished = false;
        this.compressedBlockEntities = null;
        this.chunkSections = null;
        this.rawByteBuf = rawByteBuf;
    }

    public static AxiomClientboundResponseChunkData read(class_2540 friendlyByteBuf) {
        long pos;
        long pos2;
        long id = friendlyByteBuf.readLong();
        Long2ObjectOpenHashMap compressedBlockEntities = new Long2ObjectOpenHashMap();
        while ((pos2 = friendlyByteBuf.readLong()) != PositionUtils.MIN_POSITION_LONG) {
            compressedBlockEntities.put(pos2, (Object)CompressedBlockEntity.read(friendlyByteBuf));
        }
        Long2ObjectOpenHashMap chunkSections = new Long2ObjectOpenHashMap();
        while ((pos = friendlyByteBuf.readLong()) != PositionUtils.MIN_POSITION_LONG) {
            if (friendlyByteBuf.readBoolean()) {
                class_2841<class_2680> container = DFUHelper.createPalettedContainer((class_2359<class_2680>)class_2248.field_10651, class_2246.field_10124.method_9564());
                container.method_12326(friendlyByteBuf);
                chunkSections.put(pos, container);
                continue;
            }
            chunkSections.put(pos, null);
        }
        boolean finished = friendlyByteBuf.readBoolean();
        return new AxiomClientboundResponseChunkData(id, finished, (Long2ObjectMap<CompressedBlockEntity>)compressedBlockEntities, (Long2ObjectMap<class_2841<class_2680>>)chunkSections);
    }

    @Override
    public class_2960 packetIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        if (this.rawByteBuf != null) {
            friendlyByteBuf.method_52975((ByteBuf)this.rawByteBuf);
            return;
        }
        friendlyByteBuf.method_52974(this.id);
        for (Long2ObjectMap.Entry entry : this.compressedBlockEntities.long2ObjectEntrySet()) {
            friendlyByteBuf.method_52974(entry.getLongKey());
            ((CompressedBlockEntity)entry.getValue()).write(friendlyByteBuf);
        }
        friendlyByteBuf.method_52974(PositionUtils.MIN_POSITION_LONG);
        for (Long2ObjectMap.Entry entry : this.chunkSections.long2ObjectEntrySet()) {
            friendlyByteBuf.method_52974(entry.getLongKey());
            class_2841 container = (class_2841)entry.getValue();
            if (container == null) {
                friendlyByteBuf.method_52964(false);
                continue;
            }
            friendlyByteBuf.method_52964(true);
            ((class_2841)entry.getValue()).method_12325(friendlyByteBuf);
        }
        friendlyByteBuf.method_52974(PositionUtils.MIN_POSITION_LONG);
        friendlyByteBuf.method_52964(this.finished);
    }

    @Override
    public void handle(class_310 client, class_5455 registryAccess) {
        Dispatcher.finishRequestChunkData(this.id, this.finished, this.compressedBlockEntities, this.chunkSections);
    }

    public static void register() {
        AxiomClientboundPacket.register(IDENTIFIER, AxiomClientboundResponseChunkData::read);
    }
}

