/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.screen;

import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.Dummy;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.displayentity.DisplayEntityHelper;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import com.moulberry.axiom.displayentity.DisplayEntityObject;
import com.moulberry.axiom.displayentity.GizmoMode;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.screen.CreateDisplayEntityScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4590;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_8113;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EditDisplayEntityScreen
extends class_437 {
    private static final class_2960 BACKGROUND = new class_2960("axiom:background");
    private int leftPos;
    private int topPos;
    private int menuWidth;
    private int menuHeight;
    private UUID editingEntityUuid;
    private boolean showGroupWithNearby = false;
    private float groupNearbyRange = 1.0f;
    private boolean editTransformationScreen = false;
    private Vector3f translation;
    private Quaternionf left;
    private Vector3f scale;
    private Quaternionf right;

    public EditDisplayEntityScreen(UUID editingEntityUuid) {
        super((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.title"));
        this.editingEntityUuid = editingEntityUuid;
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        if (this.editTransformationScreen) {
            this.initEditTransformation();
        } else {
            this.initMain();
        }
    }

    private void initMain() {
        this.menuWidth = 320;
        this.menuHeight = 195;
        this.leftPos = (this.field_22789 - this.menuWidth) / 2;
        this.topPos = (this.field_22790 - this.menuHeight) / 2;
        int y = this.topPos + 17;
        int x = this.leftPos + 8;
        int itemWidth = 150;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.edit_properties"), button -> {
            DisplayEntityObject input = DisplayEntityHelper.getObjectFromEntity(DisplayEntityManipulator.getActiveDisplayEntity());
            class_310.method_1551().method_1507((class_437)new CreateDisplayEntityScreen(input, object -> {
                if (this.closeSanityCheck()) {
                    return;
                }
                DisplayEntityHelper.applyDataTo(DisplayEntityManipulator.getActiveDisplayEntity(), object);
            }, true));
        }).method_46434(x, y, itemWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.edit_transformation"), button -> {
            this.editTransformationScreen = true;
            this.method_25426();
        }).method_46434(x, y += 24, itemWidth, 20).method_46431());
        y += 24;
        class_8113 currentDisplay = DisplayEntityManipulator.getActiveDisplayEntity();
        Vector3f currentTranslation = (Vector3f)currentDisplay.method_5841().method_12789(class_8113.field_42401);
        Quaternionf currentLeft = (Quaternionf)currentDisplay.method_5841().method_12789(class_8113.field_42403);
        Vector3f currentScale = (Vector3f)currentDisplay.method_5841().method_12789(class_8113.field_42402);
        Quaternionf currentRight = (Quaternionf)currentDisplay.method_5841().method_12789(class_8113.field_42367);
        class_339 resetTranslation = (class_339)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.reset_translation"), button -> {
            if (this.closeSanityCheck()) {
                return;
            }
            class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
            Quaternionf left = (Quaternionf)display.method_5841().method_12789(class_8113.field_42403);
            Vector3f scale = (Vector3f)display.method_5841().method_12789(class_8113.field_42402);
            Quaternionf right = (Quaternionf)display.method_5841().method_12789(class_8113.field_42367);
            Matrix4f matrix = new Matrix4f();
            matrix.rotate((Quaternionfc)left);
            matrix.scale((Vector3fc)scale);
            matrix.rotate((Quaternionfc)right);
            DisplayEntityHelper.applyTransformation(display, matrix);
            this.method_25426();
        }).method_46434(x, y, itemWidth, 20).method_46431());
        if (currentTranslation.x == 0.0f && currentTranslation.y == 0.0f && currentTranslation.z == 0.0f) {
            resetTranslation.field_22763 = false;
        }
        class_339 resetRotation = (class_339)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.reset_rotation"), button -> {
            if (this.closeSanityCheck()) {
                return;
            }
            class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
            Vector3f translation = (Vector3f)display.method_5841().method_12789(class_8113.field_42401);
            Vector3f scale = (Vector3f)display.method_5841().method_12789(class_8113.field_42402);
            Matrix4f matrix = new Matrix4f();
            matrix.translate((Vector3fc)translation);
            matrix.scale((Vector3fc)scale);
            DisplayEntityHelper.applyTransformation(display, matrix);
            this.method_25426();
        }).method_46434(x, y += 24, itemWidth, 20).method_46431());
        if (BrushShape.isQuaternionIdentity(currentLeft) && BrushShape.isQuaternionIdentity(currentRight)) {
            resetRotation.field_22763 = false;
        }
        class_339 resetScale = (class_339)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.reset_scale"), button -> {
            if (this.closeSanityCheck()) {
                return;
            }
            class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
            Vector3f translation = (Vector3f)display.method_5841().method_12789(class_8113.field_42401);
            Quaternionf left = (Quaternionf)display.method_5841().method_12789(class_8113.field_42403);
            Quaternionf right = (Quaternionf)display.method_5841().method_12789(class_8113.field_42367);
            Matrix4f matrix = new Matrix4f();
            matrix.translate((Vector3fc)translation);
            matrix.rotate((Quaternionfc)left);
            matrix.rotate((Quaternionfc)right);
            DisplayEntityHelper.applyTransformation(display, matrix);
            this.method_25426();
        }).method_46434(x, y += 24, itemWidth, 20).method_46431());
        if ((double)Math.abs(currentScale.x - 1.0f) < 1.0E-5 && (double)Math.abs(currentScale.y - 1.0f) < 1.0E-5 && (double)Math.abs(currentScale.z - 1.0f) < 1.0E-5) {
            resetScale.field_22763 = false;
        }
        class_5676 gizmoModeButton = class_5676.method_32606(CreateDisplayEntityScreen::toComponent).method_32624((Object[])GizmoMode.values()).method_32619((Object)DisplayEntityManipulator.gizmoMode).method_32617(x, y += 24, itemWidth, 20, (class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.gizmo_mode"), (button, value) -> {
            DisplayEntityManipulator.gizmoMode = value;
        });
        this.method_37063((class_364)gizmoModeButton);
        x = this.leftPos + 8 + 160 - 6;
        y = this.topPos + 17;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.duplicate"), button -> {
            if (this.closeSanityCheck()) {
                return;
            }
            class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
            new AxiomServerboundSpawnEntity(List.of(new AxiomServerboundSpawnEntity.SpawnEntry(UUID.randomUUID(), display.method_19538(), display.method_36454(), display.method_36455(), display.method_5667(), null))).send();
            class_310.method_1551().method_1507(null);
        }).method_46434(x, y, itemWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.grouping"), button -> {
            this.showGroupWithNearby = !this.showGroupWithNearby;
            this.method_25426();
        }).method_46434(x, y += 24, itemWidth, 20).method_46431());
        if (this.showGroupWithNearby) {
            class_5250 initialTitle = class_2561.method_43469((String)"axiom.edit_display_entity.range", (Object[])new Object[]{class_2561.method_43470((String)String.format("%.2f", Float.valueOf(this.groupNearbyRange)))});
            this.method_37063((class_364)new class_357(x, y += 20, itemWidth, 20, (class_2561)initialTitle, this.groupNearbyRange / 16.0f){

                protected void method_25346() {
                    class_5250 title = class_2561.method_43469((String)"axiom.edit_display_entity.range", (Object[])new Object[]{class_2561.method_43470((String)String.format("%.2f", Float.valueOf(EditDisplayEntityScreen.this.groupNearbyRange)))});
                    this.method_25355((class_2561)title);
                }

                protected void method_25344() {
                    EditDisplayEntityScreen.this.groupNearbyRange = (float)this.field_22753 * 16.0f;
                }
            });
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.group_with_nearby_in_range"), button -> {
                if (this.closeSanityCheck()) {
                    return;
                }
                class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
                if (display.method_5765()) {
                    return;
                }
                ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry> entries = new ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry>();
                class_243 displayPos = display.method_19538();
                float range = this.groupNearbyRange + 0.01f;
                class_238 aabb = new class_238(displayPos.field_1352 - (double)range, displayPos.field_1351 - (double)range, displayPos.field_1350 - (double)range, displayPos.field_1352 + (double)range, displayPos.field_1351 + (double)range, displayPos.field_1350 + (double)range);
                ArrayList<UUID> passengers = new ArrayList<UUID>();
                EditDisplayEntityScreen.removeYawPitchDisplay(display, entries);
                for (class_8113 nearby : display.method_37908().method_18467(class_8113.class, aabb)) {
                    if (nearby.method_5765() || nearby == display) continue;
                    class_243 deltaToMain = nearby.method_19538().method_1020(displayPos);
                    EditDisplayEntityScreen.offsetDisplayRecursive(nearby, deltaToMain, display.method_19538(), entries);
                    passengers.add(nearby.method_5667());
                }
                entries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(display.method_5667(), AxiomServerboundManipulateEntity.PassengerManipulation.ADD_LIST, passengers));
                new AxiomServerboundManipulateEntity(entries).send();
                DisplayEntityManipulator.disableActive();
                class_310.method_1551().method_1507(null);
            }).method_46434(x, y += 20, itemWidth, 20).method_46431());
            class_4185 ungroupChildren = class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.ungroup_children"), button -> {
                if (this.closeSanityCheck()) {
                    return;
                }
                class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
                ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry> entries = new ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry>();
                EditDisplayEntityScreen.removeYawPitchDisplay(display, entries);
                entries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(display.method_5667(), AxiomServerboundManipulateEntity.PassengerManipulation.REMOVE_ALL, List.of()));
                for (class_1297 passenger : display.method_5685()) {
                    if (!(passenger instanceof class_8113)) continue;
                    class_8113 displayPassenger = (class_8113)passenger;
                    Matrix4f matrix4f = DisplayEntityManipulator.getTransformationMatrix(displayPassenger);
                    if (passenger instanceof class_8113.class_8115) {
                        matrix4f.translate(0.5f, 0.5f, 0.5f);
                    }
                    Quaternionf orientation = EditDisplayEntityScreen.calculateStaticOrientation(displayPassenger.method_49777(), displayPassenger, new Quaternionf());
                    matrix4f.rotateLocal((Quaternionfc)orientation);
                    Vector3f translation = matrix4f.getTranslation(new Vector3f());
                    class_243 position = display.method_19538().method_1031((double)translation.x, (double)translation.y, (double)translation.z);
                    EditDisplayEntityScreen.offsetDisplayRecursive(displayPassenger, new class_243(translation.negate()), position, entries);
                }
                new AxiomServerboundManipulateEntity(entries).send();
                DisplayEntityManipulator.disableActive();
                class_310.method_1551().method_1507(null);
            }).method_46434(x, y += 20, itemWidth, 20).method_46431();
            if (DisplayEntityManipulator.getActiveDisplayEntity().method_5685().isEmpty()) {
                ungroupChildren.field_22763 = false;
            }
            this.method_37063((class_364)ungroupChildren);
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.remove"), button -> {
            if (this.closeSanityCheck()) {
                return;
            }
            DisplayEntityHelper.killRecursive(DisplayEntityManipulator.getActiveDisplayEntity());
            class_310.method_1551().method_1507(null);
        }).method_46434(x, y += 24, itemWidth, 20).method_46431());
        y += 24;
        if (!this.showGroupWithNearby) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.copy_summon_command"), button -> {
                if (this.closeSanityCheck()) {
                    return;
                }
                DisplayEntityManipulator.tryCopyToClipboard();
                class_310.method_1551().method_1507(null);
            }).method_46434(x, y, itemWidth, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.copy_coordinates"), button -> {
                if (this.closeSanityCheck()) {
                    return;
                }
                class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
                String coordinates = display.method_19538().field_1352 + " " + display.method_19538().field_1351 + " " + display.method_19538().field_1350;
                class_310.method_1551().field_1774.method_1455(coordinates);
                class_310.method_1551().method_1507(null);
            }).method_46434(x, y += 24, itemWidth, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"axiom.edit_display_entity.copy_transform_command"), button -> {
                if (this.closeSanityCheck()) {
                    return;
                }
                DisplayEntityManipulator.tryCopyInterpolateToClipboard();
                class_310.method_1551().method_1507(null);
            }).method_46434(x, y += 24, itemWidth, 20).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> class_310.method_1551().method_1507(null)).method_46434(this.leftPos + 8, this.topPos + this.menuHeight - 20 - 8, this.menuWidth - 16, 20).method_46431());
    }

    public static Quaternionf calculateStaticOrientation(class_8113.class_8229 renderState, class_8113 display, Quaternionf quaternionf) {
        if (renderState == null) {
            return quaternionf;
        }
        return EditDisplayEntityScreen.calculateStaticOrientation(renderState.comp_1329(), display, quaternionf);
    }

    private static Quaternionf calculateStaticOrientation(class_8113.class_8114 billboardConstraints, class_8113 display, Quaternionf quaternionf) {
        if (billboardConstraints == null) {
            return quaternionf;
        }
        return switch (billboardConstraints) {
            default -> throw new IncompatibleClassChangeError();
            case class_8113.class_8114.field_42406 -> quaternionf.rotationYXZ((float)(-Math.PI) / 180 * display.method_36454(), (float)Math.PI / 180 * display.method_36455(), 0.0f);
            case class_8113.class_8114.field_42408 -> quaternionf.rotationYXZ((float)(-Math.PI) / 180 * display.method_36454(), 0.0f, 0.0f);
            case class_8113.class_8114.field_42407 -> quaternionf.rotationYXZ(0.0f, (float)Math.PI / 180 * display.method_36455(), 0.0f);
            case class_8113.class_8114.field_42409 -> quaternionf.rotationYXZ(0.0f, 0.0f, 0.0f);
        };
    }

    private static void removeYawPitchDisplay(class_8113 display, List<AxiomServerboundManipulateEntity.ManipulateEntry> entries) {
        Matrix4f matrix4f = DisplayEntityManipulator.getTransformationMatrix(display);
        Quaternionf orientation = EditDisplayEntityScreen.calculateStaticOrientation(display.method_49777(), display, new Quaternionf());
        matrix4f.rotateLocal((Quaternionfc)orientation);
        class_4590 transformation = VersionUtils.helperTransformationNew((Matrix4fc)matrix4f);
        transformation.method_22937();
        class_4590.field_42532.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(tag -> {
            class_2487 root = new class_2487();
            root.method_10566("transformation", tag);
            entries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(display.method_5667(), Set.of(), display.method_19538(), 0.0f, 0.0f, root));
        });
        for (class_1297 passenger : display.method_5685()) {
            if (!(passenger instanceof class_8113)) continue;
            class_8113 displayPassenger = (class_8113)passenger;
            EditDisplayEntityScreen.removeYawPitchDisplay(displayPassenger, entries);
        }
    }

    private static void offsetDisplayRecursive(class_8113 display, class_243 delta, @Nullable class_243 newPosition, List<AxiomServerboundManipulateEntity.ManipulateEntry> entries) {
        Matrix4f matrix4f = DisplayEntityManipulator.getTransformationMatrix(display);
        Quaternionf orientation = EditDisplayEntityScreen.calculateStaticOrientation(display.method_49777(), display, new Quaternionf());
        matrix4f.rotateLocal((Quaternionfc)orientation);
        matrix4f.translateLocal((float)delta.field_1352, (float)delta.field_1351, (float)delta.field_1350);
        class_4590 transformation = VersionUtils.helperTransformationNew((Matrix4fc)matrix4f);
        transformation.method_22937();
        class_4590.field_42532.encodeStart((DynamicOps)class_2509.field_11560, (Object)transformation).result().ifPresent(tag -> {
            class_2487 root = new class_2487();
            root.method_10566("transformation", tag);
            entries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(display.method_5667(), Set.of(), newPosition != null ? newPosition : display.method_19538(), 0.0f, 0.0f, root));
        });
        for (class_1297 passenger : display.method_5685()) {
            if (!(passenger instanceof class_8113)) continue;
            class_8113 displayPassenger = (class_8113)passenger;
            EditDisplayEntityScreen.offsetDisplayRecursive(displayPassenger, delta, null, entries);
        }
    }

    private void initEditTransformation() {
        this.menuWidth = 195;
        this.menuHeight = 176;
        this.leftPos = (this.field_22789 - this.menuWidth) / 2;
        this.topPos = (this.field_22790 - this.menuHeight) / 2;
        int halfWidth = (this.menuWidth - 16) / 2 - 1;
        class_8113 originalDisplay = DisplayEntityManipulator.getActiveDisplayEntity();
        this.translation = new Vector3f((Vector3fc)originalDisplay.method_5841().method_12789(class_8113.field_42401));
        this.left = new Quaternionf((Quaternionfc)originalDisplay.method_5841().method_12789(class_8113.field_42403));
        this.scale = new Vector3f((Vector3fc)originalDisplay.method_5841().method_12789(class_8113.field_42402));
        this.right = new Quaternionf((Quaternionfc)originalDisplay.method_5841().method_12789(class_8113.field_42367));
        int x = this.leftPos + 8;
        int y = this.topPos + 6;
        this.method_37063((class_364)new CreateDisplayEntityScreen.BasicStringWidget(x + 1, y + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Translation (Offset)").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        this.createEditBox(this.translation.x, f -> {
            this.translation.x = f.floatValue();
        }, x, y += 10, 0, 3);
        this.createEditBox(this.translation.y, f -> {
            this.translation.y = f.floatValue();
        }, x, y, 1, 3);
        this.createEditBox(this.translation.z, f -> {
            this.translation.z = f.floatValue();
        }, x, y, 2, 3);
        this.method_37063((class_364)new CreateDisplayEntityScreen.BasicStringWidget(x + 1, (y += 24) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Left Rotation (Quaternion)").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        this.createEditBox(this.left.x, f -> {
            this.left.x = f.floatValue();
        }, x, y += 10, 0, 4);
        this.createEditBox(this.left.y, f -> {
            this.left.y = f.floatValue();
        }, x, y, 1, 4);
        this.createEditBox(this.left.z, f -> {
            this.left.z = f.floatValue();
        }, x, y, 2, 4);
        this.createEditBox(this.left.w, f -> {
            this.left.w = f.floatValue();
        }, x, y, 3, 4);
        this.method_37063((class_364)new CreateDisplayEntityScreen.BasicStringWidget(x + 1, (y += 24) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Scale").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        this.createEditBox(this.scale.x, f -> {
            this.scale.x = f.floatValue();
        }, x, y += 10, 0, 3);
        this.createEditBox(this.scale.y, f -> {
            this.scale.y = f.floatValue();
        }, x, y, 1, 3);
        this.createEditBox(this.scale.z, f -> {
            this.scale.z = f.floatValue();
        }, x, y, 2, 3);
        this.method_37063((class_364)new CreateDisplayEntityScreen.BasicStringWidget(x + 1, (y += 24) + 1, 0, 0, (class_2561)class_2561.method_43470((String)"Right Rotation (Quaternion)").method_27696(class_2583.field_24360.method_36139(0x404040)), this.field_22793));
        this.createEditBox(this.right.x, f -> {
            this.right.x = f.floatValue();
        }, x, y += 10, 0, 4);
        this.createEditBox(this.right.y, f -> {
            this.right.y = f.floatValue();
        }, x, y, 1, 4);
        this.createEditBox(this.right.z, f -> {
            this.right.z = f.floatValue();
        }, x, y, 2, 4);
        this.createEditBox(this.right.w, f -> {
            this.right.w = f.floatValue();
        }, x, y, 3, 4);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> class_310.method_1551().method_1507(null)).method_46434(this.leftPos + 8, this.topPos + this.menuHeight - 20 - 8, halfWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.leftPos + 8 + halfWidth + 1, this.topPos + this.menuHeight - 20 - 8, halfWidth, 20).method_46431());
    }

    public void method_25419() {
        super.method_25419();
        if (this.closeSanityCheck()) {
            return;
        }
        if (this.editTransformationScreen) {
            class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
            Matrix4f matrix = new Matrix4f();
            matrix.translate((Vector3fc)this.translation);
            matrix.rotate((Quaternionfc)this.left);
            matrix.scale((Vector3fc)this.scale);
            matrix.rotate((Quaternionfc)this.right);
            DisplayEntityHelper.applyTransformation(display, matrix);
            DisplayEntityManipulator.disableActive();
        }
    }

    private void createEditBox(float initialValue, Consumer<Float> setter, int x, int y, int index, int count) {
        int width = 179 / count;
        class_342 editBox = new class_342(this.field_22793, x + (width + 1) * index, y, width, 20, class_5244.field_39003);
        if (Math.round(initialValue) * 1000 == Math.round(initialValue * 1000.0f)) {
            editBox.method_1852(String.valueOf(Math.round(initialValue)));
        } else {
            editBox.method_1852(String.format(Locale.ROOT, "%.3f", Float.valueOf(initialValue)));
        }
        editBox.method_1863(string -> {
            try {
                setter.accept(Float.valueOf(Float.parseFloat(string)));
                editBox.method_1868(-1);
            }
            catch (Exception e) {
                editBox.method_1868(-65536);
            }
        });
        this.method_37063((class_364)editBox);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        VersionUtilsClient.genericBlitSprite(guiGraphics, Dummy.GUI_TEXTURED, BACKGROUND, this.leftPos, this.topPos, this.menuWidth, this.menuHeight);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.closeSanityCheck()) {
            return;
        }
        if (!this.editTransformationScreen) {
            int y = this.topPos + 6;
            guiGraphics.method_51439(this.field_22793, this.field_22785, this.leftPos + 8, y, -12566464, false);
        }
    }

    private boolean closeSanityCheck() {
        class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
        if (display == null || display.method_31481() || display.method_5667() != this.editingEntityUuid) {
            class_310.method_1551().method_1507(null);
            return true;
        }
        return false;
    }
}

