/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.worley;

import de.articdive.jnoise.core.api.noisegen.SeededExplicitNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.core.util.HashUtil;
import de.articdive.jnoise.core.util.vectors.Vector;
import de.articdive.jnoise.core.util.vectors.Vector1D;
import de.articdive.jnoise.core.util.vectors.Vector2D;
import de.articdive.jnoise.core.util.vectors.Vector3D;
import de.articdive.jnoise.core.util.vectors.Vector4D;
import de.articdive.jnoise.generators.noise_parameters.distance_functions.DistanceFunction;
import de.articdive.jnoise.generators.noise_parameters.distance_functions.DistanceFunctionType;
import de.articdive.jnoise.generators.noisegen.worley.WorleyNoiseResult;
import java.util.Random;
import java.util.function.IntToLongFunction;
import org.jetbrains.annotations.NotNull;

public final class WorleyNoiseGenerator
implements SeededExplicitNoiseGenerator<WorleyNoiseResult<Vector>> {
    private final long seed;
    private final DistanceFunction distanceFunction;
    private final IntToLongFunction fpAmountFunction;

    private WorleyNoiseGenerator(long seed, DistanceFunction distanceFunction, IntToLongFunction fpAmountFunction) {
        this.seed = seed;
        this.distanceFunction = distanceFunction;
        this.fpAmountFunction = fpAmountFunction;
    }

    @Override
    public double evaluateNoise(double x, long seed) {
        return ((WorleyNoiseResult)this.evaluateNoiseResult(x, seed)).getValue();
    }

    @Override
    public double evaluateNoise(double x, double y, long seed) {
        return ((WorleyNoiseResult)this.evaluateNoiseResult(x, y, seed)).getValue();
    }

    @Override
    public double evaluateNoise(double x, double y, double z, long seed) {
        return ((WorleyNoiseResult)this.evaluateNoiseResult(x, y, z, seed)).getValue();
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w, long seed) {
        return ((WorleyNoiseResult)this.evaluateNoiseResult(x, y, z, w, seed)).getValue();
    }

    @Override
    public double evaluateNoise(double x) {
        return ((WorleyNoiseResult)this.evaluateNoiseResult(x, this.seed)).getValue();
    }

    @Override
    public double evaluateNoise(double x, double y) {
        return ((WorleyNoiseResult)this.evaluateNoiseResult(x, y, this.seed)).getValue();
    }

    @Override
    public double evaluateNoise(double x, double y, double z) {
        return ((WorleyNoiseResult)this.evaluateNoiseResult(x, y, z, this.seed)).getValue();
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w) {
        return ((WorleyNoiseResult)this.evaluateNoiseResult(x, y, z, w, this.seed)).getValue();
    }

    @Override
    @NotNull
    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, long seed) {
        long iX = (long)Math.floor(x);
        double shortestDistance = Double.MAX_VALUE;
        Vector1D closestPoint = null;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            long secX = iX + (long)xOffset;
            int hash = HashUtil.hash1D(seed, secX);
            Random fpRNG = new Random(hash);
            int i = 0;
            while ((long)i < Math.max(1L, Math.min(this.fpAmountFunction.applyAsLong(hash), 10L))) {
                double pointX = fpRNG.nextDouble() + (double)secX;
                double distance = this.distanceFunction.distance(x, pointX);
                if (distance < shortestDistance) {
                    shortestDistance = distance;
                    closestPoint = new Vector1D(pointX);
                }
                ++i;
            }
        }
        return new WorleyNoiseResult<Object>(shortestDistance, closestPoint);
    }

    @Override
    @NotNull
    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        double shortestDistance = Double.MAX_VALUE;
        Vector2D closestPoint = null;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            long secX = iX + (long)xOffset;
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                long secY = iY + (long)yOffset;
                int hash = HashUtil.hash2D(seed, secX, secY);
                Random fpRNG = new Random(hash);
                int i = 0;
                while ((long)i < Math.max(1L, Math.min(this.fpAmountFunction.applyAsLong(hash), 10L))) {
                    double pointY;
                    double pointX = fpRNG.nextDouble() + (double)secX;
                    double distance = this.distanceFunction.distance(x, y, pointX, pointY = fpRNG.nextDouble() + (double)secY);
                    if (distance < shortestDistance) {
                        shortestDistance = distance;
                        closestPoint = new Vector2D(pointX, pointY);
                    }
                    ++i;
                }
            }
        }
        return new WorleyNoiseResult<Object>(shortestDistance, closestPoint);
    }

    @Override
    @NotNull
    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, double z, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        double shortestDistance = Double.MAX_VALUE;
        Vector3D closestPoint = null;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            long secX = iX + (long)xOffset;
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                long secY = iY + (long)yOffset;
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    long secZ = iZ + (long)zOffset;
                    int hash = HashUtil.hash3D(seed, secX, secY, secZ);
                    Random fpRNG = new Random(hash);
                    int i = 0;
                    while ((long)i < Math.max(1L, Math.min(this.fpAmountFunction.applyAsLong(hash), 10L))) {
                        double pointZ;
                        double pointY;
                        double pointX = fpRNG.nextDouble() + (double)secX;
                        double distance = this.distanceFunction.distance(x, y, z, pointX, pointY = fpRNG.nextDouble() + (double)secY, pointZ = fpRNG.nextDouble() + (double)secZ);
                        if (distance < shortestDistance) {
                            shortestDistance = distance;
                            closestPoint = new Vector3D(pointX, pointY, pointZ);
                        }
                        ++i;
                    }
                }
            }
        }
        return new WorleyNoiseResult<Object>(shortestDistance, closestPoint);
    }

    @Override
    @NotNull
    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, double z, double w, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        long iW = (long)Math.floor(w);
        double shortestDistance = Double.MAX_VALUE;
        Vector4D closestPoint = null;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            long secX = iX + (long)xOffset;
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                long secY = iY + (long)yOffset;
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    long secZ = iZ + (long)zOffset;
                    for (int wOffset = -1; wOffset <= 1; ++wOffset) {
                        long secW = iW + (long)wOffset;
                        int hash = HashUtil.hash4D(seed, secX, secY, secZ, secW);
                        Random fpRNG = new Random(hash);
                        int i = 0;
                        while ((long)i < Math.max(1L, Math.min(this.fpAmountFunction.applyAsLong(hash), 10L))) {
                            double pointW;
                            double pointZ;
                            double pointY;
                            double pointX = fpRNG.nextDouble() + (double)secX;
                            double distance = this.distanceFunction.distance(x, y, z, w, pointX, pointY = fpRNG.nextDouble() + (double)secY, pointZ = fpRNG.nextDouble() + (double)secZ, pointW = fpRNG.nextDouble() + (double)secW);
                            if (distance < shortestDistance) {
                                shortestDistance = distance;
                                closestPoint = new Vector4D(pointX, pointY, pointZ, pointW);
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        return new WorleyNoiseResult<Object>(shortestDistance, closestPoint);
    }

    @Override
    @NotNull
    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x) {
        return this.evaluateNoiseResult(x, this.seed);
    }

    @Override
    @NotNull
    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y) {
        return this.evaluateNoiseResult(x, y, this.seed);
    }

    @Override
    @NotNull
    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, double z) {
        return this.evaluateNoiseResult(x, y, z, this.seed);
    }

    @Override
    @NotNull
    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, double z, double w) {
        return this.evaluateNoiseResult(x, y, z, w, this.seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @NotNull
    public static WorleyNoiseBuilder newBuilder() {
        return new WorleyNoiseBuilder();
    }

    public static final class WorleyNoiseBuilder
    implements NoiseSourceBuilder {
        private long seed = 1729L;
        private DistanceFunction distanceFunction = DistanceFunctionType.EUCLIDEAN_SQUARED;
        private IntToLongFunction fpAmountFunction = i -> 1L;

        private WorleyNoiseBuilder() {
        }

        @NotNull
        public WorleyNoiseBuilder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        @NotNull
        public WorleyNoiseBuilder setDistanceFunction(DistanceFunction distanceFunction) {
            if (distanceFunction == null) {
                throw new IllegalArgumentException("Distance function cannot be null.");
            }
            this.distanceFunction = distanceFunction;
            return this;
        }

        @NotNull
        public WorleyNoiseBuilder setFeaturePointAmountFunction(IntToLongFunction fpAmountFunction) {
            if (fpAmountFunction == null) {
                throw new IllegalArgumentException("Featurepoint amount function cannot be null.");
            }
            this.fpAmountFunction = fpAmountFunction;
            return this;
        }

        @Override
        @NotNull
        public WorleyNoiseGenerator build() {
            return new WorleyNoiseGenerator(this.seed, this.distanceFunction, this.fpAmountFunction);
        }
    }
}

