/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.utils.ColourUtils;
import com.moulberry.axiom.utils.OkLabColourUtils;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_7764;
import net.minecraft.class_777;

public class BlockColourComputation {
    private static final Set<String> ERRORED_MODS = new HashSet<String>();
    private static final class_2350[] MODEL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033, null};

    public static List<BlockColourResult> calculateColours(Collection<class_2680> blockStates) {
        class_776 renderManager = class_310.method_1551().method_1541();
        LinkedHashMap<Object, Object2IntOpenHashMap<class_2680>> spriteTargetMap = new LinkedHashMap<Object, Object2IntOpenHashMap<class_2680>>();
        LinkedHashMap<Object, ForkJoinTask<double[]>> calculateLabTasks = new LinkedHashMap<Object, ForkJoinTask<double[]>>();
        HashSet<class_2680> ignore = new HashSet<class_2680>();
        for (class_2680 class_26802 : blockStates) {
            BlockColourComputation.extractSpriteTargets(class_26802, renderManager, spriteTargetMap, calculateLabTasks, ignore);
        }
        LinkedHashMap<class_2680, BlockInformation> infoForBlockState = new LinkedHashMap<class_2680, BlockInformation>();
        for (Map.Entry entry : calculateLabTasks.entrySet()) {
            Object sprite = entry.getKey();
            double[] lab = (double[])((ForkJoinTask)entry.getValue()).join();
            if (lab == null || lab[3] <= 0.0) continue;
            for (Object2IntMap.Entry spriteEntry : ((Object2IntOpenHashMap)spriteTargetMap.get(sprite)).object2IntEntrySet()) {
                class_2680 blockState = (class_2680)spriteEntry.getKey();
                int countMultiplier = spriteEntry.getIntValue();
                BlockInformation info = infoForBlockState.computeIfAbsent(blockState, k -> new BlockInformation());
                info.l += lab[0] * (double)countMultiplier;
                info.a += lab[1] * (double)countMultiplier;
                info.b += lab[2] * (double)countMultiplier;
                info.alpha += lab[3] * (double)countMultiplier;
                if (sprite instanceof class_7764) {
                    class_7764 spriteContents = (class_7764)sprite;
                    info.sprites.add(spriteContents);
                    continue;
                }
                if (sprite instanceof SpriteWithTint) {
                    SpriteWithTint spriteWithTint = (SpriteWithTint)sprite;
                    info.sprites.add(spriteWithTint.spriteContents());
                    continue;
                }
                throw new FaultyImplementationError();
            }
        }
        ArrayList<BlockColourResult> arrayList = new ArrayList<BlockColourResult>();
        for (Map.Entry entry : infoForBlockState.entrySet()) {
            class_2680 blockState = (class_2680)entry.getKey();
            BlockInformation information = (BlockInformation)entry.getValue();
            if (ignore.contains(blockState) || information.alpha < 1.0) continue;
            arrayList.add(new BlockColourResult(blockState, information.l / information.alpha, information.a / information.alpha, information.b / information.alpha, information.sprites.size()));
        }
        return arrayList;
    }

    private static void extractSpriteTargets(class_2680 blockState, class_776 renderManager, Map<Object, Object2IntOpenHashMap<class_2680>> spriteTargetMap, Map<Object, ForkJoinTask<double[]>> calculateLabTasks, Set<class_2680> ignore) {
        try {
            class_5819 rand = class_5819.method_43049((long)42L);
            class_1087 bakedModel = renderManager.method_3349(blockState);
            ArrayList quads = new ArrayList();
            for (class_2350 direction : MODEL_DIRECTIONS) {
                quads.addAll(bakedModel.method_4707(blockState, direction, rand));
            }
            Int2IntOpenHashMap cachedTints = new Int2IntOpenHashMap();
            for (class_777 quad : quads) {
                class_1058 sprite;
                if (quad == null || (sprite = quad.method_35788()) == null) continue;
                int tintColour = 0xFFFFFF;
                if (quad.method_3360()) {
                    try {
                        int tintIndex = quad.method_3359();
                        if (cachedTints.containsKey(tintIndex)) {
                            tintColour = cachedTints.get(tintIndex);
                        } else {
                            tintColour = class_310.method_1551().method_1505().method_1697(blockState, null, null, tintIndex);
                            cachedTints.put(tintIndex, tintColour);
                        }
                    }
                    catch (Exception e) {
                        class_2960 location = blockState.method_26204().method_40142().method_40237().method_29177();
                        String mod = location.method_12836();
                        if (!mod.equals("minecraft") && ERRORED_MODS.add(mod)) {
                            Axiom.LOGGER.warn("Mod {} threw an exception when asked for the color of {}. This is usually because the mod doesn't correctly handle null values for BlockAndTintGetter/BlockPos. The block has been excluded from the colour-related features of Axiom", mod, location, e);
                        }
                        ignore.add(blockState);
                        return;
                    }
                }
                class_7764 spriteContents = sprite.method_45851();
                class_1011 image = spriteContents.field_40540[0];
                if ((tintColour &= 0xFFFFFF) == 0xFFFFFF) {
                    calculateLabTasks.put(spriteContents, (ForkJoinTask<double[]>)ForkJoinPool.commonPool().submit((Callable)new CalculateLabTask(image)));
                    Object2IntOpenHashMap count = spriteTargetMap.computeIfAbsent(spriteContents, k -> new Object2IntOpenHashMap());
                    count.put((Object)blockState, count.getOrDefault((Object)blockState, 0) + 1);
                    continue;
                }
                SpriteWithTint spriteWithTint = new SpriteWithTint(spriteContents, tintColour);
                calculateLabTasks.put(spriteWithTint, (ForkJoinTask<double[]>)ForkJoinPool.commonPool().submit((Callable)new CalculateLabWithTintTask(image, tintColour)));
                Object2IntOpenHashMap count = spriteTargetMap.computeIfAbsent(spriteWithTint, k -> new Object2IntOpenHashMap());
                count.put((Object)blockState, count.getOrDefault((Object)blockState, 0) + 1);
            }
        }
        catch (Exception exception) {
            class_2960 location = blockState.method_26204().method_40142().method_40237().method_29177();
            String mod = location.method_12836();
            if (!mod.equals("minecraft") && ERRORED_MODS.add(mod)) {
                Axiom.LOGGER.warn("Mod {} threw an exception when trying to calculate the colour of {}. The block has been excluded from the colour-related features of Axiom", mod, location, exception);
            }
            ignore.add(blockState);
        }
    }

    private static final class BlockInformation {
        private double l = 0.0;
        private double a = 0.0;
        private double b = 0.0;
        private double alpha = 0.0;
        private final Set<class_7764> sprites = new HashSet<class_7764>();

        private BlockInformation() {
        }
    }

    private record SpriteWithTint(class_7764 spriteContents, int tint) {
    }

    public record BlockColourResult(class_2680 blockState, double l, double a, double b, int numTextures) {
    }

    private static final class CalculateLabTask
    implements Callable<double[]> {
        private final class_1011 image;

        private CalculateLabTask(class_1011 image) {
            this.image = image;
        }

        @Override
        public double[] call() {
            double[] lab = new double[4];
            double totalL = 0.0;
            double totalA = 0.0;
            double totalB = 0.0;
            double totalAlpha = 0.0;
            int width = this.image.method_4307();
            int height = this.image.method_4323();
            int lastArgb = 0;
            for (int u = 0; u < width; ++u) {
                for (int v = 0; v < height; ++v) {
                    int argb = ColourUtils.abgrToArgb(this.image.method_4315(u, v));
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha == 0) continue;
                    if (argb != lastArgb) {
                        lastArgb = argb;
                        int red = argb >> 16 & 0xFF;
                        int green = argb >> 8 & 0xFF;
                        int blue = argb & 0xFF;
                        OkLabColourUtils.rgb2lab(red, green, blue, lab);
                    }
                    float scale = (float)alpha / 255.0f;
                    totalL += lab[0] * (double)scale;
                    totalA += lab[1] * (double)scale;
                    totalB += lab[2] * (double)scale;
                    totalAlpha += (double)scale;
                }
            }
            lab[0] = totalL;
            lab[1] = totalA;
            lab[2] = totalB;
            lab[3] = totalAlpha;
            return lab;
        }
    }

    private static final class CalculateLabWithTintTask
    implements Callable<double[]> {
        private final class_1011 image;
        private final int tint;

        private CalculateLabWithTintTask(class_1011 image, int tint) {
            this.image = image;
            this.tint = tint;
        }

        @Override
        public double[] call() {
            double[] lab = new double[4];
            float redMult = (float)(this.tint >> 16 & 0xFF) / 255.0f;
            float greenMult = (float)(this.tint >> 8 & 0xFF) / 255.0f;
            float blueMult = (float)(this.tint & 0xFF) / 255.0f;
            double totalL = 0.0;
            double totalA = 0.0;
            double totalB = 0.0;
            double totalAlpha = 0.0;
            int width = this.image.method_4307();
            int height = this.image.method_4323();
            int lastArgb = 0;
            for (int u = 0; u < width; ++u) {
                for (int v = 0; v < height; ++v) {
                    int argb = ColourUtils.abgrToArgb(this.image.method_4315(u, v));
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha == 0) continue;
                    if (argb != lastArgb) {
                        lastArgb = argb;
                        int red = (int)((float)(argb >> 16 & 0xFF) * redMult);
                        int green = (int)((float)(argb >> 8 & 0xFF) * greenMult);
                        int blue = (int)((float)(argb & 0xFF) * blueMult);
                        OkLabColourUtils.rgb2lab(red, green, blue, lab);
                    }
                    float scale = (float)alpha / 255.0f;
                    totalL += lab[0] * (double)scale;
                    totalA += lab[1] * (double)scale;
                    totalB += lab[2] * (double)scale;
                    totalAlpha += (double)scale;
                }
            }
            lab[0] = totalL;
            lab[1] = totalA;
            lab[2] = totalB;
            lab[3] = totalAlpha;
            return lab;
        }
    }
}

