/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.axiom.databind.ser.std;

import com.fasterxml.jackson.axiom.core.JsonGenerator;
import com.fasterxml.jackson.axiom.databind.JavaType;
import com.fasterxml.jackson.axiom.databind.JsonMappingException;
import com.fasterxml.jackson.axiom.databind.JsonNode;
import com.fasterxml.jackson.axiom.databind.SerializerProvider;
import com.fasterxml.jackson.axiom.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.axiom.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.axiom.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.axiom.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class NullSerializer
extends StdSerializer<Object> {
    public static final NullSerializer instance = new NullSerializer();

    private NullSerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeNull();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        gen.writeNull();
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("null");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectNullFormat(typeHint);
    }
}

