/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import com.moulberry.axiom.utils.StringUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_1132;
import net.minecraft.class_1208;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3551;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class HotbarManager {
    private static int activeHotbarIndex = 0;
    private static Int2ObjectMap<class_1799> items = new Int2ObjectOpenHashMap();
    private static String location = null;
    private static String altLocation = null;
    private static int saveTimer = 0;
    private static ReentrantLock lock = new ReentrantLock();

    public static void clearPage() {
        lock.lock();
        try {
            int page = activeHotbarIndex / 9;
            int itemIndexOffset = page * 81;
            for (int i = 0; i < 81; ++i) {
                items.remove(i + itemIndexOffset);
            }
            activeHotbarIndex = page * 9;
            if (saveTimer <= 0) {
                saveTimer = 200;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void clearAll() {
        lock.lock();
        try {
            activeHotbarIndex = 0;
            items.clear();
            saveTimer = 0;
        }
        finally {
            lock.unlock();
        }
    }

    public static void tickSaving() {
        lock.lock();
        try {
            if (Objects.equals(location, "__global__") != Axiom.configuration.contextMenu.globalHotbars) {
                HotbarManager.updateLocation();
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (location == null || player == null) {
                saveTimer = 0;
                return;
            }
            if (saveTimer > 0 && --saveTimer == 0) {
                HotbarManager.trySave(player, true);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trySave(@Nullable class_746 player, boolean force) {
        block23: {
            Path altPath;
            Path hotbarDataPath;
            boolean isGlobal;
            block22: {
                block21: {
                    block20: {
                        boolean hasChanges;
                        lock.lock();
                        isGlobal = Objects.equals(location, "__global__");
                        if (force) break block20;
                        boolean bl = hasChanges = saveTimer > 0;
                        if (player != null && isGlobal) {
                            for (int i = 0; i < 9; ++i) {
                                boolean sameItem;
                                class_1799 itemStack = player.method_31548().method_5438(i);
                                class_1799 current = (class_1799)items.get(activeHotbarIndex * 9 + i);
                                if (itemStack.method_7960()) {
                                    sameItem = current == null || current.method_7960();
                                } else {
                                    boolean bl2 = sameItem = current != null && class_1799.method_7973((class_1799)itemStack, (class_1799)current);
                                }
                                if (sameItem) continue;
                                hasChanges = true;
                                if (itemStack.method_7960()) {
                                    items.remove(activeHotbarIndex * 9 + i);
                                    continue;
                                }
                                items.put(activeHotbarIndex * 9 + i, (Object)itemStack);
                            }
                        }
                        if (hasChanges) break block20;
                        lock.unlock();
                        return;
                    }
                    saveTimer = 0;
                    if (location != null) break block21;
                    lock.unlock();
                    return;
                }
                hotbarDataPath = Axiom.getInstance().getConfigDirectory().resolve("hotbars").resolve(location);
                Path path = altPath = altLocation == null ? null : Axiom.getInstance().getConfigDirectory().resolve("hotbars").resolve(altLocation);
                if (altPath != null && !Files.exists(hotbarDataPath, new LinkOption[0]) && Files.exists(altPath, new LinkOption[0])) {
                    hotbarDataPath = altPath;
                }
                if (activeHotbarIndex != 0 || !items.isEmpty()) break block22;
                Files.deleteIfExists(hotbarDataPath);
                if (altPath != null) {
                    Files.deleteIfExists(altPath);
                }
                lock.unlock();
                return;
            }
            try {
                try {
                    class_2487 compoundTag = new class_2487();
                    if (isGlobal) {
                        compoundTag.method_10556("AutomaticHotbarIndex", true);
                    } else {
                        compoundTag.method_10569("ActiveHotbarIndex", activeHotbarIndex);
                    }
                    compoundTag.method_10569("DataVersion", DFUHelper.DATA_VERSION);
                    class_2487 itemsTag = new class_2487();
                    for (Int2ObjectMap.Entry entry : items.int2ObjectEntrySet()) {
                        int key = entry.getIntKey();
                        class_1799 itemStack = (class_1799)entry.getValue();
                        if (itemStack.method_7960()) continue;
                        itemsTag.method_10566("" + key, ItemStackDataHelper.save(itemStack));
                    }
                    compoundTag.method_10566("Items", (class_2520)itemsTag);
                    Files.createDirectories(hotbarDataPath.getParent(), new FileAttribute[0]);
                    class_2507.method_30614((class_2487)compoundTag, (Path)hotbarDataPath);
                    if (altPath == null || altPath == hotbarDataPath || Files.exists(altPath, new LinkOption[0])) break block23;
                    try {
                        Files.createLink(altPath, hotbarDataPath);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    Axiom.LOGGER.error("Error saving hotbars", e);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void unload() {
        lock.lock();
        try {
            class_746 player = class_310.method_1551().field_1724;
            if (location != null) {
                HotbarManager.trySave(player, true);
            }
            location = null;
            altLocation = null;
            HotbarManager.clearAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLocation() {
        lock.lock();
        try {
            class_746 player = class_310.method_1551().field_1724;
            if (location != null) {
                HotbarManager.trySave(player, false);
            }
            String oldLocation = location;
            location = null;
            altLocation = null;
            if (player == null) {
                HotbarManager.clearAll();
                return;
            }
            class_1132 integratedServer = class_310.method_1551().method_1576();
            class_634 connection = class_310.method_1551().method_1562();
            if (Axiom.configuration.contextMenu.globalHotbars) {
                location = "__global__";
            } else if (integratedServer != null) {
                location = integratedServer.field_23784.method_27005();
            } else if (connection != null) {
                SocketAddress address = connection.method_48296().method_10755();
                if (address instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                    location = inetSocketAddress.getAddress().getHostAddress();
                } else {
                    location = address.toString();
                }
                if (ClientEvents.lastServerAddress != null) {
                    altLocation = ClientEvents.lastServerAddress.method_2952();
                    altLocation = StringUtils.sanitizePath(altLocation);
                }
            } else {
                HotbarManager.clearAll();
                return;
            }
            location = StringUtils.sanitizePath(location);
            if (!Objects.equals(oldLocation, location)) {
                HotbarManager.loadFromDisk(player);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void loadFromDisk(class_746 player) {
        block19: {
            HotbarManager.clearAll();
            if (location != null) {
                Path hotbarDataPath = Axiom.getInstance().getConfigDirectory().resolve("hotbars").resolve(location);
                if (!Files.exists(hotbarDataPath, new LinkOption[0])) {
                    if (altLocation == null) {
                        return;
                    }
                    hotbarDataPath = Axiom.getInstance().getConfigDirectory().resolve("hotbars").resolve(altLocation);
                    if (!Files.exists(hotbarDataPath, new LinkOption[0])) {
                        return;
                    }
                }
                try {
                    class_2487 compoundTag = class_2507.method_30613((Path)hotbarDataPath, (class_2505)class_2505.method_53898());
                    int currentDataVersion = DFUHelper.DATA_VERSION;
                    boolean automaticHotbarIndex = VersionUtilsNbt.helperCompoundTagGetBooleanOr(compoundTag, "AutomaticHotbarIndex", false);
                    activeHotbarIndex = Math.max(0, VersionUtilsNbt.helperCompoundTagGetIntOr(compoundTag, "ActiveHotbarIndex", 0));
                    int dataVersion = VersionUtilsNbt.helperCompoundTagGetIntOr(compoundTag, "DataVersion", currentDataVersion);
                    if (dataVersion > currentDataVersion) {
                        Axiom.LOGGER.info("Refusing to load hotbars since dataVersion (" + dataVersion + ") > currentDataVersion (" + currentDataVersion + ")");
                        break block19;
                    }
                    class_2487 itemsTag = compoundTag.method_10562("Items");
                    for (String key : itemsTag.method_10541()) {
                        class_1799 itemStack;
                        int keyInt = -1;
                        try {
                            keyInt = Integer.parseInt(key);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (keyInt < 0) continue;
                        class_2487 itemCompound = itemsTag.method_10562(key);
                        if (dataVersion != currentDataVersion) {
                            try {
                                Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)itemCompound);
                                Dynamic output = class_3551.method_15450().update(class_1208.field_5712, dynamic, dataVersion, currentDataVersion);
                                itemCompound = (class_2487)output.getValue();
                            }
                            catch (Exception e) {
                                Axiom.LOGGER.error("Failed to data fix item stack for hotbar", e);
                            }
                        }
                        if ((itemStack = ItemStackDataHelper.loadOrEmpty(itemCompound)).method_7960()) continue;
                        items.put(keyInt, (Object)itemStack);
                    }
                    if (dataVersion != currentDataVersion) {
                        HotbarManager.trySave(player, true);
                    }
                    if (!automaticHotbarIndex) break block19;
                    class_1799[] hotbarItems = new class_1799[9];
                    for (int i = 0; i < 9; ++i) {
                        hotbarItems[i] = player.method_31548().method_5438(i);
                    }
                    IntRBTreeSet hotbarIndexes = new IntRBTreeSet();
                    IntIterator intIterator = items.keySet().intIterator();
                    while (intIterator.hasNext()) {
                        hotbarIndexes.add(intIterator.nextInt() / 9);
                    }
                    intIterator = hotbarIndexes.intIterator();
                    while (intIterator.hasNext()) {
                        int candidateHotbarIndex = intIterator.nextInt();
                        boolean matches = true;
                        for (int i = 0; i < 9; ++i) {
                            class_1799 storedItemStack = (class_1799)items.get(candidateHotbarIndex * 9 + i);
                            if (hotbarItems[i].method_7960()) {
                                if (storedItemStack == null || storedItemStack.method_7960()) continue;
                                matches = false;
                                break;
                            }
                            if (storedItemStack != null && class_1799.method_7973((class_1799)hotbarItems[i], (class_1799)storedItemStack)) continue;
                            matches = false;
                            break;
                        }
                        if (!matches) continue;
                        activeHotbarIndex = candidateHotbarIndex;
                        break;
                    }
                }
                catch (Exception e) {
                    Axiom.LOGGER.error("Failed to load hotbars", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findHotbarWithMatchingItem(class_1799 matching) {
        lock.lock();
        try {
            for (Int2ObjectMap.Entry entry : items.int2ObjectEntrySet()) {
                int hotbarIndex;
                class_1799 itemStack = (class_1799)entry.getValue();
                if (itemStack == null || itemStack.method_7960() || (hotbarIndex = entry.getIntKey() / 9) == activeHotbarIndex) continue;
                if (!class_1799.method_31577((class_1799)matching, (class_1799)itemStack)) continue;
                int n = hotbarIndex;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public static int getActiveHotbarIndex() {
        return activeHotbarIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActiveHotbarIndex(int activeHotbarIndex) {
        lock.lock();
        try {
            if (activeHotbarIndex == HotbarManager.activeHotbarIndex) {
                return;
            }
            class_636 gameMode = class_310.method_1551().field_1761;
            if (gameMode == null) {
                return;
            }
            if (!class_310.method_1551().field_1724.method_56992()) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                class_1799 oldStack = player.method_31548().method_5438(i);
                if (oldStack.method_7960()) {
                    items.remove(HotbarManager.activeHotbarIndex * 9 + i);
                } else {
                    items.put(HotbarManager.activeHotbarIndex * 9 + i, (Object)oldStack);
                }
                class_1799 itemStack = HotbarManager.getItemStack(activeHotbarIndex, i);
                player.method_31548().method_5447(i, itemStack);
                gameMode.method_2909(itemStack, 36 + i);
            }
            HotbarManager.activeHotbarIndex = activeHotbarIndex;
            player.field_7498.method_7623();
            if (saveTimer <= 0) {
                saveTimer = 200;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setItemStack(int hotbarIndex, int itemIndex, class_1799 itemStack) {
        lock.lock();
        try {
            if (hotbarIndex == activeHotbarIndex) {
                class_636 gameMode = class_310.method_1551().field_1761;
                if (gameMode == null) {
                    return;
                }
                if (!class_310.method_1551().field_1724.method_56992()) {
                    return;
                }
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return;
                }
                player.method_31548().method_5447(itemIndex, itemStack);
                gameMode.method_2909(itemStack, 36 + itemIndex);
                player.field_7498.method_7623();
            } else {
                if (itemStack.method_7960()) {
                    items.remove(hotbarIndex * 9 + itemIndex);
                } else {
                    items.put(hotbarIndex * 9 + itemIndex, (Object)itemStack.method_7972());
                }
                if (saveTimer <= 0) {
                    saveTimer = 200;
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static class_1799 getItemStack(int hotbarIndex, int itemIndex) {
        lock.lock();
        try {
            if (hotbarIndex == activeHotbarIndex) {
                class_1799 class_17992 = class_310.method_1551().field_1724.method_31548().method_5438(itemIndex).method_7972();
                return class_17992;
            }
            class_1799 class_17993 = Objects.requireNonNullElse((class_1799)items.get(hotbarIndex * 9 + itemIndex), class_1799.field_8037).method_7972();
            return class_17993;
        }
        finally {
            lock.unlock();
        }
    }
}

