/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.Position2dSet;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.scaling.RotSprite;
import com.moulberry.axiom.scaling.Scale3x;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.utils.BlockVoxelShapeUtils;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.EntityDataUtils;
import com.moulberry.axiom.utils.IntMatrix;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.utils.RenderHelper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.ClientBlockEntitySerializer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.DeleteEntityAdditionalUndoOperation;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public enum Placement {
    INSTANCE;

    private static final int CUTOUT_LIMIT = 65536;
    private ChunkedBlockRegion blockRegion;
    private ChunkedBlockRegion scaled3xBlockRegion;
    private Matrix4f partialRotationMatrix;
    private Long2ObjectMap<CompressedBlockEntity> blockEntities = null;
    public List<class_2487> entities = null;
    private IntMatrix entityRotationMatrix = null;
    public boolean containsAir = false;
    private class_2338 lastTargetPosition;
    private Gizmo gizmo;
    private PositionSet cutoutPositionSet = null;
    private String placementDescription = null;
    private final AtomicInteger placementId = new AtomicInteger();
    public boolean keepExisting = false;
    private boolean lastKeepExisting = false;
    public boolean prioritizeFullBlocks = false;
    private boolean lastPrioritizeFullBlocks = false;
    public boolean pasteAir = true;
    private boolean lastPasteAir = true;
    public boolean pasteEntities = true;
    public boolean unlockRotation = false;
    public boolean applyToolMask = false;
    public boolean reposition = true;
    private boolean hasAppliedCutout = false;
    public int pasteModifiers = HistoryEntry.MODIFIER_PASTE;
    private boolean acquiredChunkRenderOverrider = false;

    public void replacePlacement(ChunkedBlockRegion blockRegion) {
        this.replacePlacement(blockRegion, this.placementDescription);
    }

    public void replacePlacement(ChunkedBlockRegion blockRegion, String placementDescription) {
        if (!this.isPlacing() || blockRegion.isEmpty()) {
            return;
        }
        if (ToolManager.isToolActive()) {
            ToolManager.getCurrentTool().reset();
            ToolManager.setToolSelected(false);
        }
        if (this.gizmo != null) {
            this.gizmo.enableRotation = true;
        }
        this.placementDescription = placementDescription;
        this.blockRegion = blockRegion;
        this.scaled3xBlockRegion = null;
        this.partialRotationMatrix = null;
        this.blockEntities = null;
        this.entities = null;
        this.entityRotationMatrix = null;
        this.containsAir = false;
        this.cutoutPositionSet = null;
        this.reposition = true;
        this.pasteModifiers = HistoryEntry.MODIFIER_PASTE;
        this.updateCutout();
    }

    public int startPlacement(class_2338 target, ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, List<class_2487> entities, boolean containsAir, String placementDescription) {
        if (this.isPlacing()) {
            this.stopPlacement();
        }
        if (ToolManager.isToolActive()) {
            ToolManager.getCurrentTool().reset();
            ToolManager.setToolSelected(false);
        }
        if (!AxiomClient.hasPermission(AxiomPermission.BUILD_SECTION)) {
            ChatUtils.error("Server hasn't given you permission to place blocks with Axiom");
            return this.placementId.incrementAndGet();
        }
        this.lastTargetPosition = target;
        this.placementDescription = placementDescription;
        this.gizmo = new Gizmo(target);
        this.gizmo.enableRotation = true;
        this.blockRegion = blockRegion;
        this.scaled3xBlockRegion = null;
        this.partialRotationMatrix = null;
        this.blockEntities = blockEntities;
        this.entities = entities == null || entities.isEmpty() ? null : entities;
        this.entityRotationMatrix = new IntMatrix();
        this.containsAir = containsAir;
        this.cutoutPositionSet = null;
        this.updateCutout();
        this.reposition = true;
        this.pasteModifiers = HistoryEntry.MODIFIER_PASTE;
        return this.placementId.incrementAndGet();
    }

    public void startPlacement(class_2338 target, BlockBuffer blockBuffer, String placementDescription) {
        ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
        Long2ObjectOpenHashMap blockEntities = new Long2ObjectOpenHashMap();
        boolean containsAir = false;
        for (Long2ObjectMap.Entry entry : blockBuffer.entrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey()) * 16 - target.method_10263();
            int cy = class_2338.method_10071((long)entry.getLongKey()) * 16 - target.method_10264();
            int cz = class_2338.method_10083((long)entry.getLongKey()) * 16 - target.method_10260();
            Short2ObjectMap<CompressedBlockEntity> chunkBlockEntities = blockBuffer.getBlockEntityChunkMap(entry.getLongKey());
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        short key;
                        CompressedBlockEntity blockEntity;
                        class_2680 block = (class_2680)((class_2841)entry.getValue()).method_12321(x, y, z);
                        if (block == BlockBuffer.EMPTY_STATE) continue;
                        blockRegion.addBlock(cx + x, cy + y, cz + z, block);
                        containsAir |= block.method_26215();
                        if (!block.method_31709() || chunkBlockEntities == null || (blockEntity = (CompressedBlockEntity)chunkBlockEntities.get(key = (short)(x | y << 4 | z << 8))) == null) continue;
                        blockEntities.put(class_2338.method_10064((int)(cx + x), (int)(cy + y), (int)(cz + z)), (Object)blockEntity);
                    }
                }
            }
        }
        if (blockRegion.isEmpty()) {
            return;
        }
        this.startPlacement(target, blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntities, List.of(), containsAir, placementDescription);
    }

    public ChunkedBlockRegion getBlockRegion() {
        return this.blockRegion;
    }

    private boolean pasteAir() {
        return this.containsAir && this.pasteAir;
    }

    private void tryReleaseChunkRenderOverrider() {
        if (this.acquiredChunkRenderOverrider) {
            ChunkRenderOverrider.release("placement");
            this.acquiredChunkRenderOverrider = false;
            this.hasAppliedCutout = false;
            this.cutoutPositionSet = null;
        }
    }

    public void updateCutout() {
        if (!EditorUI.isActive() || !this.isPlacing() || this.lastTargetPosition == null || ToolManager.isToolActive()) {
            this.tryReleaseChunkRenderOverrider();
            return;
        }
        this.hasAppliedCutout = false;
        boolean pasteAir = this.pasteAir();
        boolean optionsChanged = pasteAir != this.lastPasteAir || this.keepExisting != this.lastKeepExisting || this.prioritizeFullBlocks != this.lastPrioritizeFullBlocks;
        this.lastPasteAir = pasteAir;
        this.lastKeepExisting = this.keepExisting;
        this.lastPrioritizeFullBlocks = this.prioritizeFullBlocks;
        if (this.blockRegion.count() > 65536 || this.blockRegion.isEmpty()) {
            this.tryReleaseChunkRenderOverrider();
            return;
        }
        if (!this.acquiredChunkRenderOverrider) {
            ChunkRenderOverrider.acquire("placement");
            this.acquiredChunkRenderOverrider = true;
        }
        if (this.cutoutPositionSet == null || optionsChanged || this.keepExisting || this.prioritizeFullBlocks) {
            int zo;
            this.cutoutPositionSet = new PositionSet();
            int xo = this.reposition ? -(this.blockRegion.max().method_10263() + this.blockRegion.min().method_10263()) / 2 : 0;
            int yo = this.reposition ? -(this.blockRegion.max().method_10264() + this.blockRegion.min().method_10264()) / 2 : 0;
            int n = zo = this.reposition ? -(this.blockRegion.max().method_10260() + this.blockRegion.min().method_10260()) / 2 : 0;
            if (!this.keepExisting && !this.prioritizeFullBlocks) {
                if (pasteAir) {
                    this.blockRegion.forEachEntry((x, y, z, block) -> this.cutoutPositionSet.add(x + xo, y + yo, z + zo));
                } else {
                    this.blockRegion.forEachEntry((x, y, z, block) -> {
                        if (!block.method_26215()) {
                            this.cutoutPositionSet.add(x + xo, y + yo, z + zo);
                        }
                    });
                }
            } else {
                class_638 level = class_310.method_1551().field_1687;
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                int tx = this.lastTargetPosition.method_10263();
                int ty = this.lastTargetPosition.method_10264();
                int tz = this.lastTargetPosition.method_10260();
                if (pasteAir) {
                    this.blockRegion.forEachEntry((x, y, z, block) -> {
                        if (block.method_26215() || Placement.shouldReplaceExisting(this.keepExisting, this.prioritizeFullBlocks, level.method_8320((class_2338)mutableBlockPos.method_10103(x + xo + tx, y + yo + ty, z + zo + tz)), block)) {
                            this.cutoutPositionSet.add(x + xo, y + yo, z + zo);
                        }
                    });
                } else {
                    this.blockRegion.forEachEntry((x, y, z, block) -> {
                        if (!block.method_26215() && Placement.shouldReplaceExisting(this.keepExisting, this.prioritizeFullBlocks, level.method_8320((class_2338)mutableBlockPos.method_10103(x + xo + tx, y + yo + ty, z + zo + tz)), block)) {
                            this.cutoutPositionSet.add(x + xo, y + yo, z + zo);
                        }
                    });
                }
            }
        }
        if (this.cutoutPositionSet.isEmpty()) {
            ChunkRenderOverrider.clear();
        } else {
            ChunkRenderOverrider.cutoutBoolean(this.cutoutPositionSet, this.lastTargetPosition);
        }
        this.hasAppliedCutout = true;
    }

    public UserAction.ActionResult callAction(UserAction action, Object object) {
        if (!EditorUI.isActive()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        if (!this.isPlacing()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        if (ToolManager.isToolActive()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (action) {
            case ROTATE_PLACEMENT: {
                this.rotate(class_2350.class_2351.field_11052, -1.5707964f);
                this.cutoutPositionSet = null;
                this.updateCutout();
                break;
            }
            case FLIP_PLACEMENT: {
                class_243 lookDirection = Tool.getLookDirection();
                if (lookDirection == null) {
                    lookDirection = class_310.method_1551().field_1719.method_5720();
                }
                class_2350 direction = PositionUtils.orderedByNearest(lookDirection)[0];
                this.flip(direction.method_10166());
                break;
            }
            case LEFT_MOUSE: {
                if (this.leftClick()) break;
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result;
                if (this.gizmo != null || (result = Tool.raycastBlock()) == null) break;
                this.gizmo = new Gizmo(result.blockPos());
                this.gizmo.enableRotation = true;
                break;
            }
            case SCROLL: {
                UserAction.ScrollAmount scrollAmount = (UserAction.ScrollAmount)object;
                if (this.handleScroll(scrollAmount.scrollX(), scrollAmount.scrollY())) break;
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case UNDO: 
            case REDO: {
                return Dispatcher.callAction(action, object);
            }
            case SAVE: 
            case ESCAPE: {
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case DELETE: {
                this.stopPlacement();
                break;
            }
            case ENTER: 
            case PASTE: {
                this.pastePlacement();
            }
        }
        return UserAction.ActionResult.USED_STOP;
    }

    public void flip(class_2350.class_2351 axis) {
        this.scaled3xBlockRegion = null;
        this.partialRotationMatrix = null;
        this.blockRegion = this.blockRegion.flip(axis);
        if (this.entityRotationMatrix != null) {
            this.entityRotationMatrix.flip(axis);
        }
        this.cutoutPositionSet = null;
        this.updateCutout();
    }

    public void pastePlacement() {
        this.pastePlacement(false);
    }

    public void pastePlacement(boolean select2) {
        this.pastePlacementWithoutStopping(select2);
        this.stopPlacement();
    }

    public void pastePlacementWithoutStopping(boolean select2) {
        MaskContext maskContext;
        class_2338 targetPos;
        if (this.gizmo != null) {
            targetPos = this.gizmo.getTargetPosition();
        } else {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                this.stopPlacement();
                return;
            }
            targetPos = result.blockPos();
        }
        int minX = this.blockRegion.min().method_10263();
        int minY = this.blockRegion.min().method_10264();
        int minZ = this.blockRegion.min().method_10260();
        int maxX = this.blockRegion.max().method_10263();
        int maxY = this.blockRegion.max().method_10264();
        int maxZ = this.blockRegion.max().method_10260();
        class_2338 originPos = this.reposition ? targetPos.method_10069(-(maxX + minX) / 2, -(maxY + minY) / 2, -(maxZ + minZ) / 2) : targetPos;
        Dispatcher.resetShouldRemovePlacementOnStep();
        if (select2) {
            PositionSet selection = new PositionSet();
            this.blockRegion.forEachEntry((x, y, z, blockState) -> {
                if (blockState.method_26215()) {
                    return;
                }
                selection.add(originPos.method_10263() + x, originPos.method_10264() + y, originPos.method_10260() + z);
            });
            Selection.clearSelection();
            Selection.addSet(selection);
        }
        LongOpenHashSet needNbt = new LongOpenHashSet();
        LongOpenHashSet needChunks = new LongOpenHashSet();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BlockBuffer forwards = new BlockBuffer();
        BlockBuffer backwards = new BlockBuffer();
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int worldMinX = minX + originPos.method_10263();
        int worldMinY = minY + originPos.method_10264();
        int worldMinZ = minZ + originPos.method_10260();
        int worldMaxX = maxX + originPos.method_10263();
        int worldMaxY = maxY + originPos.method_10264();
        int worldMaxZ = maxZ + originPos.method_10260();
        ServerConfig serverConfig = Axiom.getInstance().serverConfig;
        Long2ObjectOpenHashMap containers = new Long2ObjectOpenHashMap();
        int chunkOffsetX = originPos.method_10263() >> 4;
        int chunkOffsetY = originPos.method_10264() >> 4;
        int chunkOffsetZ = originPos.method_10260() >> 4;
        MaskElement maskElement = this.applyToolMask && EditorWindowType.TOOL_MASKS.isOpen() && MaskManager.hasConfiguredMask() ? MaskManager.getDestMask() : null;
        MaskContext maskContext2 = maskContext = maskElement == null ? null : new MaskContext((class_1937)class_310.method_1551().field_1687);
        if (this.blockEntities != null && !this.blockEntities.isEmpty()) {
            if (this.entityRotationMatrix == null || this.entityRotationMatrix.isIdentity()) {
                for (Long2ObjectMap.Entry entry : this.blockEntities.long2ObjectEntrySet()) {
                    pos = entry.getLongKey();
                    x = class_2338.method_10061((long)pos) + originPos.method_10263();
                    y = class_2338.method_10071((long)pos) + originPos.method_10264();
                    z = class_2338.method_10083((long)pos) + originPos.method_10260();
                    if (maskElement != null && !maskElement.test(maskContext.reset(), x, y, z)) continue;
                    forwards.putBlockEntity(x, y, z, (CompressedBlockEntity)entry.getValue());
                }
            } else {
                for (Long2ObjectMap.Entry entry : this.blockEntities.long2ObjectEntrySet()) {
                    pos = entry.getLongKey();
                    x = class_2338.method_10061((long)pos);
                    y = class_2338.method_10071((long)pos);
                    z = class_2338.method_10083((long)pos);
                    int nx = this.entityRotationMatrix.transformX(x, y, z) + originPos.method_10263();
                    int ny = this.entityRotationMatrix.transformY(x, y, z) + originPos.method_10264();
                    int nz = this.entityRotationMatrix.transformZ(x, y, z) + originPos.method_10260();
                    if (maskElement != null && !maskElement.test(maskContext.reset(), nx, ny, nz)) continue;
                    forwards.putBlockEntity(nx, ny, nz, (CompressedBlockEntity)entry.getValue());
                }
            }
        }
        ArrayList<AxiomServerboundSpawnEntity.SpawnEntry> spawnEntries = new ArrayList<AxiomServerboundSpawnEntity.SpawnEntry>();
        ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry> manipulateEntries = new ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry>();
        DeleteEntityAdditionalUndoOperation additionalUndoOperation = null;
        if (this.pasteEntities && this.entities != null && !this.entities.isEmpty()) {
            ArrayList<UUID> uuids = new ArrayList<UUID>();
            for (class_2487 entity : this.entities) {
                EntityDataUtils.cloneEntity(UUID.randomUUID(), entity.method_10553(), class_243.method_24954((class_2382)originPos), this.entityRotationMatrix, spawnEntries, manipulateEntries, uuids);
            }
            if (!uuids.isEmpty()) {
                additionalUndoOperation = new DeleteEntityAdditionalUndoOperation(uuids);
            }
        }
        DeleteEntityAdditionalUndoOperation additionalUndoOperationF = additionalUndoOperation;
        LongIterator longIterator = this.blockRegion.chunkKeySet().longIterator();
        while (longIterator.hasNext()) {
            long regionPos = longIterator.nextLong();
            int cx = class_2338.method_10061((long)regionPos) + chunkOffsetX;
            int cy = class_2338.method_10071((long)regionPos) + chunkOffsetY;
            int cz = class_2338.method_10083((long)regionPos) + chunkOffsetZ;
            for (int cxo = 0; cxo <= 1; ++cxo) {
                for (int cyo = 0; cyo <= 1; ++cyo) {
                    for (int czo = 0; czo <= 1; ++czo) {
                        int sectionIndex;
                        int ncx = cx + cxo;
                        int ncy = cy + cyo;
                        int ncz = cz + czo;
                        long chunkPos = class_2338.method_10064((int)ncx, (int)ncy, (int)ncz);
                        if (containers.containsKey(chunkPos) || needChunks.contains(chunkPos) || ncx * 16 + 15 < worldMinX || ncy * 16 + 15 < worldMinY || ncz * 16 + 15 < worldMinZ || ncx * 16 > worldMaxX || ncy * 16 > worldMaxY || ncz * 16 > worldMaxZ || (sectionIndex = world.method_31603(ncy)) < 0 || sectionIndex >= world.method_32890()) continue;
                        class_2818 chunk = (class_2818)world.method_8402(ncx, ncz, class_2806.field_12803, false);
                        if (chunk == null) {
                            needChunks.add(chunkPos);
                            continue;
                        }
                        class_2826 section = chunk.method_38259(sectionIndex);
                        containers.put(chunkPos, (Object)section.method_12265());
                    }
                }
            }
        }
        boolean pasteAir = this.pasteAir();
        containers.forEach((arg_0, arg_1) -> this.lambda$pastePlacementWithoutStopping$5(originPos, forwards, backwards, maskElement, maskContext, pasteAir, serverConfig, (LongSet)needNbt, world, mutable, baos, arg_0, arg_1));
        if (needNbt.isEmpty() && needChunks.isEmpty()) {
            Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, targetPos, this.placementDescription, this.pasteModifiers, additionalUndoOperation));
            if (!spawnEntries.isEmpty()) {
                new AxiomServerboundSpawnEntity(spawnEntries).send();
            }
            if (!manipulateEntries.isEmpty()) {
                new AxiomServerboundManipulateEntity(manipulateEntries).send();
            }
        } else {
            String description = this.placementDescription;
            int modifiers = this.pasteModifiers;
            boolean keepExisting = this.keepExisting;
            boolean prioritizeFullBlocks = this.prioritizeFullBlocks;
            Position2ObjectMap<class_2680> copiedBlocks = this.blockRegion.copyBlockData();
            Dispatcher.requestChunkData((LongSet)needNbt, (LongSet)needChunks, true, (compressedBlockEntities, chunkSections) -> {
                class_2680 air = class_2246.field_10124.method_9564();
                chunkSections.forEach((cpos, container) -> {
                    int cx = class_2338.method_10061((long)cpos);
                    int cy = class_2338.method_10071((long)cpos);
                    int cz = class_2338.method_10083((long)cpos);
                    int xo = cx * 16 - originPos.method_10263();
                    int yo = cy * 16 - originPos.method_10264();
                    int zo = cz * 16 - originPos.method_10260();
                    class_2841<class_2680> forwardsContainer = forwards.getOrCreateSection((long)cpos);
                    class_2841<class_2680> backwardsContainer = backwards.getOrCreateSection((long)cpos);
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            for (int x = 0; x < 16; ++x) {
                                class_2680 existingState;
                                class_2680 pasteState = (class_2680)copiedBlocks.get(x + xo, y + yo, z + zo);
                                if (pasteState == null) continue;
                                class_2680 class_26802 = existingState = container == null ? air : (class_2680)container.method_12321(x, y, z);
                                if (maskElement != null && !maskElement.test(maskContext.reset(), x + cx * 16, y + cy * 16, z + cz * 16) || (pasteState.method_26215() ? !pasteAir || existingState.method_26215() : !Placement.shouldReplaceExisting(keepExisting, prioritizeFullBlocks, existingState, pasteState))) continue;
                                forwardsContainer.method_16678(x, y, z, (Object)pasteState);
                                backwardsContainer.method_16678(x, y, z, (Object)existingState);
                            }
                        }
                    }
                });
                compressedBlockEntities.forEach((pos, compressedBlockEntity) -> {
                    int x = class_2338.method_10061((long)pos);
                    int y = class_2338.method_10071((long)pos);
                    int z = class_2338.method_10083((long)pos);
                    backwards.putBlockEntity(x, y, z, (CompressedBlockEntity)compressedBlockEntity);
                });
                Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, targetPos, description, modifiers, additionalUndoOperationF));
                if (!spawnEntries.isEmpty()) {
                    new AxiomServerboundSpawnEntity(spawnEntries).send();
                }
                if (!manipulateEntries.isEmpty()) {
                    new AxiomServerboundManipulateEntity(manipulateEntries).send();
                }
            });
        }
    }

    private static boolean shouldReplaceExisting(boolean keepExisting, boolean prioritizeFullBlocks, class_2680 existingState, class_2680 pasteState) {
        if (existingState.method_26215()) {
            return !pasteState.method_26215();
        }
        if (existingState.method_45474() && !pasteState.method_45474()) {
            return true;
        }
        if (keepExisting) {
            if (prioritizeFullBlocks) {
                class_265 pasteShape;
                class_265 existingShape = existingState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980);
                if (existingShape == (pasteShape = pasteState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980))) {
                    return false;
                }
                return !BlockVoxelShapeUtils.firstCompletelyOverlapsSecond(existingShape, pasteShape);
            }
            return false;
        }
        if (prioritizeFullBlocks) {
            class_265 pasteShape;
            class_265 existingShape = existingState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980);
            if (existingShape == (pasteShape = pasteState.method_26218((class_1922)class_2682.field_12294, class_2338.field_10980))) {
                return true;
            }
            return BlockVoxelShapeUtils.firstCompletelyOverlapsSecond(pasteShape, existingShape);
        }
        return true;
    }

    public void stopPlacement() {
        if (this.blockRegion != null) {
            this.tryReleaseChunkRenderOverrider();
            Dispatcher.resetShouldRemovePlacementOnStep();
            this.cutoutPositionSet = null;
            this.blockRegion = null;
            this.scaled3xBlockRegion = null;
            this.partialRotationMatrix = null;
            this.gizmo = null;
        }
    }

    public boolean isPlacing() {
        return this.blockRegion != null;
    }

    private boolean leftClick() {
        if (this.gizmo == null || EditorUI.isCtrlOrCmdDown() && !this.gizmo.isGrabbed()) {
            return false;
        }
        return this.gizmo.leftClick();
    }

    public boolean handleScroll(int xScroll, int yScroll) {
        if (this.gizmo == null || EditorUI.isCtrlOrCmdDown() && !this.gizmo.isGrabbed()) {
            return false;
        }
        class_243 look = Tool.getLookDirection();
        if (look != null) {
            this.gizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), look);
            return true;
        }
        return false;
    }

    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        Quaternionf peekRotation;
        class_243 translation;
        if (!this.isPlacing()) {
            return;
        }
        boolean showGizmo = false;
        boolean doCutout = false;
        if (EditorUI.isActive() && !ToolManager.isToolActive()) {
            if (this.gizmo != null) {
                Gizmo.GizmoRotation rotation;
                class_243 lookDirection = Tool.getLookDirection();
                boolean isLeftDown = Tool.isMouseDown(0);
                boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
                showGizmo = !EditorUI.isActive() || !isCtrlDown;
                float f = this.gizmo.rotationSnapRadians = this.unlockRotation ? (float)Math.toRadians(1.0) : 1.5707964f;
                if (lookDirection != null) {
                    this.gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
                    this.gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)this.gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)this.gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)this.gizmo.getTargetPosition().method_10260());
                }
                if (!this.gizmo.getTargetPosition().equals((Object)this.lastTargetPosition)) {
                    this.lastTargetPosition = this.gizmo.getTargetPosition();
                    doCutout = true;
                }
                if (!this.gizmo.isGrabbed() && (rotation = this.gizmo.popRotation()) != null) {
                    if (this.unlockRotation && this.partialRotationMatrix == null) {
                        this.partialRotationMatrix = new Matrix4f();
                    }
                    this.rotate(rotation.axis(), rotation.radians());
                    this.cutoutPositionSet = null;
                    doCutout = true;
                }
                translation = this.gizmo.getInterpPosition();
            } else {
                RayCaster.RaycastResult result = Tool.raycastBlock();
                if (result == null) {
                    return;
                }
                translation = class_243.method_24953((class_2382)result.blockPos());
                if (!result.blockPos().equals((Object)this.lastTargetPosition)) {
                    this.lastTargetPosition = result.blockPos();
                    this.updateCutout();
                }
            }
            if (doCutout || this.lastPasteAir != this.pasteAir() || this.lastKeepExisting != this.keepExisting || this.lastPrioritizeFullBlocks != this.prioritizeFullBlocks) {
                this.updateCutout();
            }
        } else {
            this.tryReleaseChunkRenderOverrider();
            if (this.gizmo != null) {
                translation = this.gizmo.getInterpPosition();
            } else {
                return;
            }
        }
        Vector3f vector3f = new Vector3f(-0.5f, -0.5f, -0.5f);
        if (this.reposition) {
            vector3f.set((float)(-(this.blockRegion.max().method_10263() + this.blockRegion.min().method_10263()) / 2) - 0.5f, (float)(-(this.blockRegion.max().method_10264() + this.blockRegion.min().method_10264()) / 2) - 0.5f, (float)(-(this.blockRegion.max().method_10260() + this.blockRegion.min().method_10260()) / 2) - 0.5f);
        }
        Quaternionf quaternionf = peekRotation = this.gizmo == null ? null : this.gizmo.peekRotation();
        if (peekRotation != null) {
            vector3f.rotate((Quaternionfc)peekRotation);
        }
        translation = translation.method_1031((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
        int blockRegionCount = this.blockRegion.count();
        if (blockRegionCount < 0x1000000) {
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            float blockOpacity = this.blockRegion.count() > 131072 ? 1.0f : 0.75f + opacity * 0.225f;
            this.blockRegion.render(camera, translation, peekRotation, matrices, projection, blockOpacity, 0.1f - opacity * 0.1f, !this.hasAppliedCutout);
        }
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352 + translation.field_1352, -camera.method_19326().field_1351 + translation.field_1351, -camera.method_19326().field_1350 + translation.field_1350);
        if (peekRotation != null) {
            matrices.method_22907(peekRotation);
        }
        this.renderBoundingBox(matrices);
        matrices.method_22909();
        if (this.gizmo != null && (this.gizmo.isGrabbed() || showGizmo)) {
            this.gizmo.render(matrices, camera, EditorUI.isCtrlOrCmdDown());
        }
    }

    private void rotate(class_2350.class_2351 axis, float radians2) {
        if (this.partialRotationMatrix != null) {
            switch (axis) {
                case field_11048: {
                    this.partialRotationMatrix.rotateLocalX(radians2);
                    break;
                }
                case field_11052: {
                    this.partialRotationMatrix.rotateLocalY(radians2);
                    break;
                }
                case field_11051: {
                    this.partialRotationMatrix.rotateLocalZ(radians2);
                }
            }
            if (this.scaled3xBlockRegion == null) {
                this.scaled3xBlockRegion = Scale3x.scale3x(this.blockRegion, false);
            }
            this.blockRegion = RotSprite.rotateCached(this.scaled3xBlockRegion, this.partialRotationMatrix);
            this.blockEntities = null;
            this.entities = null;
            this.entityRotationMatrix = null;
        } else {
            int rotations = Math.round((float)Math.toDegrees(radians2) / 90.0f);
            this.blockRegion = this.blockRegion.rotate(axis, rotations);
            if (this.entityRotationMatrix != null) {
                this.entityRotationMatrix.rotate(axis, rotations);
            }
        }
    }

    public void snapToGround() {
        class_2338 min2 = this.blockRegion.min();
        class_2338 max2 = this.blockRegion.max();
        if (this.blockRegion == null || this.gizmo == null || this.blockRegion.isEmpty() || min2 == null || max2 == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        Position2dSet insideGroundPositions = new Position2dSet();
        Position2dSet aboveGroundPositions = new Position2dSet();
        int minX = min2.method_10263();
        int minY = min2.method_10264();
        int minZ = min2.method_10260();
        int maxX = max2.method_10263();
        int maxY = max2.method_10264();
        int maxZ = max2.method_10260();
        class_2338 originPos = this.reposition ? this.gizmo.getTargetPosition().method_10069(-(maxX + minX) / 2, -(maxY + minY) / 2, -(maxZ + minZ) / 2) : this.gizmo.getTargetPosition();
        boolean hasOnGround = false;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                class_2680 existing;
                class_2680 blockState = this.blockRegion.getBlockStateOrNull(x2, minY, z2);
                if (blockState == null || (existing = level.method_8320((class_2338)mutableBlockPos.method_25504((class_2382)originPos, x2, minY, z2))).method_26204() == class_2246.field_10243) continue;
                if (!existing.method_45474()) {
                    insideGroundPositions.add(x2, z2);
                    continue;
                }
                class_2680 below = level.method_8320((class_2338)mutableBlockPos.method_25504((class_2382)originPos, x2, minY - 1, z2));
                if (below.method_26204() == class_2246.field_10243) continue;
                if (below.method_45474()) {
                    aboveGroundPositions.add(x2, z2);
                    continue;
                }
                hasOnGround = true;
            }
        }
        if (!aboveGroundPositions.isEmpty()) {
            int i = 0;
            while (i < 64) {
                int finalI = i++;
                aboveGroundPositions.removeIf((x, z) -> {
                    class_2680 below = level.method_8320((class_2338)mutableBlockPos.method_25504((class_2382)originPos, x, minY - finalI - 1, z));
                    return below.method_26204() == class_2246.field_10243 || !below.method_45474();
                });
                if (!aboveGroundPositions.isEmpty()) continue;
                this.gizmo.moveToInstantly(this.gizmo.getTargetPosition().method_10069(0, -i, 0));
                return;
            }
        }
        if (!insideGroundPositions.isEmpty() && !hasOnGround) {
            BooleanWrapper found = new BooleanWrapper(false);
            int i = 1;
            while (i < 64) {
                int finalI = i++;
                insideGroundPositions.forEach((x, z) -> {
                    class_2680 existing = level.method_8320((class_2338)mutableBlockPos.method_25504((class_2382)originPos, x, minY + finalI, z));
                    if (existing.method_45474()) {
                        found.value = true;
                    }
                });
                if (!found.value) continue;
                this.gizmo.moveToInstantly(this.gizmo.getTargetPosition().method_10069(0, i, 0));
                return;
            }
        }
    }

    private void renderBoundingBox(class_4587 matrices) {
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
        Shapes.lineBox(matrices, (class_4588)bufferBuilder, this.blockRegion.min().method_10263(), this.blockRegion.min().method_10264(), this.blockRegion.min().method_10260(), this.blockRegion.max().method_10263() + 1, this.blockRegion.max().method_10264() + 1, this.blockRegion.max().method_10260() + 1, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, RenderHelper.baseLineWidth);
        class_9801 meshData = provider.build();
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 0.4f);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, false);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 0.1f);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_IGNORE_DEPTH, null, meshData, true);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private /* synthetic */ void lambda$pastePlacementWithoutStopping$5(class_2338 originPos, BlockBuffer forwards, BlockBuffer backwards, MaskElement maskElement, MaskContext maskContext, boolean pasteAir, ServerConfig serverConfig, LongSet needNbt, class_638 world, class_2338.class_2339 mutable, ByteArrayOutputStream baos, Long cpos, class_2841 container) {
        int cx = class_2338.method_10061((long)cpos);
        int cy = class_2338.method_10071((long)cpos);
        int cz = class_2338.method_10083((long)cpos);
        int xo = cx * 16 - originPos.method_10263();
        int yo = cy * 16 - originPos.method_10264();
        int zo = cz * 16 - originPos.method_10260();
        class_2841<class_2680> forwardsContainer = forwards.getOrCreateSection(cpos);
        class_2841<class_2680> backwardsContainer = backwards.getOrCreateSection(cpos);
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    class_2586 blockEntity;
                    class_2680 pasteState = this.blockRegion.getBlockStateOrNull(x + xo, y + yo, z + zo);
                    if (pasteState == null) continue;
                    class_2680 existingState = (class_2680)container.method_12321(x, y, z);
                    if (maskElement != null && !maskElement.test(maskContext.reset(), x + cx * 16, y + cy * 16, z + cz * 16) || (pasteState.method_26215() ? !pasteAir || existingState.method_26215() : !Placement.shouldReplaceExisting(this.keepExisting, this.prioritizeFullBlocks, existingState, pasteState))) continue;
                    int toX = x + cx * 16;
                    int toY = y + cy * 16;
                    int toZ = z + cz * 16;
                    forwardsContainer.method_16678(x, y, z, (Object)pasteState);
                    backwardsContainer.method_16678(x, y, z, (Object)existingState);
                    if (serverConfig.blocksWithCustomData().contains(existingState.method_26204())) {
                        needNbt.add(class_2338.method_10064((int)toX, (int)toY, (int)toZ));
                        continue;
                    }
                    if (!existingState.method_31709() || (blockEntity = world.method_8321((class_2338)mutable.method_10103(toX, toY, toZ))) == null) continue;
                    class_2487 nbt = ClientBlockEntitySerializer.serialize(blockEntity, (class_7225.class_7874)world.method_30349());
                    if (nbt != null) {
                        if (nbt.method_33133()) continue;
                        CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(nbt, baos);
                        backwards.putBlockEntity(toX, toY, toZ, compressedBlockEntity);
                        continue;
                    }
                    needNbt.add(mutable.method_10063());
                }
            }
        }
    }
}

