/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.configuration.AltMenuKeybindMode;
import com.moulberry.axiom.configuration.BuilderToolMiddleClick;
import com.moulberry.axiom.configuration.FlightDirection;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybind;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.palette.EditorPalette;
import com.moulberry.axiom.editor.styles.StyleHelper;
import com.moulberry.axiom.editor.styles.StyleManager;
import com.moulberry.lattice.WidgetFunction;
import com.moulberry.lattice.annotation.LatticeCategory;
import com.moulberry.lattice.annotation.LatticeFormatValues;
import com.moulberry.lattice.annotation.LatticeOption;
import com.moulberry.lattice.annotation.constraint.LatticeFloatRange;
import com.moulberry.lattice.annotation.constraint.LatticeIntRange;
import com.moulberry.lattice.annotation.widget.LatticeWidgetButton;
import com.moulberry.lattice.annotation.widget.LatticeWidgetCustom;
import com.moulberry.lattice.annotation.widget.LatticeWidgetKeybind;
import com.moulberry.lattice.annotation.widget.LatticeWidgetSlider;
import com.moulberry.lattice.annotation.widget.LatticeWidgetTextArea;
import com.moulberry.lattice.annotation.widget.LatticeWidgetTextField;
import com.moulberry.lattice.element.LatticeElements;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6599;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AxiomConfig {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(EditorPalette.class, (Object)new EditorPalette.TypeAdapter()).setPrettyPrinting().create();
    @LatticeCategory(name="axiom.editorui.window.keybinds")
    public SubcategoryKeybinds keybinds = new SubcategoryKeybinds();
    @LatticeCategory(name="axiom.config.visuals")
    public SubcategoryVisuals visuals = new SubcategoryVisuals();
    @LatticeCategory(name="axiom.config.context_menu")
    public SubcategoryContextMenu contextMenu = new SubcategoryContextMenu();
    @LatticeCategory(name="axiom.config.capabilities")
    public SubcategoryCapabilities capabilities = new SubcategoryCapabilities();
    @LatticeCategory(name="axiom.config.block_attributes")
    public SubcategoryBlockAttributes blockAttributes = new SubcategoryBlockAttributes();
    @LatticeCategory(name="axiom.config.movement")
    public SubcategoryMovement movement = new SubcategoryMovement();
    @LatticeCategory(name="axiom.config.builder_tools")
    public SubcategoryBuilderTools builderTools = new SubcategoryBuilderTools();
    @LatticeCategory(name="axiom.config.creative_menu")
    public SubcategoryCreativeMenu creativeMenu = new SubcategoryCreativeMenu();
    @LatticeCategory(name="axiom.config.entity_manipulation")
    public SubcategoryEntityManipulation entityManipulation = new SubcategoryEntityManipulation();
    @LatticeCategory(name="axiom.config.editor")
    public SubcategoryEditor editor = new SubcategoryEditor();
    @LatticeCategory(name="axiom.config.blueprint")
    public SubcategoryBlueprint blueprint = new SubcategoryBlueprint();
    public SubcategoryInternal internal = new SubcategoryInternal();
    public static final String DEFAULT_LAYOUT = "[Window][###Tools]\nPos=0,0\nSize=300,250\nCollapsed=0\nDockId=0x00000003,0\n\n[Window][###Tool Options]\nPos=0,250\nSize=300,750\nCollapsed=0\nDockId=0x00000004,0\n\n[Window][###Clipboard]\nPos=1700,0\nSize=300,200\nCollapsed=0\nDockId=0x0000000D,0\n\n[Window][###TargetInfo]\nPos=1700,0\nSize=300,200\nCollapsed=0\nDockId=0x0000000D,1\n\n[Window][###Palette]\nPos=1700,200\nSize=300,200\nCollapsed=0\nDockId=0x0000000E,0\n\n[Window][###ActiveBlock]\nPos=1700,400\nSize=300,100\nCollapsed=0\nDockId=0x0000000C,0\n\n[Window][###History]\nPos=1700,500\nSize=300,300\nCollapsed=0\nDockId=0x0000000A,0\n\n[Window][###WorldProperties]\nPos=1700,800\nSize=300,200\nCollapsed=0\nDockId=0x00000008,0\n\n[Docking][Data]\nDockSpace           ID=0x8B93E3BD Window=0xA787BDB4 Pos=0,0 Size=2000,1000 Split=X\nDockNode          ID=0x00000005 Parent=0x8B93E3BD SizeRef=1700,1000 Split=X\n DockNode        ID=0x00000001 Parent=0x00000005 SizeRef=300,1000 Split=Y\n   DockNode      ID=0x00000003 Parent=0x00000001 SizeRef=300,250 Selected=0x80AFE82B\n   DockNode      ID=0x00000004 Parent=0x00000001 SizeRef=300,750 Selected=0xECA27DCB\n DockNode        ID=0x00000002 Parent=0x00000005 SizeRef=1400,1000 CentralNode=1 Selected=0x1F1A625A\nDockNode          ID=0x00000006 Parent=0x8B93E3BD SizeRef=300,1000 Split=Y Selected=0x34064FA7\n DockNode        ID=0x00000007 Parent=0x00000006 SizeRef=300,800 Split=Y Selected=0x34064FA7\n   DockNode      ID=0x00000009 Parent=0x00000007 SizeRef=300,500 Split=Y Selected=0x34064FA7\n     DockNode    ID=0x0000000B Parent=0x00000009 SizeRef=300,400 Split=Y Selected=0x34064FA7\n       DockNode  ID=0x0000000D Parent=0x0000000B SizeRef=300,200 Selected=0x34064FA7\n       DockNode  ID=0x0000000E Parent=0x0000000B SizeRef=300,200 Selected=0x1E514AEA\n     DockNode    ID=0x0000000C Parent=0x00000009 SizeRef=300,100 Selected=0x1D216E21\n   DockNode      ID=0x0000000A Parent=0x00000007 SizeRef=300,300 Selected=0xFE0E9DDF\n DockNode        ID=0x00000008 Parent=0x00000006 SizeRef=300,200 Selected=0x602D8B84";

    public String serialize() {
        return GSON.toJson((Object)this);
    }

    public static AxiomConfig tryLoadFromFolder(Path configFolder) {
        Path primary = configFolder.resolve("axiom.json");
        Path backup = configFolder.resolve(".axiom.json.backup");
        if (Files.exists(primary, new LinkOption[0])) {
            try {
                return AxiomConfig.load(primary);
            }
            catch (Exception e) {
                Axiom.LOGGER.error("Failed to load config from {}", (Object)primary, (Object)e);
            }
        }
        if (Files.exists(backup, new LinkOption[0])) {
            try {
                return AxiomConfig.load(backup);
            }
            catch (Exception e) {
                Axiom.LOGGER.error("Failed to load config from {}", (Object)backup, (Object)e);
            }
        }
        return new AxiomConfig();
    }

    public void saveToDefaultFolder() {
        this.saveToFolder(Axiom.getInstance().getConfigDirectory());
    }

    public synchronized void saveToFolder(Path configFolder) {
        this.updateInternalValues();
        Path primary = configFolder.resolve("axiom.json");
        Path backup = configFolder.resolve(".axiom.json.backup");
        if (Files.exists(primary, new LinkOption[0])) {
            try {
                AxiomConfig.load(primary);
                try {
                    Files.move(primary, backup, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (IOException e) {
                    Axiom.LOGGER.error("Failed to backup config", e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.save(primary);
    }

    private static AxiomConfig load(Path path) throws IOException {
        String serialized = Files.readString(path);
        return (AxiomConfig)GSON.fromJson(serialized, AxiomConfig.class);
    }

    private void save(Path path) {
        String serialized = GSON.toJson((Object)this, AxiomConfig.class);
        try {
            Files.writeString(path, (CharSequence)serialized, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.DSYNC);
        }
        catch (IOException e) {
            Axiom.LOGGER.error("Failed to save config", e);
        }
    }

    private void updateInternalValues() {
        this.internal.openEditorWindowTypes = EditorWindowType.getOpenByName();
        this.updateTheme();
        Keybinds.save(this);
    }

    private void updateTheme() {
        if (!EditorUI.hasImGuiContext()) {
            return;
        }
        long oldContext = EditorUI.pushImGuiContext();
        ImGuiHelper.popAllStyleColors();
        ImGuiHelper.popAllStyleVars();
        StyleHelper.Theme theme = StyleManager.createTheme();
        if (theme != null) {
            this.internal.savedCustomTheme = theme.convertToBase64();
        }
        EditorUI.popImGuiContext(oldContext);
    }

    public LatticeElements createElements() {
        return LatticeElements.fromAnnotations((class_2561)class_2561.method_43471((String)"axiom.config"), (Object)this);
    }

    public static class SubcategoryKeybinds {
        @LatticeOption(title="axiom.config.keybinds.view_all_ingame_keybinds")
        @LatticeWidgetButton
        private transient Runnable viewAllIngameKeybinds = () -> class_310.method_1551().method_1507((class_437)new class_6599(class_310.method_1551().field_1755, class_310.method_1551().field_1690));
        @LatticeOption(title="axiom.config.keybinds.view_editor_keybinds")
        @LatticeWidgetButton
        private transient Runnable viewEditorKeybinds = () -> {
            if (!EditorUI.isActive()) {
                class_310.method_1551().method_1507(null);
                EditorUI.enable();
            }
            EditorWindowType.KEYBINDS.setOpen(true);
        };
        @LatticeOption(title="axiom.keybinds.copy_ingame", description="axiom.config.keybinds.copy_ingame.description")
        @LatticeWidgetKeybind(allowModifiers=true)
        private transient Keybind copyIngameKeybind = Keybinds.COPY_INGAME;
        @LatticeOption(title="axiom.keybinds.rotate_placement", description="axiom.config.keybinds.rotate_placement.description")
        @LatticeWidgetKeybind(allowModifiers=true)
        private transient Keybind rotatePlacementKeybind = Keybinds.ROTATE_PLACEMENT;
        @LatticeOption(title="axiom.keybinds.flip_placement", description="axiom.config.keybinds.flip_placement.description")
        @LatticeWidgetKeybind(allowModifiers=true)
        private transient Keybind flipPlacementKeybind = Keybinds.FLIP_PLACEMENT;
        public Map<String, String> regularKeybinds = new LinkedHashMap<String, String>();
        public Map<String, String> toolKeybinds = new LinkedHashMap<String, String>();
    }

    public static class SubcategoryVisuals {
        @LatticeOption(title="axiom.editorui.mainmenu.view.min_brightness", description="axiom.config.visuals.min_brightness.description")
        @LatticeFormatValues(formattingString="%d%%")
        @LatticeIntRange(min=0, max=100, clampMin=0, clampMax=100)
        @LatticeWidgetSlider
        public int minBrightness = 0;
        @LatticeOption(title="axiom.editorui.mainmenu.view.liquid_opacity", description="axiom.config.visuals.liquid_opacity.description")
        @LatticeFormatValues(formattingString="%d%%")
        @LatticeIntRange(min=0, max=100, clampMin=0, clampMax=100)
        @LatticeWidgetSlider
        public int liquidOpacity = 100;
        @LatticeOption(title="axiom.editorui.mainmenu.view.show_biomes", description="axiom.config.visuals.show_biomes.description")
        @LatticeWidgetButton
        public boolean showBiomes = false;
        @LatticeOption(title="axiom.editorui.mainmenu.view.show_annotations", description="axiom.config.visuals.show_annotations.description")
        @LatticeWidgetButton
        public boolean showAnnotations = true;
        @LatticeOption(title="axiom.editorui.mainmenu.view.show_ruler", description="axiom.config.visuals.show_ruler.description")
        @LatticeWidgetButton
        public boolean showRuler = true;
        @LatticeOption(title="axiom.editorui.mainmenu.view.show_key_presses", description="axiom.config.visuals.show_key_presses.description")
        @LatticeWidgetButton
        public boolean keypressOverlay = false;
        @LatticeOption(title="axiom.contextmenu.show_key_hints", description="axiom.config.visuals.show_key_hints.description")
        @LatticeWidgetButton
        public boolean showKeyHints = true;
        @LatticeOption(title="axiom.config.visuals.add_blockstate_to_tooltip", description="!!.description")
        @LatticeWidgetButton
        public boolean showBlockStateTooltip = true;
        @LatticeOption(title="axiom.config.visuals.status_background", description="!!.description")
        @LatticeWidgetButton
        public boolean statusBackground = true;
    }

    public static class SubcategoryContextMenu {
        @LatticeOption(title="axiom.config.context_menu.keybind")
        @LatticeWidgetKeybind
        private transient class_304 contextMenuKeybind = ClientEvents.contextMenuKeyBind;
        @LatticeOption(title="axiom.config.context_menu.keybind_mode")
        @LatticeWidgetButton
        public AltMenuKeybindMode keybindMode = AltMenuKeybindMode.HOLD;
        @LatticeOption(title="axiom.config.context_menu.auto_swap_to_creative", description="!!.description")
        @LatticeWidgetButton
        public boolean autoSwapToCreative = true;
        @LatticeOption(title="axiom.config.context_menu.auto_swap_to_hotbar_with_item", description="!!.description")
        @LatticeWidgetButton
        public boolean autoSwapToOtherHotbarWithItem = false;
        @LatticeOption(title="axiom.config.context_menu.global_hotbars", description="!!.description")
        @LatticeWidgetButton
        public boolean globalHotbars = false;
    }

    public static class SubcategoryCapabilities {
        @LatticeOption(title="axiom.capability.bulldozer.title", description="axiom.capability.bulldozer.description_alt")
        @LatticeWidgetButton
        public boolean bulldozer = true;
        @LatticeOption(title="axiom.capability.replace_mode.title", description="axiom.capability.replace_mode.description")
        @LatticeWidgetButton
        public boolean replaceMode = false;
        @LatticeOption(title="axiom.config.capabilities.type_replace", description="!!.description")
        @LatticeWidgetButton
        public boolean typeReplace = false;
        @LatticeOption(title="axiom.capability.force_place.title", description="axiom.capability.force_place.description")
        @LatticeWidgetButton
        public boolean forcePlace = false;
        @LatticeOption(title="axiom.capability.no_updates.title", description="axiom.capability.no_updates.description")
        @LatticeWidgetButton
        public boolean noUpdates = false;
        @LatticeOption(title="axiom.capability.tinker.title", description="axiom.capability.tinker.description")
        @LatticeWidgetButton
        public boolean tinker = true;
        @LatticeOption(title="axiom.capability.infinite_reach.title", description="axiom.capability.infinite_reach.description")
        @LatticeWidgetButton
        public boolean infiniteReach = false;
        @LatticeOption(title="axiom.contextmenu.infinite_reach_limit_none", description="axiom.config.capabilities.infinite_reach_limit.description")
        @LatticeWidgetCustom(function="createInfiniteReachLimitSlider")
        public int infiniteReachLimit = -1;
        @LatticeOption(title="axiom.capability.fast_place.title", description="axiom.capability.fast_place.description")
        @LatticeWidgetButton
        public boolean fastPlace = false;
        @LatticeOption(title="axiom.capability.angel_placement.title", description="axiom.capability.angel_placement.description")
        @LatticeWidgetButton
        public boolean angelPlacement = false;
        @LatticeOption(title="axiom.capability.no_clip.title", description="axiom.capability.no_clip.description")
        @LatticeWidgetButton
        public boolean noClip = false;
        @LatticeOption(title="axiom.capability.phantom.title", description="axiom.capability.phantom.description")
        @LatticeWidgetButton
        public boolean phantom = false;

        private WidgetFunction createInfiniteReachLimitSlider(final IntSupplier supplier, final IntConsumer consumer) {
            return new WidgetFunction(){

                public class_339 createWidget(class_327 arg, @NotNull class_2561 title, @Nullable class_2561 description, int width) {
                    float infiniteReachLimit = supplier.getAsInt();
                    infiniteReachLimit = infiniteReachLimit < 5.0f ? 1.0f : (infiniteReachLimit - 5.0f) / 96.0f;
                    return new class_357(0, 0, width, 20, class_5244.field_39003, infiniteReachLimit){
                        {
                            super(i, j, k, l, component, d);
                            this.method_25346();
                        }

                        protected void method_25346() {
                            int infiniteReachLimit = supplier.getAsInt();
                            if (infiniteReachLimit < 0) {
                                this.method_25355((class_2561)class_2561.method_43471((String)"axiom.contextmenu.infinite_reach_limit_none"));
                            } else {
                                this.method_25355((class_2561)class_2561.method_43469((String)"axiom.contextmenu.infinite_reach_limit", (Object[])new Object[]{infiniteReachLimit}));
                            }
                        }

                        protected void method_25344() {
                            int value = (int)(this.field_22753 * 96.0 + 5.0);
                            if (value < 5) {
                                value = 5;
                            }
                            if (value > 100) {
                                consumer.accept(-1);
                            } else {
                                consumer.accept(value);
                            }
                        }
                    };
                }
            };
        }
    }

    public static class SubcategoryBlockAttributes {
        @LatticeOption(title="axiom.block_attributes.show_collision_mesh", description="!!.description")
        @LatticeWidgetButton
        public boolean showCollisionMesh = false;
        @LatticeOption(title="axiom.block_attributes.show_light_blocks", description="!!.description")
        @LatticeWidgetButton
        public boolean showLightBlocks = false;
        @LatticeOption(title="axiom.block_attributes.show_structure_void_blocks", description="!!.description")
        @LatticeWidgetButton
        public boolean showStructureVoidBlocks = false;
        @LatticeOption(title="axiom.block_attributes.show_moving_piston_blocks", description="!!.description")
        @LatticeWidgetButton
        public boolean showMovingPistonBlocks = false;
        @LatticeOption(title="axiom.block_attributes.expand_hitboxes_to_full_cube", description="!!.description")
        @LatticeWidgetButton
        public boolean expandHitboxesToFullCube = false;
        @LatticeOption(title="axiom.block_attributes.make_fluid_hitboxes_solid", description="!!.description")
        @LatticeWidgetButton
        public boolean makeFluidHitboxesSolid = false;
        @LatticeOption(title="axiom.block_attributes.prevent_interactions", description="!!.description")
        @LatticeWidgetButton
        public boolean preventInteractions = false;
    }

    public static class SubcategoryMovement {
        @LatticeOption(title="axiom.config.movement.flight_momentum", description="!!.description")
        @LatticeFormatValues(formattingString="%d%%")
        @LatticeIntRange(min=0, max=100, clampMin=0, clampMax=100)
        @LatticeWidgetSlider
        public int flightMomentum = 100;
        @LatticeOption(title="axiom.contextmenu.flight_direction", description="axiom.config.movement.flight_direction.description")
        @LatticeWidgetButton
        public FlightDirection flightDirection = FlightDirection.HORIZONTAL;
        @LatticeOption(title="axiom.config.movement.sync_with_editor_ui", description="!!.description")
        @LatticeWidgetButton
        public boolean syncIngameMovementWithEditorUI = false;
        @LatticeOption(title="axiom.config.movement.separate_flight_speed", description="!!.description")
        @LatticeWidgetButton
        public boolean separateFlightSpeeds = false;
    }

    public static class SubcategoryBuilderTools {
        @LatticeOption(title="axiom.config.builder_tools.show_builder_tool_slot", description="!!.description")
        @LatticeWidgetButton
        public boolean showBuilderToolSlot = true;
        @LatticeOption(title="axiom.config.builder_tools.direction_lock", description="!!.description")
        @LatticeWidgetButton
        public boolean directionLock = true;
        @LatticeOption(title="axiom.config.builder_tools.symmetry_range", description="!!.description")
        @LatticeIntRange(min=64, max=1024, clampMin=0)
        @LatticeWidgetSlider
        public int symmetryRange = 128;
        @LatticeOption(title="axiom.config.builder_tools.magic_select_count", description="!!.description")
        @LatticeIntRange(min=16, max=1024, clampMin=1)
        @LatticeWidgetSlider
        public int magicSelectCount = 128;
        @LatticeOption(title="axiom.config.builder_tools.middle_click", description="!!.description")
        @LatticeWidgetButton
        public BuilderToolMiddleClick middleClick = BuilderToolMiddleClick.EXTEND_SELECT;
    }

    public static class SubcategoryCreativeMenu {
        @LatticeOption(title="axiom.config.creative_menu.show_color_picker", description="!!.description")
        @LatticeWidgetButton
        public boolean showColorPicker = true;
        @LatticeOption(title="axiom.config.creative_menu.show_gradient_helper", description="!!.description")
        @LatticeWidgetButton
        public boolean showGradientHelper = true;
        @LatticeOption(title="axiom.config.creative_menu.search_quick_add", description="!!.description")
        @LatticeWidgetButton
        public boolean searchQuickAdd = true;
    }

    public static class SubcategoryEntityManipulation {
        @LatticeOption(title="axiom.contextmenu.show_display_entity_gizmos", description="axiom.config.entity_manipulation.show_display_entity_gizmos.description")
        @LatticeWidgetButton
        public boolean showDisplayEntities = true;
        @LatticeOption(title="axiom.config.entity_manipulation.display_entity_range", description="!!.description")
        @LatticeIntRange(min=1, max=128, clampMin=1)
        @LatticeWidgetSlider
        public int displayEntityRange = 8;
        @LatticeOption(title="axiom.contextmenu.show_marker_entity_gizmos", description="axiom.config.entity_manipulation.show_marker_entity_gizmos.description")
        @LatticeWidgetButton
        public boolean showMarkerEntities = true;
        @LatticeOption(title="axiom.config.entity_manipulation.marker_entity_range", description="!!.description")
        @LatticeIntRange(min=1, max=128, clampMin=1)
        @LatticeWidgetSlider
        public int markerEntityRange = 24;
        @LatticeOption(title="axiom.config.entity_manipulation.swap_left_right_click", description="!!.description")
        @LatticeWidgetButton
        public boolean swapLeftRightClick = false;
    }

    public static class SubcategoryEditor {
        @LatticeOption(title="axiom.keybind.toggle_editor_ui")
        @LatticeWidgetKeybind
        private transient class_304 toggleEditorUiKeyBind = ClientEvents.toggleEditorUiKeyBind;
        @LatticeOption(title="axiom.editorui.tool_stabilization")
        @LatticeFloatRange(min=0.0f, max=16.0f, step="0.1", clampMin=0.0f, clampMax=64.0f)
        @LatticeWidgetSlider
        public float toolStabilization = 0.0f;
        @LatticeOption(title="axiom.config.editor.clear_tool_when_swapping", description="!!.description")
        @LatticeWidgetButton
        public boolean clearToolWhenSwapping = true;
    }

    public static class SubcategoryBlueprint {
        @LatticeOption(title="axiom.editorui.window.blueprint_browser.automatically_refresh", description="!!.description")
        @LatticeWidgetButton
        public boolean automaticRefreshing = true;
        @LatticeOption(title="axiom.editorui.window.blueprint_browser.search_inside_folders", description="!!.description")
        @LatticeWidgetButton
        public boolean recursiveSearch = false;
        @LatticeOption(title="axiom.config.blueprint.custom_path", description="!!.description")
        @LatticeWidgetTextField
        public String customPath = "";
        @LatticeOption(title="axiom.config.blueprint.default_tags", description="!!.description")
        @LatticeWidgetTextArea
        public String defaultTags = "small,medium,large,massive,organic,structure,terrain,interior,house,tower,bridge,castle,statue,temple,monument,barn,stable,windmill,store,watermill,ship,airship,balloon,palace,watchtower,mansion,grave,marketplace,mine,obelisk,warehouse,silo,shipwreck,mausoleum,cemetery,bunker,airplane,helicopter,car,truck,vehicle,blacksmith,crypt,factory,mountain,cliff,rock,iceberg,spike,stone,wood,brick,natural,sand,metal,winter,spring,summer,autumn,tree,bush,mushroom,spruce,oak,birch,coniferous,deciduous,acacia,mangrove,cherryblossom,darkoak,jungle,baobab,azalea,cypress,coral,sapling,grass,seagrass,bamboo,flowers,animal,creature,dead,lamp,streetlight,brazier,bed,bookshelf,closet,table,chair,fireplace,carpet,fountain,clock,banner,flag,bell,modern,medieval,steampunk,gothic,oriental,victorian,fantasy,sci-fi,elven,dwarven,futuristic,retro,classic,rustic,baroque,rococo,industrial,artnouveau,artdeco,cyberpunk,space,arabic,indian,egyptian,greek,roman,norse,mesoamerican,japanese,western,spanish,tudor,spooky,pirate,dungeons,rubble,crates,redstone,wall,window,roof,stairs,pillar,arch,stairs,chimney,well";
    }

    public static class SubcategoryInternal {
        public long nextUpdateNag = 0L;
        public boolean shownIntroduction = false;
        public boolean showOpenConfigTip = true;
        public boolean showOpenContextMenuTip = true;
        public boolean showOpenEditorTip = true;
        public Set<String> completedTutorials = new HashSet<String>();
        public List<String> openEditorWindowTypes = EditorWindowType.getOpenByName();
        public String defaultLayout = "[Window][###Tools]\nPos=0,0\nSize=300,250\nCollapsed=0\nDockId=0x00000003,0\n\n[Window][###Tool Options]\nPos=0,250\nSize=300,750\nCollapsed=0\nDockId=0x00000004,0\n\n[Window][###Clipboard]\nPos=1700,0\nSize=300,200\nCollapsed=0\nDockId=0x0000000D,0\n\n[Window][###TargetInfo]\nPos=1700,0\nSize=300,200\nCollapsed=0\nDockId=0x0000000D,1\n\n[Window][###Palette]\nPos=1700,200\nSize=300,200\nCollapsed=0\nDockId=0x0000000E,0\n\n[Window][###ActiveBlock]\nPos=1700,400\nSize=300,100\nCollapsed=0\nDockId=0x0000000C,0\n\n[Window][###History]\nPos=1700,500\nSize=300,300\nCollapsed=0\nDockId=0x0000000A,0\n\n[Window][###WorldProperties]\nPos=1700,800\nSize=300,200\nCollapsed=0\nDockId=0x00000008,0\n\n[Docking][Data]\nDockSpace           ID=0x8B93E3BD Window=0xA787BDB4 Pos=0,0 Size=2000,1000 Split=X\nDockNode          ID=0x00000005 Parent=0x8B93E3BD SizeRef=1700,1000 Split=X\n DockNode        ID=0x00000001 Parent=0x00000005 SizeRef=300,1000 Split=Y\n   DockNode      ID=0x00000003 Parent=0x00000001 SizeRef=300,250 Selected=0x80AFE82B\n   DockNode      ID=0x00000004 Parent=0x00000001 SizeRef=300,750 Selected=0xECA27DCB\n DockNode        ID=0x00000002 Parent=0x00000005 SizeRef=1400,1000 CentralNode=1 Selected=0x1F1A625A\nDockNode          ID=0x00000006 Parent=0x8B93E3BD SizeRef=300,1000 Split=Y Selected=0x34064FA7\n DockNode        ID=0x00000007 Parent=0x00000006 SizeRef=300,800 Split=Y Selected=0x34064FA7\n   DockNode      ID=0x00000009 Parent=0x00000007 SizeRef=300,500 Split=Y Selected=0x34064FA7\n     DockNode    ID=0x0000000B Parent=0x00000009 SizeRef=300,400 Split=Y Selected=0x34064FA7\n       DockNode  ID=0x0000000D Parent=0x0000000B SizeRef=300,200 Selected=0x34064FA7\n       DockNode  ID=0x0000000E Parent=0x0000000B SizeRef=300,200 Selected=0x1E514AEA\n     DockNode    ID=0x0000000C Parent=0x00000009 SizeRef=300,100 Selected=0x1D216E21\n   DockNode      ID=0x0000000A Parent=0x00000007 SizeRef=300,300 Selected=0xFE0E9DDF\n DockNode        ID=0x00000008 Parent=0x00000006 SizeRef=300,200 Selected=0x602D8B84";
        public int lastTranslationCount = 0;
        public float globalScale = 1.0f;
        public String savedCustomTheme = "";
        public boolean showCloseWindowButton = false;
        public boolean showToolMaskOpenWarning = true;
        public boolean showNon90DegreeRotationWarning = true;
        public boolean showQuickReplaceCtrlClickTip = true;
        public boolean dockedInventoryWithPalette = false;
        public EditorPalette rootEditorPalette = new EditorPalette("");
        public Map<String, String> customDowngradeSuggestions = new LinkedHashMap<String, String>();
        public boolean invertCameraRotate = false;
        public boolean useCenterOfScreenForArcball = false;
        public boolean pickBlockDrag = true;
        public boolean cutAlsoCopiesToClipboard = false;
        public boolean useVanillaMovementForEditor = true;
        public boolean tallGrassIsActuallyNotTall = false;
        public boolean disableChunkRenderOverrider = false;
        public boolean hadEditorUIOpen = false;
        public int blueprintBrowserDirSize = 175;
    }
}

