/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.styles;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.styles.BuiltinStyles;
import com.moulberry.axiom.editor.styles.StyleHelper;
import imgui.ImGui;
import imgui.ImGuiStyle;
import imgui.type.ImString;

public class StyleManager {
    private static int baseStyleIndex = 0;
    private static final ImString customThemeName = new ImString(64);

    public static void initialize() {
        StyleHelper.Theme theme;
        if (Axiom.configuration.internal.savedCustomTheme != null && (theme = StyleHelper.Theme.convertFromBase64(Axiom.configuration.internal.savedCustomTheme.trim())) != null) {
            StyleManager.loadTheme(theme);
        }
    }

    public static ImGuiStyle getBaseStyle() {
        return BuiltinStyles.BASE_STYLES[baseStyleIndex];
    }

    public static int getBaseStyleIndex() {
        return baseStyleIndex;
    }

    public static ImString getCustomThemeName() {
        return customThemeName;
    }

    public static StyleHelper.Theme createTheme() {
        if (ImGui.getCurrentContext().isNotValidPtr()) {
            return null;
        }
        StyleHelper.ModifiedStyleValues modified = StyleHelper.calcModifiedStyleValues(StyleManager.getBaseStyle(), ImGui.getStyle());
        String themeId = BuiltinStyles.getStringId(baseStyleIndex);
        return new StyleHelper.Theme(ImGuiHelper.getString(StyleManager.getCustomThemeName()), themeId, modified);
    }

    public static void loadTheme(StyleHelper.Theme theme) {
        customThemeName.set(theme.name());
        int styleIndex = BuiltinStyles.getIndexForStringId(theme.baseTheme());
        StyleManager.resetToBaseStyle(styleIndex);
        StyleHelper.applyModifiedStyleValues(ImGui.getStyle(), theme.values());
    }

    public static void switchBaseStyle(int newBaseStyleIndex) {
        StyleHelper.ModifiedStyleValues modified = StyleHelper.calcModifiedStyleValues(StyleManager.getBaseStyle(), ImGui.getStyle());
        baseStyleIndex = newBaseStyleIndex;
        StyleHelper.copyStyleValues(StyleManager.getBaseStyle(), ImGui.getStyle());
        StyleHelper.applyModifiedStyleValues(ImGui.getStyle(), modified);
    }

    public static void resetToBaseStyle(int baseStyleIndex) {
        StyleManager.baseStyleIndex = baseStyleIndex;
        StyleHelper.copyStyleValues(StyleManager.getBaseStyle(), ImGui.getStyle());
    }

    public static void reset() {
        StyleHelper.copyStyleValues(StyleManager.getBaseStyle(), ImGui.getStyle());
        StyleManager.getCustomThemeName().set("");
    }
}

