/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.clipboard;

import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintDirectory;
import com.moulberry.axiom.editor.windows.clipboard.BlueprintOrDirectory;
import com.moulberry.axiom.editor.windows.clipboard.PathWrapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;

public class BlueprintDirectoryLoader {
    public static BlueprintDirectory loadDirectory(String name, Path path, WatchService watchService, Map<Path, BlueprintDirectory> dirStructureMap) {
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        BlueprintOrDirectory blueprintOrDirectory = forkJoinPool.invoke(new LoadBlueprintOrDirectoryTask(name, path, watchService, Collections.synchronizedMap(dirStructureMap)));
        if (blueprintOrDirectory instanceof BlueprintOrDirectory.Dir) {
            BlueprintOrDirectory.Dir dir = (BlueprintOrDirectory.Dir)blueprintOrDirectory;
            return dir.blueprintDirectory;
        }
        throw new RuntimeException("Not a valid blueprint directory: " + String.valueOf(path));
    }

    public static BlueprintOrDirectory loadBlueprintOrDirectory(Path path, WatchService watchService, Map<Path, BlueprintDirectory> dirStructureMap) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            String name = path.getFileName().toString();
            ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
            return forkJoinPool.invoke(new LoadBlueprintOrDirectoryTask(name, path, watchService, Collections.synchronizedMap(dirStructureMap)));
        }
        return BlueprintDirectoryLoader.loadBpInner(path);
    }

    private static ForkJoinTask<BlueprintOrDirectory> forkBlueprintOrDirectory(Path path, WatchService watchService, Map<Path, BlueprintDirectory> dirStructureMap) {
        return new LoadBlueprintOrDirectoryTask(path.getFileName().toString(), path, watchService, dirStructureMap).fork();
    }

    private static BlueprintOrDirectory.Bp loadBpInner(Path path) {
        BlueprintOrDirectory.Bp bp;
        BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]), 2048);
        try {
            BlueprintHeader blueprintHeader = BlueprintIo.readHeader(inputStream);
            bp = new BlueprintOrDirectory.Bp(new PathWrapper(path, null), blueprintHeader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        ((InputStream)inputStream).close();
        return bp;
    }

    private static class LoadBlueprintOrDirectoryTask
    extends RecursiveTask<BlueprintOrDirectory> {
        private final String name;
        private final Path path;
        private final WatchService watchService;
        private final Map<Path, BlueprintDirectory> dirStructureMap;

        public LoadBlueprintOrDirectoryTask(String name, Path path, WatchService watchService, Map<Path, BlueprintDirectory> dirStructureMap) {
            this.name = name;
            this.path = path;
            this.watchService = watchService;
            this.dirStructureMap = dirStructureMap;
        }

        @Override
        protected BlueprintOrDirectory compute() {
            if (Files.isDirectory(this.path, new LinkOption[0])) {
                HashSet<Path> loadedPaths = new HashSet<Path>();
                BlueprintDirectory blueprintDirectory = new BlueprintDirectory(new PathWrapper(this.path, null), this.name);
                try {
                    if (this.watchService != null) {
                        this.path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                    }
                    this.dirStructureMap.put(this.path, blueprintDirectory);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                ArrayList<ForkJoinTask<BlueprintOrDirectory>> childrenTasks = new ArrayList<ForkJoinTask<BlueprintOrDirectory>>();
                Path dotfile = this.path.resolve(".axiom_blueprint_ordering");
                if (Files.exists(dotfile, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(dotfile);){
                        String string;
                        while ((string = reader.readLine()) != null) {
                            Path subpath = this.path.resolve(string.replace("/", this.path.getFileSystem().getSeparator()));
                            if (!loadedPaths.add(subpath)) continue;
                            childrenTasks.add(BlueprintDirectoryLoader.forkBlueprintOrDirectory(subpath, this.watchService, this.dirStructureMap));
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.path);){
                    for (Path subpath : ds) {
                        if (loadedPaths.contains(subpath) || subpath.getFileName().toString().startsWith(".")) continue;
                        childrenTasks.add(BlueprintDirectoryLoader.forkBlueprintOrDirectory(subpath, this.watchService, this.dirStructureMap));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                for (ForkJoinTask forkJoinTask : childrenTasks) {
                    BlueprintOrDirectory blueprintOrDirectory = (BlueprintOrDirectory)forkJoinTask.join();
                    if (blueprintOrDirectory == null) continue;
                    blueprintDirectory.addLast(blueprintOrDirectory);
                }
                return new BlueprintOrDirectory.Dir(blueprintDirectory);
            }
            return BlueprintDirectoryLoader.loadBpInner(this.path);
        }
    }
}

