/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.i18n;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.StaticValues;
import com.moulberry.axiom.i18n.LoadedPackResources;
import com.moulberry.axiom.i18n.LocalizationSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.Bidi;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;

public class LocalizationLoader {
    private static final Gson GSON = new GsonBuilder().create();
    private static boolean attemptedLocalizationDownload = false;
    private static boolean appliedCachedTranslations = false;
    private static final Set<String> languages = Set.of("af_za", "ar_sa", "ast_es", "az_az", "ba_ru", "bar", "be_by", "bg_bg", "br_fr", "brb", "bs_ba", "ca_es", "cs_cz", "cy_gb", "da_dk", "de_at", "de_ch", "de_de", "el_gr", "en_au", "en_ca", "en_gb", "en_nz", "en_pt", "en_ud", "en_us", "enp", "enws", "eo_uy", "es_ar", "es_cl", "es_ec", "es_es", "es_mx", "es_uy", "es_ve", "esan", "et_ee", "eu_es", "fa_ir", "fi_fi", "fil_ph", "fo_fo", "fr_ca", "fr_fr", "fra_de", "fur_it", "fy_nl", "ga_ie", "gd_gb", "gl_es", "haw_us", "he_il", "hi_in", "hr_hr", "hu_hu", "hy_am", "id_id", "ig_ng", "io_en", "is_is", "isv", "it_it", "ja_jp", "jbo_en", "ka_ge", "kk_kz", "kn_in", "ko_kr", "ksh", "kw_gb", "la_la", "lb_lu", "li_li", "lmo", "lo_la", "lol_us", "lt_lt", "lv_lv", "lzh", "mk_mk", "mn_mn", "ms_my", "mt_mt", "nah", "nds_de", "nl_be", "nl_nl", "nn_no", "no_no", "oc_fr", "ovd", "pl_pl", "pt_br", "pt_pt", "qya_aa", "ro_ro", "rpr", "ru_ru", "ry_ua", "sah_sah", "se_no", "sk_sk", "sl_si", "so_so", "sq_al", "sr_cs", "sr_sp", "sv_se", "sxu", "szl", "ta_in", "th_th", "tl_ph", "tlh_aa", "tok", "tr_tr", "tt_ru", "uk_ua", "val_es", "vec_it", "vi_vn", "yi_de", "yo_ng", "zh_cn", "zh_hk", "zh_tw", "zlm_arab");

    public static synchronized void applyCachedTranslations() {
        try {
            Path path;
            String languageCode = class_310.method_1551().field_1690.field_1883;
            if (!languageCode.startsWith("en") && Files.exists(path = Axiom.getInstance().getConfigDirectory().resolve("translations.zip"), new LinkOption[0])) {
                Axiom.dbg("Using cached localizations...");
                byte[] cachedBytes = Files.readAllBytes(path);
                Map<String, byte[]> localizations = LocalizationLoader.createLocalizations(cachedBytes);
                LocalizationSource.INSTANCE.setResources(new LoadedPackResources("axiom_translations", (class_2561)class_2561.method_43470((String)"Axiom Translations"), localizations));
                appliedCachedTranslations = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void languageChanged(String languageCode) {
        if (attemptedLocalizationDownload) {
            return;
        }
        if (!languageCode.startsWith("en")) {
            attemptedLocalizationDownload = true;
            ForkJoinPool.commonPool().submit(() -> {
                try {
                    byte[] cachedBytes;
                    Path path = Axiom.getInstance().getConfigDirectory().resolve("translations.zip");
                    boolean wantDownload = true;
                    boolean canDownload = true;
                    boolean canUseCached = true;
                    if (!Files.exists(path, new LinkOption[0])) {
                        canUseCached = false;
                    }
                    int remoteCount = 0;
                    try {
                        remoteCount = LocalizationLoader.fetchUpdateCount();
                        Axiom.dbg("Localization update count: remote=" + remoteCount + ", last=" + Axiom.configuration.internal.lastTranslationCount);
                        if (Axiom.configuration.internal.lastTranslationCount == remoteCount) {
                            wantDownload = false;
                        }
                    }
                    catch (Exception e) {
                        canDownload = false;
                        wantDownload = false;
                    }
                    if (canUseCached && !wantDownload) {
                        if (appliedCachedTranslations) {
                            return;
                        }
                        Axiom.dbg("Using cached localizations...");
                        cachedBytes = Files.readAllBytes(path);
                        try {
                            Map<String, byte[]> localizations = LocalizationLoader.createLocalizations(cachedBytes);
                            LocalizationSource.INSTANCE.setResources(new LoadedPackResources("axiom_translations", (class_2561)class_2561.method_43470((String)"Axiom Translations"), localizations));
                            StaticValues.shouldReloadResourcesForLanguage = true;
                            appliedCachedTranslations = true;
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (canDownload) {
                        Axiom.dbg("Downloading localizations...");
                        try {
                            URL url = new URL("https://axiom.moulberry.com/weblate/api/components/axiom/mod/file/");
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            conn.setConnectTimeout(5000);
                            conn.setRequestMethod("GET");
                            conn.setRequestProperty("Authorization", "Token wlp_tWKISyESQ0OAAmYj7MqvJEjDZAZvHWtju1WW");
                            conn.setRequestProperty("Accept", "*/*");
                            InputStream inputStream = conn.getInputStream();
                            byte[] allBytes = inputStream.readAllBytes();
                            Files.write(path, allBytes, new OpenOption[0]);
                            Axiom.configuration.internal.lastTranslationCount = remoteCount;
                            Map<String, byte[]> localizations = LocalizationLoader.createLocalizations(allBytes);
                            LocalizationSource.INSTANCE.setResources(new LoadedPackResources("axiom_translations", (class_2561)class_2561.method_43470((String)"Axiom Translations"), localizations));
                            StaticValues.shouldReloadResourcesForLanguage = true;
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (canUseCached) {
                        if (appliedCachedTranslations) {
                            return;
                        }
                        Axiom.dbg("Using cached localizations after download failed...");
                        cachedBytes = Files.readAllBytes(path);
                        try {
                            Map<String, byte[]> localizations = LocalizationLoader.createLocalizations(cachedBytes);
                            LocalizationSource.INSTANCE.setResources(new LoadedPackResources("axiom_translations", (class_2561)class_2561.method_43470((String)"Axiom Translations"), localizations));
                            StaticValues.shouldReloadResourcesForLanguage = true;
                            appliedCachedTranslations = true;
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private static int fetchUpdateCount() throws IOException {
        URL url = new URL("https://axiom.moulberry.com/weblate/api/components/axiom/mod/changes/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Token wlp_tWKISyESQ0OAAmYj7MqvJEjDZAZvHWtju1WW");
        conn.setRequestProperty("Accept", "application/json");
        InputStream inputStream = conn.getInputStream();
        String input = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        conn.disconnect();
        JsonObject jsonObject = (JsonObject)GSON.fromJson(input, JsonObject.class);
        return jsonObject.get("count").getAsInt();
    }

    private static Map<String, byte[]> createLocalizations(byte[] translationsZip) throws IOException {
        ZipFile zipFile = new ZipFile((SeekableByteChannel)new SeekableInMemoryByteChannel(translationsZip));
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        Enumeration enumeration = zipFile.getEntries();
        while (enumeration.hasMoreElements()) {
            Object lang;
            ZipArchiveEntry entry = (ZipArchiveEntry)enumeration.nextElement();
            String name = entry.getName();
            String[] split = name.split("/");
            switch (lang = split[split.length - 1].replace(".json", "").toLowerCase(Locale.ROOT)) {
                case "ru": {
                    Object object = "ru_ru";
                    break;
                }
                case "cs": {
                    Object object = "cs_cz";
                    break;
                }
                case "de": {
                    Object object = "de_de";
                    break;
                }
                case "en": {
                    Object object = "en_us";
                    break;
                }
                case "es": {
                    Object object = "es_es";
                    break;
                }
                case "fr": {
                    Object object = "fr_fr";
                    break;
                }
                case "ja": {
                    Object object = "ja_jp";
                    break;
                }
                case "nl": {
                    Object object = "nl_nl";
                    break;
                }
                case "uk": {
                    Object object = "uk_ua";
                    break;
                }
                case "tr": {
                    Object object = "tr_tr";
                    break;
                }
                case "zh_hans": {
                    Object object = "zh_cn";
                    break;
                }
                case "zh_hant": {
                    Object object = "zh_tw";
                    break;
                }
                case "pl": {
                    Object object = "pl_pl";
                    break;
                }
                case "da": {
                    Object object = "da_dk";
                    break;
                }
                case "sv": {
                    Object object = "sv_se";
                    break;
                }
                case "af": {
                    Object object = "af_za";
                    break;
                }
                case "ko": {
                    Object object = "ko_kr";
                    break;
                }
                default: {
                    Object object = lang = lang;
                }
            }
            if (!languages.contains(lang)) {
                if (languages.contains((String)lang + "_" + (String)lang)) {
                    lang = (String)lang + "_" + (String)lang;
                } else {
                    for (String language : languages) {
                        if (!language.startsWith((String)lang + "_")) continue;
                        lang = language;
                        break;
                    }
                }
            }
            if (!languages.contains(lang)) {
                Axiom.LOGGER.error("Unknown language, need alias: {}", lang);
                continue;
            }
            byte[] bytes = zipFile.getInputStream(entry).readAllBytes();
            if (((String)lang).startsWith("he")) {
                JsonObject object = (JsonObject)GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), JsonObject.class);
                JsonObject newObject = new JsonObject();
                for (Map.Entry jsonEntry : object.entrySet()) {
                    String value = LocalizationLoader.convertBidi(((JsonElement)jsonEntry.getValue()).getAsString());
                    value = value.replace("s%", "%s");
                    value = value.replace("s$1%", "%1$s");
                    value = value.replace("s$2%", "%2$s");
                    value = value.replace("s$3%", "%3$s");
                    newObject.addProperty((String)jsonEntry.getKey(), value);
                }
                bytes = GSON.toJson((JsonElement)newObject).getBytes(StandardCharsets.UTF_8);
            }
            data.put("lang/" + (String)lang + ".json", bytes);
            if (!((String)lang).equals("zh_tw")) continue;
            data.put("lang/zh_hk.json", bytes);
        }
        block41: for (String languageKey : languages) {
            if (data.containsKey("lang/" + languageKey + ".json")) continue;
            String code = languageKey.split("_")[0];
            for (Map.Entry entry : data.entrySet()) {
                if (!((String)entry.getKey()).startsWith("lang/" + code + "_")) continue;
                data.put("lang/" + languageKey + ".json", (byte[])entry.getValue());
                continue block41;
            }
        }
        return data;
    }

    private static String convertBidi(String input) {
        Bidi bidi = new Bidi(input, -1);
        int runCount = bidi.getRunCount();
        StringBuilder builder = new StringBuilder();
        if (bidi.baseIsLeftToRight()) {
            for (int i = 0; i < runCount; ++i) {
                String subString = input.substring(bidi.getRunStart(i), bidi.getRunLimit(i));
                if (bidi.getRunLevel(i) % 2 != 0) {
                    for (int j = 0; j < subString.length(); ++j) {
                        char c = subString.charAt(j);
                        if (c == '(') {
                            builder.insert(0, ')');
                            continue;
                        }
                        if (c == ')') {
                            builder.insert(0, '(');
                            continue;
                        }
                        builder.insert(0, c);
                    }
                    continue;
                }
                builder.append(subString);
            }
        } else {
            for (int i = 0; i < runCount; ++i) {
                String subString = input.substring(bidi.getRunStart(i), bidi.getRunLimit(i));
                if (bidi.getRunLevel(i) % 2 != 0) {
                    for (int j = 0; j < subString.length(); ++j) {
                        char c = subString.charAt(j);
                        if (c == '(') {
                            builder.insert(0, ')');
                            continue;
                        }
                        if (c == ')') {
                            builder.insert(0, '(');
                            continue;
                        }
                        builder.insert(0, c);
                    }
                    continue;
                }
                builder.insert(0, subString);
            }
        }
        return builder.toString();
    }
}

