/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mask;

import com.mojang.datafixers.util.Pair;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.widgets.BlockConditionWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.NumericVisitor;
import com.moulberry.axiom.mask.antlr.MaskBaseVisitor;
import com.moulberry.axiom.mask.antlr.MaskLexer;
import com.moulberry.axiom.mask.antlr.MaskParser;
import com.moulberry.axiom.mask.elements.AllMaskElement;
import com.moulberry.axiom.mask.elements.AngleMaskElement;
import com.moulberry.axiom.mask.elements.AnyMaskElement;
import com.moulberry.axiom.mask.elements.BiomeConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockAboveConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockAdjacentConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockBelowConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockNearConditionMaskElement;
import com.moulberry.axiom.mask.elements.BlockNeighborConditionMaskElement;
import com.moulberry.axiom.mask.elements.BothMaskElement;
import com.moulberry.axiom.mask.elements.CanSeeSkyMaskElement;
import com.moulberry.axiom.mask.elements.CoordMaskElement;
import com.moulberry.axiom.mask.elements.EitherMaskElement;
import com.moulberry.axiom.mask.elements.GenericBlockConditionMaskElement;
import com.moulberry.axiom.mask.elements.GenericSingleMaskElement;
import com.moulberry.axiom.mask.elements.NotMaskElement;
import com.moulberry.axiom.mask.elements.OffsetMaskElement;
import com.moulberry.axiom.mask.elements.SelectedMaskElement;
import com.moulberry.axiom.mask.elements.SurfaceMaskElement;
import com.moulberry.axiom.utils.BooleanWrapper;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
import net.minecraft.class_151;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.antlr.axiom.v4.runtime.ANTLRErrorListener;
import org.antlr.axiom.v4.runtime.CharStreams;
import org.antlr.axiom.v4.runtime.CommonTokenStream;
import org.antlr.axiom.v4.runtime.DefaultErrorStrategy;
import org.antlr.axiom.v4.runtime.InputMismatchException;
import org.antlr.axiom.v4.runtime.Parser;
import org.antlr.axiom.v4.runtime.ParserRuleContext;
import org.antlr.axiom.v4.runtime.RecognitionException;
import org.antlr.axiom.v4.runtime.Recognizer;
import org.antlr.axiom.v4.runtime.Token;
import org.antlr.axiom.v4.runtime.atn.ATNConfigSet;
import org.antlr.axiom.v4.runtime.dfa.DFA;
import org.antlr.axiom.v4.runtime.misc.IntervalSet;

public class CmdStringConverter {
    public static MaskElement fromCmdString(String string) throws CmdStringParseException {
        string = string.toLowerCase(Locale.ROOT);
        MaskLexer lexer = new MaskLexer(CharStreams.fromString(string));
        lexer.removeErrorListeners();
        MaskParser parser = new MaskParser(new CommonTokenStream(lexer));
        MaskBaseVisitor<MaskElement> visitor = new MaskBaseVisitor<MaskElement>(){

            @Override
            public MaskElement visitMask(MaskParser.MaskContext ctx) {
                return ctx.maskElement().accept(this);
            }

            @Override
            public MaskElement visitMaskElementNot(MaskParser.MaskElementNotContext ctx) {
                MaskElement inner = ctx.maskElement().accept(this);
                if (inner == null) {
                    return null;
                }
                return new NotMaskElement(inner);
            }

            @Override
            public MaskElement visitMaskElementParen(MaskParser.MaskElementParenContext ctx) {
                return ctx.maskElement().accept(this);
            }

            @Override
            public MaskElement visitMaskElementSingle(MaskParser.MaskElementSingleContext ctx) {
                return switch (ctx.single().getText()) {
                    case "selected" -> new SelectedMaskElement();
                    case "sky" -> new CanSeeSkyMaskElement();
                    case "surface" -> new SurfaceMaskElement();
                    default -> throw new FaultyImplementationError();
                };
            }

            @Override
            public MaskElement visitMaskElementOr(MaskParser.MaskElementOrContext ctx) {
                MaskElement left = ctx.maskElement(0).accept(this);
                MaskElement right = ctx.maskElement(1).accept(this);
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                return new EitherMaskElement(left, right);
            }

            @Override
            public MaskElement visitMaskElementAnd(MaskParser.MaskElementAndContext ctx) {
                MaskElement left = ctx.maskElement(0).accept(this);
                MaskElement right = ctx.maskElement(1).accept(this);
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                return new BothMaskElement(left, right);
            }

            @Override
            public MaskElement visitMaskElementCmpBiome(MaskParser.MaskElementCmpBiomeContext ctx) {
                MaskParser.CmpBiomeContext cmpBiomeContext = ctx.cmpBiome();
                MaskParser.MultiBiomeMatchContext multiBiomeMatchContext = ctx.multiBiomeMatch();
                if (cmpBiomeContext == null || multiBiomeMatchContext == null) {
                    return null;
                }
                ArrayList<BiomeConditionMaskElement> any = new ArrayList<BiomeConditionMaskElement>();
                List<MaskParser.IdentifierContext> blockMatches = multiBiomeMatchContext.identifier();
                for (MaskParser.IdentifierContext biomeMatch : blockMatches) {
                    class_6880<class_1959> biome = CmdStringConverter.parseBiome(biomeMatch.getText(), biomeMatch.start.getStartIndex());
                    any.add(new BiomeConditionMaskElement((class_5321<class_1959>)((class_5321)biome.method_40230().get())));
                }
                if (ctx.cmp.getType() == 38) {
                    return new AnyMaskElement(any.toArray(new MaskElement[0]));
                }
                if (ctx.cmp.getType() == 43) {
                    return new NotMaskElement(new AnyMaskElement(any.toArray(new MaskElement[0])));
                }
                throw new FaultyImplementationError();
            }

            @Override
            public MaskElement visitMaskElementCmpBlock(MaskParser.MaskElementCmpBlockContext ctx) {
                MaskParser.CmpBlockContext cmpBlockContext = ctx.cmpBlock();
                MaskParser.MultiBlockMatchContext multiBlockMatchContext = ctx.multiBlockMatch();
                if (cmpBlockContext == null || multiBlockMatchContext == null) {
                    return null;
                }
                MaskParser.NearContext nearContext = cmpBlockContext.near();
                String text = cmpBlockContext.getText();
                ArrayList<MaskElement> any = new ArrayList<MaskElement>();
                List<MaskParser.BlockMatchContext> blockMatches = multiBlockMatchContext.blockMatch();
                block14: for (MaskParser.BlockMatchContext blockMatch : blockMatches) {
                    BlockConditionWidget.BlockConditionState condition = CmdStringConverter.parseBlockCondition(blockMatch.getText(), blockMatch.start.getStartIndex());
                    if (nearContext != null) {
                        MaskParser.NumericContext numeric = nearContext.numeric();
                        int radius = numeric == null ? 1 : numeric.accept(new NumericVisitor());
                        any.add(new BlockNearConditionMaskElement(condition.createCondition(), List.of(condition), radius));
                        continue;
                    }
                    switch (text) {
                        case "block": {
                            any.add(new BlockConditionMaskElement(condition.createCondition(), List.of(condition)));
                            continue block14;
                        }
                        case "above": {
                            any.add(new BlockAboveConditionMaskElement(condition.createCondition(), List.of(condition)));
                            continue block14;
                        }
                        case "below": {
                            any.add(new BlockBelowConditionMaskElement(condition.createCondition(), List.of(condition)));
                            continue block14;
                        }
                        case "neighbor": {
                            any.add(new BlockNeighborConditionMaskElement(condition.createCondition(), List.of(condition)));
                            continue block14;
                        }
                        case "adjacent": {
                            any.add(new BlockAdjacentConditionMaskElement(condition.createCondition(), List.of(condition)));
                            continue block14;
                        }
                    }
                    throw new FaultyImplementationError();
                }
                if (ctx.cmp.getType() == 38) {
                    return new AnyMaskElement(any.toArray(new MaskElement[0]));
                }
                if (ctx.cmp.getType() == 43) {
                    return new NotMaskElement(new AnyMaskElement(any.toArray(new MaskElement[0])));
                }
                throw new FaultyImplementationError();
            }

            @Override
            public MaskElement visitMaskElementCmpNumeric(MaskParser.MaskElementCmpNumericContext ctx) {
                int value = ctx.numeric().accept(new NumericVisitor());
                int comparison = switch (ctx.cmp.getType()) {
                    case 38 -> 0;
                    case 43 -> 1;
                    case 41 -> 3;
                    case 42 -> 5;
                    case 39 -> 2;
                    case 40 -> 4;
                    default -> throw new FaultyImplementationError();
                };
                return switch (ctx.cmpNumeric().getText()) {
                    case "x" -> new CoordMaskElement(class_2350.class_2351.field_11048, value, comparison);
                    case "y" -> new CoordMaskElement(class_2350.class_2351.field_11052, value, comparison);
                    case "z" -> new CoordMaskElement(class_2350.class_2351.field_11051, value, comparison);
                    case "angle" -> new AngleMaskElement(value, comparison);
                    default -> throw new FaultyImplementationError();
                };
            }

            @Override
            public MaskElement visitMaskElementOffset(MaskParser.MaskElementOffsetContext ctx) {
                int offsetX = ctx.numeric(0).accept(new NumericVisitor());
                int offsetY = ctx.numeric(1).accept(new NumericVisitor());
                int offsetZ = ctx.numeric(2).accept(new NumericVisitor());
                MaskElement inner = ctx.maskElement().accept(this);
                if (inner == null) {
                    return null;
                }
                return new OffsetMaskElement(inner, offsetX, offsetY, offsetZ);
            }
        };
        parser.setErrorHandler(new DefaultErrorStrategy(){

            @Override
            protected void reportInputMismatch(Parser recognizer, InputMismatchException e) {
                ParserRuleContext context = recognizer.getRuleContext();
                if (context.getChildCount() == 0) {
                    String friendlyName;
                    switch (context.getRuleIndex()) {
                        case 0: 
                        case 1: {
                            String string = "mask name";
                            break;
                        }
                        case 3: {
                            String string = "block or block tag";
                            break;
                        }
                        case 2: {
                            String string = "biome";
                            break;
                        }
                        case 11: {
                            String string = "number";
                            break;
                        }
                        default: {
                            String string = friendlyName = null;
                        }
                    }
                    if (friendlyName != null) {
                        String msg = "expected " + friendlyName;
                        if (e.getOffendingToken().getType() != -1) {
                            msg = msg + ", got " + this.getTokenErrorDisplay(e.getOffendingToken());
                        }
                        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
                        return;
                    }
                }
                IntervalSet expectedTokens = e.getExpectedTokens();
                String msg = e.getOffendingToken().getType() == -1 ? "expected " + expectedTokens.toString(recognizer.getVocabulary()).replace("EQUALS", "'='") : "mismatched input " + this.getTokenErrorDisplay(e.getOffendingToken()) + " expected " + expectedTokens.toString(recognizer.getVocabulary()).replace("EQUALS", "'='");
                recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
            }
        });
        parser.removeErrorListeners();
        parser.addErrorListener(new ANTLRErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                int start;
                String symbolStr;
                if (offendingSymbol instanceof Token) {
                    Token token = (Token)offendingSymbol;
                    symbolStr = token.getText();
                    start = token.getStartIndex();
                } else {
                    symbolStr = offendingSymbol.toString();
                    start = charPositionInLine;
                }
                throw new CmdStringParseException(start, start + symbolStr.length() + 1, msg);
            }

            @Override
            public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
            }

            @Override
            public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
            }

            @Override
            public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
            }
        });
        MaskElement maskElement = (MaskElement)visitor.visit(parser.mask());
        if (maskElement != null) {
            return maskElement;
        }
        throw new CmdStringParseException(0, string.length(), "Unknown Error");
    }

    private static class_6880<class_1959> parseBiome(String biomeStr, int start) {
        class_2960 resource;
        try {
            resource = class_2960.method_60654((String)biomeStr);
        }
        catch (class_151 e) {
            throw new CmdStringParseException(start, start + biomeStr.length() + 1, "not a valid resource location");
        }
        class_2378 registry = (class_2378)class_310.method_1551().method_1562().method_29091().method_33310(class_7924.field_41236).get();
        Optional biomeOpt = registry.method_40264(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)resource));
        if (biomeOpt.isEmpty()) {
            throw new CmdStringParseException(start, start + biomeStr.length() + 1, "unknown biome");
        }
        return (class_6880)biomeOpt.get();
    }

    private static BlockConditionWidget.BlockConditionState parseBlockCondition(String blockStr, int start) {
        if (blockStr.startsWith("#")) {
            class_2960 resource;
            blockStr = blockStr.substring("#".length());
            try {
                resource = class_2960.method_60654((String)blockStr);
            }
            catch (class_151 e) {
                throw new CmdStringParseException(start, start + blockStr.length() + 1, "not a valid resource location");
            }
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)resource);
            Optional<class_6885.class_6888> tagOpt = class_7923.field_41175.method_40266(tagKey);
            if (tagOpt.isPresent()) {
                class_6885.class_6888 tag = (class_6885.class_6888)tagOpt.get();
                BlockList.MinecraftOrCustomTagSet tagSet = new BlockList.MinecraftOrCustomTagSet(resource, (class_6885<class_2248>)tag, null);
                return new BlockConditionWidget.BlockConditionState(null, null, tagSet);
            }
            Set localTag = ClientTags.getOrCreateLocalTag((class_6862)tagKey);
            if (localTag != null && !localTag.isEmpty()) {
                BlockList.MinecraftOrCustomTagSet tagSet = new BlockList.MinecraftOrCustomTagSet(resource, null, localTag);
                return new BlockConditionWidget.BlockConditionState(null, null, tagSet);
            }
            if (!blockStr.contains(":")) {
                String[] searchLocations;
                tagOpt = class_7923.field_41175.method_40272().filter(pair -> ((class_6862)pair.getFirst()).comp_327().method_12832().equals(resource.method_12832())).findAny().map(Pair::getSecond);
                if (tagOpt.isPresent()) {
                    class_6885.class_6888 tag = tagOpt.get();
                    BlockList.MinecraftOrCustomTagSet tagSet = new BlockList.MinecraftOrCustomTagSet(resource, (class_6885<class_2248>)tag, null, null);
                    return new BlockConditionWidget.BlockConditionState(null, null, tagSet);
                }
                for (String namespace : searchLocations = new String[]{"axiom", "color", "material"}) {
                    try {
                        class_2960 newResource = class_2960.method_60654((String)(namespace + ":" + blockStr));
                        tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)newResource);
                        localTag = ClientTags.getOrCreateLocalTag((class_6862)tagKey);
                        if (localTag != null && !localTag.isEmpty()) {
                            BlockList.MinecraftOrCustomTagSet tagSet = new BlockList.MinecraftOrCustomTagSet(newResource, null, localTag);
                            return new BlockConditionWidget.BlockConditionState(null, null, tagSet);
                        }
                    }
                    catch (class_151 class_1512) {
                        // empty catch block
                    }
                }
            }
            throw new CmdStringParseException(start, start + blockStr.length() + 1, "unknown block tag");
        }
        HashSet<String> nonDefaultProperties = new HashSet<String>();
        CustomBlockState customBlockState = ServerCustomBlocks.deserialize(blockStr, nonDefaultProperties);
        if (customBlockState == null) {
            throw new CmdStringParseException(start, start + blockStr.length() + 1, "unknown block");
        }
        HashMap selectedProperties = new HashMap();
        for (class_2769<?> property : customBlockState.getProperties()) {
            if (nonDefaultProperties.contains(property.method_11899())) {
                selectedProperties.put(property, (Comparable<?>)customBlockState.getProperty(property));
                continue;
            }
            selectedProperties.put(property, null);
        }
        return new BlockConditionWidget.BlockConditionState(customBlockState.getCustomBlock(), selectedProperties, null);
    }

    public static String toCmdString(MaskElement maskElement) {
        StringBuilder stringBuilder = new StringBuilder();
        CmdStringConverter.addToCmdString(stringBuilder, maskElement, new BooleanWrapper(false));
        String string = stringBuilder.toString();
        if (string.startsWith("(") && string.endsWith(")")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static void addToCmdString(StringBuilder stringBuilder, MaskElement maskElement, BooleanWrapper negate) {
        if (maskElement instanceof BothMaskElement) {
            BothMaskElement bothMaskElement = (BothMaskElement)maskElement;
            if (negate.value) {
                stringBuilder.append("!");
                negate.value = false;
            }
            stringBuilder.append("(");
            CmdStringConverter.addToCmdString(stringBuilder, bothMaskElement.getChild1(), new BooleanWrapper(false));
            stringBuilder.append(" & ");
            CmdStringConverter.addToCmdString(stringBuilder, bothMaskElement.getChild2(), new BooleanWrapper(false));
            stringBuilder.append(")");
        } else if (maskElement instanceof AllMaskElement) {
            AllMaskElement allMaskElement = (AllMaskElement)maskElement;
            if (negate.value) {
                stringBuilder.append("!");
                negate.value = false;
            }
            stringBuilder.append("(");
            MaskElement[] children = allMaskElement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" & ");
                }
                CmdStringConverter.addToCmdString(stringBuilder, children[i], new BooleanWrapper(false));
            }
            stringBuilder.append(")");
        } else if (maskElement instanceof EitherMaskElement) {
            EitherMaskElement eitherMaskElement = (EitherMaskElement)maskElement;
            MaskElement left = eitherMaskElement.getChild1();
            MaskElement right = eitherMaskElement.getChild2();
            if (negate.value) {
                stringBuilder.append("!");
                negate.value = false;
            }
            stringBuilder.append("(");
            CmdStringConverter.addToCmdString(stringBuilder, left, new BooleanWrapper(false));
            stringBuilder.append(" | ");
            CmdStringConverter.addToCmdString(stringBuilder, right, new BooleanWrapper(false));
            stringBuilder.append(")");
        } else if (maskElement instanceof AnyMaskElement) {
            AnyMaskElement anyMaskElement = (AnyMaskElement)maskElement;
            MaskElement[] children = anyMaskElement.getChildren();
            if (negate.value) {
                stringBuilder.append("!");
                negate.value = false;
            }
            stringBuilder.append("(");
            for (int i = 0; i < children.length; ++i) {
                MaskElement child = children[i];
                if (child == null) continue;
                if (i > 0) {
                    stringBuilder.append(" | ");
                }
                CmdStringConverter.addToCmdString(stringBuilder, children[i], new BooleanWrapper(false));
            }
            stringBuilder.append(")");
        } else if (maskElement instanceof NotMaskElement) {
            NotMaskElement notMaskElement = (NotMaskElement)maskElement;
            BooleanWrapper booleanWrapper = new BooleanWrapper(true);
            StringBuilder childBuilder = new StringBuilder();
            CmdStringConverter.addToCmdString(childBuilder, notMaskElement.getChild(), booleanWrapper);
            if (booleanWrapper.value) {
                stringBuilder.append("!(");
                stringBuilder.append((CharSequence)childBuilder);
                stringBuilder.append(")");
            } else {
                stringBuilder.append((CharSequence)childBuilder);
            }
        } else if (maskElement instanceof OffsetMaskElement) {
            OffsetMaskElement offsetMaskElement = (OffsetMaskElement)maskElement;
            stringBuilder.append("offset(");
            stringBuilder.append(offsetMaskElement.getOffsetX());
            stringBuilder.append(",");
            stringBuilder.append(offsetMaskElement.getOffsetY());
            stringBuilder.append(",");
            stringBuilder.append(offsetMaskElement.getOffsetZ());
            stringBuilder.append("){ ");
            CmdStringConverter.addToCmdString(stringBuilder, offsetMaskElement.getChild(), new BooleanWrapper(false));
            stringBuilder.append(" }");
        } else if (maskElement instanceof BiomeConditionMaskElement) {
            BiomeConditionMaskElement biomeConditionMaskElement = (BiomeConditionMaskElement)maskElement;
            if (negate.value) {
                stringBuilder.append("biome != ");
                negate.value = false;
            } else {
                stringBuilder.append("biome = ");
            }
            stringBuilder.append(CmdStringConverter.convertResource(biomeConditionMaskElement.getMatchBiome().method_29177()));
        } else if (maskElement instanceof GenericBlockConditionMaskElement) {
            GenericBlockConditionMaskElement blockConditionMaskElement = (GenericBlockConditionMaskElement)((Object)maskElement);
            stringBuilder.append(blockConditionMaskElement.cmdStringName());
            if (negate.value) {
                stringBuilder.append(" != ");
                negate.value = false;
            } else {
                stringBuilder.append(" = ");
            }
            CmdStringConverter.appendBlockConditions(stringBuilder, blockConditionMaskElement.getConditionStates());
        } else if (maskElement instanceof CoordMaskElement) {
            CoordMaskElement coordMaskElement = (CoordMaskElement)maskElement;
            stringBuilder.append(coordMaskElement.getAxis().method_10174().toLowerCase(Locale.ROOT));
            stringBuilder.append(" ");
            stringBuilder.append(switch (coordMaskElement.getComparison()) {
                case 0 -> "=";
                case 1 -> "!=";
                case 2 -> "<";
                case 3 -> ">";
                case 4 -> "<=";
                case 5 -> ">=";
                default -> throw new FaultyImplementationError();
            });
            stringBuilder.append(" ").append(coordMaskElement.getValue());
        } else if (maskElement instanceof AngleMaskElement) {
            AngleMaskElement angleMaskElement = (AngleMaskElement)maskElement;
            stringBuilder.append("angle ");
            stringBuilder.append(switch (angleMaskElement.getComparison()) {
                case 0 -> "=";
                case 1 -> "!=";
                case 2 -> "<";
                case 3 -> ">";
                case 4 -> "<=";
                case 5 -> ">=";
                default -> throw new FaultyImplementationError();
            });
            stringBuilder.append(" ").append(angleMaskElement.getAngle());
        } else if (maskElement instanceof GenericSingleMaskElement) {
            GenericSingleMaskElement genericSingleMaskElement = (GenericSingleMaskElement)((Object)maskElement);
            if (negate.value) {
                stringBuilder.append("!");
                negate.value = false;
            }
            stringBuilder.append(genericSingleMaskElement.cmdStringName());
        } else {
            throw new UnsupportedOperationException("Don't know how to convert " + String.valueOf(maskElement.getClass()));
        }
    }

    private static void appendBlockConditions(StringBuilder stringBuilder, List<BlockConditionWidget.BlockConditionState> conditions) {
        if (conditions.size() == 1) {
            CmdStringConverter.appendBlockCondition(stringBuilder, conditions.get(0));
            return;
        }
        boolean first = true;
        stringBuilder.append("[");
        for (BlockConditionWidget.BlockConditionState condition : conditions) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(",");
            }
            CmdStringConverter.appendBlockCondition(stringBuilder, condition);
        }
        stringBuilder.append("]");
    }

    private static void appendBlockCondition(StringBuilder stringBuilder, BlockConditionWidget.BlockConditionState condition) {
        if (condition.tag() != null) {
            stringBuilder.append("#");
            stringBuilder.append(CmdStringConverter.convertResource(condition.tag().name()));
        } else {
            stringBuilder.append(CmdStringConverter.convertResource(condition.block().axiom$getIdentifier()));
            Map<class_2769<?>, Comparable<?>> map = condition.selectedProperties();
            boolean empty = true;
            for (Map.Entry<class_2769<?>, Comparable<?>> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                if (empty) {
                    stringBuilder.append("[");
                    empty = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(entry.getKey().method_11899());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue().toString().toLowerCase(Locale.ROOT));
            }
            if (!empty) {
                stringBuilder.append("]");
            }
        }
    }

    private static String convertResource(class_2960 resourceLocation) {
        if (resourceLocation.method_12836().equals("minecraft")) {
            return resourceLocation.method_12832();
        }
        return resourceLocation.toString();
    }

    public static final class CmdStringParseException
    extends RuntimeException {
        public final int start;
        public final int end;
        public final String message;

        public CmdStringParseException(int start, int end, String message) {
            this.start = start;
            this.end = end;
            this.message = message;
        }
    }
}

