/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.AxiomServer;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.editor.EditorWarningType;
import com.moulberry.axiom.packets.AxiomClientboundEditorWarning;
import com.moulberry.axiom.packets.AxiomClientboundEnable;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.DFUHelper;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_1928;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class AxiomServerboundHello
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = class_2960.method_60654((String)"axiom:hello");
    private final int apiVersion;
    private final int dataVersion;
    private final int protocolVersion;

    public AxiomServerboundHello(int apiVersion, int dataVersion, int protocolVersion) {
        this.apiVersion = apiVersion;
        this.dataVersion = dataVersion;
        this.protocolVersion = protocolVersion;
    }

    public AxiomServerboundHello(class_2540 friendlyByteBuf) {
        this.apiVersion = friendlyByteBuf.method_10816();
        if (this.apiVersion != 9) {
            this.dataVersion = 0;
            this.protocolVersion = 0;
            friendlyByteBuf.method_52988(friendlyByteBuf.writerIndex());
            return;
        }
        this.dataVersion = friendlyByteBuf.method_10816();
        this.protocolVersion = friendlyByteBuf.method_10816();
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_10804(this.apiVersion);
        friendlyByteBuf.method_10804(this.dataVersion);
        friendlyByteBuf.method_10804(this.protocolVersion);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (!AxiomServer.hasPermission(player, AxiomPermission.USE)) {
            AxiomServer.activeAxiomPlayers.remove(player.method_5667());
            AxiomServer.failedPermissionPlayers.add(player.method_5667());
            return;
        }
        if (this.apiVersion != 9) {
            player.field_13987.method_52396((class_2561)class_2561.method_43470((String)("Unsupported Axiom API Version. Server supports 9, while client is " + this.apiVersion)));
            return;
        }
        if (this.protocolVersion != class_155.method_31372()) {
            int serverDataVersion = DFUHelper.DATA_VERSION;
            player.field_13987.method_52396((class_2561)class_2561.method_43470((String)("Axiom: Incompatible data version detected (client " + this.dataVersion + ", server " + serverDataVersion + "), are you using ViaVersion?")));
            return;
        }
        boolean spectatorsGenerateChunks = server.method_3767().method_8355(class_1928.field_19402);
        if (!spectatorsGenerateChunks) {
            new AxiomClientboundEditorWarning(EditorWarningType.SPECTATORS_GENERATE_CHUNKS, true).send(player);
        }
        new AxiomClientboundEnable().send(player);
        AxiomServer.onAxiomActive(player);
        if (AxiomServer.supportsServerBlueprints()) {
            ServerBlueprintManager.sendManifest(List.of(player));
        }
        if (AxiomServer.usingDeprecatedAxiomStarPermission(player)) {
            class_5250 text = class_2561.method_43470((String)"Axiom: Using deprecated axiom.* permission. Please switch to axiom.default for public servers, or axiom.all for private servers");
            player.method_43496((class_2561)text.method_27692(class_124.field_1054));
        }
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundHello::new);
    }
}

