/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.EntityDataUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6335;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AxiomServerboundManipulateEntity
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = class_2960.method_60654((String)"axiom:manipulate_entity");
    private final List<ManipulateEntry> entries;
    private static final class_2470[] ROTATION_VALUES = class_2470.values();
    private static final class_2561 UNSUPPORTED_MESSAGE = class_2561.method_43470((String)"Server doesn't support (or doesn't allow) manipulating entities").method_27692(class_124.field_1061);

    public AxiomServerboundManipulateEntity(List<ManipulateEntry> entries) {
        this.entries = entries;
    }

    public AxiomServerboundManipulateEntity(class_2540 friendlyByteBuf) {
        this.entries = friendlyByteBuf.method_34066(ManipulateEntry::read);
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_34062(this.entries, ManipulateEntry::write);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (!AxiomServerboundPacket.canUseAxiom(player, AxiomPermission.ENTITY_MANIPULATE)) {
            return;
        }
        class_3218 serverLevel = player.method_51469();
        block6: for (ManipulateEntry entry : this.entries) {
            class_243 entryPos;
            class_1297 entity = serverLevel.method_14190(entry.uuid);
            if (entity == null || entity instanceof class_1657 || entity.method_5703(AxiomServerboundManipulateEntity::isPlayer)) continue;
            if (entry.nbt != null && !entry.nbt.method_33133()) {
                class_2487 compoundTag = EntityDataUtils.saveWithoutId(entity);
                compoundTag = AxiomServerboundManipulateEntity.merge(compoundTag, entry.nbt);
                EntityDataUtils.load(entity, compoundTag);
            }
            if ((entryPos = entry.position()) != null && entry.relativeMovementSet != null) {
                float newPitch;
                double newX = entry.relativeMovementSet.contains(class_2709.field_12400) ? entity.method_19538().field_1352 + entryPos.field_1352 : entryPos.field_1352;
                double newY = entry.relativeMovementSet.contains(class_2709.field_12398) ? entity.method_19538().field_1351 + entryPos.field_1351 : entryPos.field_1351;
                double newZ = entry.relativeMovementSet.contains(class_2709.field_12403) ? entity.method_19538().field_1350 + entryPos.field_1350 : entryPos.field_1350;
                float newYaw = entry.relativeMovementSet.contains(class_2709.field_12401) ? entity.method_36454() + entry.yaw : entry.yaw;
                float f = newPitch = entry.relativeMovementSet.contains(class_2709.field_12397) ? entity.method_36455() + entry.pitch : entry.pitch;
                if (entity instanceof class_1530) {
                    class_1533 itemFrame;
                    class_1530 hangingEntity = (class_1530)entity;
                    float changedYaw = newYaw - entity.method_36454();
                    int rotations = Math.round(changedYaw / 90.0f);
                    hangingEntity.method_5832(ROTATION_VALUES[rotations & 3]);
                    if (entity instanceof class_1533 && (itemFrame = (class_1533)entity).method_5735().method_10166() == class_2350.class_2351.field_11052) {
                        itemFrame.method_6939(itemFrame.method_6934() - Math.round(changedYaw / 45.0f));
                    }
                }
                if (!entity.method_5765()) {
                    entity.method_5814(newX, newY, newZ);
                }
                entity.method_36457(newPitch);
                entity.method_36456(newYaw);
                entity.method_5847(newYaw);
            }
            if (!AxiomServerboundManipulateEntity.canManipulatePassengers(entity)) continue;
            switch (entry.passengerManipulation.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    entity.method_5772();
                    break;
                }
                case 2: {
                    for (UUID passengerUuid : entry.passengers) {
                        class_1297 passenger = serverLevel.method_14190(passengerUuid);
                        if (passenger == null || passenger.method_5765() || !AxiomServerboundManipulateEntity.canManipulatePassengers(passenger) || passenger.method_5703(AxiomServerboundManipulateEntity::cannotManipulatePassengers) || passenger.method_24204().anyMatch(entity2 -> entity2 == entity)) continue;
                        passenger.method_5873(entity, true);
                    }
                    continue block6;
                }
                case 3: {
                    for (UUID passengerUuid : entry.passengers) {
                        class_1297 vehicle;
                        class_1297 passenger = serverLevel.method_14190(passengerUuid);
                        if (passenger == null || passenger == entity || !AxiomServerboundManipulateEntity.canManipulatePassengers(passenger) || passenger.method_5703(AxiomServerboundManipulateEntity::cannotManipulatePassengers) || (vehicle = passenger.method_5854()) != entity) continue;
                        passenger.method_5848();
                    }
                    break;
                }
            }
        }
    }

    private static boolean canManipulatePassengers(class_1297 entity) {
        return entity != null && entity.method_5864().method_5893() && !(entity instanceof class_1657) && !(entity instanceof class_6335);
    }

    private static boolean cannotManipulatePassengers(class_1297 entity) {
        return !AxiomServerboundManipulateEntity.canManipulatePassengers(entity);
    }

    private static boolean isPlayer(class_1297 entity) {
        return entity instanceof class_1657;
    }

    private static class_2487 merge(class_2487 left, class_2487 right) {
        if (right.method_10545("axiom:modify")) {
            right.method_10551("axiom:modify");
            return right;
        }
        for (String key : right.method_10541()) {
            class_2520 tag = right.method_10580(key);
            if (tag instanceof class_2487) {
                class_2487 compound = (class_2487)tag;
                if (compound.method_33133()) {
                    left.method_10551(key);
                    continue;
                }
                Optional<class_2487> leftCompoundOptional = VersionUtilsNbt.helperCompoundTagGetCompound(left, key);
                if (leftCompoundOptional.isPresent()) {
                    class_2487 child = leftCompoundOptional.get();
                    child = AxiomServerboundManipulateEntity.merge(child, compound);
                    left.method_10566(key, (class_2520)child);
                    continue;
                }
                class_2487 copied = compound.method_10553();
                if (copied.method_10545("axiom:modify")) {
                    copied.method_10551("axiom:modify");
                }
                left.method_10566(key, (class_2520)copied);
                continue;
            }
            left.method_10566(key, tag.method_10707());
        }
        return left;
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundManipulateEntity::new);
    }

    @Override
    public void send() {
        if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.MANIPULATE_ENTITY)) {
            ChatUtils.error(UNSUPPORTED_MESSAGE);
            return;
        }
        AxiomServerboundPacket.super.send();
    }

    public record ManipulateEntry(UUID uuid, @Nullable Set<class_2709> relativeMovementSet, @Nullable class_243 position, float yaw, float pitch, class_2487 nbt, PassengerManipulation passengerManipulation, List<UUID> passengers) {
        public ManipulateEntry(UUID uuid, @Nullable Set<class_2709> relativeMovementSet, @Nullable class_243 position, float yaw, float pitch, class_2487 nbt, PassengerManipulation passengerManipulation, List<UUID> passengers) {
            passengers = List.copyOf(passengers);
        }

        public ManipulateEntry(UUID uuid, PassengerManipulation passengerManipulation, List<UUID> passengers) {
            this(uuid, null, null, 0.0f, 0.0f, null, passengerManipulation, passengers);
        }

        public ManipulateEntry(UUID uuid, @Nullable class_243 position, class_2487 merge) {
            this(uuid, position == null ? null : class_2709.field_40711, position, 0.0f, 0.0f, merge, PassengerManipulation.NONE, List.of());
        }

        public ManipulateEntry(UUID uuid, @Nullable Set<class_2709> relativeMovementSet, @Nullable class_243 position, float yaw, float pitch, class_2487 merge) {
            this(uuid, relativeMovementSet, position, yaw, pitch, merge, PassengerManipulation.NONE, List.of());
        }

        public static ManipulateEntry read(class_2540 friendlyByteBuf) {
            UUID uuid = friendlyByteBuf.method_10790();
            byte flags = friendlyByteBuf.readByte();
            Set relativeMovementSet = null;
            class_243 position = null;
            float yaw = 0.0f;
            float pitch = 0.0f;
            if (flags >= 0) {
                relativeMovementSet = class_2709.method_11744((int)flags);
                position = friendlyByteBuf.method_52996();
                yaw = friendlyByteBuf.readFloat();
                pitch = friendlyByteBuf.readFloat();
            }
            class_2487 nbt = friendlyByteBuf.method_10798();
            PassengerManipulation passengerManipulation = (PassengerManipulation)friendlyByteBuf.method_10818(PassengerManipulation.class);
            List passengers = List.of();
            if (passengerManipulation == PassengerManipulation.ADD_LIST || passengerManipulation == PassengerManipulation.REMOVE_LIST) {
                passengers = friendlyByteBuf.method_34066(buf -> buf.method_10790());
            }
            return new ManipulateEntry(uuid, relativeMovementSet, position, yaw, pitch, nbt, passengerManipulation, passengers);
        }

        public static void write(class_2540 friendlyByteBuf, ManipulateEntry entry) {
            friendlyByteBuf.method_10797(entry.uuid);
            if (entry.position != null && entry.relativeMovementSet != null) {
                friendlyByteBuf.method_52997(class_2709.method_11741(entry.relativeMovementSet));
                friendlyByteBuf.method_52940(entry.position.field_1352);
                friendlyByteBuf.method_52940(entry.position.field_1351);
                friendlyByteBuf.method_52940(entry.position.field_1350);
                friendlyByteBuf.method_52941(entry.yaw);
                friendlyByteBuf.method_52941(entry.pitch);
            } else {
                friendlyByteBuf.method_52997(-1);
            }
            friendlyByteBuf.method_10794((class_2520)entry.nbt);
            friendlyByteBuf.method_10817((Enum)entry.passengerManipulation);
            if (entry.passengerManipulation == PassengerManipulation.ADD_LIST || entry.passengerManipulation == PassengerManipulation.REMOVE_LIST) {
                friendlyByteBuf.method_34062(entry.passengers, (buf, uuid) -> buf.method_10797(uuid));
            }
        }
    }

    public static enum PassengerManipulation {
        NONE,
        REMOVE_ALL,
        ADD_LIST,
        REMOVE_LIST;

    }
}

