/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomServer;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.hooks.ServerLevelExt;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.SerializationUtils;
import com.moulberry.axiom.world_modification.BiomeBuffer;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2548;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5552;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.class_7924;
import net.minecraft.class_8212;
import net.minecraft.class_8528;
import net.minecraft.class_8563;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AxiomServerboundSetBuffer
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = class_2960.method_60654((String)"axiom:set_buffer");
    private final class_5321<class_1937> world;
    private final BlockOrBiomeBuffer buffer;
    private final int clientAvailableDispatchSends;
    private final class_2540 rawByteBuf;
    private final int rawByteBufReaderIndex;
    private static final class_3230<class_1923> CHUNK_UPDATE = class_3230.method_20628((String)"axiom_chunk_update", Comparator.comparingLong(class_1923::method_8324), (int)5);

    public AxiomServerboundSetBuffer(class_5321<class_1937> world, BlockOrBiomeBuffer buffer, int clientAvailableDispatchSends) {
        this.world = world;
        this.buffer = buffer;
        this.clientAvailableDispatchSends = clientAvailableDispatchSends;
        this.rawByteBuf = null;
        this.rawByteBufReaderIndex = 0;
    }

    public AxiomServerboundSetBuffer(class_2540 friendlyByteBuf) {
        this.world = null;
        this.buffer = null;
        this.clientAvailableDispatchSends = Integer.MAX_VALUE;
        this.rawByteBuf = friendlyByteBuf;
        this.rawByteBufReaderIndex = friendlyByteBuf.readerIndex();
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    public static AxiomServerboundSetBuffer read(class_2540 friendlyByteBuf) {
        BlockOrBiomeBuffer buffer;
        class_5321 world = friendlyByteBuf.method_44112(class_7924.field_41223);
        friendlyByteBuf.method_10790();
        byte type2 = friendlyByteBuf.readByte();
        if (type2 == 0) {
            buffer = BlockBuffer.loadRaw(friendlyByteBuf);
        } else if (type2 == 1) {
            buffer = BiomeBuffer.load(friendlyByteBuf);
        } else {
            throw new RuntimeException("Unknown buffer type: " + type2);
        }
        int clientAvailableDispatchSends = friendlyByteBuf.method_10816();
        return new AxiomServerboundSetBuffer((class_5321<class_1937>)world, buffer, clientAvailableDispatchSends);
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        if (this.rawByteBuf == null) {
            throw new class_2548((Throwable)new RuntimeException("Not a serializable AxiomServerboundSetBuffer"));
        }
        this.rawByteBuf.method_52988(this.rawByteBufReaderIndex);
        friendlyByteBuf.method_52975((ByteBuf)this.rawByteBuf);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (!AxiomServerboundPacket.canUseAxiom(player, AxiomPermission.BUILD_SECTION)) {
            return;
        }
        class_3218 level = server.method_3847(this.world);
        if (level == null) {
            return;
        }
        BlockOrBiomeBuffer blockOrBiomeBuffer = this.buffer;
        if (blockOrBiomeBuffer instanceof BlockBuffer) {
            BlockBuffer blockBuffer = (BlockBuffer)blockOrBiomeBuffer;
            if (!AxiomServer.consumeDispatchSends(player, blockBuffer.getSectionCount(), this.clientAvailableDispatchSends)) {
                return;
            }
            AxiomServerboundSetBuffer.applyBlockBufferServer(blockBuffer, level, null, player);
        } else {
            blockOrBiomeBuffer = this.buffer;
            if (blockOrBiomeBuffer instanceof BiomeBuffer) {
                BiomeBuffer biomeBuffer = (BiomeBuffer)blockOrBiomeBuffer;
                if (!AxiomServer.consumeDispatchSends(player, biomeBuffer.map.map.size(), this.clientAvailableDispatchSends)) {
                    return;
                }
                AxiomServerboundSetBuffer.applyBiomeBufferServer(biomeBuffer, level);
            } else {
                throw new RuntimeException("Unknown buffer type: " + String.valueOf(this.buffer.getClass()));
            }
        }
    }

    public static Comparator<Long2ObjectMap.Entry<class_2841<class_2680>>> createBlockBufferOrderComparator(int sortChunkX, int sortChunkZ) {
        return (e1, e2) -> {
            int chunkDistanceXZ2;
            long pos1 = e1.getLongKey();
            long pos2 = e2.getLongKey();
            int pos1X = class_2338.method_10061((long)pos1);
            int pos1Y = class_2338.method_10071((long)pos1);
            int pos1Z = class_2338.method_10083((long)pos1);
            int pos2X = class_2338.method_10061((long)pos2);
            int pos2Y = class_2338.method_10071((long)pos2);
            int pos2Z = class_2338.method_10083((long)pos2);
            int chunkDistanceXZ1 = Math.abs(pos1X - sortChunkX) + Math.abs(pos1Z - sortChunkZ);
            int chunkDistanceComparison = Integer.compare(chunkDistanceXZ1, chunkDistanceXZ2 = Math.abs(pos2X - sortChunkX) + Math.abs(pos2Z - sortChunkZ));
            if (chunkDistanceComparison != 0) {
                return chunkDistanceComparison;
            }
            int xComparison = Integer.compare(pos1X, pos2X);
            if (xComparison != 0) {
                return xComparison;
            }
            int zComparison = Integer.compare(pos1Z, pos2Z);
            if (zComparison != 0) {
                return zComparison;
            }
            return Integer.compare(pos1Y, pos2Y);
        };
    }

    public static void applyBlockBufferServer(BlockBuffer buffer, class_3218 world, @Nullable ChunkedBooleanRegion selection, @Nullable class_3222 source) {
        int sortChunkZ;
        int sortChunkX;
        boolean canEditNbt;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_2680 emptyState = BlockBuffer.EMPTY_STATE;
        boolean hasStarlight = Axiom.hasStarlight();
        boolean sendGameMasterBlockWarning = false;
        boolean bl = canEditNbt = source == null || AxiomServer.canUseAxiom(source, AxiomPermission.BUILD_NBT);
        if (source != null) {
            sortChunkX = source.method_31477() >> 4;
            sortChunkZ = source.method_31479() >> 4;
        } else {
            sortChunkX = 0;
            sortChunkZ = 0;
        }
        ArrayList<Long2ObjectMap.Entry<class_2841<class_2680>>> entries = new ArrayList<Long2ObjectMap.Entry<class_2841<class_2680>>>((Collection<Long2ObjectMap.Entry<class_2841<class_2680>>>)buffer.entrySet());
        entries.sort(AxiomServerboundSetBuffer.createBlockBufferOrderComparator(sortChunkX, sortChunkZ));
        LongIterator iterator = buffer.keySet().iterator();
        LongOpenHashSet addedTicketSet = new LongOpenHashSet();
        while (iterator.hasNext()) {
            int sz;
            long pos = iterator.nextLong();
            int sx = class_2338.method_10061((long)pos);
            if (!addedTicketSet.add(class_1923.method_8331((int)sx, (int)(sz = class_2338.method_10083((long)pos))))) continue;
            class_1923 chunkPos = new class_1923(sx, sz);
            world.method_14178().field_17254.method_17263().method_17290(CHUNK_UPDATE, chunkPos, class_8563.method_51829((class_2806)class_2806.field_12803), (Object)chunkPos);
        }
        for (Long2ObjectMap.Entry entry : entries) {
            int cx = class_2338.method_10061((long)entry.getLongKey());
            int cy = class_2338.method_10071((long)entry.getLongKey());
            int cz = class_2338.method_10083((long)entry.getLongKey());
            class_2841 container = (class_2841)entry.getValue();
            if (cy < world.method_32891() || cy > world.method_31597() - 1) continue;
            class_2818 chunk = world.method_8497(cx, cz);
            class_2826 section = chunk.method_38259(world.method_31603(cy));
            boolean hasOnlyAir = section.method_38292();
            class_2902 worldSurface = null;
            class_2902 oceanFloor = null;
            class_2902 motionBlocking = null;
            class_2902 motionBlockingNoLeaves = null;
            for (Map.Entry heightmap : chunk.method_12011()) {
                switch ((class_2902.class_2903)heightmap.getKey()) {
                    case field_13202: {
                        worldSurface = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13200: {
                        oceanFloor = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13197: {
                        motionBlocking = (class_2902)heightmap.getValue();
                        break;
                    }
                    case field_13203: {
                        motionBlockingNoLeaves = (class_2902)heightmap.getValue();
                        break;
                    }
                }
            }
            short[] lightUpdates = hasStarlight ? null : ((ServerLevelExt)world).axiom$getPendingLightUpdates(cx, cy, cz);
            boolean sectionChanged = false;
            boolean relightStarlight = false;
            boolean containerMaybeHasPoi = container.method_19526(class_7477::method_46397);
            boolean sectionMaybeHasPoi = section.method_19523(class_7477::method_46397);
            Short2ObjectMap<CompressedBlockEntity> blockEntityChunkMap = canEditNbt ? buffer.getBlockEntityChunkMap(entry.getLongKey()) : null;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                        if (blockState == emptyState) continue;
                        int bx = cx * 16 + x;
                        int by = cy * 16 + y;
                        int bz = cz * 16 + z;
                        if (selection != null) {
                            selection.add(bx, by, bz);
                        }
                        if (hasOnlyAir && blockState.method_26215()) continue;
                        class_2248 block = blockState.method_26204();
                        class_2680 old = section.method_12256(x, y, z, blockState, true);
                        if (blockState != old) {
                            Optional oldPoi;
                            sectionChanged = true;
                            blockPos.method_10103(bx, by, bz);
                            motionBlocking.method_12597(x, by, z, blockState);
                            motionBlockingNoLeaves.method_12597(x, by, z, blockState);
                            oceanFloor.method_12597(x, by, z, blockState);
                            worldSurface.method_12597(x, by, z, blockState);
                            if (VersionUtils.hasDifferentLightProperties((class_1922)chunk, (class_2338)blockPos, old, blockState)) {
                                if (hasStarlight) {
                                    relightStarlight = true;
                                } else {
                                    class_8528 sources = chunk.method_12018();
                                    if (sources != null) {
                                        sources.method_51536((class_1922)chunk, x, by, z);
                                    }
                                    int n = y + z * 16;
                                    lightUpdates[n] = (short)(lightUpdates[n] | 1 << x);
                                }
                            }
                            Optional newPoi = containerMaybeHasPoi ? class_7477.method_43989((class_2680)blockState) : Optional.empty();
                            Optional optional = oldPoi = sectionMaybeHasPoi ? class_7477.method_43989((class_2680)old) : Optional.empty();
                            if (!Objects.equals(oldPoi, newPoi)) {
                                if (oldPoi.isPresent()) {
                                    world.method_19494().method_19112((class_2338)blockPos);
                                }
                                if (newPoi.isPresent()) {
                                    world.method_19494().method_19115((class_2338)blockPos, (class_6880)newPoi.get());
                                }
                            }
                        }
                        if (blockState.method_31709()) {
                            blockPos.method_10103(bx, by, bz);
                            class_2586 blockEntity = chunk.method_12201((class_2338)blockPos, class_2818.class_2819.field_12859);
                            if (blockEntity == null) {
                                blockEntity = ((class_2343)block).method_10123((class_2338)blockPos, blockState);
                                if (blockEntity != null) {
                                    chunk.method_12216(blockEntity);
                                }
                            } else if (blockEntity.method_11017().method_20526(blockState)) {
                                blockEntity.method_31664(blockState);
                                chunk.method_31723(blockEntity);
                            } else {
                                chunk.method_12041((class_2338)blockPos);
                                blockEntity = ((class_2343)block).method_10123((class_2338)blockPos, blockState);
                                if (blockEntity != null) {
                                    chunk.method_12216(blockEntity);
                                }
                            }
                            if (blockEntity == null || blockEntityChunkMap == null) continue;
                            if (blockEntity instanceof class_5552 && source != null && !source.method_7338()) {
                                sendGameMasterBlockWarning = true;
                                continue;
                            }
                            int key = x | y << 4 | z << 8;
                            CompressedBlockEntity savedBlockEntity = (CompressedBlockEntity)blockEntityChunkMap.get((short)key);
                            if (savedBlockEntity == null) continue;
                            SerializationUtils.loadBlockEntity(blockEntity, savedBlockEntity.decompress(), world.method_30349());
                            sectionChanged = true;
                            continue;
                        }
                        if (!old.method_31709()) continue;
                        chunk.method_12041((class_2338)blockPos);
                    }
                }
            }
            boolean nowHasOnlyAir = section.method_38292();
            if (hasOnlyAir != nowHasOnlyAir) {
                world.method_14178().method_17293().method_15551(class_4076.method_18676((int)cx, (int)cy, (int)cz), nowHasOnlyAir);
            }
            if (sectionChanged) {
                ((ServerLevelExt)world).axiom$markChunkDirty(cx, cz);
                chunk.method_12008(true);
            }
            if (!relightStarlight) continue;
            ((ServerLevelExt)world).axiom$relightChunkStarlight(cx, cz);
        }
        if (sendGameMasterBlockWarning && source != null) {
            source.method_43496((class_2561)class_2561.method_43470((String)"Unable to set data for Game Master block since you don't have op").method_27692(class_124.field_1061));
        }
    }

    private static void applyBiomeBufferServer(BiomeBuffer biomeBuffer, class_3218 world) {
        HashSet changedChunks = new HashSet();
        int minSection = world.method_32891();
        int maxSection = world.method_31597() - 1;
        Optional registryOptional = world.method_30349().method_33310(class_7924.field_41236);
        if (registryOptional.isEmpty()) {
            return;
        }
        class_2378 registry = (class_2378)registryOptional.get();
        biomeBuffer.forEachEntry((x, y, z, biome) -> {
            int cy = y >> 2;
            if (cy < minSection || cy > maxSection) {
                return;
            }
            class_2818 chunk = world.method_8497(x >> 2, z >> 2);
            class_2826 section = chunk.method_38259(cy - minSection);
            class_2841 container = (class_2841)section.method_38294();
            Optional holder = registry.method_40264(biome);
            if (holder.isPresent()) {
                container.method_35321(x & 3, y & 3, z & 3, (Object)((class_6880)holder.get()));
                changedChunks.add(chunk);
            }
        });
        class_3898 chunkMap = world.method_14178().field_17254;
        HashMap<class_3222, List> map = new HashMap<class_3222, List>();
        for (class_2818 chunk : changedChunks) {
            chunk.method_12008(true);
            class_1923 chunkPos = chunk.method_12004();
            for (class_3222 serverPlayer2 : chunkMap.method_17210(chunkPos, false)) {
                map.computeIfAbsent(serverPlayer2, serverPlayer -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((serverPlayer, list) -> serverPlayer.field_13987.method_14364((class_2596)class_8212.method_49685((List)list)));
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundSetBuffer::read);
    }
}

