/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.shape.TerrainDistanceField;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class ConeRasterization {
    private static final Quaternionf EMPTY_QUATERNION = new Quaternionf();
    private static final int[] CARDINAL_OFFSETS = new int[]{0, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 0, 0};

    public static void cone(ChunkedBlockRegion region, class_2680 block, class_2338 center, float diameterX, float height, float diameterZ, boolean hollow, boolean centerEvenDiameters, float rounding, @Nullable Quaternionf quaternionf) {
        if (diameterX <= 0.0f || height <= 0.0f || diameterZ <= 0.0f) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float radiusX = (diameterX - 1.0f) / 2.0f;
        float radiusY = (height - 1.0f) / 2.0f;
        float radiusZ = (diameterZ - 1.0f) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRadiusY * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        float invRadiusSqX = 1.0f / ((radiusX + 0.5f) * (radiusX + 0.5f));
        float invRadiusSqZ = 1.0f / ((radiusZ + 0.5f) * (radiusZ + 0.5f));
        if (!Float.isFinite(invRadiusSqX)) {
            invRadiusSqX = Float.MAX_VALUE;
        }
        if (!Float.isFinite(invRadiusSqZ)) {
            invRadiusSqZ = Float.MAX_VALUE;
        }
        float offsetX = centerEvenDiameters ? -(radiusX % 1.0f) : 0.0f;
        float offsetY = centerEvenDiameters ? -(radiusY % 1.0f) : 0.0f;
        float offsetZ = centerEvenDiameters ? -(radiusZ % 1.0f) : 0.0f;
        float s2 = 2.0f;
        float mNumer = rounding * rounding * 12.0f;
        float mDenom = 8.0f;
        float m4 = (float)Math.sqrt(mNumer / mDenom);
        float v = rounding * 2.0f - 2.0f + (float)Math.sqrt(2.0f * m4 * m4 - 2.0f * rounding * rounding);
        v = v * (radiusY + 0.5f) + (radiusY + 0.5f);
        float ellipsoidRadiusY = height / 2.0f * (float)Math.sqrt(2.0) - 0.5f;
        float ellipsoidInvRadiusSqY = RasterizationHelper.calcInvRadiusSq(ellipsoidRadiusY);
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block5: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    float h2 = radiusY - ry + 1.0f;
                    if (!((rx * rx * invRadiusSqX + rz * rz * invRadiusSqZ) * height * height <= h2 * h2) || !(Math.abs(ry) <= radiusY) || rounding * height > h2 && rx * rx * invRadiusSqX + (ry + v) * (ry + v) * ellipsoidInvRadiusSqY + rz * rz * invRadiusSqZ > m4 * m4) continue;
                    if (!hollow) {
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue;
                    }
                    for (int i = 0; i < 18; i += 3) {
                        int nx = x + CARDINAL_OFFSETS[i];
                        int ny = y + CARDINAL_OFFSETS[i + 1];
                        int nz = z + CARDINAL_OFFSETS[i + 2];
                        vector3f.set((float)nx, (float)ny, (float)nz);
                        quaternionf.transform(vector3f);
                        rx = vector3f.x + offsetX;
                        ry = vector3f.y + offsetY;
                        rz = vector3f.z + offsetZ;
                        h2 = radiusY - ry + 1.0f;
                        if ((rx * rx * invRadiusSqX + rz * rz * invRadiusSqZ) * height * height > h2 * h2 || Math.abs(ry) > radiusY) {
                            region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                            continue block5;
                        }
                        if (!(rounding * height > h2) || !(rx * rx * invRadiusSqX + (ry + v) * (ry + v) * ellipsoidInvRadiusSqY + rz * rz * invRadiusSqZ > m4 * m4)) continue;
                        region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                        continue block5;
                    }
                }
            }
        }
    }

    public static void coneMetaball(ChunkedBlockRegion region, int metaballRange, class_2680 block, class_2338 center, float diameterX, float height, float diameterZ, boolean hollow, boolean centerEvenDiameters, float rounding, @Nullable Quaternionf quaternionf) {
        class_638 level = class_310.method_1551().field_1687;
        if (metaballRange <= 1 || level == null) {
            ConeRasterization.cone(region, block, center, diameterX, height, diameterZ, hollow, centerEvenDiameters, rounding, quaternionf);
            return;
        }
        int extra = (int)Math.ceil(Math.sqrt((float)(metaballRange * metaballRange - metaballRange) / 2.0f)) + 1;
        if (diameterX <= 0.0f || height <= 0.0f || diameterZ <= 0.0f) {
            return;
        }
        if (quaternionf == null) {
            quaternionf = EMPTY_QUATERNION;
        }
        float radiusX = (diameterX - 1.0f) / 2.0f;
        float radiusY = (height - 1.0f) / 2.0f;
        float radiusZ = (diameterZ - 1.0f) / 2.0f;
        int ceilRadiusX = (int)Math.ceil(radiusX + (float)extra);
        int ceilRadiusY = (int)Math.ceil(radiusY + (float)extra);
        int ceilRadiusZ = (int)Math.ceil(radiusZ + (float)extra);
        int maxRadiusX = 0;
        int maxRadiusY = 0;
        int maxRadiusZ = 0;
        Vector3f vector3f = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    vector3f.set((float)(ceilRadiusX * x), (float)(ceilRadiusY * y), (float)(ceilRadiusZ * z));
                    quaternionf.transformInverse(vector3f);
                    maxRadiusX = Math.max(maxRadiusX, (int)Math.ceil(Math.abs(vector3f.x)));
                    maxRadiusY = Math.max(maxRadiusY, (int)Math.ceil(Math.abs(vector3f.y)));
                    maxRadiusZ = Math.max(maxRadiusZ, (int)Math.ceil(Math.abs(vector3f.z)));
                }
            }
        }
        float invRadiusSqX = RasterizationHelper.calcInvRadiusSq(radiusX);
        float invRadiusSqZ = RasterizationHelper.calcInvRadiusSq(radiusZ);
        float invExpandedRadiusSqX = 1.0f / ((radiusX + (float)extra + 0.5f) * (radiusX + (float)extra + 0.5f));
        float invExpandedRadiusSqZ = 1.0f / ((radiusZ + (float)extra + 0.5f) * (radiusZ + (float)extra + 0.5f));
        if (!Float.isFinite(invExpandedRadiusSqX)) {
            invExpandedRadiusSqX = Float.MAX_VALUE;
        }
        if (!Float.isFinite(invExpandedRadiusSqZ)) {
            invExpandedRadiusSqZ = Float.MAX_VALUE;
        }
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        float offsetX = centerEvenDiameters ? -(radiusX % 1.0f) : 0.0f;
        float offsetY = centerEvenDiameters ? -(radiusY % 1.0f) : 0.0f;
        float offsetZ = centerEvenDiameters ? -(radiusZ % 1.0f) : 0.0f;
        float s2 = 2.0f;
        float mNumer = rounding * rounding * 12.0f;
        float mDenom = 8.0f;
        float m4 = (float)Math.sqrt(mNumer / mDenom);
        float v = rounding * 2.0f - 2.0f + (float)Math.sqrt(2.0f * m4 * m4 - 2.0f * rounding * rounding);
        v = v * (radiusY + 0.5f) + (radiusY + 0.5f);
        float ellipsoidRadiusY = height / 2.0f * (float)Math.sqrt(2.0) - 0.5f;
        float ellipsoidInvRadiusSqY = RasterizationHelper.calcInvRadiusSq(ellipsoidRadiusY);
        float[] distances = TerrainDistanceField.calculateChamferEuclidean((class_1937)level, centerX - maxRadiusX, centerY - maxRadiusY, centerZ - maxRadiusZ, centerX + maxRadiusX, centerY + maxRadiusY, centerZ + maxRadiusZ);
        int xIndexOffset = (maxRadiusY * 2 + 3) * (maxRadiusZ * 2 + 3);
        int yIndexOffset = maxRadiusZ * 2 + 3;
        Vector2f intersectionPos = new Vector2f();
        for (int x = -maxRadiusX; x <= maxRadiusX; ++x) {
            for (int y = -maxRadiusY; y <= maxRadiusY; ++y) {
                block5: for (int z = -maxRadiusZ; z <= maxRadiusZ; ++z) {
                    float surfaceDistanceSq;
                    int index;
                    float distance;
                    boolean insideShape;
                    vector3f.set((float)x, (float)y, (float)z);
                    quaternionf.transform(vector3f);
                    float rx = vector3f.x + offsetX;
                    float ry = vector3f.y + offsetY;
                    float rz = vector3f.z + offsetZ;
                    float h2 = radiusY - ry + 1.0f;
                    float surface = rx * rx * invRadiusSqX + rz * rz * invRadiusSqZ;
                    boolean bl = insideShape = surface * height * height <= h2 * h2 && Math.abs(ry) <= radiusY + 0.5f;
                    if (insideShape && rounding * height > h2 && rx * rx * invRadiusSqX + (ry + v) * (ry + v) * ellipsoidInvRadiusSqY + rz * rz * invRadiusSqZ > m4 * m4) {
                        insideShape = false;
                    }
                    if (insideShape) {
                        if (!hollow) {
                            region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                            continue;
                        }
                        for (int i = 0; i < 18; i += 3) {
                            int nx = x + CARDINAL_OFFSETS[i];
                            int ny = y + CARDINAL_OFFSETS[i + 1];
                            int nz = z + CARDINAL_OFFSETS[i + 2];
                            vector3f.set((float)nx, (float)ny, (float)nz);
                            quaternionf.transform(vector3f);
                            rx = vector3f.x + offsetX;
                            ry = vector3f.y + offsetY;
                            rz = vector3f.z + offsetZ;
                            h2 = radiusY - ry + 1.0f;
                            if ((rx * rx * invRadiusSqX + rz * rz * invRadiusSqZ) * height * height > h2 * h2 || Math.abs(ry) > radiusY + 0.5f) {
                                region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                                continue block5;
                            }
                            if (!(rounding * height > h2) || !(rx * rx * invRadiusSqX + (ry + v) * (ry + v) * ellipsoidInvRadiusSqY + rz * rz * invRadiusSqZ > m4 * m4)) continue;
                            region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                            continue block5;
                        }
                        continue;
                    }
                    if (!(rx * rx * invExpandedRadiusSqX + rz * rz * invExpandedRadiusSqZ <= 1.0f) || !(Math.abs(ry) <= radiusY + 0.5f + (float)extra) || !Float.isFinite(distance = distances[index = (x + maxRadiusX + 1) * xIndexOffset + (y + maxRadiusY + 1) * yIndexOffset + (z + maxRadiusZ + 1)]) || distance == 0.0f) continue;
                    float terrainAmount = (float)metaballRange / ((float)metaballRange + distance * distance) - 1.0f / (float)(1 + metaballRange);
                    if ((double)surface < 1.0E-5) {
                        if (ry < -radiusY - 0.5f) {
                            verticalDelta = -radiusY - 0.5f - ry;
                            surfaceDistanceSq = verticalDelta * verticalDelta;
                        } else {
                            float surfaceDistance = RasterizationHelper.distancePointEllipsoid((radiusX + 0.5f) * m4, (ellipsoidRadiusY + 0.5f) * m4, (radiusZ + 0.5f) * m4, rx, ry + v, rz, null);
                            surfaceDistanceSq = surfaceDistance * surfaceDistance;
                        }
                    } else if (ry < -(radiusY + 0.5f)) {
                        surfaceDistanceSq = 0.0f;
                        if (surface > 1.0f) {
                            float edgeDistance = RasterizationHelper.distancePointEllipse(radiusX + 0.5f, radiusZ + 0.5f, rx, rz, null);
                            surfaceDistanceSq += edgeDistance * edgeDistance;
                        }
                        verticalDelta = Math.abs(ry) - (radiusY + 0.5f);
                        surfaceDistanceSq += verticalDelta * verticalDelta;
                    } else {
                        float factor = h2 / height;
                        if (factor > 1.0f) {
                            factor = 1.0f;
                        }
                        if (factor < 0.01f) {
                            factor = 0.01f;
                        }
                        RasterizationHelper.distancePointEllipse((radiusX + 0.5f) * factor, (radiusZ + 0.5f) * factor, rx, rz, intersectionPos);
                        Vector3f point = Intersectionf.findClosestPointOnLineSegment((float)0.0f, (float)(radiusY + 0.5f), (float)0.0f, (float)(intersectionPos.x / factor), (float)(-radiusY - 0.5f), (float)(intersectionPos.y / factor), (float)rx, (float)ry, (float)rz, (Vector3f)new Vector3f());
                        if (rounding * height > radiusY - point.y + 1.0f) {
                            float surfaceDistance = RasterizationHelper.distancePointEllipsoid((radiusX + 0.5f) * m4, (ellipsoidRadiusY + 0.5f) * m4, (radiusZ + 0.5f) * m4, rx, ry + v, rz, null);
                            surfaceDistanceSq = surfaceDistance * surfaceDistance;
                        } else {
                            float dx = rx - point.x;
                            float dy = ry - point.y;
                            float dz = rz - point.z;
                            surfaceDistanceSq = dx * dx + dy * dy + dz * dz;
                        }
                    }
                    float amount = (float)metaballRange / ((float)metaballRange + surfaceDistanceSq) - 1.0f / (float)(1 + metaballRange);
                    if (!(terrainAmount + amount >= 1.0f)) continue;
                    region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                }
            }
        }
    }
}

