/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class GrahamScan2d {
    public static Vector2d[] getVertices(Vector2d[] a) {
        int k2;
        int k1;
        Stack<Vector2d> hull = new Stack<Vector2d>();
        int n = a.length;
        Arrays.sort(a, new YOrder());
        Arrays.sort(a, 1, n, new PolarOrder(a[0]));
        hull.push(a[0]);
        for (k1 = 1; k1 < n && a[0].equals((Object)a[k1]); ++k1) {
        }
        if (k1 == n) {
            return null;
        }
        for (k2 = k1 + 1; k2 < n && GrahamScan2d.ccw(a[0], a[k1], a[k2]) == 0; ++k2) {
        }
        hull.push(a[k2 - 1]);
        for (int i = k2; i < n; ++i) {
            Vector2d top = (Vector2d)hull.pop();
            while (GrahamScan2d.ccw((Vector2d)hull.peek(), top, a[i]) <= 0) {
                top = (Vector2d)hull.pop();
            }
            hull.push(top);
            hull.push(a[i]);
        }
        return hull.toArray(new Vector2d[0]);
    }

    public static int ccw(Vector2d a, Vector2d b, Vector2d c) {
        double area2 = (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        if (area2 < 0.0) {
            return -1;
        }
        if (area2 > 0.0) {
            return 1;
        }
        return 0;
    }

    private static int lowestPolarAngle(Vector2d[] points, Vector2d lowestPoint) {
        int index = 0;
        double minorPolarAngle = 180.0;
        for (int i = 1; i < points.length; ++i) {
            double angle = lowestPoint.angle((Vector2dc)points[i]);
            if (!(angle < minorPolarAngle)) continue;
            minorPolarAngle = angle;
            index = i;
        }
        return index;
    }

    public static int lowestPoint(Vector2d[] points) {
        Vector2d lowest = points[0];
        int index = 0;
        for (int i = 1; i < points.length; ++i) {
            if (!(points[i].y < lowest.y) && (points[i].y != lowest.y || !(points[i].x > lowest.x))) continue;
            lowest = points[i];
            index = i;
        }
        return index;
    }

    public static void swap(Vector2d[] points, int index0, int index1) {
        Vector2d temp = points[index0];
        points[index0] = points[index1];
        points[index1] = temp;
    }

    public static double angle(Vector2d first, Vector2d p1, Vector2d p2) {
        double x = first.x;
        double ax = p1.x - x;
        double bx = p2.x - x;
        double y = first.y;
        double ay = p1.y - y;
        double by = p2.y - y;
        double delta = (ax * bx + ay * by) / Math.sqrt((ax * ax + ay * ay) * (bx * bx + by * by));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    private static class YOrder
    implements Comparator<Vector2d> {
        private YOrder() {
        }

        @Override
        public int compare(Vector2d o1, Vector2d o2) {
            if (o1.y < o2.y) {
                return -1;
            }
            if (o1.y > o2.y) {
                return 1;
            }
            if (o1.x < o2.x) {
                return -1;
            }
            if (o1.x > o2.x) {
                return 1;
            }
            return 0;
        }
    }

    private record PolarOrder(Vector2d main) implements Comparator<Vector2d>
    {
        @Override
        public int compare(Vector2d q1, Vector2d q2) {
            double dx1 = q1.x - this.main.x;
            double dy1 = q1.y - this.main.y;
            double dx2 = q2.x - this.main.x;
            double dy2 = q2.y - this.main.y;
            if (dy1 >= 0.0 && dy2 < 0.0) {
                return -1;
            }
            if (dy2 >= 0.0 && dy1 < 0.0) {
                return 1;
            }
            if (dy1 == 0.0 && dy2 == 0.0) {
                if (dx1 >= 0.0 && dx2 < 0.0) {
                    return -1;
                }
                if (dx2 >= 0.0 && dx1 < 0.0) {
                    return 1;
                }
                return 0;
            }
            return -GrahamScan2d.ccw(this.main, q1, q2);
        }
    }
}

