/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.annotation;

import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.annotations.AnnotationHistoryElement;
import com.moulberry.axiom.annotations.AnnotationUpdateAction;
import com.moulberry.axiom.annotations.data.AnnotationData;
import com.moulberry.axiom.annotations.data.BoxOutlineAnnotationData;
import com.moulberry.axiom.annotations.data.FreehandOutlineAnnotationData;
import com.moulberry.axiom.annotations.data.ImageAnnotationData;
import com.moulberry.axiom.annotations.data.LineAnnotationData;
import com.moulberry.axiom.annotations.data.LinesOutlineAnnotationData;
import com.moulberry.axiom.annotations.data.TextAnnotationData;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.AxiomServerboundAnnotationUpdate;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.pather.ToolPatherPoint;
import com.moulberry.axiom.pather.ToolPatherVec3;
import com.moulberry.axiom.rasterization.Rasterization2D;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.annotations.Annotation;
import com.moulberry.axiom.render.annotations.Annotations;
import com.moulberry.axiom.render.annotations.LineAnnotation;
import com.moulberry.axiom.render.annotations.OutlineAnnotation;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.annotation.AnnotationByteOffset;
import com.moulberry.axiom.tools.annotation.AnnotationsDisabled;
import com.moulberry.axiom.utils.PositionUtils;
import imgui.ImGui;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class AnnotationTool
implements Tool {
    public static EnumSet<AnnotationsDisabled> annotationsDisabled = EnumSet.noneOf(AnnotationsDisabled.class);
    private boolean raycastFluids = true;
    @Nullable
    private ToolPatherVec3 linePather = null;
    private class_2382 startQuantized = null;
    private class_2382 lastQuantized = null;
    private class_2350 currentDirection = null;
    private class_2350 lastUsedDirection = null;
    private class_243 lastRaycastPosition = null;
    private final List<class_243> raycastPositions = new ArrayList<class_243>();
    private final ByteList quantizedLineOffsets = new ByteArrayList();
    private final int[] outlineMode = new int[]{0};
    private static final int OUTLINE_MODE_FREEHAND = 0;
    private static final int OUTLINE_MODE_LINES = 1;
    private static final int OUTLINE_MODE_BOX = 2;
    private ToolPatherPoint outlinePather = null;
    private class_2338 startOutline = null;
    private final class_2338.class_2339 lastOutlinePos = new class_2338.class_2339();
    private int outlineOffsetIndex = 0;
    private final ByteArrayList outlineOffsets = new ByteArrayList();
    private final LongArrayList outlineLines = new LongArrayList();
    private class_2338 outlineBoxStart = null;
    private boolean maxBoxSizeReached = false;
    private class_241 deleteMouseDragStart = null;
    public Gizmo selectedGizmo = null;
    public UUID lastSelectedAnnotation = null;
    public UUID selectedAnnotation = null;
    public UUID justPlacedAnnotation = null;
    private final int[] tool = new int[]{0};
    private static final int TOOL_DRAW = 0;
    private static final int TOOL_OUTLINE = 1;
    private static final int TOOL_TEXT = 2;
    private static final int TOOL_IMAGE = 3;
    private static final int TOOL_ERASE = 4;
    private static final int TOOL_MOVE = 5;
    private static final String[] TOOL_NAMES = new String[]{"Draw", "Outline", "Text", "Image", "Erase", "Move"};
    private static final String[] TOOL_ICONS = new String[]{"\ue924", "\ue927", "\ue925", "\ue926", "\ue922", "\ue923"};
    private boolean textShadow = true;
    private final int[] textScale = new int[]{1};
    private final int[] billboardMode = new int[]{0};
    private final ImString textContent = new ImString();
    private final float[] colour = new float[]{1.0f, 1.0f, 1.0f};
    private final float[] opacity = new float[]{1.0f};
    private final float[] lineWidth = new float[]{2.0f};
    private final int[] imageWidth = new int[]{8};
    private final ImString imageUrl = new ImString();

    public AnnotationTool() {
        this.textContent.inputData.isResizable = true;
        this.imageUrl.inputData.isResizable = true;
    }

    @Override
    public void reset() {
        this.linePather = null;
        this.startQuantized = null;
        this.lastQuantized = null;
        this.currentDirection = null;
        this.lastUsedDirection = null;
        this.lastRaycastPosition = null;
        this.raycastPositions.clear();
        this.quantizedLineOffsets.clear();
        this.outlinePather = null;
        this.startOutline = null;
        this.outlineOffsetIndex = 0;
        this.outlineOffsets.clear();
        this.outlineBoxStart = null;
        this.maxBoxSizeReached = false;
        this.outlineLines.clear();
        this.deleteMouseDragStart = null;
        this.lastRaycastPosition = null;
        this.raycastPositions.clear();
        this.selectedGizmo = null;
        this.selectedAnnotation = null;
        this.lastSelectedAnnotation = null;
        this.justPlacedAnnotation = null;
    }

    private static boolean compatibleSign(int a, int b) {
        if (Math.abs(a) <= 1 || Math.abs(b) <= 0) {
            return true;
        }
        return a > 0 == b > 0;
    }

    public static boolean leftQuantizedCloserToEdge(int a, int b) {
        if ((a %= 16) > 8) {
            a -= 16;
        }
        if (a < -8) {
            a += 16;
        }
        if ((b %= 16) > 8) {
            b -= 16;
        }
        if (b < -8) {
            b += 16;
        }
        return Math.abs(a) < Math.abs(b);
    }

    private static class_2382 quantize(class_243 vec3) {
        return new class_2382((int)Math.round(vec3.field_1352 * 16.0), (int)Math.round(vec3.field_1351 * 16.0), (int)Math.round(vec3.field_1350 * 16.0));
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        if (!annotationsDisabled.isEmpty()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (action) {
            case RIGHT_MOUSE: {
                if (this.tool[0] != 1) {
                    this.reset();
                } else {
                    switch (this.outlineMode[0]) {
                        case 0: {
                            this.reset();
                            break;
                        }
                        case 1: {
                            if (!this.outlineLines.isEmpty()) break;
                            this.reset();
                            break;
                        }
                        case 2: {
                            if (this.outlineBoxStart != null) break;
                            this.reset();
                        }
                    }
                }
                block12 : switch (this.tool[0]) {
                    case 0: {
                        RayCaster.RaycastResult result = Tool.raycastBlock(false, false, this.raycastFluids);
                        if (result == null) break;
                        this.linePather = new ToolPatherVec3();
                        this.startQuantized = AnnotationTool.quantize(result.getLocation());
                        this.lastRaycastPosition = result.getLocation();
                        this.lastUsedDirection = result.getDirection();
                        this.lastQuantized = this.startQuantized;
                        break;
                    }
                    case 2: {
                        TextAnnotationData data;
                        RayCaster.RaycastResult result = Tool.raycastBlock(false, false, this.raycastFluids);
                        if (result == null || (data = this.createTextAnnotationData(result.getLocation().method_46409(), AnnotationTool.calculateFallbackYaw(), result.direction())) == null) break;
                        this.justPlacedAnnotation = Annotations.pushCreateAnnotation(data);
                        if (this.billboardMode[0] != 0 && (this.billboardMode[0] != 2 || result.direction().method_10166() != class_2350.class_2351.field_11052)) break;
                        this.justPlacedAnnotation = null;
                        break;
                    }
                    case 1: {
                        RayCaster.RaycastResult result = Tool.raycastBlock(false, false, this.raycastFluids);
                        if (result == null) break;
                        switch (this.outlineMode[0]) {
                            case 0: {
                                this.outlinePather = new ToolPatherPoint(false);
                                this.outlinePather.includeFluids = this.raycastFluids;
                                this.outlineOffsetIndex = 0;
                                this.outlineOffsets.clear();
                                break;
                            }
                            case 1: {
                                class_2338 to;
                                if (this.outlineLines.isEmpty()) {
                                    this.outlineLines.add(result.blockPos().method_10063());
                                    break;
                                }
                                long lastPos = this.outlineLines.getLong(this.outlineLines.size() - 1);
                                class_2338 from = class_2338.method_10092((long)lastPos);
                                if (from.equals((Object)(to = result.blockPos()))) break block12;
                                this.outlineLines.add(to.method_10063());
                                break;
                            }
                            case 2: {
                                int maxZ;
                                int maxY;
                                if (this.outlineBoxStart == null) {
                                    this.outlineBoxStart = result.blockPos();
                                    this.maxBoxSizeReached = false;
                                    break;
                                }
                                int minX = Math.min(this.outlineBoxStart.method_10263(), result.blockPos().method_10263());
                                int minY = Math.min(this.outlineBoxStart.method_10264(), result.blockPos().method_10264());
                                int minZ = Math.min(this.outlineBoxStart.method_10260(), result.blockPos().method_10260());
                                int maxX = Math.max(this.outlineBoxStart.method_10263(), result.blockPos().method_10263());
                                int size = (maxX - minX + 1) * ((maxY = Math.max(this.outlineBoxStart.method_10264(), result.blockPos().method_10264())) - minY + 1) * ((maxZ = Math.max(this.outlineBoxStart.method_10260(), result.blockPos().method_10260())) - minZ + 1);
                                if (size <= 1000000) {
                                    BoxOutlineAnnotationData annotation = new BoxOutlineAnnotationData(minX, minY, minZ, maxX, maxY, maxZ, AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]));
                                    Annotations.pushCreateAnnotation(annotation);
                                }
                                this.reset();
                            }
                        }
                        break;
                    }
                    case 3: {
                        RayCaster.RaycastResult result = Tool.raycastBlock(false, false, this.raycastFluids);
                        if (result == null) break;
                        ImageAnnotationData annotation = this.createImageAnnotationData(result.getLocation().method_46409(), AnnotationTool.calculateFallbackYaw(), result.direction());
                        this.justPlacedAnnotation = Annotations.pushCreateAnnotation(annotation);
                        if (this.billboardMode[0] != 0 && (this.billboardMode[0] != 2 || result.direction().method_10166() != class_2350.class_2351.field_11052)) break;
                        this.justPlacedAnnotation = null;
                        break;
                    }
                    case 4: {
                        this.deleteMouseDragStart = new class_241(EditorUI.getIO().getMousePosX(), EditorUI.getIO().getMousePosY());
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (this.canBeResetByUndo()) {
                    this.reset();
                } else if (!this.outlineLines.isEmpty()) {
                    this.outlineLines.removeLong(this.outlineLines.size() - 1);
                    if (this.outlineLines.isEmpty()) {
                        this.reset();
                    }
                } else {
                    Annotations.undo();
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case REDO: {
                if (this.canBeResetByUndo() || !this.outlineLines.isEmpty()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                Annotations.redo();
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (this.tool[0] == 5 && !EditorUI.isCtrlOrCmdDown()) {
                    for (Map.Entry<UUID, Annotation> entry : Annotations.visibleAnnotations()) {
                        Annotation annotation = entry.getValue();
                        Gizmo gizmo = annotation.getGizmo();
                        if (gizmo == null || !gizmo.leftClick()) continue;
                        this.selectedGizmo = gizmo;
                        this.selectedAnnotation = entry.getKey();
                        this.lastSelectedAnnotation = null;
                        return UserAction.ActionResult.USED_STOP;
                    }
                } else if (this.selectedGizmo != null && this.selectedGizmo.leftClick()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                this.selectedGizmo = null;
                this.selectedAnnotation = null;
                this.lastSelectedAnnotation = null;
                break;
            }
            case DELETE: {
                if (this.selectedGizmo != null) {
                    for (Map.Entry<UUID, Annotation> entry : Annotations.visibleAnnotations()) {
                        Annotation annotation = entry.getValue();
                        if (this.selectedGizmo != annotation.getGizmo()) continue;
                        Annotations.push(AnnotationHistoryElement.makeDeleteAnnotation(entry.getKey(), entry.getValue().getData()));
                        return UserAction.ActionResult.USED_STOP;
                    }
                }
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private static float calculateFallbackYaw() {
        float roundedYaw;
        float yaw = class_310.method_1551().field_1724.method_36454();
        float difference = Math.abs(class_3532.method_15393((float)(yaw - (roundedYaw = (float)(Math.round(yaw / 90.0f) * 90)))));
        if ((double)difference < 7.5) {
            return roundedYaw;
        }
        return yaw;
    }

    private TextAnnotationData createTextAnnotationData(Vector3f position, float fallbackYaw, class_2350 direction) {
        String textContent = ImGuiHelper.getString(this.textContent);
        if (!textContent.isBlank()) {
            int colour = AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]) & 0xFFFFFF;
            return new TextAnnotationData(textContent, position, new Quaternionf(), direction, fallbackYaw, this.textScale[0], this.billboardMode[0], colour |= (int)(this.opacity[0] * 255.0f) << 24, this.textShadow);
        }
        return null;
    }

    private ImageAnnotationData createImageAnnotationData(Vector3f position, float fallbackYaw, class_2350 direction) {
        return new ImageAnnotationData(ImGuiHelper.getString(this.imageUrl), position, new Quaternionf(), direction, fallbackYaw, this.imageWidth[0], this.opacity[0], this.billboardMode[0]);
    }

    private boolean canBeResetByUndo() {
        return this.deleteMouseDragStart != null || this.outlineBoxStart != null || this.outlinePather != null || this.linePather != null;
    }

    private static int colourFromFloat(float red, float green, float blue) {
        int redI = (int)(red * 255.0f);
        int greenI = (int)(green * 255.0f);
        int blueI = (int)(blue * 255.0f);
        return 0xFF000000 | redI << 16 | greenI << 8 | blueI;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        RayCaster.RaycastResult result;
        if (!annotationsDisabled.isEmpty()) {
            return;
        }
        this.update(camera);
        if (this.startQuantized != null && !this.quantizedLineOffsets.isEmpty()) {
            LineAnnotation.drawStatic(camera.method_19326(), matrices, projection, this.startQuantized, this.quantizedLineOffsets, this.lineWidth[0], AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]));
        }
        if (this.startOutline != null) {
            FreehandOutlineAnnotationData data = new FreehandOutlineAnnotationData(this.startOutline, this.outlineOffsets.elements(), this.outlineOffsetIndex, AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]));
            OutlineAnnotation.drawStatic(camera, class_310.method_1551().field_1687, matrices, projection, data);
        }
        if (!this.outlineLines.isEmpty()) {
            long[] positions;
            RayCaster.RaycastResult result2 = Tool.raycastBlock(false, false, this.raycastFluids);
            if (result2 != null) {
                positions = new long[this.outlineLines.size() + 1];
                this.outlineLines.toArray(positions);
                positions[positions.length - 1] = result2.blockPos().method_10063();
            } else {
                positions = this.outlineLines.toLongArray();
            }
            LinesOutlineAnnotationData data = new LinesOutlineAnnotationData(positions, AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]));
            OutlineAnnotation.drawStatic(camera, class_310.method_1551().field_1687, matrices, projection, data);
        }
        if (this.outlineBoxStart != null && (result = Tool.raycastBlock(false, false, this.raycastFluids)) != null) {
            int maxZ;
            int maxY;
            int minX = Math.min(this.outlineBoxStart.method_10263(), result.blockPos().method_10263());
            int minY = Math.min(this.outlineBoxStart.method_10264(), result.blockPos().method_10264());
            int minZ = Math.min(this.outlineBoxStart.method_10260(), result.blockPos().method_10260());
            int maxX = Math.max(this.outlineBoxStart.method_10263(), result.blockPos().method_10263());
            int size = (maxX - minX + 1) * ((maxY = Math.max(this.outlineBoxStart.method_10264(), result.blockPos().method_10264())) - minY + 1) * ((maxZ = Math.max(this.outlineBoxStart.method_10260(), result.blockPos().method_10260())) - minZ + 1);
            boolean bl = this.maxBoxSizeReached = size > 1000000;
            if (!this.maxBoxSizeReached) {
                BoxOutlineAnnotationData data = new BoxOutlineAnnotationData(minX, minY, minZ, maxX, maxY, maxZ, AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]));
                OutlineAnnotation.drawStatic(camera, class_310.method_1551().field_1687, matrices, projection, data);
            }
        }
        boolean showedSelectedGizmo = false;
        if (this.tool[0] == 5) {
            Gizmo gizmo;
            class_243 lookDirection = Tool.getLookDirection();
            boolean isLeftDown = Tool.isMouseDown(0);
            boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
            boolean showGizmos = !isCtrlDown;
            for (Map.Entry<UUID, Annotation> entry : Annotations.visibleAnnotations()) {
                Annotation annotation = entry.getValue();
                gizmo = annotation.getGizmo();
                if (gizmo == null) continue;
                boolean bl = gizmo.enableAxes = gizmo == this.selectedGizmo;
                if (gizmo == this.selectedGizmo) {
                    showedSelectedGizmo = true;
                }
                boolean wasGrabbed = gizmo.isGrabbed();
                class_243 previousTarget = gizmo.getTargetVec();
                gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, true);
                class_243 currentTarget = gizmo.getTargetVec();
                if (!previousTarget.equals((Object)currentTarget)) {
                    Annotations.push(new AnnotationHistoryElement(new AnnotationUpdateAction.MoveAnnotation(entry.getKey(), previousTarget.method_46409()), new AnnotationUpdateAction.MoveAnnotation(entry.getKey(), currentTarget.method_46409())));
                }
                if (!wasGrabbed || !gizmo.isGrabbed()) continue;
                gizmo.render(matrices, camera, isCtrlDown);
                showGizmos = false;
            }
            if (showGizmos) {
                for (Map.Entry<UUID, Annotation> entry : Annotations.visibleAnnotations()) {
                    Annotation annotation = entry.getValue();
                    gizmo = annotation.getGizmo();
                    if (gizmo == null) continue;
                    gizmo.render(matrices, camera, false);
                }
            }
        } else if (this.selectedGizmo != null) {
            boolean isLeftDown = Tool.isMouseDown(0);
            boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
            for (Map.Entry<UUID, Annotation> entry : Annotations.visibleAnnotations()) {
                Annotation annotation = entry.getValue();
                Gizmo gizmo = annotation.getGizmo();
                if (gizmo == null || gizmo != this.selectedGizmo) continue;
                gizmo.enableAxes = true;
                showedSelectedGizmo = true;
                boolean wasGrabbed = gizmo.isGrabbed();
                class_243 previousTarget = gizmo.getTargetVec();
                gizmo.update(time, Tool.getLookDirection(), isLeftDown, isCtrlDown, true);
                class_243 currentTarget = gizmo.getTargetVec();
                if (!previousTarget.equals((Object)currentTarget)) {
                    Annotations.push(new AnnotationHistoryElement(new AnnotationUpdateAction.MoveAnnotation(entry.getKey(), previousTarget.method_46409()), new AnnotationUpdateAction.MoveAnnotation(entry.getKey(), currentTarget.method_46409())));
                }
                if (wasGrabbed && gizmo.isGrabbed()) {
                    gizmo.render(matrices, camera, isCtrlDown);
                    continue;
                }
                if (isCtrlDown) continue;
                gizmo.render(matrices, camera, false);
            }
        }
        if (!showedSelectedGizmo) {
            this.selectedGizmo = null;
            this.selectedAnnotation = null;
            this.lastSelectedAnnotation = null;
        }
    }

    private void update(class_4184 camera) {
        if (Tool.cancelUsing()) {
            this.reset();
        }
        this.updateErase();
        this.updateOutline();
        this.updateDraw(camera);
    }

    private void updateErase() {
        if (this.deleteMouseDragStart != null && !Tool.isMouseDown(1)) {
            class_241 end = new class_241(ImGui.getMousePosX(), ImGui.getMousePosY());
            Annotations.erase(this.deleteMouseDragStart, end);
            this.reset();
        }
    }

    private void updateOutline() {
        if (this.outlinePather != null) {
            this.outlinePather.update((x, y, z) -> {
                if (this.startOutline == null) {
                    this.startOutline = new class_2338(x, y, z);
                    this.lastOutlinePos.method_10103(x, y, z);
                    return;
                }
                int dx = x - this.lastOutlinePos.method_10263();
                int dy = y - this.lastOutlinePos.method_10264();
                int dz = z - this.lastOutlinePos.method_10260();
                if (dx == 0 && dy == 0 && dz == 0) {
                    return;
                }
                class_2350 direction = PositionUtils.directionFromDelta(dx, dy, dz);
                Objects.requireNonNull(direction);
                byte directionValue = (byte)direction.method_10146();
                int indexModulo = this.outlineOffsetIndex % 3;
                if (indexModulo == 0) {
                    this.outlineOffsets.add(directionValue);
                } else {
                    byte last = this.outlineOffsets.getByte(this.outlineOffsets.size() - 1);
                    if (indexModulo == 1) {
                        this.outlineOffsets.set(this.outlineOffsets.size() - 1, (byte)(last + directionValue * 6));
                    } else {
                        this.outlineOffsets.set(this.outlineOffsets.size() - 1, (byte)(last + directionValue * 6 * 6));
                    }
                }
                ++this.outlineOffsetIndex;
                this.lastOutlinePos.method_10103(x, y, z);
            });
            if (!Tool.isMouseDown(1)) {
                FreehandOutlineAnnotationData annotation = new FreehandOutlineAnnotationData(this.startOutline, this.outlineOffsets.toByteArray(), this.outlineOffsetIndex, AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]));
                Annotations.pushCreateAnnotation(annotation);
                this.reset();
            }
        }
    }

    private void updateDraw(class_4184 camera) {
        if (this.linePather != null) {
            class_2382 cameraPosition = AnnotationTool.quantize(camera.method_19326());
            double distanceSq = camera.method_19326().method_1025(this.lastRaycastPosition);
            double distance = Math.sqrt(distanceSq);
            int levelOfDetail = (int)Math.max(1.0, Math.ceil(distance / 16.0));
            double threshold = (double)levelOfDetail / 16.0;
            double thresholdSq = threshold * threshold;
            this.linePather.update((RayCaster.RaycastResult raycastResult) -> {
                boolean emitPoint = this.lastRaycastPosition.method_1025(raycastResult.getLocation()) > thresholdSq;
                if ((emitPoint |= this.currentDirection == null || this.currentDirection != raycastResult.direction()) && !this.raycastPositions.isEmpty()) {
                    double sumX = 0.0;
                    double sumY = 0.0;
                    double sumZ = 0.0;
                    int sumCount = 0;
                    for (class_243 raycastPosition : this.raycastPositions) {
                        sumX += raycastPosition.field_1352;
                        sumY += raycastPosition.field_1351;
                        sumZ += raycastPosition.field_1350;
                        ++sumCount;
                    }
                    class_243 position = new class_243(sumX / (double)sumCount, sumY / (double)sumCount, sumZ / (double)sumCount);
                    class_2382 quantized = AnnotationTool.quantize(position);
                    if (!quantized.equals((Object)this.lastQuantized)) {
                        this.handleDrawFromTo(cameraPosition, this.lastQuantized, quantized, this.lastUsedDirection.method_10166(), this.currentDirection.method_10166());
                        this.lastQuantized = quantized;
                        this.lastUsedDirection = this.currentDirection;
                        this.lastRaycastPosition = position;
                    }
                    this.raycastPositions.clear();
                }
                this.currentDirection = raycastResult.direction();
                this.raycastPositions.add(raycastResult.getLocation());
            });
            if (!Tool.isMouseDown(1)) {
                if (!this.quantizedLineOffsets.isEmpty()) {
                    LineAnnotationData annotation = new LineAnnotationData(this.startQuantized, this.quantizedLineOffsets.toByteArray(), this.lineWidth[0], AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]));
                    Annotations.pushCreateAnnotation(annotation);
                }
                this.reset();
            }
        }
    }

    private void handleDrawFromTo(class_2382 cameraPosition, class_2382 from, class_2382 to, class_2350.class_2351 fromAxis, class_2350.class_2351 toAxis) {
        if (from.equals((Object)to)) {
            return;
        }
        if (fromAxis != toAxis) {
            class_2382 middle = switch (fromAxis) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.class_2351.field_11048 -> new class_2382(from.method_10263(), to.method_10264(), to.method_10260());
                case class_2350.class_2351.field_11052 -> new class_2382(to.method_10263(), from.method_10264(), to.method_10260());
                case class_2350.class_2351.field_11051 -> new class_2382(to.method_10263(), to.method_10264(), from.method_10260());
            };
            this.handleDrawFromTo(cameraPosition, from, middle, fromAxis, fromAxis);
            this.handleDrawFromTo(cameraPosition, middle, to, toAxis, toAxis);
            return;
        }
        if (fromAxis.method_10173(from.method_10263(), from.method_10264(), from.method_10260()) != fromAxis.method_10173(to.method_10263(), to.method_10264(), to.method_10260())) {
            switch (fromAxis) {
                case field_11048: {
                    Vector2i middle;
                    Vector2i from2d = new Vector2i(from.method_10264(), from.method_10260());
                    Vector2i to2d = new Vector2i(to.method_10264(), to.method_10260());
                    if (cameraPosition.method_10262(from) > cameraPosition.method_10262(to)) {
                        Vector2i temp = from2d;
                        from2d = to2d;
                        to2d = temp;
                    }
                    if ((middle = Rasterization2D.bresenhamReturn(from2d, to2d, (y, z) -> {
                        if (y % 16 == 0 || z % 16 == 0) {
                            return new Vector2i(y, z);
                        }
                        return null;
                    })) == null) {
                        middle = new Vector2i((to.method_10264() + from.method_10264()) / 2, (to.method_10260() + from.method_10260()) / 2);
                    }
                    class_2350.class_2351 axis = AnnotationTool.leftQuantizedCloserToEdge(middle.x, middle.y) ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051;
                    this.handleDrawFromTo(cameraPosition, from, new class_2382(from.method_10263(), middle.x, middle.y), fromAxis, fromAxis);
                    this.handleDrawFromTo(cameraPosition, new class_2382(from.method_10263(), middle.x, middle.y), new class_2382(to.method_10263(), middle.x, middle.y), axis, axis);
                    this.handleDrawFromTo(cameraPosition, new class_2382(to.method_10263(), middle.x, middle.y), to, toAxis, toAxis);
                    return;
                }
                case field_11052: {
                    Vector2i middle;
                    Vector2i from2d = new Vector2i(from.method_10263(), from.method_10260());
                    Vector2i to2d = new Vector2i(to.method_10263(), to.method_10260());
                    if (cameraPosition.method_10262(from) > cameraPosition.method_10262(to)) {
                        Vector2i temp = from2d;
                        from2d = to2d;
                        to2d = temp;
                    }
                    if ((middle = Rasterization2D.bresenhamReturn(from2d, to2d, (x, z) -> {
                        if (x % 16 == 0 || z % 16 == 0) {
                            return new Vector2i(x, z);
                        }
                        return null;
                    })) == null) {
                        middle = new Vector2i((to.method_10263() + from.method_10263()) / 2, (to.method_10260() + from.method_10260()) / 2);
                    }
                    class_2350.class_2351 axis = AnnotationTool.leftQuantizedCloserToEdge(middle.x, middle.y) ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
                    this.handleDrawFromTo(cameraPosition, from, new class_2382(middle.x, from.method_10264(), middle.y), fromAxis, fromAxis);
                    this.handleDrawFromTo(cameraPosition, new class_2382(middle.x, from.method_10264(), middle.y), new class_2382(middle.x, to.method_10264(), middle.y), axis, axis);
                    this.handleDrawFromTo(cameraPosition, new class_2382(middle.x, to.method_10264(), middle.y), to, toAxis, toAxis);
                    return;
                }
                case field_11051: {
                    Vector2i middle;
                    Vector2i from2d = new Vector2i(from.method_10263(), from.method_10264());
                    Vector2i to2d = new Vector2i(to.method_10263(), to.method_10264());
                    if (cameraPosition.method_10262(from) > cameraPosition.method_10262(to)) {
                        Vector2i temp = from2d;
                        from2d = to2d;
                        to2d = temp;
                    }
                    if ((middle = Rasterization2D.bresenhamReturn(from2d, to2d, (x, y) -> {
                        if (x % 16 == 0 || y % 16 == 0) {
                            return new Vector2i(x, y);
                        }
                        return null;
                    })) == null) {
                        middle = new Vector2i((to.method_10263() + from.method_10263()) / 2, (to.method_10264() + from.method_10264()) / 2);
                    }
                    class_2350.class_2351 axis = AnnotationTool.leftQuantizedCloserToEdge(middle.x, middle.y) ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11052;
                    this.handleDrawFromTo(cameraPosition, from, new class_2382(middle.x, middle.y, from.method_10260()), fromAxis, fromAxis);
                    this.handleDrawFromTo(cameraPosition, new class_2382(middle.x, middle.y, from.method_10260()), new class_2382(middle.x, middle.y, to.method_10260()), axis, axis);
                    this.handleDrawFromTo(cameraPosition, new class_2382(middle.x, middle.y, to.method_10260()), to, toAxis, toAxis);
                    return;
                }
            }
        }
        class_2338.class_2339 last = new class_2338.class_2339(from.method_10263(), from.method_10264(), from.method_10260());
        Rasterization3D.bresenhamSkipFrom(from, to, (x1, y1, z1) -> {
            int combinedOffsetId;
            byte lastOffsetId;
            AnnotationByteOffset lastOffset;
            int dx = x1 - last.method_10263();
            int dy = y1 - last.method_10264();
            int dz = z1 - last.method_10260();
            while (!this.quantizedLineOffsets.isEmpty() && (lastOffset = AnnotationByteOffset.idToOffset(lastOffsetId = this.quantizedLineOffsets.getByte(this.quantizedLineOffsets.size() - 1))).axis() == fromAxis && AnnotationTool.compatibleSign(lastOffset.dx(), dx) && AnnotationTool.compatibleSign(lastOffset.dy(), dy) && AnnotationTool.compatibleSign(lastOffset.dz(), dz) && (combinedOffsetId = AnnotationByteOffset.offsetToId(lastOffset.dx() + dx, lastOffset.dy() + dy, lastOffset.dz() + dz, lastOffset.axis())) >= 0) {
                this.quantizedLineOffsets.removeByte(this.quantizedLineOffsets.size() - 1);
                dx += lastOffset.dx();
                dy += lastOffset.dy();
                dz += lastOffset.dz();
            }
            if (dx != 0 || dy != 0 || dz != 0) {
                int offset = AnnotationByteOffset.offsetToId(dx, dy, dz, fromAxis);
                if (offset == -1) {
                    throw new FaultyImplementationError();
                }
                this.quantizedLineOffsets.add((byte)offset);
            }
            last.method_10103(x1, y1, z1);
        });
    }

    @Override
    public void displayImguiOptions() {
        if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.ANNOTATION_UPDATE)) {
            ImGui.textWrapped("\u26a0 The server does not allow creating annotations");
            return;
        }
        if (annotationsDisabled.contains((Object)AnnotationsDisabled.UNAVAILABLE)) {
            ImGui.textWrapped("\u26a0 Annotations in Multiplayer is a Commercial License feature. Click for more information");
            ImGuiHelper.openCommercialLicenseOnClick();
            return;
        }
        if (!this.outlineLines.isEmpty()) {
            if (ImGui.button("Finish Lines")) {
                LinesOutlineAnnotationData annotation = new LinesOutlineAnnotationData(this.outlineLines.toLongArray(), AnnotationTool.colourFromFloat(this.colour[0], this.colour[1], this.colour[2]));
                Annotations.pushCreateAnnotation(annotation);
                this.reset();
            }
            return;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.annotation"));
        float toolButtonSizeX = (32.0f + ImGui.getStyle().getFramePaddingX() * 2.0f) * EditorUI.getUiScale();
        float toolButtonSizeY = (32.0f + ImGui.getStyle().getFramePaddingY() * 2.0f) * EditorUI.getUiScale();
        float strideX = toolButtonSizeX + ImGui.getStyle().getItemInnerSpacingX();
        float strideY = toolButtonSizeY + ImGui.getStyle().getItemInnerSpacingY();
        int rows = Math.max(1, (int)Math.ceil(strideX * (float)TOOL_NAMES.length / (ImGui.getContentRegionAvailX() + toolButtonSizeX / 3.0f)));
        int buttonsPerRow = (int)Math.ceil((float)TOOL_NAMES.length / (float)rows);
        float currentX = ImGui.getCursorPosX();
        float currentY = ImGui.getCursorPosY();
        float originalX = currentX;
        int buttonActiveCol = ImGui.getColorU32(23);
        ImGui.pushFont(EditorUI.icons);
        int activeTool = this.tool[0];
        for (int i = 0; i <= 5; ++i) {
            if (i > 0 && i % buttonsPerRow == 0) {
                currentX = originalX;
                currentY += strideY;
            }
            ImGui.setCursorPos(currentX, currentY);
            if (i == activeTool) {
                ImGuiHelper.pushStyleColor(21, buttonActiveCol);
            }
            ImGui.pushID(i);
            if (ImGui.button(TOOL_ICONS[i], toolButtonSizeX, toolButtonSizeY) && i != activeTool) {
                this.tool[0] = i;
                this.reset();
            }
            ImGui.popID();
            if (i == activeTool) {
                ImGuiHelper.popStyleColor();
            }
            if (ImGui.isItemHovered()) {
                ImGui.popFont();
                ImGui.beginTooltip();
                ImGui.text(TOOL_NAMES[i]);
                ImGui.endTooltip();
                ImGui.pushFont(EditorUI.icons);
            }
            currentX += strideX;
        }
        ImGui.popFont();
        if (this.deleteMouseDragStart != null) {
            float mouseX = ImGui.getMousePosX();
            float mouseY = ImGui.getMousePosY();
            float minX = Math.min(this.deleteMouseDragStart.field_1343, mouseX);
            float maxX = Math.max(this.deleteMouseDragStart.field_1343, mouseX);
            float minY = Math.min(this.deleteMouseDragStart.field_1342, mouseY);
            float maxY = Math.max(this.deleteMouseDragStart.field_1342, mouseY);
            ImGui.getForegroundDrawList().addRectFilled(minX, minY, maxX, maxY, -2147483393, 4.0f);
            ImGui.getForegroundDrawList().addRect(minX, minY, maxX, maxY, -16776961);
        }
        if (this.tool[0] == 0) {
            ImGuiHelper.separatorWithText("Options");
            ImGui.sliderFloat("Line Width", this.lineWidth, 1.0f, 8.0f);
            ImGuiHelper.colorPicker3WithBlockDrop("Color", this.colour);
        } else if (this.tool[0] == 1) {
            ImGuiHelper.separatorWithText("Options");
            ImGuiHelper.combo("Mode", this.outlineMode, new String[]{"Freehand", "Lines", "Box"});
            if (this.outlineMode[0] == 2 && this.maxBoxSizeReached) {
                ImGui.textWrapped("\u26a0 Maximum outline box size reached. Boxes with a volume of >1,000,000 are disallowed for performance reasons");
            } else {
                ImGuiHelper.colorPicker3WithBlockDrop("Color", this.colour);
            }
        } else if (this.tool[0] == 2) {
            ImGuiHelper.separatorWithText("Options");
            this.renderTextOptions();
        } else if (this.tool[0] == 3) {
            ImGuiHelper.separatorWithText("Options");
            this.renderImageOptions();
        } else if (this.tool[0] == 5 && this.selectedAnnotation != null) {
            AnnotationData annotationData = Annotations.getData(this.selectedAnnotation);
            if (!Objects.equals(this.lastSelectedAnnotation, this.selectedAnnotation)) {
                this.lastSelectedAnnotation = this.selectedAnnotation;
                if (annotationData instanceof TextAnnotationData) {
                    TextAnnotationData textAnnotationData = (TextAnnotationData)annotationData;
                    this.textShadow = textAnnotationData.shadow();
                    this.textScale[0] = Math.round(textAnnotationData.scale());
                    this.billboardMode[0] = textAnnotationData.billboardMode();
                    this.textContent.set(textAnnotationData.text());
                    this.colour[0] = (float)(textAnnotationData.colour() >> 16 & 0xFF) / 255.0f;
                    this.colour[1] = (float)(textAnnotationData.colour() >> 8 & 0xFF) / 255.0f;
                    this.colour[2] = (float)(textAnnotationData.colour() & 0xFF) / 255.0f;
                    this.opacity[0] = (float)(textAnnotationData.colour() >> 24 & 0xFF) / 255.0f;
                } else if (annotationData instanceof ImageAnnotationData) {
                    ImageAnnotationData imageAnnotationData = (ImageAnnotationData)annotationData;
                    this.imageWidth[0] = Math.round(imageAnnotationData.width());
                    this.billboardMode[0] = imageAnnotationData.billboardMode();
                    this.imageUrl.set(imageAnnotationData.imageUrl());
                    this.opacity[0] = imageAnnotationData.opacity();
                }
            }
            if (annotationData instanceof TextAnnotationData) {
                TextAnnotationData newData;
                TextAnnotationData oldData = (TextAnnotationData)annotationData;
                ImGuiHelper.separatorWithText("Options");
                this.renderTextOptions();
                if (ImGui.button("Update") && !Objects.equals(newData = this.createTextAnnotationData(oldData.position(), oldData.fallbackYaw(), oldData.direction()), oldData)) {
                    Annotations.pushUpdateAnnotation(this.selectedAnnotation, oldData, newData);
                    this.justPlacedAnnotation = this.selectedAnnotation;
                }
            } else if (annotationData instanceof ImageAnnotationData) {
                ImageAnnotationData newData;
                ImageAnnotationData oldData = (ImageAnnotationData)annotationData;
                ImGuiHelper.separatorWithText("Options");
                this.renderImageOptions();
                if (ImGui.button("Update") && !Objects.equals(newData = this.createImageAnnotationData(oldData.position(), oldData.fallbackYaw(), oldData.direction()), oldData)) {
                    Annotations.pushUpdateAnnotation(this.selectedAnnotation, oldData, newData);
                    this.justPlacedAnnotation = this.selectedAnnotation;
                }
            }
        }
        if (this.tool[0] != 5 && this.tool[0] != 4) {
            ImGui.separator();
            if (ImGui.checkbox("Raycast Fluids", this.raycastFluids)) {
                this.raycastFluids = !this.raycastFluids;
            }
        }
        ImGui.separator();
        int annotationCount = Annotations.totalCount();
        int visibleAnnotationCount = Annotations.visibleAnnotations().size();
        ImGui.text("Total Annotations: " + annotationCount);
        ImGui.text("Annotations in range: " + visibleAnnotationCount);
        if (this.tool[0] == 2 && ImGui.button("View All Text Annotations")) {
            EditorWindowType.TEXT_ANNOTATIONS.setOpen(true);
        }
        if (this.tool[0] == 4 && annotationCount > 0) {
            boolean allowedToClearAll = AxiomClient.hasPermission(AxiomPermission.ANNOTATION_CLEARALL);
            if (!allowedToClearAll) {
                ImGui.beginDisabled();
            }
            if (ImGui.button("Clear ALL Annotations") && allowedToClearAll) {
                ImGui.openPopup("##ConfirmClear");
            }
            if (!allowedToClearAll) {
                ImGui.endDisabled();
                ImGuiHelper.tooltip("Server has not given you permission to clear all annotations", 512);
            }
            if (ImGui.beginPopup("##ConfirmClear") && allowedToClearAll) {
                ImGui.pushTextWrapPos(300.0f);
                ImGui.textWrapped("Are you sure? If you clear all annotations in this world, it won't be possible to recover them!");
                ImGui.popTextWrapPos();
                if (ImGui.button("I'm sure! Delete them")) {
                    new AxiomServerboundAnnotationUpdate(List.of(new AnnotationUpdateAction.ClearAllAnnotations())).send();
                    Annotations.clear();
                    ImGui.closeCurrentPopup();
                }
                ImGui.sameLine();
                if (ImGui.button("Cancel")) {
                    ImGui.closeCurrentPopup();
                }
                ImGui.endPopup();
            }
        }
    }

    private void renderImageOptions() {
        ImGui.sliderInt("Width", this.imageWidth, 1, 64);
        ImGuiHelper.combo("Billboard", this.billboardMode, new String[]{"Fixed", "Horizontal", "Vertical", "Center"});
        ImGui.inputText("Image URL", this.imageUrl);
        ImGui.sliderFloat("Opacity", this.opacity, 0.2f, 1.0f);
    }

    private void renderTextOptions() {
        if (ImGui.checkbox("Shadow", this.textShadow)) {
            this.textShadow = !this.textShadow;
        }
        ImGui.sliderInt("Scale", this.textScale, 1, 32);
        ImGuiHelper.combo("Billboard", this.billboardMode, new String[]{"Fixed", "Horizontal", "Vertical", "Center"});
        ImGui.inputTextMultiline("Text", this.textContent);
        char[] charPresets = new char[]{'\u2714', '\u2716', '\u2620', '\u2622', '\u2764', '\u2b06', '\u2b07', '\u27a1', '\u2b05', '\u270f'};
        for (int i = 0; i < charPresets.length; ++i) {
            if (i > 0 && i % 5 != 0) {
                ImGui.sameLine();
            }
            if (!ImGui.button(String.valueOf(charPresets[i]))) continue;
            this.textContent.set(String.valueOf(charPresets[i]));
        }
        ImGuiHelper.colorPicker3WithBlockDrop("Color", this.colour);
        ImGui.sliderFloat("Opacity", this.opacity, 0.2f, 1.0f);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.annotation");
    }

    @Override
    public void writeSettings(class_2487 tag) {
    }

    @Override
    public void loadSettings(class_2487 tag) {
    }

    @Override
    public char iconChar() {
        return '\ue921';
    }

    @Override
    public String keybindId() {
        return "annotation";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_ANNOTATION);
    }
}

