/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.core_rendering.AxiomBlending;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.core_rendering.AxiomRenderPipeline;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.ProjectionMatrixBackup;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class FramebufferUtils {
    private static int dynamicReadFbo = -1;
    private static class_276 tempRenderTarget = null;

    public static void bindDepth(class_276 renderTarget) {
        renderTarget.method_1235(false);
    }

    public static int bindColour(class_276 renderTarget) {
        renderTarget.method_1235(false);
        return renderTarget.field_1476;
    }

    public static void unbind() {
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public static int getRawColorTextureId(class_276 renderTarget) {
        return renderTarget.method_30277();
    }

    public static CompletableFuture<class_1011> downloadAsync(class_276 renderTarget) {
        class_1011 nativeImage = new class_1011(renderTarget.field_1482, renderTarget.field_1481, false);
        RenderSystem.bindTexture((int)renderTarget.method_30277());
        nativeImage.method_4327(0, false);
        return CompletableFuture.completedFuture(nativeImage);
    }

    public static void copyDepth(class_276 from, class_276 to) {
        int oldReadFbo = GL11.glGetInteger((int)36010);
        int oldDrawFbo = GL11.glGetInteger((int)36006);
        to.method_29329(from);
        GlStateManager._glBindFramebuffer((int)36008, (int)oldReadFbo);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDrawFbo);
    }

    public static void clear(class_276 renderTarget, int colour) {
        int oldReadFbo = GL11.glGetInteger((int)36010);
        int oldDrawFbo = GL11.glGetInteger((int)36006);
        renderTarget.method_1236((float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, (float)(colour >> 24 & 0xFF) / 255.0f);
        renderTarget.method_1230(class_310.field_1703);
        GlStateManager._glBindFramebuffer((int)36008, (int)oldReadFbo);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDrawFbo);
    }

    public static class_276 resizeOrCreateFramebuffer(class_276 renderTarget, int width, int height) {
        if (renderTarget == null) {
            renderTarget = VersionUtilsClient.helperCreateNewTextureTarget(null, width, height, true);
            renderTarget.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        } else if (renderTarget.field_1482 != width || renderTarget.field_1481 != height) {
            renderTarget.method_1234(width, height, class_310.field_1703);
        }
        return renderTarget;
    }

    public static void blitToMainBlend(class_276 renderTarget, int width, int height) {
        FramebufferUtils.blitToMainBlend(new AxiomGpuTexture(renderTarget.method_30277()), width, height);
    }

    public static void blitToMainBlend(class_276 renderTarget, int width, int height, AxiomBlending blending) {
        FramebufferUtils.blitToMainBlend(new AxiomGpuTexture(renderTarget.method_30277()), width, height, blending);
    }

    public static void blitToMainBlend(AxiomGpuTexture textureId, int width, int height) {
        FramebufferUtils.blitToMainBlend(textureId, width, height, AxiomBlending.DEFAULT);
    }

    public static void blitToMainBlend(AxiomGpuTexture textureId, int width, int height, AxiomBlending blending) {
        FramebufferUtils.blitTo(textureId, null, width, height, 0.0f, 0.0f, 1.0f, 1.0f, blending);
    }

    public static void blitTo(AxiomGpuTexture from, class_276 to, int width, int height, float x1, float y1, float x2, float y2, AxiomBlending blending) {
        AxiomRenderPipeline pipeline;
        RenderHelper.pushModelViewMatrix(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        ProjectionMatrixBackup backup = ProjectionMatrixBackup.create();
        RenderHelper.setOrthoProjectionMatrix(width, height);
        AxiomRenderer.setMainTexture(from);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 builder = provider.begin(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22912((float)width * x1, (float)height * y2, 0.0f).method_22913(0.0f, 0.0f);
        builder.method_22912((float)width * x2, (float)height * y2, 0.0f).method_22913(1.0f, 0.0f);
        builder.method_22912((float)width * x2, (float)height * y1, 0.0f).method_22913(1.0f, 1.0f);
        builder.method_22912((float)width * x1, (float)height * y1, 0.0f).method_22913(0.0f, 1.0f);
        if (blending == null) {
            pipeline = AxiomRenderPipelines.BLIT_NO_BLEND;
        } else {
            pipeline = switch (blending) {
                case AxiomBlending.ONE_ONE_MINUS_SRC_ALPHA -> AxiomRenderPipelines.BLIT_ONE_ONE_MINUS_SRC_ALPHA;
                default -> AxiomRenderPipelines.BLIT;
            };
        }
        pipeline.render(to, provider.build());
        backup.restore();
        RenderHelper.popModelViewStack();
    }

    public static void blitToScreenPartial(class_276 renderTarget, int width, int height, float x1, float y1, float x2, float y2) {
        GlStateManager._viewport((int)0, (int)0, (int)width, (int)height);
        int oldReadFbo = GL11.glGetInteger((int)36010);
        int oldDrawFbo = GL11.glGetInteger((int)36006);
        tempRenderTarget = FramebufferUtils.resizeOrCreateFramebuffer(tempRenderTarget, width, height);
        FramebufferUtils.clear(tempRenderTarget, 0);
        FramebufferUtils.blitTo(new AxiomGpuTexture(renderTarget.method_30277()), tempRenderTarget, width, height, x1, y1, x2, y2, null);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        tempRenderTarget.method_1237(width, height);
        GlStateManager._glBindFramebuffer((int)36008, (int)oldReadFbo);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDrawFbo);
    }
}

