/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;

public record CompressedBlockEntity(int originalSize, byte compressionDict, byte[] compressed) {
    private static final ZstdDictCompress zstdDictCompress;
    private static final ZstdDictDecompress zstdDictDecompress;

    public static CompressedBlockEntity compress(class_2487 tag, ByteArrayOutputStream baos) {
        try {
            baos.reset();
            DataOutputStream dos = new DataOutputStream(baos);
            class_2507.method_10628((class_2487)tag, (DataOutput)dos);
            byte[] uncompressed = baos.toByteArray();
            byte[] compressed = Zstd.compress(uncompressed, zstdDictCompress);
            return new CompressedBlockEntity(uncompressed.length, 0, compressed);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2487 decompress() {
        if (this.compressionDict != 0) {
            throw new UnsupportedOperationException("Unknown compression dict: " + this.compressionDict);
        }
        try {
            byte[] nbt = Zstd.decompress(this.compressed, zstdDictDecompress, this.originalSize);
            return class_2507.method_10627((DataInput)new DataInputStream(new ByteArrayInputStream(nbt)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompressedBlockEntity read(class_2540 friendlyByteBuf) {
        int originalSize = friendlyByteBuf.method_10816();
        byte compressionDict = friendlyByteBuf.readByte();
        byte[] compressed = friendlyByteBuf.method_10795();
        return new CompressedBlockEntity(originalSize, compressionDict, compressed);
    }

    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_10804(this.originalSize);
        friendlyByteBuf.method_52997((int)this.compressionDict);
        friendlyByteBuf.method_10813(this.compressed);
    }

    static {
        try {
            URL url = CompressedBlockEntity.class.getClassLoader().getResource("zstd_dictionaries/block_entities_v1.dict");
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            try (InputStream is = connection.getInputStream();){
                byte[] bytes = is.readAllBytes();
                zstdDictCompress = new ZstdDictCompress(bytes, Zstd.defaultCompressionLevel());
                zstdDictDecompress = new ZstdDictDecompress(bytes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

