/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.editor.tutorial.TutorialStage;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.UndoRedoTracer;
import com.moulberry.axi\u03bfm.utils.Authorization;
import imgui.ImGui;
import imgui.ImGuiListClipper;
import imgui.callback.ImListClipperCallback;
import java.text.NumberFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2183;
import net.minecraft.class_310;

public class HistoryWindow {
    private static int lastHistoryPosition = -1;
    private static int historyPopupPosition = -1;
    private static boolean hiddenHistoryIdentifier = false;
    private static boolean obscuredHistoryIdentifier = true;
    private static boolean revertHistoryIKnowWhatImDoing = false;
    private static boolean bigUndoIKnowWhatImDoing = false;

    public static void render() {
        boolean showTutorial;
        boolean bl = showTutorial = TutorialManager.getCurrentStage() == TutorialStage.HISTORY;
        if (!EditorWindowType.HISTORY.isOpen() && !showTutorial) {
            return;
        }
        if (EditorWindowType.HISTORY.begin("###History", true)) {
            long historyBytes;
            if (!hiddenHistoryIdentifier) {
                if (Dispatcher.historyIdentifier != null) {
                    if (obscuredHistoryIdentifier) {
                        String[] split = Dispatcher.historyIdentifier.split("/");
                        if (split.length >= 3) {
                            StringBuilder builder = new StringBuilder();
                            boolean first = true;
                            for (int i = 2; i < split.length; ++i) {
                                if (first) {
                                    first = false;
                                } else {
                                    builder.append(",");
                                }
                                builder.append(split[i]);
                            }
                            ImGui.text(split[0] + "/(Hidden)/" + String.valueOf(builder));
                            if (ImGui.isItemClicked()) {
                                obscuredHistoryIdentifier = false;
                            }
                            ImGuiHelper.tooltip("Click to show");
                        } else {
                            ImGui.text(Dispatcher.historyIdentifier);
                        }
                    } else {
                        ImGui.text(Dispatcher.historyIdentifier);
                    }
                } else {
                    ImGui.text("\u26a0 History is not being saved");
                    if (!Authorization.hasCommercialLicense()) {
                        ImGuiHelper.tooltip("Automatic history persistence is a Commercial License feature. Click for more information");
                        ImGuiHelper.openCommercialLicenseOnClick();
                    }
                }
                ImGui.sameLine();
                if (ImGui.smallButton("Hide")) {
                    hiddenHistoryIdentifier = true;
                }
                ImGui.separator();
            }
            String bytesString = (historyBytes = Dispatcher.getHistoryBytes()) < 1024L ? NumberFormat.getInstance().format(historyBytes) + " bytes" : (historyBytes < 0x100000L ? NumberFormat.getInstance().format(historyBytes / 1024L) + "kB" : NumberFormat.getInstance().format(historyBytes / 1024L / 1024L) + "MB");
            ImGui.text(AxiomI18n.get("axiom.editorui.window.history.history_size", bytesString));
            ImGui.sameLine();
            if (ImGui.smallButton(AxiomI18n.get("axiom.editorui.window.history.clear") + "##ClearHistory")) {
                Dispatcher.clear();
            }
            ImGui.separator();
            if (Dispatcher.getHistoryDataCount() == 0) {
                ImGui.textDisabled(AxiomI18n.get("axiom.editorui.window.history.no_history"));
                if (showTutorial) {
                    TutorialStage.HISTORY.render(ImGui.getWindowPos(), ImGui.getWindowSize());
                }
                EditorWindowType.HISTORY.end();
                return;
            }
            if (ImGui.beginChild("##Scroller")) {
                Dispatcher.HistoryData history;
                HistoryEntry<?> entry;
                Object backwards;
                boolean historyPositionChanged;
                final int position = Dispatcher.getHistoryPosition();
                boolean bl2 = historyPositionChanged = position != lastHistoryPosition;
                if (historyPositionChanged) {
                    lastHistoryPosition = position;
                    float textLineHeightWithSpacing = ImGui.getTextLineHeightWithSpacing();
                    float localY = ImGui.getCursorStartPosY() + textLineHeightWithSpacing * (float)position;
                    float windowHeight = ImGui.getWindowHeight();
                    if (ImGui.getWindowHeight() < textLineHeightWithSpacing * 4.0f) {
                        if (localY < textLineHeightWithSpacing) {
                            ImGui.setScrollFromPosY(ImGui.getCursorStartPosY() + textLineHeightWithSpacing * (float)position, 0.0f);
                        } else if (localY > windowHeight - textLineHeightWithSpacing) {
                            ImGui.setScrollFromPosY(ImGui.getCursorStartPosY() + textLineHeightWithSpacing * (float)position + textLineHeightWithSpacing, 1.0f);
                        }
                    } else if (localY < textLineHeightWithSpacing * 2.0f) {
                        ImGui.setScrollFromPosY(ImGui.getCursorStartPosY() + textLineHeightWithSpacing * (float)position - textLineHeightWithSpacing, 0.0f);
                    } else if (localY > windowHeight - textLineHeightWithSpacing * 2.0f) {
                        ImGui.setScrollFromPosY(ImGui.getCursorStartPosY() + textLineHeightWithSpacing * (float)position + textLineHeightWithSpacing * 2.0f, 1.0f);
                    }
                }
                final AtomicBoolean disabledAlpha = new AtomicBoolean(false);
                final AtomicInteger setHistoryPosition = new AtomicInteger(-1);
                final AtomicInteger revertHistoryPosition = new AtomicInteger(-1);
                final int historyCount = Dispatcher.getHistoryDataCount();
                final int historyPosition = Dispatcher.getHistoryPosition();
                ImGuiListClipper.forEach(historyCount, (int)ImGui.getTextLineHeightWithSpacing(), new ImListClipperCallback(){

                    @Override
                    public void accept(int index) {
                        boolean shouldUseDisabledAlpha;
                        Dispatcher.HistoryData historyData = Dispatcher.getHistoryData(index);
                        if (historyData == null) {
                            return;
                        }
                        ImGui.pushID(index);
                        boolean bl = shouldUseDisabledAlpha = index != position;
                        if (disabledAlpha.get() != shouldUseDisabledAlpha) {
                            disabledAlpha.set(shouldUseDisabledAlpha);
                            if (shouldUseDisabledAlpha) {
                                ImGuiHelper.pushStyleVar(0, ImGui.getStyle().getAlpha() * ImGui.getStyle().getDisabledAlpha());
                            } else {
                                ImGuiHelper.popStyleVar();
                            }
                        }
                        if (ImGui.menuItem("(" + historyData.getIndexIdentifier() + ") " + historyData.entry().description())) {
                            ImGui.openPopup("##HistoryItemPopup");
                            historyPopupPosition = index;
                        }
                        if (ImGui.isItemClicked(1)) {
                            ImGui.openPopup("##HistoryItemPopup");
                            historyPopupPosition = index;
                        }
                        if (historyPopupPosition == index) {
                            if (disabledAlpha.get()) {
                                ImGuiHelper.popStyleVar();
                            }
                            boolean openUndoWarningPopup = false;
                            boolean openRevertPopup = false;
                            if (ImGui.beginPopup("##HistoryItemPopup", 64)) {
                                String message;
                                String string = message = historyPopupPosition <= historyPosition ? "Undo to this point" : "Redo to this point";
                                if (historyPopupPosition == historyPosition) {
                                    ImGui.beginDisabled();
                                }
                                if (ImGui.menuItem(message)) {
                                    if (Math.abs(historyPopupPosition - historyPosition) >= 10) {
                                        openUndoWarningPopup = true;
                                    } else {
                                        setHistoryPosition.set(historyPopupPosition);
                                    }
                                }
                                if (historyPopupPosition == historyPosition) {
                                    ImGui.endDisabled();
                                }
                                if (ImGui.menuItem("Locate change")) {
                                    class_310.method_1551().field_1724.method_5702(class_2183.class_2184.field_9851, historyData.entry().origin().method_46558());
                                    Dispatcher.addTracer(new UndoRedoTracer(historyData.entry().origin().method_46558(), -256, false));
                                }
                                if (historyData.entry().backwards() instanceof BlockBuffer && historyPopupPosition <= historyPosition - 1 && historyPosition >= historyCount - 2 && ImGui.menuItem("Revert without undo")) {
                                    openRevertPopup = true;
                                }
                                ImGui.endPopup();
                            }
                            if (openUndoWarningPopup) {
                                ImGui.openPopup("Undo/Redo Warning!##HistoryUndoWarning");
                            }
                            if (ImGuiHelper.beginPopupModalCloseable("Undo/Redo Warning!##HistoryUndoWarning", 64)) {
                                int changeCount = Math.abs(historyPopupPosition - historyPosition);
                                Object warning = historyPopupPosition <= historyPosition ? "Undoing" : "Redoing";
                                warning = (String)warning + " to this point will result in a lot of changes. If you have modified the world by hand or by using a non-Axiom tool, these changes may get overriden and may be impossible to recover!";
                                ImGui.pushTextWrapPos(500.0f);
                                ImGui.textWrapped((String)warning);
                                ImGui.popTextWrapPos();
                                if (!bigUndoIKnowWhatImDoing) {
                                    if (ImGui.button("I know what I'm doing!")) {
                                        bigUndoIKnowWhatImDoing = true;
                                    }
                                } else {
                                    if (ImGui.button(historyPopupPosition <= historyPosition ? "Undo " + changeCount + " changes" : "Redo " + changeCount + " changes")) {
                                        setHistoryPosition.set(historyPopupPosition);
                                        ImGui.closeCurrentPopup();
                                    }
                                    ImGui.sameLine();
                                    if (ImGui.button("Cancel")) {
                                        ImGui.closeCurrentPopup();
                                    }
                                }
                                ImGuiHelper.endPopupModalCloseable();
                            }
                            if (openRevertPopup) {
                                ImGui.openPopup("Revert Change##RevertWarning");
                            }
                            if (ImGuiHelper.beginPopupModalCloseable("Revert Change##RevertWarning")) {
                                String explanation = "This function will revert the history change without undoing to that point. It will create a new history element. This is an advanced feature and should not be used unless you know what you're doing!";
                                ImGui.pushTextWrapPos(500.0f);
                                ImGui.textWrapped(explanation);
                                ImGui.popTextWrapPos();
                                if (!revertHistoryIKnowWhatImDoing) {
                                    if (ImGui.button("I know what I'm doing!")) {
                                        revertHistoryIKnowWhatImDoing = true;
                                    }
                                } else {
                                    if (ImGui.button("Revert '" + historyData.entry().description() + "'")) {
                                        revertHistoryPosition.set(historyPopupPosition);
                                        ImGui.closeCurrentPopup();
                                    }
                                    ImGui.sameLine();
                                    if (ImGui.button("Cancel")) {
                                        ImGui.closeCurrentPopup();
                                    }
                                }
                                ImGuiHelper.endPopupModalCloseable();
                            }
                            if (disabledAlpha.get()) {
                                ImGuiHelper.pushStyleVar(0, ImGui.getStyle().getAlpha() * ImGui.getStyle().getDisabledAlpha());
                            }
                        }
                        ImGui.popID();
                    }
                });
                if (setHistoryPosition.get() != -1) {
                    Dispatcher.setHistoryPosition(setHistoryPosition.get());
                }
                if (revertHistoryPosition.get() != -1 && (backwards = (entry = (history = Dispatcher.getHistoryData(revertHistoryPosition.get())).entry()).backwards()) instanceof BlockBuffer) {
                    BlockBuffer blockBuffer = (BlockBuffer)backwards;
                    String description = "Revert '" + entry.description() + "'";
                    RegionHelper.pushBlockBufferChange(blockBuffer, entry.origin(), description, null);
                }
                if (disabledAlpha.get()) {
                    ImGuiHelper.popStyleVar();
                }
            }
            ImGui.endChild();
            if (showTutorial) {
                TutorialStage.HISTORY.render(ImGui.getWindowPos(), ImGui.getWindowSize());
            }
        } else if (showTutorial) {
            TutorialManager.nextTutorialStage();
        }
        EditorWindowType.HISTORY.end();
    }

    private static String formatBytes(int bytes) {
        int exp2;
        String[] shorthand = new String[]{"b", "kB", "MB", "GB"};
        for (exp2 = 0; bytes >= 10000 && exp2 < shorthand.length - 1; ++exp2) {
            bytes = (bytes + 512) / 1024;
        }
        return NumberFormat.getInstance().format(bytes) + shorthand[exp2];
    }
}

