/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.packets.AxiomClientboundResponseEntityData;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.EntityDataUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AxiomServerboundRequestEntityData
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = new class_2960("axiom:request_entity_data");
    private final long id;
    private final List<UUID> request;
    private static final class_2561 UNSUPPORTED_MESSAGE = class_2561.method_43470((String)"Server doesn't support (or doesn't allow) requesting entity data").method_27692(class_124.field_1061);

    public AxiomServerboundRequestEntityData(long id, List<UUID> request) {
        this.id = id;
        this.request = List.copyOf(request);
    }

    public AxiomServerboundRequestEntityData(class_2540 friendlyByteBuf) {
        this.id = friendlyByteBuf.readLong();
        this.request = friendlyByteBuf.method_34066(buf -> buf.method_10790());
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_52974(this.id);
        friendlyByteBuf.method_34062(this.request, (buf, uuid) -> buf.method_10797(uuid));
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (!AxiomServerboundPacket.canUseAxiom(player, AxiomPermission.ENTITY_REQUESTDATA)) {
            new AxiomClientboundResponseEntityData(this.id, true, Map.of()).send(player);
            return;
        }
        class_3218 serverLevel = player.method_51469();
        int maxPacketSize = 0x100000;
        int remainingBytes = 0x100000;
        HashMap<UUID, class_2487> entityData = new HashMap<UUID, class_2487>();
        HashSet<UUID> visitedEntities = new HashSet<UUID>();
        for (UUID uuid : this.request) {
            class_2487 entityTag;
            class_1297 entity;
            if (!visitedEntities.add(uuid) || (entity = serverLevel.method_14190(uuid)) == null || entity instanceof class_1657 || (entityTag = EntityDataUtils.saveRoot(entity)) == null) continue;
            int size = entityTag.method_47988();
            if (size >= 0x100000) {
                new AxiomClientboundResponseEntityData(this.id, false, Map.of(uuid, entityTag)).send(player);
                continue;
            }
            if (remainingBytes - size < 0) {
                new AxiomClientboundResponseEntityData(this.id, false, entityData).send(player);
                entityData.clear();
                remainingBytes = 0x100000;
            }
            entityData.put(uuid, entityTag);
            remainingBytes -= size;
        }
        new AxiomClientboundResponseEntityData(this.id, true, entityData).send(player);
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundRequestEntityData::new);
    }

    @Override
    public void send() {
        if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.REQUEST_ENTITY)) {
            ChatUtils.error(UNSUPPORTED_MESSAGE);
            return;
        }
        AxiomServerboundPacket.super.send();
    }
}

