/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import net.minecraft.class_1041;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderHelper {
    private static float previousFogStart = 0.0f;

    public static void tryApplyModelViewMatrix() {
        RenderSystem.applyModelViewMatrix();
        AxiomRenderer.dirtyDynamicUniforms();
    }

    public static void tryFlush(class_332 guiGraphics) {
        guiGraphics.method_51452();
    }

    public static void setOrthoProjectionMatrix(float width, float height) {
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, width, height, 0.0f, 1000.0f, 3000.0f), (class_8251)class_8251.field_43361);
    }

    public static void setPerspectiveProjectionMatrix(Matrix4f matrix4f) {
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43360);
    }

    public static void setupShader(class_5944 shaderInstance, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        class_1041 window = class_310.method_1551().method_22683();
        RenderHelper.setupShader(shaderInstance, modelViewMatrix, projectionMatrix, window.method_4489(), window.method_4506());
    }

    public static void setupShader(class_5944 shaderInstance, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float screenWidth, float screenHeight) {
        RenderSystem.assertOnRenderThread();
        for (int index = 0; index < 12; ++index) {
            AxiomGpuTexture texture = new AxiomGpuTexture(RenderSystem.getShaderTexture((int)index));
            shaderInstance.method_34583("Sampler" + index, (Object)texture.glId());
        }
        if (shaderInstance.field_29470 != null) {
            shaderInstance.field_29470.method_1250(modelViewMatrix);
        }
        if (shaderInstance.field_29471 != null) {
            shaderInstance.field_29471.method_1250(projectionMatrix);
        }
        if (shaderInstance.field_36323 != null) {
            shaderInstance.field_36323.method_39978(RenderSystem.getInverseViewRotationMatrix());
        }
        if (shaderInstance.field_29474 != null) {
            shaderInstance.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shaderInstance.field_42231 != null) {
            shaderInstance.field_42231.method_1251(RenderSystem.getShaderGlintAlpha());
        }
        if (shaderInstance.field_29477 != null) {
            shaderInstance.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (shaderInstance.field_29478 != null) {
            shaderInstance.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (shaderInstance.field_29479 != null) {
            shaderInstance.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (shaderInstance.field_36373 != null) {
            shaderInstance.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
        }
        if (shaderInstance.field_29472 != null) {
            shaderInstance.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shaderInstance.field_29481 != null) {
            shaderInstance.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (shaderInstance.field_29473 != null) {
            shaderInstance.field_29473.method_1255(screenWidth, screenHeight);
        }
        if (shaderInstance.field_29480 != null) {
            shaderInstance.field_29480.method_1251(RenderSystem.getShaderLineWidth());
        }
        RenderSystem.setupShaderLights((class_5944)shaderInstance);
        shaderInstance.method_34586();
    }

    public static void finishShader(class_5944 shaderInstance) {
        shaderInstance.method_34585();
    }

    public static void pushDisableFog() {
        previousFogStart = RenderSystem.getShaderFogStart();
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
    }

    public static void popDisableFog() {
        RenderSystem.setShaderFogStart((float)previousFogStart);
    }

    public static void pushModelViewMatrix(Matrix4f matrix4f) {
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34426();
        modelViewStack.method_34425(matrix4f);
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void pushModelViewStackWithIdentity() {
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34426();
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void popModelViewStack() {
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22909();
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void setupFlatLighting() {
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
    }

    public static void setup3DLighting() {
        class_308.method_24211();
    }
}

