/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.axiom.databind.deser.impl;

import com.fasterxml.jackson.axiom.databind.BeanProperty;
import com.fasterxml.jackson.axiom.databind.DeserializationContext;
import com.fasterxml.jackson.axiom.databind.JavaType;
import com.fasterxml.jackson.axiom.databind.JsonMappingException;
import com.fasterxml.jackson.axiom.databind.PropertyName;
import com.fasterxml.jackson.axiom.databind.deser.NullValueProvider;
import com.fasterxml.jackson.axiom.databind.exc.InvalidNullException;
import com.fasterxml.jackson.axiom.databind.util.AccessPattern;
import java.io.Serializable;

public class NullsFailProvider
implements NullValueProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyName _name;
    protected final JavaType _type;

    protected NullsFailProvider(PropertyName name, JavaType type2) {
        this._name = name;
        this._type = type2;
    }

    public static NullsFailProvider constructForProperty(BeanProperty prop) {
        return NullsFailProvider.constructForProperty(prop, prop.getType());
    }

    public static NullsFailProvider constructForProperty(BeanProperty prop, JavaType type2) {
        return new NullsFailProvider(prop.getFullName(), type2);
    }

    public static NullsFailProvider constructForRootValue(JavaType t2) {
        return new NullsFailProvider(null, t2);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        throw InvalidNullException.from(ctxt, this._name, this._type);
    }
}

