/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.moulberry.axiom.capabilities.ReplaceMode;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.utils.BlockShapeUpdater;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1743;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2478;
import net.minecraft.class_2504;
import net.minecraft.class_2506;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4778;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_5815;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FamilyMap {
    private static final Map<class_2248, AxiomBlockFamily> ANY_BLOCK_TO_FAMILY_MAP;
    private static final Map<class_2248, AxiomBlockFamily> BASE_BLOCK_TO_FAMILY_MAP;
    private static final Map<class_2248, AxiomBlockVariant> BLOCK_TO_VARIANT_MAP;
    private static final Map<class_5794.class_5796, AxiomBlockVariant> AXIOM_VARIANTS;
    private static final Map<AxiomBlockVariant, Map<AxiomBlockVariant, VariantConverter>> variantConverters;

    public static AxiomBlockFamily getFamilyFor(class_2248 block) {
        return ANY_BLOCK_TO_FAMILY_MAP.get(block);
    }

    public static AxiomBlockFamily getFamilyForBase(class_2248 block) {
        return BASE_BLOCK_TO_FAMILY_MAP.get(block);
    }

    public static AxiomBlockVariant getVariantFor(class_2248 block) {
        return BLOCK_TO_VARIANT_MAP.get(block);
    }

    public static class_2680 typeReplace(class_2680 from, AxiomBlockFamily to, class_2338 pos, class_1937 level) {
        class_2680 toState;
        block5: {
            class_2248 toBlock;
            block6: {
                if (BASE_BLOCK_TO_FAMILY_MAP.containsKey(from.method_26204())) {
                    class_2680 toState2 = to.getBaseBlock().method_9564();
                    for (class_2769 property : from.method_28501()) {
                        if (!toState2.method_28498(property)) continue;
                        toState2 = ReplaceMode.copyProperty((CustomBlockState)from, toState2, property);
                    }
                    return toState2;
                }
                AxiomBlockVariant variant = FamilyMap.getVariantFor(from.method_26204());
                toState = null;
                toBlock = to.getVariant(variant);
                if (toBlock != null) break block6;
                Map<AxiomBlockVariant, VariantConverter> converters = FamilyMap.getVariantConverters(variant);
                if (converters == null) break block5;
                for (Map.Entry<AxiomBlockVariant, VariantConverter> entry : converters.entrySet()) {
                    toBlock = to.getVariant(entry.getKey());
                    if (toBlock == null) continue;
                    toState = toBlock.method_9564();
                    for (class_2769 property : from.method_28501()) {
                        if (!toState.method_28498(property)) continue;
                        toState = ReplaceMode.copyProperty((CustomBlockState)from, toState, property);
                    }
                    toState = entry.getValue().convert(from, toState, pos, (class_1922)level);
                    break block5;
                }
                break block5;
            }
            toState = toBlock.method_9564();
            for (class_2769 property : from.method_28501()) {
                if (!toState.method_28498(property)) continue;
                toState = ReplaceMode.copyProperty((CustomBlockState)from, toState, property);
            }
        }
        return toState;
    }

    public static Map<AxiomBlockVariant, VariantConverter> getVariantConverters(AxiomBlockVariant variant) {
        return variantConverters.get(variant);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var10_21;
        CustomBlockFamily family;
        class_2248 base;
        class_1767 dyeColor;
        void var10_19;
        ANY_BLOCK_TO_FAMILY_MAP = new HashMap<class_2248, AxiomBlockFamily>();
        BASE_BLOCK_TO_FAMILY_MAP = new HashMap<class_2248, AxiomBlockFamily>();
        BLOCK_TO_VARIANT_MAP = new HashMap<class_2248, AxiomBlockVariant>();
        AXIOM_VARIANTS = new HashMap<class_5794.class_5796, AxiomBlockVariant>();
        boolean throwErrors = FabricLoader.getInstance().isDevelopmentEnvironment();
        for (class_5794.class_5796 variant : class_5794.class_5796.values()) {
            AXIOM_VARIANTS.put(variant, new VanillaBlockVariant(variant));
        }
        HashMap familiesForSignType = new HashMap();
        TreeMap<class_2248, CustomBlockFamily> familiesToRegister = new TreeMap<class_2248, CustomBlockFamily>(Comparator.comparingInt(arg_0 -> ((class_7922)class_7923.field_41175).method_10206(arg_0)));
        class_5793.method_33467().forEach(blockFamily -> {
            VanillaBlockFamily vanillaBlockFamily = new VanillaBlockFamily((class_5794)blockFamily, (Map<AxiomBlockVariant, class_2248>)new HashMap<AxiomBlockVariant, class_2248>());
            class_2248 signVariant = blockFamily.method_33470(class_5794.class_5796.field_28538);
            if (signVariant instanceof class_2478) {
                class_2478 signBlock = (class_2478)signVariant;
                familiesForSignType.put(signBlock.method_24025(), vanillaBlockFamily);
            }
            familiesToRegister.put(blockFamily.method_33469(), (CustomBlockFamily)((Object)vanillaBlockFamily));
        });
        EnumMap<class_1767, class_2248> fullGlassBlocks = new EnumMap<class_1767, class_2248>(class_1767.class);
        EnumMap<class_1767, class_2248> glassPaneBlocks = new EnumMap<class_1767, class_2248>(class_1767.class);
        EnumMap<class_1767, class_2248> woolBlocks = new EnumMap<class_1767, class_2248>(class_1767.class);
        woolBlocks.put(class_1767.field_7952, class_2246.field_10446);
        woolBlocks.put(class_1767.field_7946, class_2246.field_10095);
        woolBlocks.put(class_1767.field_7958, class_2246.field_10215);
        woolBlocks.put(class_1767.field_7951, class_2246.field_10294);
        woolBlocks.put(class_1767.field_7947, class_2246.field_10490);
        woolBlocks.put(class_1767.field_7961, class_2246.field_10028);
        woolBlocks.put(class_1767.field_7954, class_2246.field_10459);
        woolBlocks.put(class_1767.field_7944, class_2246.field_10423);
        woolBlocks.put(class_1767.field_7967, class_2246.field_10222);
        woolBlocks.put(class_1767.field_7955, class_2246.field_10619);
        woolBlocks.put(class_1767.field_7945, class_2246.field_10259);
        woolBlocks.put(class_1767.field_7966, class_2246.field_10514);
        woolBlocks.put(class_1767.field_7957, class_2246.field_10113);
        woolBlocks.put(class_1767.field_7942, class_2246.field_10170);
        woolBlocks.put(class_1767.field_7964, class_2246.field_10314);
        woolBlocks.put(class_1767.field_7963, class_2246.field_10146);
        EnumMap<class_1767, class_2248> woolCarpetBlocks = new EnumMap<class_1767, class_2248>(class_1767.class);
        EnumMap<class_1767, class_2248> bedBlocks = new EnumMap<class_1767, class_2248>(class_1767.class);
        for (class_2248 block : class_7923.field_41175) {
            try {
                class_2244 bedBlock;
                if (block instanceof class_2506) {
                    class_2506 class_25062 = (class_2506)block;
                    if (class_25062.method_10622() == null) continue;
                    fullGlassBlocks.put(class_25062.method_10622(), block);
                    continue;
                }
                if (block instanceof class_2504) {
                    class_2504 stainedGlassPaneBlock = (class_2504)block;
                    if (stainedGlassPaneBlock.method_10622() == null) continue;
                    glassPaneBlocks.put(stainedGlassPaneBlock.method_10622(), block);
                    continue;
                }
                if (block instanceof class_7713) {
                    class_7713 ceilingHangingSignBlock = (class_7713)block;
                    VanillaBlockFamily family2 = (VanillaBlockFamily)familiesForSignType.get(ceilingHangingSignBlock.method_24025());
                    if (family2 == null) continue;
                    family2.additionalVariants.put(CustomVariants.CEILING_HANGING_SIGN, block);
                    continue;
                }
                if (block instanceof class_7715) {
                    class_7715 class_77152 = (class_7715)block;
                    VanillaBlockFamily family2 = (VanillaBlockFamily)familiesForSignType.get(class_77152.method_24025());
                    if (family2 == null) continue;
                    family2.additionalVariants.put(CustomVariants.WALL_HANGING_SIGN, block);
                    continue;
                }
                if (block instanceof class_5815) {
                    class_5815 woolCarpetBlock = (class_5815)block;
                    if (woolCarpetBlock.method_33635() == null) continue;
                    woolCarpetBlocks.put(woolCarpetBlock.method_33635(), block);
                    continue;
                }
                if (!(block instanceof class_2244) || (bedBlock = (class_2244)block).method_9487() == null) continue;
                bedBlocks.put(bedBlock.method_9487(), block);
            }
            catch (Exception exception) {}
        }
        class_1767[] class_1767Array = class_1767.values();
        int n = class_1767Array.length;
        boolean bl = false;
        while (var10_19 < n) {
            dyeColor = class_1767Array[var10_19];
            base = (class_2248)fullGlassBlocks.get(dyeColor);
            class_2248 class_22482 = (class_2248)glassPaneBlocks.get(dyeColor);
            if (base != null && class_22482 != null && !familiesToRegister.containsKey(base)) {
                family = new CustomBlockFamily(base, Map.of(CustomVariants.PANE, class_22482));
                familiesToRegister.put(base, family);
            }
            ++var10_19;
        }
        class_1767Array = class_1767.values();
        n = class_1767Array.length;
        boolean bl2 = false;
        while (var10_21 < n) {
            dyeColor = class_1767Array[var10_21];
            base = (class_2248)woolBlocks.get(dyeColor);
            class_2248 class_22483 = (class_2248)woolCarpetBlocks.get(dyeColor);
            class_2248 bed = (class_2248)bedBlocks.get(dyeColor);
            if (base != null && class_22483 != null && bed != null && !familiesToRegister.containsKey(base)) {
                CustomBlockFamily family3 = new CustomBlockFamily(base, Map.of(CustomVariants.CARPET, class_22483, CustomVariants.BED, bed));
                familiesToRegister.put(base, family3);
            }
            ++var10_21;
        }
        if (!familiesToRegister.containsKey(class_2246.field_10033)) {
            familiesToRegister.put(class_2246.field_10033, new CustomBlockFamily(class_2246.field_10033, Map.of(CustomVariants.PANE, class_2246.field_10285)));
        }
        ArrayList<BaseWoodSet> woods = new ArrayList<BaseWoodSet>();
        record BaseWoodSet(class_2248 wood, class_2248 log, class_2248 plank) {
        }
        woods.add(new BaseWoodSet(class_2246.field_10126, class_2246.field_10431, class_2246.field_10161));
        woods.add(new BaseWoodSet(class_2246.field_10178, class_2246.field_10010, class_2246.field_10075));
        woods.add(new BaseWoodSet(class_2246.field_54734, class_2246.field_54715, class_2246.field_54735));
        woods.add(new BaseWoodSet(class_2246.field_9999, class_2246.field_10533, class_2246.field_10218));
        woods.add(new BaseWoodSet(class_2246.field_42733, class_2246.field_42729, class_2246.field_42751));
        woods.add(new BaseWoodSet(class_2246.field_10307, class_2246.field_10511, class_2246.field_10148));
        woods.add(new BaseWoodSet(class_2246.field_10303, class_2246.field_10306, class_2246.field_10334));
        woods.add(new BaseWoodSet(class_2246.field_10155, class_2246.field_10037, class_2246.field_9975));
        woods.add(new BaseWoodSet(class_2246.field_22503, class_2246.field_22111, class_2246.field_22127));
        woods.add(new BaseWoodSet(class_2246.field_22505, class_2246.field_22118, class_2246.field_22126));
        woods.add(new BaseWoodSet(class_2246.field_37549, class_2246.field_37545, class_2246.field_37577));
        for (BaseWoodSet baseWoodSet : woods) {
            Object object;
            class_2248 class_22484;
            HashMap<AxiomBlockVariant, class_2248> variants = new HashMap<AxiomBlockVariant, class_2248>();
            variants.put(CustomVariants.LOG, baseWoodSet.log);
            class_2248 strippedLog = (class_2248)class_1743.field_7898.get(baseWoodSet.log);
            if (strippedLog != null) {
                variants.put(CustomVariants.STRIPPED_LOG, strippedLog);
            }
            if ((class_22484 = (class_2248)class_1743.field_7898.get(baseWoodSet.wood)) != null) {
                variants.put(CustomVariants.STRIPPED_WOOD, class_22484);
            }
            if ((object = familiesToRegister.get(baseWoodSet.plank)) instanceof VanillaBlockFamily) {
                VanillaBlockFamily vanillaBlockFamily = (VanillaBlockFamily)object;
                object = vanillaBlockFamily.family.method_33474().entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    variants.put(AXIOM_VARIANTS.get(entry.getKey()), (class_2248)entry.getValue());
                }
                variants.putAll(vanillaBlockFamily.additionalVariants);
            }
            family = new CustomBlockFamily(baseWoodSet.wood, variants);
            familiesToRegister.put(baseWoodSet.wood, family);
        }
        if (throwErrors) {
            for (Map.Entry entry : class_1743.field_7898.entrySet()) {
                if (entry.getKey() == class_2246.field_41072 || !((class_2248)entry.getKey()).method_40142().method_40237().method_29177().method_12836().equals("minecraft")) continue;
                boolean present = false;
                for (BaseWoodSet baseWoodSet : woods) {
                    if (baseWoodSet.wood != entry.getKey() && baseWoodSet.log != entry.getKey()) continue;
                    present = true;
                    break;
                }
                if (present) continue;
                throw new RuntimeException("Missing base wood set for " + String.valueOf(entry.getKey()));
            }
        }
        for (AxiomBlockFamily axiomBlockFamily : familiesToRegister.values()) {
            if (!(axiomBlockFamily instanceof VanillaBlockFamily)) continue;
            VanillaBlockFamily vanillaBlockFamily = (VanillaBlockFamily)axiomBlockFamily;
            if (!BASE_BLOCK_TO_FAMILY_MAP.containsKey(axiomBlockFamily.getBaseBlock())) {
                ANY_BLOCK_TO_FAMILY_MAP.put(axiomBlockFamily.getBaseBlock(), axiomBlockFamily);
                BASE_BLOCK_TO_FAMILY_MAP.put(axiomBlockFamily.getBaseBlock(), axiomBlockFamily);
                BLOCK_TO_VARIANT_MAP.remove(axiomBlockFamily.getBaseBlock());
            }
            for (Map.Entry entry : vanillaBlockFamily.family.method_33474().entrySet()) {
                if (ANY_BLOCK_TO_FAMILY_MAP.containsKey(entry.getValue())) continue;
                ANY_BLOCK_TO_FAMILY_MAP.put((class_2248)entry.getValue(), axiomBlockFamily);
                BLOCK_TO_VARIANT_MAP.put((class_2248)entry.getValue(), AXIOM_VARIANTS.get(entry.getKey()));
            }
            for (Map.Entry<Object, Object> entry : vanillaBlockFamily.additionalVariants.entrySet()) {
                if (ANY_BLOCK_TO_FAMILY_MAP.containsKey(entry.getValue())) continue;
                ANY_BLOCK_TO_FAMILY_MAP.put((class_2248)entry.getValue(), axiomBlockFamily);
                BLOCK_TO_VARIANT_MAP.put((class_2248)entry.getValue(), (AxiomBlockVariant)entry.getKey());
            }
        }
        for (AxiomBlockFamily axiomBlockFamily : familiesToRegister.values()) {
            if (!(axiomBlockFamily instanceof CustomBlockFamily)) continue;
            CustomBlockFamily custom = (CustomBlockFamily)axiomBlockFamily;
            if (!BASE_BLOCK_TO_FAMILY_MAP.containsKey(axiomBlockFamily.getBaseBlock())) {
                ANY_BLOCK_TO_FAMILY_MAP.put(axiomBlockFamily.getBaseBlock(), axiomBlockFamily);
                BASE_BLOCK_TO_FAMILY_MAP.put(axiomBlockFamily.getBaseBlock(), axiomBlockFamily);
                BLOCK_TO_VARIANT_MAP.remove(axiomBlockFamily.getBaseBlock());
            }
            for (Map.Entry<Object, Object> entry : custom.variants.entrySet()) {
                if (ANY_BLOCK_TO_FAMILY_MAP.containsKey(entry.getValue())) continue;
                ANY_BLOCK_TO_FAMILY_MAP.put((class_2248)entry.getValue(), axiomBlockFamily);
                BLOCK_TO_VARIANT_MAP.put((class_2248)entry.getValue(), (AxiomBlockVariant)entry.getKey());
            }
        }
        variantConverters = new HashMap<AxiomBlockVariant, Map<AxiomBlockVariant, VariantConverter>>();
        VariantConverter identity = (from, to, pos, blockGetter) -> to;
        VariantConverter fenceToWall = (from, to, pos, blockGetter) -> {
            boolean north = (Boolean)from.method_11654((class_2769)class_2741.field_12489);
            boolean east = (Boolean)from.method_11654((class_2769)class_2741.field_12487);
            boolean south = (Boolean)from.method_11654((class_2769)class_2741.field_12540);
            boolean west = (Boolean)from.method_11654((class_2769)class_2741.field_12527);
            class_2338 abovePos = pos.method_10084();
            class_2680 above = blockGetter.method_8320(abovePos);
            class_265 aboveVoxelShape = above.method_26220(blockGetter, abovePos).method_20538(class_2350.field_11033);
            to = BlockShapeUpdater.updateWallSides(to, aboveVoxelShape, north, east, south, west);
            return BlockShapeUpdater.updateWallUp(to, above, aboveVoxelShape);
        };
        VariantConverter wallToFence = (from, to, pos, blockGetter) -> {
            boolean north = from.method_11654((class_2769)class_2741.field_22175) != class_4778.field_22178;
            boolean east = from.method_11654((class_2769)class_2741.field_22174) != class_4778.field_22178;
            boolean south = from.method_11654((class_2769)class_2741.field_22176) != class_4778.field_22178;
            boolean west = from.method_11654((class_2769)class_2741.field_22177) != class_4778.field_22178;
            to = (class_2680)to.method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(north));
            to = (class_2680)to.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(east));
            to = (class_2680)to.method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(south));
            return (class_2680)to.method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(west));
        };
        variantConverters.put(AXIOM_VARIANTS.get(class_5794.class_5796.field_28536), Map.of(AXIOM_VARIANTS.get(class_5794.class_5796.field_40592), identity, AXIOM_VARIANTS.get(class_5794.class_5796.field_28544), fenceToWall));
        variantConverters.put(AXIOM_VARIANTS.get(class_5794.class_5796.field_28544), Map.of(AXIOM_VARIANTS.get(class_5794.class_5796.field_28536), wallToFence, AXIOM_VARIANTS.get(class_5794.class_5796.field_40592), wallToFence));
        variantConverters.put(AXIOM_VARIANTS.get(class_5794.class_5796.field_40592), Map.of(AXIOM_VARIANTS.get(class_5794.class_5796.field_28536), identity));
        variantConverters.put(AXIOM_VARIANTS.get(class_5794.class_5796.field_40593), Map.of(AXIOM_VARIANTS.get(class_5794.class_5796.field_28537), identity));
        variantConverters.put(AXIOM_VARIANTS.get(class_5794.class_5796.field_28537), Map.of(AXIOM_VARIANTS.get(class_5794.class_5796.field_40593), identity));
    }

    public static interface AxiomBlockFamily {
        public class_2248 getBaseBlock();

        @Nullable
        public class_2248 getVariant(AxiomBlockVariant var1);
    }

    public static interface AxiomBlockVariant {
    }

    @FunctionalInterface
    public static interface VariantConverter {
        public class_2680 convert(class_2680 var1, class_2680 var2, class_2338 var3, class_1922 var4);
    }

    private record VanillaBlockFamily(class_5794 family, Map<AxiomBlockVariant, class_2248> additionalVariants) implements AxiomBlockFamily
    {
        @Override
        public class_2248 getBaseBlock() {
            return this.family.method_33469();
        }

        @Override
        @Nullable
        public class_2248 getVariant(AxiomBlockVariant variant) {
            if (variant instanceof VanillaBlockVariant) {
                VanillaBlockVariant vanilla = (VanillaBlockVariant)variant;
                class_2248 block = this.family.method_33470(vanilla.variant);
                if (block != null) {
                    return block;
                }
            }
            return this.additionalVariants.get(variant);
        }
    }

    private record VanillaBlockVariant(class_5794.class_5796 variant) implements AxiomBlockVariant
    {
    }

    private static enum CustomVariants implements AxiomBlockVariant
    {
        PANE,
        CEILING_HANGING_SIGN,
        WALL_HANGING_SIGN,
        CARPET,
        BED,
        LOG,
        WOOD,
        STRIPPED_LOG,
        STRIPPED_WOOD;

    }

    private record CustomBlockFamily(class_2248 base, Map<AxiomBlockVariant, class_2248> variants) implements AxiomBlockFamily
    {
        @Override
        public class_2248 getBaseBlock() {
            return this.base;
        }

        @Override
        @Nullable
        public class_2248 getVariant(AxiomBlockVariant variant) {
            return this.variants.get(variant);
        }
    }
}

