/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.capabilities.BuildSymmetry;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.restrictions.AxiomPermission;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public class MirrorBuilderTool
implements BuilderTool {
    @Override
    public void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        if (!BuildSymmetry.isActive()) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.setup_symmetry.place_symmetry"), class_310.method_1551().field_1690.field_1904, 0);
        } else {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.setup_symmetry.move_symmetry"), class_310.method_1551().field_1690.field_1904, 0);
            int leftKey = class_310.field_1703 ? 343 : 341;
            int rightKey = class_310.field_1703 ? 347 : 345;
            long window = class_310.method_1551().method_22683().method_4490();
            if (GLFW.glfwGetKey((long)window, (int)leftKey) != 0 || GLFW.glfwGetKey((long)window, (int)rightKey) != 0) {
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.setup_symmetry.nudge_symmetry"), class_310.method_1551().field_1690.field_1871, 1);
            } else if (class_310.field_1703) {
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.setup_symmetry.cmd_nudge_symmetry"), class_310.method_1551().field_1690.field_1871, 1);
            } else {
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.setup_symmetry.ctrl_nudge_symmetry"), class_310.method_1551().field_1690.field_1871, 1);
            }
            class_310 mc = class_310.method_1551();
            int n = screenHeight / 2;
            Objects.requireNonNull(mc.field_1772);
            int y = n + (9 + 4) * 3;
            String text = "[DEL] " + AxiomI18n.get("axiom.widget.clear");
            int width = mc.field_1772.method_1727(text);
            guiGraphics.method_25303(mc.field_1772, text, screenWidth / 2 - width / 2, y, -2130706433);
            int n2 = screenHeight / 2;
            Objects.requireNonNull(mc.field_1772);
            y = n2 + (9 + 4) * 4;
            String flipAxis = this.getLookAxis().method_15434().toUpperCase(Locale.ROOT);
            text = "[" + Keybinds.FLIP_PLACEMENT.shortKeyIdentifier() + "] " + AxiomI18n.get("axiom.buildertool.setup_symmetry.flip", flipAxis);
            width = mc.field_1772.method_1727(text);
            guiGraphics.method_25303(mc.field_1772, text, screenWidth / 2 - width / 2, y, -2130706433);
            int n3 = screenHeight / 2;
            Objects.requireNonNull(mc.field_1772);
            y = n3 + (9 + 4) * 5;
            text = "[" + Keybinds.ROTATE_PLACEMENT.shortKeyIdentifier() + "] " + AxiomI18n.get("axiom.buildertool.setup_symmetry.rotate", "Y");
            width = mc.field_1772.method_1727(text);
            guiGraphics.method_25303(mc.field_1772, text, screenWidth / 2 - width / 2, y, -2130706433);
        }
    }

    @Override
    public void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
    }

    private class_2350.class_2351 getLookAxis() {
        class_2350 direction = BuilderTool.calculateDirection();
        return direction.method_10166();
    }

    @Override
    public void handleInput(boolean nudgeForwards, boolean nudgeBackwards) {
    }

    @Override
    public void leftClick(class_239 hitResult) {
        this.rightClick(hitResult);
    }

    @Override
    public void rightClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            BuildSymmetry.setSymmetryPoint(hitResult.method_17784());
        }
    }

    @Override
    public void middleClick(class_239 hitResult) {
    }

    @Override
    public boolean scroll(int scroll) {
        int rightKey;
        long window = class_310.method_1551().method_22683().method_4490();
        int leftKey = class_310.field_1703 ? 343 : 341;
        int n = rightKey = class_310.field_1703 ? 347 : 345;
        if (BuildSymmetry.isActive() && (GLFW.glfwGetKey((long)window, (int)leftKey) != 0 || GLFW.glfwGetKey((long)window, (int)rightKey) != 0)) {
            class_2350 direction = BuilderTool.calculateDirection();
            class_243 symmetry = BuildSymmetry.getSymmetryPoint();
            if (symmetry == null) {
                return false;
            }
            symmetry = symmetry.method_1031((double)((float)direction.method_10148() * Math.signum(scroll) * 0.5f), (double)((float)direction.method_10164() * Math.signum(scroll) * 0.5f), (double)((float)direction.method_10165() * Math.signum(scroll) * 0.5f));
            BuildSymmetry.setSymmetryPoint(symmetry);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRenderBlockOutline(class_2338 blockPos) {
        return true;
    }

    @Override
    public String getName() {
        return AxiomI18n.get("axiom.buildertool.setup_symmetry");
    }

    @Override
    public void reset(boolean apply) {
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.BUILDERTOOL_SETUPSYMMETRY, AxiomPermission.BUILD_PLACE);
    }
}

