/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.terraform.decoration;

import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.CustomBlockStateImplementation;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.noise.MetaballNoise;
import com.moulberry.axiom.noise.SimplexNoise;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.terraform.ClentaminatorDecorationPlacer;
import com.moulberry.axiom.tools.terraform.ClentaminatorSettings;
import imgui.ImGui;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;

public class CropsDecorationPlacer
implements ClentaminatorDecorationPlacer {
    private static final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private static final Predicate<CustomBlockState> cropsFilter = customBlockState -> {
        if (customBlockState instanceof CustomBlockStateImplementation) {
            return !customBlockState.getVanillaState().method_51366() && CropsDecorationPlacer.findAgeProperty(customBlockState) != null;
        }
        return customBlockState.getCustomBlock() instanceof class_2302;
    };
    private final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
    private final MetaballNoise growthNoise = new MetaballNoise(987654321L, 1.0f, 0.8f);
    private final SimplexNoise blendNoise = new SimplexNoise(123456789L);
    private final class_2758 ageProperty;
    private final CustomBlockState cropState;
    private final boolean alwaysFullyGrown;
    private final boolean forcePlaceCrop;

    public CropsDecorationPlacer(Settings settings, boolean forcePlaceCrop) {
        this.cropState = settings.cropState;
        this.alwaysFullyGrown = settings.alwaysFullyGrown;
        this.forcePlaceCrop = forcePlaceCrop;
        this.ageProperty = CropsDecorationPlacer.findAgeProperty(this.cropState);
    }

    private static class_2758 findAgeProperty(CustomBlockState blockState) {
        for (class_2769<?> property : blockState.getProperties()) {
            if (!(property instanceof class_2758)) continue;
            class_2758 integerProperty = (class_2758)property;
            if (!property.method_11899().equalsIgnoreCase("age")) continue;
            return integerProperty;
        }
        return null;
    }

    @Override
    public void place(class_1922 blockGetter, ChunkedBlockRegion blockRegion, MaskElement element, MaskContext maskContext, int x, int y, int z) {
        boolean shouldPlace;
        class_2680 belowState = blockGetter.method_8320((class_2338)this.mutableBlockPos.method_10103(x, y - 1, z));
        boolean bl = shouldPlace = this.forcePlaceCrop || belowState.method_27852(class_2246.field_10362);
        if (shouldPlace) {
            if (this.ageProperty == null) {
                blockRegion.addBlock(x, y, z, this.cropState.getVanillaState());
            } else if (this.alwaysFullyGrown) {
                blockRegion.addBlock(x, y, z, this.cropState.setPropertyUnsafe(this.ageProperty, Integer.valueOf(this.ageProperty.field_37656)).getVanillaState());
            } else {
                float growthStageValue = 1.0f - this.growthNoise.evaluate((float)x / 8.0f, (float)z / 8.0f);
                float blendFactor = this.blendNoise.evaluate((float)(x * 3) / 5.0f, (float)(z * 3) / 5.0f);
                if ((growthStageValue = (float)((double)growthStageValue + (double)blendFactor * 0.2)) > 1.0f) {
                    growthStageValue = 1.0f;
                }
                if (growthStageValue < 0.0f) {
                    growthStageValue = 0.0f;
                }
                int age = this.ageProperty.field_37655 + Math.round((float)(this.ageProperty.field_37656 - this.ageProperty.field_37655) * growthStageValue);
                blockRegion.addBlock(x, y, z, this.cropState.setPropertyUnsafe(this.ageProperty, Integer.valueOf(age)).getVanillaState());
            }
        }
    }

    public static class Settings
    implements ClentaminatorSettings {
        private CustomBlockState cropState = (CustomBlockState)class_2246.field_10293.method_9564();
        private boolean alwaysFullyGrown = false;

        @Override
        public void displayImguiOptions() {
            selectBlockWidget.setFilter(cropsFilter);
            this.cropState = ImGuiHelper.blockStateWidget(selectBlockWidget, this.cropState, AxiomI18n.get("axiom.tool.clentaminator.crop_type"), 0);
            if (ImGui.checkbox(AxiomI18n.get("axiom.tool.clentaminator.fully_grown"), this.alwaysFullyGrown)) {
                this.alwaysFullyGrown = !this.alwaysFullyGrown;
            }
        }

        @Override
        public void writeSettings(class_2487 tag) {
            tag.method_10582("CropType", ServerCustomBlocks.serialize(this.cropState));
            tag.method_10556("CropAlwaysFullyGrown", this.alwaysFullyGrown);
        }
    }
}

